// -*-Mode: C++;-*-
//
// Abstract class for QDF writer classes
//

#ifndef QSYS_QDF_ABS_WRITER_HPP
#define QSYS_QDF_ABS_WRITER_HPP

#include "qsys.hpp"

#include <qlib/mcutils.hpp>
#include <qlib/LExceptions.hpp>
#include <qlib/LTypes.hpp>
#include "ObjWriter.hpp"

#define QDF_VERSION 2

namespace qlib { class BinOutStream; }

namespace qsys {

using qlib::LString;

class QdfDataType
{
public:
  // static const int QDF_TYPE_BOOL = 0;

  // static const int QDF_TYPE_UINT8 = 1;
  // static const int QDF_TYPE_UINT16 = 2;
  // static const int QDF_TYPE_UINT32 = 3;
  // static const int QDF_TYPE_UINT64 = 4;

  static const int QDF_TYPE_INT8 = 11;
  static const int QDF_TYPE_INT16 = 12;
  static const int QDF_TYPE_INT32 = 13;
  static const int QDF_TYPE_INT64 = 14;

  static const int QDF_TYPE_FLOAT32 = 21;
  static const int QDF_TYPE_FLOAT64 = 22;
  static const int QDF_TYPE_FLOAT128 = 23;

  // static const int QDF_TYPE_CHAR8 = 31;
  // static const int QDF_TYPE_CHAR16 = 32;
  // static const int QDF_TYPE_CHAR32 = 33;

  static const int QDF_TYPE_UTF8STR = 41;

  typedef std::pair<LString, int> RecElem;
  typedef std::vector<RecElem> RecElemList;
  typedef qlib::MapTable<int> RecIndMap;
};

class QSYS_API QdfAbsWriter : public qsys::ObjWriter, public QdfDataType
{

public:
  QdfAbsWriter();
  virtual ~QdfAbsWriter();

  /////////

  // QDF common interface

  void start(qlib::OutStream &outs);
  void end();

  // Set 4-char file ID string
  void setFileType(const LString &type);

  void defineData(const LString &name, int nrec);
  
  void defineRecord(const LString &name, int ntype);

  void startData();
  void endData();

  void startRecord();
  void endRecord();

  void setRecValStr(const LString &name, const LString &value);
  void setRecValInt32(const LString &name, int value);
  void setRecValInt8(const LString &name, qint8 value);
  void setRecValFloat32(const LString &name, qfloat32 value);

private:
  // QDF implementation data

  /// Binary output stream
  qlib::BinOutStream *m_pBinOut;

  /// File type string
  LString m_strFileType;

  RecElemList m_recdefs;
  
  RecIndMap m_recmap;

  /// Record index counter
  int m_nRecInd;
}; 

} // namespace qsys

#endif
