// -*-Mode: C++;-*-
//
//  XML format Scene Reader
//

#ifndef QSYS_SCENE_XML_READER_HPP_INCLUDED
#define QSYS_SCENE_XML_READER_HPP_INCLUDED

#include "qsys.hpp"

#include "Scene.hpp"
#include "InOutHandler.hpp"

namespace qsys {

using qlib::LString;

class QSYS_API SceneXMLReader : public InOutHandler
{
  MC_SCRIPTABLE;

private:

  ScenePtr m_pClient;

  //////////

public:
  SceneXMLReader();

  virtual ~SceneXMLReader();

  /// Get category ID
  virtual int getCatID() const;

  virtual void read();

  ////////////////////////////////////////
  // Client management

  /// attach to and lock the target object
  virtual void attach(ScenePtr pScene);
    
  /// detach from the target object
  virtual ScenePtr detach();
    
  ScenePtr getClient() const { return m_pClient; }

  /////////////////////////////////
  // Attributes

  /// Get name of the writer
  virtual const char *getName() const;

  /// Get file-type description
  virtual const char *getTypeDescr() const;

  /// Get file extension
  virtual const char *getFileExt() const;

private:
  bool readObjectFrom(ObjectPtr obj, const LString &url);
  bool readObjectFrom(ObjectPtr obj, qlib::InStream &ins);

};

////////////////////////////////////////////////////////////

/// XML-format Scene Writer
class QSYS_API SceneXMLWriter : public InOutHandler
{
  MC_SCRIPTABLE;

private:

  ScenePtr m_pClient;

  bool m_bForceEmbedAll;

  //////////

public:
  SceneXMLWriter();

  virtual ~SceneXMLWriter();

  /// Get category ID
  virtual int getCatID() const;

  virtual void write();

  ////////////////////////////////////////
  // Client management

  /// attach to and lock the target object
  virtual void attach(ScenePtr pScene);
    
  /// detach from the target object
  virtual ScenePtr detach();
    
  ScenePtr getClient() const { return m_pClient; }

  /////////////////////////////////
  // Attributes

  /// Get name of the writer
  virtual const char *getName() const;

  /// Get file-type description
  virtual const char *getTypeDescr() const;

  /// Get file extension
  virtual const char *getFileExt() const;

};

}

#endif

