// -*-Mode: C++;-*-
//
//  OpenGL display context interface
//
//  $Id: OglDisplayContext.hpp,v 1.20 2011/01/09 15:12:22 rishitani Exp $

#ifndef GFX_OGL_DISPLAY_CONTEXT_HPP_
#define GFX_OGL_DISPLAY_CONTEXT_HPP_

#include <gfx/DisplayContext.hpp>

namespace sysdep {

  using gfx::AbstractColor;
  using gfx::ColorPtr;

  class OglDisplayContext : public gfx::DisplayContext
  {
  private:
    typedef gfx::DisplayContext super_t;

    int m_nSceneID;
    // int m_nViewID;

    Vector4D m_color;
    // Vector4D m_pos;

    int m_nDetail;
    void *m_pGluData;

    // name buffer emulation
    std::deque<int> m_namebuf;
    
  public:
    OglDisplayContext(int sceneid);
    virtual ~OglDisplayContext();

    int getSceneID() const { return m_nSceneID; }
//    int getViewID() const { return m_nViewID; }

    virtual void vertex(const Vector4D &);
    virtual void vertex(double x, double y, double z);
    virtual void normal(const Vector4D &);
    virtual void normal(double x, double y, double z);
    virtual void color(const ColorPtr &c);
    virtual void color(double r, double g, double b, double a);
    virtual void color(double r, double g, double b);

    virtual void pushMatrix();
    virtual void popMatrix();
    virtual void multMatrix(const Matrix4D &mat);
    virtual void loadMatrix(const Matrix4D &mat);

    virtual void enableDepthTest(bool);

    // virtual void rotate(const qlib::LQuat &q);
    virtual void scale(const Vector4D &);
    virtual void translate(const Vector4D &);
    virtual void loadIdent();

    ////////////////

    virtual void setLineWidth(double lw);
    virtual void setLineStipple(unsigned short pattern);
    virtual void setPointSize(double size);

    virtual void setLighting(bool f=true);
    virtual void setCullFace(bool f=true);

    ////////////////
    // metadata operations

    virtual void startHit(qlib::uid_t rend_uid);
    virtual void endHit();

    virtual void loadName(int nameid);
    virtual void pushName(int nameid);
    virtual void popName();

    virtual void drawPointHit(int nid, const Vector4D &pos);

    ////////////////
    // image/text drawing

    virtual void drawString(const Vector4D &pos, const qlib::LString &str);
    virtual void drawPixels(const Vector4D &pos,
                            const gfx::PixelBuffer &data,
                            const gfx::AbstractColor &col);

    ////////////////

    virtual void setPolygonMode(int id) ;
    virtual void startPoints() ;
    virtual void startPolygon() ;
    virtual void startLines() ;
    virtual void startLineStrip() ;
    virtual void startTriangles() ;
    virtual void startTriangleStrip() ;
    virtual void startTriangleFan() ;
    virtual void startQuadStrip() ;
    virtual void startQuads() ;
    virtual void end() ;

    ///////////////////////////////

    /// Display unit sphere
    virtual void sphere();

    virtual void sphere(double r, const Vector4D &vec);

    /// Display cone (and cylinder)
    virtual void cone(double r1, double r2,const Vector4D &pos1,
                      const Vector4D &pos2,bool bCap);

    virtual void setDetail(int n);
    virtual int getDetail() const;

    virtual void drawMesh(const gfx::Mesh &l);    

#if 0
    virtual void useTexture(const LTexture &) ;
    virtual void unuseTexture() ;
    virtual void texCoord(float, float) ;

    /** call display list */
    virtual void callDisplayList(DisplayList *pdl) ;
  
    /** Is display list supported in this implementation? */
    virtual bool isDisplayListSupported() const ;

#endif

    ///////////////////////////////
    // Display List support

    virtual gfx::DisplayContext *createDisplayList();
    virtual bool canCreateDL() const;

    virtual void callDisplayList(DisplayContext *pdl);
    virtual bool isCompatibleDL(DisplayContext *pdl) const;

    virtual bool isDisplayList() const;

    virtual bool recordStart();
    virtual void recordEnd();

    virtual void setMaterial(const LString &name);

  private:
    LString m_curMater;
    void setMaterImpl(const LString &name);

  };

}

#endif
