//
// $Id: XPCCueMol.hpp,v 1.8 2011/03/10 13:11:55 rishitani Exp $
//

#ifndef XPC_CUEMOL_HPP__
#define XPC_CUEMOL_HPP__

#include <nsCOMPtr.h>
#include <nsITimer.h>
#include <nsIObserver.h>
#include "qICueMol.h"

#include <qlib/LString.hpp>

namespace xpcom {

  using qlib::LString;

  class XPCObjWrapper;

  class XPCCueMol : public qICueMol, public nsITimerCallback, public nsIObserver
  {
  private:

    struct Cell {
      Cell() : ptr(NULL), bUsed(false) {}
      XPCObjWrapper *ptr;
      bool bUsed;
    };
    
    std::vector<Cell> m_pool;
    std::list<int> m_freeind;

    bool m_bInit;

    // Timer used for notification
    nsCOMPtr<nsITimer> m_timer;

    void *m_pTR;

    // Recently occured error message
    LString m_errMsg;

    // setup text rendering
    bool initTextRender();
    void finiTextRender();

  public:

    XPCCueMol();
    virtual ~XPCCueMol();

    NS_DECL_ISUPPORTS;

    NS_DECL_QICUEMOL;

    // nsITimerCallback
    NS_DECL_NSITIMERCALLBACK;

    NS_DECL_NSIOBSERVER;

    void notifyDestr(int nind);
    XPCObjWrapper *createWrapper();

    void setErrMsg(const LString &msg) {
      m_errMsg = msg;
    }
  };

}

/// Class ID for XPCCueMol service
#define XPCCueMol_CID					\
  { 0x16ab26f1, 0xe579, 0x4aa6,				\
      { 0xa9, 0x46, 0xde, 0x71, 0x2e, 0x17, 0x26, 0xc4}}

/// Contract ID for XPCCueMol service
#define XPCCueMol_CONTRACTID "@cuemol.org/XPCCueMol"

#endif
