// -*-Mode: C++;-*-
// $Id: objectManip.js,v 1.5 2011/01/03 16:46:31 rishitani Exp $
//

function deleteObject(aObjID)
{
  var obj = cuemol.getObject(aObjID);
  if (!obj) {
    dd("DeleteObject: ERROR!! invalid object ID="+aObjID);
    return;
  }
  var sc = obj.getScene();
  if (!sc) {
    dd("DeleteObject: ERROR!! invalid object ID="+aObjID);
    return;
  }
  
  // EDIT TXN START //
  sc.startUndoTxn("Destroy object");

  try {
    sc.destroyObject(aObjID);
  }
  catch (e) {
    debug.exception(e);
    sc.rollbackUndoTxn();
    util.alert(window, "Fatal error: Cannot destroy object.");
    return;
  }

  sc.commitUndoTxn();
  // EDIT TXN END //

  return;
}

