// -*-Mode: C++;-*-
//
// paint-panel.js: paint (PaintColoring) setup sidepanel implementation
//
// $Id: paint-panel.js,v 1.32 2011/05/01 09:28:03 rishitani Exp $
//

if (!("paint" in cuemolui.panels)) {

( function () {

const COL_UNKNOWN = 0;
const COL_PAINT = 1;
const COL_CPK = 2;
const COL_SIMPLE = 3;
const COL_RAINBOW = 4;
const COL_BFAC = 5;
const COL_ELEPOT = 6;

var panel = cuemolui.panels.paint = new Object();

// panel's ID
panel.id = "paint-panel";
  
panel.collapsed = false;
panel.command_id = "menu-paint-panel-toggle";
  
panel.mLoaded = false;
panel.mTgtRendID = -1;
panel.mTgtSceID = 0;

panel.mTreeView = new cuemolui.TreeView(window, "paint-listbox");
panel.mTreeView.clickHandler = function (ev, row, col) {
  panel.onTreeItemClick(ev, row, col);
}

panel.mPaintPanelDeck = null;
panel._colCssRules = new Object();
panel.mTgtColType = null;

////////
// setup renderer menulist

var paint_coloring_filter = function (elem)
{
  // elem is supplied by Scene.getObjectTreeJSON() method
  var rend = cuemol.getRenderer(elem.ID);
  if (!rend) return false;
  if (!("coloring" in rend)) return false;
  // if (rend.coloring._wrapped.getClassName()!="PaintColoring") return false;
  // do not display the selection renderer
  if (elem.type=="*selection")
    return false;
  return true;
}

panel.mSelector = new cuemolui.ObjMenuList(
  "paint-rend-selector",
  window,
  paint_coloring_filter,
  cuemol.evtMgr.SEM_RENDERER);

// set listener for receiving all property changes (for widget update)
panel.mSelector.addPropChgListener("*", function(args) {panel.targetPropChanged(args)} );

////////
// setup potobj menulist

panel.mPotSel = new cuemolui.ObjMenuList(
  "paint-elepot-obj-selector",
  window,
  function (elem) { return (elem.type=="ElePotMap")?true:false; },
  cuemol.evtMgr.SEM_OBJECT);

////////

window.addEventListener("load", function(){panel.onLoad();}, false);
// window.addEventListener("unload", function() {panel.onUnLoad();}, false);

panel.serial = 0;

//////////////////////////
// methods

panel._setupUnknownColoring = function ()
{
  this.mPaintPanelDeck.selectedIndex = 0;
  this.mTgtColType = COL_UNKNOWN;
  document.getElementById("paint-coloring-selector").setAttribute("disabled", true);
}

/// Setup main panel
panel._setupData = function (aRend)
{
  // dd("PaintPanel._setupData> Rend id="+aRend.uid+
  // ", type="+aRend._wrapped.getClassName()+
  // ", coloring="+aRend.coloring);

  if (!('coloring' in aRend) ||
      aRend.coloring==null) {
    this._setupUnknownColoring();
    return false;
  }

  // dd("*** COLORING rend.coloring._wrapped: "+aRend.coloring._wrapped);
  // dd("*** COLORING classname: "+aRend.coloring._wrapped.getClassName());

  document.getElementById("paint-coloring-selector").disabled = false;

  var coloring = aRend.coloring;
  var clsname = coloring._wrapped.getClassName();
  this.setupColoringSelector(aRend, clsname);

  if (aRend.type_name == "molsurf" &&
      aRend.colormode == "potential") {
    this.mPaintPanelDeck.selectedIndex = 6;
    this.mTgtColType = COL_ELEPOT;
    return true;
  }

  if (clsname == "CPKColoring") {
    this.mPaintPanelDeck.selectedIndex = 3;
    this.mTgtColType = COL_CPK;
    return true;
  }
  else if (clsname == "RainbowColoring") {
    this.mPaintPanelDeck.selectedIndex = 4;
    this.mTgtColType = COL_RAINBOW;
    return true;
  }
  else if (clsname == "BfacColoring") {
    this.mPaintPanelDeck.selectedIndex = 5;
    this.mTgtColType = COL_BFAC;
    return true;
  }

  if (clsname!="PaintColoring") {
    this.mPaintPanelDeck.selectedIndex = 1;
    this.mPaintPanelColClsName.value = "Coloring type: "+coloring._wrapped.getClassName();
    this.mTgtColType = COL_UNKNOWN;
    return false;
  }

  this.mTgtColType = COL_PAINT;
  // remove existing rules
  this._removeColCSS();

  this.mPaintPanelDeck.selectedIndex = 2;
  var i, col, sel, nlen = coloring.size;
  var nodes = new Array();
  
  for (i=0; i<nlen; ++i) {
    sel = coloring.getSelAt(i);
    col = coloring.getColorAt(i);
    dd("sel="+sel+", col="+col);
    var node = new Object();
    node.obj_id = i;
    node.name = sel.toString();
    node.values = { paint_value: col.toString() };
    // node.props = { paint_value_imgsrc: "chrome://cuemol2/content/images/visible1-dis.png" };
    var propval = "col_"+this.serial+"_"+i;
    node.props = { paint_value: propval };
    nodes.push(node);
    this._setColor(propval, col);
  }

  // New button is always enabled
  this.mBtnNew.removeAttribute("disabled");

  //var elem = document.getElementById("paint-listbox-children");
  //dd("listbox styyle="+elem.style.cssText);


/*
// DEBUG: dump all style sheet rules
  var nlen = document.styleSheets.length;
  for (i=0; i<nlen; ++i) {
    var ss = document.styleSheets[i];
    for (var j=0; j<ss.cssRules.length; ++j) {
      var sr = ss.cssRules[j];
      // dd("css "+i+", "+j+" = "+sr);
      // if ('cssText' in sr)
      // dd("css ="+sr.cssText);
      if ('selectorText' in sr &&
          sr.selectorText.indexOf("#paint-listbox-children::-moz-tree-cell")==0) {
        dd("css sel="+sr.cssText);
        // dd("css sel="+sr.selectorText);
        // sr.style.setProperty("background", "blue", "important");
      }
    }
  }
*/

  ++this.serial;
  this.mTreeView.setData(nodes);
  return true;
}

panel._removeColCSS = function ()
{
  var i, nlen = document.styleSheets.length;
  for (i=0; i<nlen; ++i) {
    var ss = document.styleSheets[i];
    for (var j=ss.cssRules.length-1; j>=0; --j) {
      var sr = ss.cssRules[j];
      if ('selectorText' in sr &&
          sr.selectorText.indexOf("#paint-listbox-children::-moz-tree-cellcol")==0) {
        ss.deleteRule(j);
      }
    }
  }
}

panel._setColor = function (aPropName, aColor)
{
  var strcol = "rgb("+aColor.r()+","+aColor.g()+","+aColor.b()+")";
  //if (this._colCssRules[aInd]) {
  //}
  //  else {

  var ss = document.styleSheets[document.styleSheets.length-1];
  var propnm = aPropName; //"col"+aInd;
  var insid = ss.insertRule("#paint-listbox-children::-moz-tree-cell("+propnm+") {}",
                            ss.cssRules.length);
  var sr = ss.cssRules[insid];
  sr.style.backgroundColor = strcol;
  // this._colCssRules[aPropName] = sr;

  //}
  //this._colCssRules[aInd].style.backgroundColor = strcol;
}

/// Setup coloring selector dropdown menu
panel.setupColoringSelector = function (aRend, clsname)
{
  var elepot_elem = document.getElementById("paint-type-elepot");
  if (aRend.type_name == "molsurf") {
    elepot_elem.hidden = false;
    if (aRend.colormode == "potential") {
      /*elepot_elem.setAttribute("checked", "true");
      document.getElementById("paint-type-cpk").removeAttribute("checked");
      document.getElementById("paint-type-paint").removeAttribute("checked");
      document.getElementById("paint-type-bfac").removeAttribute("checked");
      document.getElementById("paint-type-rainbow").removeAttribute("checked");*/
      return;
    }
    
    //elepot_elem.removeAttribute("checked");
  }
  else {
    elepot_elem.hidden = true;
  }
/*  
  document.getElementById("paint-type-cpk").checked = (clsname=="CPKColoring");
  document.getElementById("paint-type-paint").checked = (clsname=="PaintColoring");
  document.getElementById("paint-type-bfac").checked = (clsname=="BfacColoring");
  document.getElementById("paint-type-rainbow").checked = (clsname=="RainbowColoring");
*/

/*
  if (clsname=="CPKColoring")
    document.getElementById("paint-type-cpk").setAttribute("checked", "true");
  else
    document.getElementById("paint-type-cpk").removeAttribute("checked");

  if (clsname=="PaintColoring")
    document.getElementById("paint-type-paint").setAttribute("checked", "true");
  else
    document.getElementById("paint-type-paint").removeAttribute("checked");

  if (clsname=="BfacColoring")
    document.getElementById("paint-type-bfac").setAttribute("checked", "true");
  else
    document.getElementById("paint-type-bfac").removeAttribute("checked");

  if (clsname=="RainbowColoring")
    document.getElementById("paint-type-rainbow").setAttribute("checked", "true");
  else
    document.getElementById("paint-type-rainbow").removeAttribute("checked");
*/
}

/// Perform initialization (complete update) of widgets from model (i.e. renderer) data
panel._initWidgets = function (aRend)
{
  var type = this.mTgtColType;
  if (type == COL_PAINT) {
    this.mTreeView.buildView();
  }
  else if (type == COL_CPK) {
    this.mCPKColC.setTargetSceneID(this.mTgtSceID);
    this.mCPKColN.setTargetSceneID(this.mTgtSceID);
    this.mCPKColO.setTargetSceneID(this.mTgtSceID);
    this.mCPKColP.setTargetSceneID(this.mTgtSceID);
    this.mCPKColS.setTargetSceneID(this.mTgtSceID);
    this.mCPKColH.setTargetSceneID(this.mTgtSceID);
    this.mCPKColX.setTargetSceneID(this.mTgtSceID);
    this.updateCPKAll(aRend);
  }
  else if (type == COL_RAINBOW) {
    //
    this.updateRainbowWidgets(aRend);
  }
  else if (type == COL_BFAC) {
    //
    this.updateBfacWidgets(aRend);
  }
  else if (type == COL_ELEPOT) {
    //
    this.updateElepotWidgets(aRend);
  }
}

/// Perform (partial) update of widgets from model (i.e. renderer) data
panel._updateWidgets = function (aRend, aPropName, aParentName)
{
  var type = this.mTgtColType;

  switch (type) {
  case COL_PAINT: {
    this.mTreeView.buildView();
    return;
  }
  case COL_CPK: {
    if (aParentName=="coloring")
      this.updateCPK(aRend, aPropName);
    else 
      this.updateCPKAll(aRend);
    return;
  }
  case COL_RAINBOW: {
    if (aParentName=="coloring")
      this.updateRainbowWidgets(aRend, aPropName);
    else 
      this.updateRainbowWidgets(aRend);
    return;
  }
  case COL_BFAC: {
    if (aParentName=="coloring")
      this.updateBfacWidgets(aRend, aPropName);
    else 
      this.updateBfacWidgets(aRend);
    return;
  }
  case COL_ELEPOT: {
    if (aPropName=="colormode")
      // color-mode change --> update all widgets
      this.updateElepotWidgets(aRend);
    else 
      this.updateElepotWidgets(aRend, aPropName);
    return;
  }
  }
}

panel.attachRenderer = function (aRend)
{
  if (typeof aRend == 'undefined' || aRend==null) {
    // no target renderer
    this._setupUnknownColoring();
    return;
  }

  // This is initial update, so we have to do complete update.
  if (this._setupData(aRend))
    this._initWidgets(aRend);

  this.mTgtRendID = aRend.uid;

  var nSceID = this.mTgtSceID = aRend.getScene().uid;

}

panel.detachRenderer = function ()
{
}

//////////////////////////
// event handlers

panel.onLoad = function ()
{
  var that = this;

  // Setup the toolbuttons/widgets
  this.mPaintPanelDeck = document.getElementById("paint-panel-deck");
  this.mPaintPanelColClsName = document.getElementById("paint-panel-colclsname");

  this.mBtnNew = document.getElementById("paintpanel-addbtn");
  this.mBtnDel = document.getElementById("paintpanel-delbtn");
  this.mBtnProp = document.getElementById("paintpanel-propbtn");

  this.mListBox = document.getElementById("paint-listbox");

  // Setup event handlers

  this.mSelector.addSelChanged(function(aEvent) {
    try { that.targetChanged(aEvent);}
    catch (e) { debug.exception(e); }
  });
  
  this.mListBox.addEventListener("select", function(e) { that.onTreeSelChanged(); }, false);

  // Setup CPKColoring panel

  this.mCPKColC = document.getElementById("cpk_col_C");
  this.mCPKColN = document.getElementById("cpk_col_N");
  this.mCPKColO = document.getElementById("cpk_col_O");
  this.mCPKColS = document.getElementById("cpk_col_S");
  this.mCPKColP = document.getElementById("cpk_col_P");
  this.mCPKColH = document.getElementById("cpk_col_H");
  this.mCPKColX = document.getElementById("cpk_col_X");

  /// Rainbow coloring panel

  this.mRnbMode = document.getElementById("paint-rnb-mode");
  this.mRnbStaH = document.getElementById("paint-rnb-starth");
  this.mRnbEndH = document.getElementById("paint-rnb-endh");
  this.mRnbBri = document.getElementById("paint-rnb-bri");
  this.mRnbSat = document.getElementById("paint-rnb-sat");

  /// Bfac coloring panel

  this.mBfacMode = document.getElementById("paint-bfac-mode");
  this.mBfacColLo = document.getElementById("paint-bfac-collo");
  this.mBfacColHi = document.getElementById("paint-bfac-colhi");
  this.mBfacAuto = document.getElementById("paint-bfac-auto");
  this.mBfacParLo = document.getElementById("paint-bfac-parlo");
  this.mBfacParHi = document.getElementById("paint-bfac-parhi");

  /// Elepot coloring panel
  this.mPotRamp = document.getElementById("paint-elepot-ramp-above");
  this.mPotColL = document.getElementById("paint-elepot-coll");
  this.mPotColM = document.getElementById("paint-elepot-colm");
  this.mPotColH = document.getElementById("paint-elepot-colh");
  this.mPotParL = document.getElementById("paint-elepot-parl");
  this.mPotParM = document.getElementById("paint-elepot-parm");
  this.mPotParH = document.getElementById("paint-elepot-parh");

  // set listener for elepot-obj-selector "select" change event
  this.mPotSel.addSelChanged(function(args) {that.onPotSelChanged(args)});

  this.mLoaded = true;
}

panel.onUnLoad = function ()
{
  detachRenderer();
  this.mLoaded = false;
}

panel.onPanelShown = function ()
{
  if (this.mLoaded) {
    this.mTreeView.ressignTreeView();
    dd("PaintPanel.onPanelShown> this.mCPKColC.mImpl="+this.mCPKColC.mImpl);
    this.targetChanged(null);
  }
  // alert("Panel "+this.id+" shown");
}

panel.onPanelMoved = function ()
{
  if (this.mLoaded) {
    this.mTreeView.ressignTreeView();
    this.targetChanged(null);
  }
}

panel.onPanelClosed = function ()
{
  // alert("Panel "+this.id+" closed");
}


panel.onChgColoring = function (aEvent)
{
  try {
    if (!this.mTgtRendID) {
      dd("onChgColoring> ERROR: mTgtRendID=null!!");
      return;
    }

    dd("onChgCol> tgtrend id "+this.mTgtRendID);
    var rend = cuemol.getRenderer(this.mTgtRendID);
    var id = aEvent.originalTarget.value;

    if (rend.type_name=="molsurf") {
      if (id=="paint-type-elepot") {
        this.setDefaultElepot(rend);
        return;
      }
    }

    dd("setRendColoring: id="+id+", rend="+rend.name);
    gQm2Main.setRendColoring(id, rend);
  }
  catch (e) {
    debug.exception(e);
  }
}


/// rend-listbox selection (target) is changed
panel.targetChanged = function (scid)
{
  if (!this.shown) {
    dd("PaintPanel targetChanged, but panel is not shown: "+this.shown);
    return;
  }

  var obj;
  try {
    obj = this.mSelector.getSelectedObj();
    dd("PaintPanel, targetChanged selected="+obj+", this.mTreeView="+this.mTreeView);
    this.detachRenderer();
    this.attachRenderer(obj);
  }
  catch (e) {
    dd("Error in panel.targetSceneChanged !!");
    debug.exception(e);
  }
  obj = null;
}

/// Property of renerer is changed
/// ATTN: Event for all renderers in the scene will be reported.
panel.targetPropChanged = function (args)
{
  var rend;

  // filter out unrelated events
  if (this.mTgtRendID<1 ||
      this.mTgtRendID!=args.obj.target_uid) return;

  var propname = args.obj.propname;
  var parentname = args.obj.parentname;
  dd("PaintPanel> TargetPropChanged prop: "+propname);
  dd("PaintPanel> TargetPropChanged parent: "+parentname);

  if (propname=="styles" ||
      propname=="coloring" ||
      parentname=="coloring" ||
      propname=="colormode") {
    rend = cuemol.getRenderer(this.mTgtRendID);
    if (!rend) {
      dd("PaintPanel.targetPropChanged> error, invalid target rend id="+this.mTgtRendID);
      return;
    }
    if (this._setupData(rend)) {
      //dd("PaintPanel.targetPropChanged> call update w prop="+propname);
      this._updateWidgets(rend, propname, parentname);
    }
  }
}

/// Commit property change
panel.commitPropChange = function (aPropName, aPropVal, aMsg)
{
  var rend = cuemol.getRenderer(this.mTgtRendID);
  if ( !rend || !('coloring' in rend) ) return;
  var scene = rend.getScene();
  if (!scene) return;
  var coloring = rend.coloring;

  // EDIT TXN START //
  scene.startUndoTxn(aMsg);
  try {
    coloring._wrapped.setProp(aPropName, aPropVal);
  }
  catch (e) {
    dd("PaintPanel.commitPropChg> FATAL ERROR: "+e);
    debug.exception(e);
    scene.rollbackUndoTxn();
    return;
  }
  scene.commitUndoTxn();
  // EDIT TXN END //
}

////////////////////////////////////////////////////////////////
// Paint coloring implementation

/// selection of paint element list is changed
panel.onTreeSelChanged = function ()
{
  var elem = this.mTreeView.getSelectedNode();
  if (elem) {
    this.mBtnNew.removeAttribute("disabled");
    this.mBtnDel.removeAttribute("disabled");
    this.mBtnProp.removeAttribute("disabled");
    return;
  }
  else {
    this.mBtnNew.removeAttribute("disabled");
    this.mBtnDel.setAttribute("disabled", "true");
    this.mBtnProp.setAttribute("disabled", "true");
  }
}

panel.onTreeItemClick = function (aEvent, elem, col)
{
  if (aEvent.detail==2) {
    // dblclicked --> propchg
    this.onPropCmd(aEvent);
    aEvent.preventDefault();
    aEvent.stopPropagation();
    return;
  }
}

panel.onAddCmd = function (aEvent)
{
  // try {

  var rend = cuemol.getRenderer(this.mTgtRendID);
  if ( !rend || !('coloring' in rend) ) return;
  var coloring = rend.coloring;
  var scene = rend.getScene();

  // check current mol selection
  var cursel = null;
  try {
    var mol = rend.getClientObj();
    cursel = mol.sel;
  } catch (e) {
    dd("PaintPanel> rend client is not a mol??");
  }

  // check selected tree node
  var elem = this.mTreeView.getSelectedNode();
  var id = 0;
  if (elem)
    id = elem.obj_id;

  // prepare default sel and col
  var args = new Object();
  args.scene_id = scene.uid;
  args.rend_id = rend.uid;
  args.sel = cursel;
  if (id<coloring.size) {
    if (args.sel==null)
      args.sel = coloring.getSelAt(id);
    args.col = coloring.getColorAt(id);
  }
  else {
    if (args.sel==null)
      args.sel = cuemol.makeSel("*");
    args.col = cuemol.makeColor("#FFF");
  }

  // show paintprop dialog
  window.openDialog("chrome://cuemol2/content/paint-propdlg.xul",
                    "New paint property",
                    "chrome,modal,resizable=no,dependent,centerscreen",
                    args);

  dd("rval.sel: "+args.sel.toString());
  dd("rval.col: "+args.col.toString());
  dd("rval.OK: "+args.bOK);

  if (!args.bOK)
    return;

  //dd("onAddCmd elem="+require("debug_util").dumpObjectTree(elem, 1));


  // EDIT TXN START //
  scene.startUndoTxn("Add paint entry");

  try {
    if (rend._wrapped.isPropDefault("coloring"))
      rend.coloring = coloring;
    coloring.insertBefore(id, args.sel, args.col);
  }
  catch (e) {
    dd("***** ERROR: insewrtBefore "+e);
    debug.exception(e);
  }

  scene.commitUndoTxn();
  // EDIT TXN END //

  // } catch (e) { debug.exception(e); }
}

panel.onDeleteCmd = function (aEvent)
{
  try {

  var elem, id, rend, coloring, scene;
  var bDelAll = false;
  if (aEvent.target.id=="paintpanel-delallbtn")
    bDelAll = true;

  if (!bDelAll) {
    elem = this.mTreeView.getSelectedNode();
    if (!elem) return;
    id = elem.obj_id;
  }

  rend = cuemol.getRenderer(this.mTgtRendID);
  if ( !rend || !('coloring' in rend) ) return;
  coloring = rend.coloring;
  scene = rend.getScene();

  dd("&&&&&& bDelAll="+bDelAll);

  // EDIT TXN START //
  scene.startUndoTxn("Remove paint entry");
  try {
    if (rend._wrapped.isPropDefault("coloring"))
      rend.coloring = coloring;
    if (bDelAll)
      coloring.clear();
    else
      coloring.removeAt(id);
  }
  catch (e) {
    dd("PaintPanel> ERROR in remove paint entries "+e);
    debug.exception(e);
  }
  scene.commitUndoTxn();
  // EDIT TXN END //


  } catch (e) { debug.exception(e); }
}

panel.onPropCmd = function (aEvent)
{
  var elem = this.mTreeView.getSelectedNode();
  if (!elem) return;
  var id = elem.obj_id;

  var rend = cuemol.getRenderer(this.mTgtRendID);
  if ( !rend || !('coloring' in rend) ) return;
  var coloring = rend.coloring;

  var scene = rend.getScene();
  if (!scene) return;

  var args = new Object();
  args.scene_id = scene.uid;
  args.rend_id = rend.uid;
  args.sel = coloring.getSelAt(id);
  args.col = coloring.getColorAt(id);
  args.rval = new Object();
  args.rval.sel = null;
  args.rval.col = null;

  window.openDialog("chrome://cuemol2/content/paint-propdlg.xul",
                    "Paint property",
                    "chrome,modal,resizable=no,dependent,centerscreen",
                    args);

  dd("rval.sel: "+args.sel.toString());
  dd("rval.col: "+args.col.toString());
  dd("rval.OK: "+args.bOK);

  if (!args.bOK)
    return;

  // EDIT TXN START //
  scene.startUndoTxn("Change paint entry");
  try {
    if (rend._wrapped.isPropDefault("coloring"))
      rend.coloring = coloring;
    coloring.changeAt(id, args.sel, args.col);
  }
  catch (e) {
    dd("***** ERROR: ChangeAt "+e);
    debug.exception(e);
  }
  scene.commitUndoTxn();
  // EDIT TXN END //
}

////////////////////////////////////////////////////////////////
// CPK coloring implementation

/// Data --> widget (all)
panel.updateCPKAll = function (aRend)
{
  var coloring = aRend.coloring;
  this.mCPKColC.setColorObj(coloring.col_C);
  this.mCPKColN.setColorObj(coloring.col_N);
  this.mCPKColO.setColorObj(coloring.col_O);
  this.mCPKColP.setColorObj(coloring.col_P);
  this.mCPKColS.setColorObj(coloring.col_S);
  this.mCPKColH.setColorObj(coloring.col_H);
  this.mCPKColX.setColorObj(coloring.col_X);
};

/// Data --> widget (specific)
panel.updateCPK = function (aRend, aPropName)
{
  dd("PaintPanel.updateCPK> prop="+aPropName);
  var coloring = aRend.coloring;
  switch (aPropName) {
  case "col_C":
    this.mCPKColC.setColorObj(coloring.col_C);
    break;
  case "col_N":
    this.mCPKColN.setColorObj(coloring.col_N);
    break;
  case "col_O":
    this.mCPKColO.setColorObj(coloring.col_O);
    break;
  case "col_P":
    this.mCPKColP.setColorObj(coloring.col_P);
    break;
  case "col_S":
    this.mCPKColS.setColorObj(coloring.col_S);
    break;
  case "col_H":
    this.mCPKColH.setColorObj(coloring.col_H);
    break;
  case "col_X":
    this.mCPKColX.setColorObj(coloring.col_X);
    break;
  }
};

// CPK coloring event handling (Widget --> data)
panel.onCPKColChanged = function (aEvent)
{
  try {
  if (!aEvent.isCompleted)
    return; // --> popup is still open
  var id = aEvent.target.id;
  var color, propnm;
  switch (id) {
  case "cpk_col_C":
    propnm = "col_C";
    break;
  case "cpk_col_N":
    propnm = "col_N";
    break;
  case "cpk_col_O":
    propnm = "col_O";
    break;
  case "cpk_col_S":
    propnm = "col_S";
    break;
  case "cpk_col_P":
    propnm = "col_P";
    break;
  case "cpk_col_H":
    propnm = "col_H";
    break;
  case "cpk_col_X":
    propnm = "col_X";
    break;
  default:
    return;
  }
  color = aEvent.target.getColorObj();

  this.commitPropChange(propnm, color._wrapped, "Change CPK coloring");

  } catch (e) { debug.exception(e); }

};

////////////////////////////////////////////////////////////////
// Rainbow coloring implementation

/// Data --> widgets
panel.updateRainbowWidgets = function (aRend, aPropName)
{
  var coloring = aRend.coloring;

  if (aPropName==undefined ||
      aPropName=="mode") {
    util.selectMenuListByValue(this.mRnbMode, coloring.mode);
  }
  
  if (aPropName==undefined ||
      aPropName=="start_hue") {
    this.mRnbStaH.value = coloring.start_hue;
  }
  
  if (aPropName==undefined ||
      aPropName=="end_hue") {
    this.mRnbEndH.value = coloring.end_hue;
  }
  
  if (aPropName==undefined ||
      aPropName=="sat") {
    this.mRnbSat.value = coloring.sat * 100;
  }

  if (aPropName==undefined ||
      aPropName=="bri") {
    this.mRnbBri.value = coloring.bri * 100;
  }
};

panel.onRainbowChange = function (aEvent)
{
  var tgtid = aEvent.currentTarget.id;
  var propname;
  var val;

  //dd("*** isDragging="+aEvent.isDragging);
  //dd("*** isMouse="+aEvent.isMouse);

  // Ignore the event for starting of slider thumb drag
  if ('isDragging' in aEvent && aEvent.isDragging)
    return;

  dd("Paint.RnbChg> target="+tgtid);

  switch (tgtid) {
  case "paint-rnb-mode":
    propname = "mode";
    val = aEvent.target.value;
    break;

  case "paint-rnb-starth":
    propname = "start_hue";
    val = parseFloat(this.mRnbStaH.value);
    // dd("%%% "+val);
    if (isNaN(val) || val<0.0 || val>360.0)
      return;
    break;

  case "paint-rnb-endh":
    propname = "end_hue";
    val = parseFloat(this.mRnbEndH.value);
    if (isNaN(val) || val<0.0 || val>360.0)
      return;
    break;

  case "paint-rnb-bri":
    propname = "bri";
    val = parseFloat(this.mRnbBri.value);
    if (isNaN(val) || val<0 || val>100)
      return;
    val /= 100.0;
    break;

  case "paint-rnb-sat":
    propname = "sat";
    val = parseFloat(this.mRnbSat.value);
    if (isNaN(val) || val<0 || val>100)
      return;
    val /= 100.0;
    break;

  default:
    return;
  }

  this.commitPropChange(propname, val, "Change rainbow coloring");
};

////////////////////////////////////////////////////////////////
// Bfac coloring implementation

/// Data --> widgets
panel.updateBfacWidgets = function (aRend, aPropName)
{
  var coloring = aRend.coloring;

  if (aPropName==undefined ||
      aPropName=="mode") {
    util.selectMenuListByValue(this.mBfacMode, coloring.mode);
  }
  
  if (aPropName==undefined ||
      aPropName=="lowcol") {
    this.mBfacColLo.setColorObj(coloring.lowcol);
  }
  if (aPropName==undefined ||
      aPropName=="highcol") {
    this.mBfacColHi.setColorObj(coloring.highcol);
  }
  
  if (aPropName==undefined ||
      aPropName=="auto") {
    var value = coloring.auto;
    util.selectMenuListByValue(this.mBfacAuto, value);
    if (value=="none") {
      this.mBfacParLo.disabled = false;
      this.mBfacParHi.disabled = false;
    }
    else {
      this.mBfacParLo.disabled = true;
      this.mBfacParHi.disabled = true;
    }
  }

  if (aPropName==undefined ||
      aPropName=="lowpar") {
    this.mBfacParLo.value = coloring.lowpar;
  }
  if (aPropName==undefined ||
      aPropName=="highpar") {
    this.mBfacParHi.value = coloring.highpar;
  }
  
};

panel.onBfacChange = function (aEvent)
{
  var tgtid = aEvent.currentTarget.id;
  var propname;
  var val;

  // color picking is not completed --> ignore event
  if ('isCompleted' in aEvent &&
      !aEvent.isCompleted)
    return;

  dd("Paint.BfacChg> target="+tgtid);
  switch (tgtid) {
  case "paint-bfac-mode":
    propname = "mode";
    val = aEvent.target.value;
    break;
  case "paint-bfac-collo":
    propname = "lowcol";
    val = this.mBfacColLo.getColorObj()._wrapped;
    break;
  case "paint-bfac-colhi":
    propname = "highcol";
    val = this.mBfacColHi.getColorObj()._wrapped;
    break;

  case "paint-bfac-auto":
    propname = "auto";
    val = aEvent.target.value;
    if (val=="none") {
      this.mBfacParLo.disabled = false;
      this.mBfacParHi.disabled = false;
    }
    else {
      this.mBfacParLo.disabled = true;
      this.mBfacParHi.disabled = true;
    }
    break;

  case "paint-bfac-parlo":
    propname = "lowpar";
    val = parseFloat(this.mBfacParLo.value);
    if (isNaN(val)) return;
    break;
  case "paint-bfac-parhi":
    propname = "highpar";
    val = parseFloat(this.mBfacParHi.value);
    if (isNaN(val)) return;
    break;
  }

  this.commitPropChange(propname, val, "Change Bfac coloring");

};

////////////////////////////////////////////////////////////////
// Electrostatic coloring implementation

/// Setup default electrostatic coloring
panel.setDefaultElepot = function (aRend)
{
  var tgtname = null;
  if (this.mPotSel.getItemCount()>0) {
    if (aRend.elepot=="") {
      var pot = this.mPotSel.getSelectedObj();
      tgtname = pot.name;
    }
  }

  var scene = aRend.getScene();
  // EDIT TXN START //
  scene.startUndoTxn("Change to elepot coloring");
  try {
    if (tgtname)
      aRend.elepot = tgtname;
    aRend.colormode = "potential";
  }
  catch (e) {
    dd("PaintPanel.setDefaultElepot> FATAL ERROR: "+e);
    debug.exception(e);
    scene.rollbackUndoTxn();
    return;
  }
  scene.commitUndoTxn();
  // EDIT TXN END //
  
  return;
};

/// elepot selector change event listener
panel.onPotSelChanged = function (aEvent)
{
  var obj = this.mPotSel.getSelectedObj();
  if (!obj)
    return;

  var rend = cuemol.getRenderer(this.mTgtRendID);
  if (rend.type_name!="molsurf")
    return;
  if (rend.elepot==obj.name)
    return;

  this.commitElepotPropChange("elepot", obj.name);
}

/// Data --> widgets
panel.updateElepotWidgets = function (aRend, aPropName)
{
  //alert("Update elepot widgets: "+aPropName);
  if (aPropName==undefined ||
      aPropName=="ramp_above") {
    if (aRend.ramp_above)
      this.mPotRamp.setAttribute("checked", "true");
    else
      this.mPotRamp.removeAttribute("checked");
  }

  if (aPropName==undefined ||
      aPropName=="lowcol") {
    this.mPotColL.setColorObj(aRend.lowcol);
  }

  if (aPropName==undefined ||
      aPropName=="midcol") {
    this.mPotColM.setColorObj(aRend.midcol);
  }

  if (aPropName==undefined ||
      aPropName=="highcol") {
    this.mPotColH.setColorObj(aRend.highcol);
  }

  ////

  if (aPropName==undefined ||
      aPropName=="lowpar") {
    this.mPotParL.value = aRend.lowpar;
  }

  if (aPropName==undefined ||
      aPropName=="midpar") {
    this.mPotParM.value = aRend.midpar;
  }

  if (aPropName==undefined ||
      aPropName=="highpar") {
    this.mPotParH.value = aRend.highpar;
  }

};

/// Elepot widgets --> data
panel.onElepotChange = function (aEvent)
{
  var tgtid = aEvent.currentTarget.id;
  var propname;
  var val;

  // color picking is not completed --> ignore event
  if ('isCompleted' in aEvent &&
      !aEvent.isCompleted)
    return;

  dd("Paint.ElepotChg> target="+tgtid);
  switch (tgtid) {
  case "paint-elepot-ramp-above":
    propname = "ramp_above";
    val = aEvent.target.checked;
    break;

  case "paint-elepot-coll":
    propname = "lowcol";
    val = this.mPotColL.getColorObj()._wrapped;
    break;
  case "paint-elepot-parl":
    propname = "lowpar";
    val = parseFloat(this.mPotParL.value);
    if (isNaN(val)) return;
    break;

  case "paint-elepot-colm":
    propname = "midcol";
    val = this.mPotColM.getColorObj()._wrapped;
    break;
  case "paint-elepot-parm":
    propname = "midpar";
    val = parseFloat(this.mPotParM.value);
    if (isNaN(val)) return;
    break;

  case "paint-elepot-colh":
    propname = "highcol";
    val = this.mPotColH.getColorObj()._wrapped;
    break;
  case "paint-elepot-parh":
    propname = "highpar";
    val = parseFloat(this.mPotParH.value);
    if (isNaN(val)) return;
    break;
  }

  this.commitElepotPropChange(propname, val);

};

panel.commitElepotPropChange = function (propname, val)
{
  var rend = cuemol.getRenderer(this.mTgtRendID);
  var scene = rend.getScene();

  // EDIT TXN START //
  scene.startUndoTxn("Change Elepot coloring");
  try {
    rend._wrapped.setProp(propname, val);
  }
  catch (e) {
    dd("PaintPanel.commitPropChg> FATAL ERROR: "+e);
    debug.exception(e);
    scene.rollbackUndoTxn();
    return;
  }
  scene.commitUndoTxn();
  // EDIT TXN END //
};

////////////////////////////////////////////////////////////////
} )();

}

