// -*-Mode: C++;-*-
// $Id: panelOverlays.js,v 1.21 2010/08/29 13:09:47 rishitani Exp $
//

////////////////////////////////
// setup gObjectPanel

//var Cc = Components.classes;
//var Ci = Components.interfaces;

////////////////////////////////

function SceneEventListener(aPanel)
{
  this.parent = aPanel;
}

SceneEventListener.prototype.notify0 = function()
{
}

SceneEventListener.prototype.notify = function(args)
{
  // args[0] ... string Method name (always "sceneChanged")
  // args[1] ... int Type
  // args[2] ... int Scene ID
  // args[3] ... int Object/Renderer ID
  // args[4] ... string Description
  dump("Scene event invoked: "+args+"\n");
  var type = args[1];
  var scene_id = args[2];
  var tgt_id = args[3];
  var descr = args[4];

  if (type==11 || type==21) {
    // SCE_OBJ_ADDED
    //window.alert("Scene event: SCE_OBJ_ADDED "+args);
    this.parent.syncContents(scene_id);
  }
  else if (type==12 || type==22) {
    // SCE_OBJ_REMOVING
    this.parent.removeObject(tgt_id);
  }
  else if (type==2||type==14||type==24) {
    if (descr=="name" || descr=="visible") {
      // SCE_OBJ_PROPCHG (name, visible)
      //window.alert("Scene event: SCE_OBJ_PROPCHG name="+(args[4]=="name"));
      this.parent.syncContents(scene_id);
    }
  }
}

////////////////////////////////

var gObjectPanel = {

mTgtSceneID : null, //readonly="true"

// Full object/renderer information
mObjData : null, //readonly="true"

// Shown object/renderer information
mVisibleData : null, //readonly="true"

mTree: null, //readonly="true"
mTreeView: null,
mMainWnd: null,

////////////////////

ctor: function () {
  var xthis = this;
  addEventListener("load", function(){xthis.init();}, false);
  addEventListener("unload", function() {xthis.fini();}, false);
},

////////////////////

checkContextMenu: function(event) {
  //dump("checkContextMenu: "+event.target.localName+"\n");
  //dump("  event.button="+event.button+"\n");
  //dump("  event.clientX="+event.clientX+"\n");
  //dump("  event.clientY="+event.clientY+"\n");

  // hit test
  var row = {}, col = {}, obj = {};
  //gFruitsTreeView._treeBoxObject.getCellAt(aEvent.clientX, aEvent.clientY, row, {}, obj);
  this.mTreeView.treebox.getCellAt(event.clientX, event.clientY, row, col, obj);

  dump("hittest: row="+row.value+", col="+col.value+", obj="+obj.value+"\n");

  if (row.value<0 || row.value>=this.mTreeView.rowCount)
    return;

  if (!(obj.value=="cell"||obj.value=="text"))
    return;

  this.mMenuTgt = this.mVisibleData[row.value];
  if (row.value==0) {
    this.mSceneCtxtMenu.openPopup(null, "", event.clientX+1, event.clientY+1, true, false);
  }
  else if (this.mVisibleData[row.value].parent==-1) {
    this.mObjCtxtMenu.openPopup(null, "", event.clientX+1, event.clientY+1, true, false);
  }
  else {
    this.mRendCtxtMenu.openPopup(null, "", event.clientX+1, event.clientY+1, true, false);
  }

  event.preventDefault();

},

init: function () {
  this.mTree = document.getElementById("objectTree");

  this.mSceneCtxtMenu = document.getElementById("scnPanelSceneCtxtMenu");
  this.mObjCtxtMenu = document.getElementById("scnPanelObjCtxtMenu");
  this.mRendCtxtMenu = document.getElementById("scnPanelRendCtxtMenu");

  // dump("this.mObjCtxtMenu="+this.mObjCtxtMenu+"\n");
  var xthis = this;
  this.mTree.addEventListener("contextmenu", function(event) {xthis.checkContextMenu(event);}, false);

  this.mTreeView = {
  treebox : null,
  selection : null,
  mParent : this,
  rowCount : 0,
  setTree: function(treebox) {
      dd("ObjTreeView: setTree called "+treebox);
    this.treebox = treebox;
  },
  getCellText : function(row,column){
      //dump("getCellText: row="+row+", col="+column.id+"\n");
    if (column.id == "object_id") {
      return this.mParent.mVisibleData[row].ID;
    }
    else if (column.id == "object_type") {
      return this.mParent.mVisibleData[row].type;
    }
    else if (column.id == "object_name") {
      //var obj = this.mParent.mSceneMgr.invoke1("getObject", nid);
      return this.mParent.mVisibleData[row].name;
    }
    /*
    else if (column.id == "object_vis") {
      //var obj = this.mParent.mSceneMgr.invoke1("getObject", nid);
      return this.mParent.mVisibleData[row].visible;
    }
    */
    return "";
  },

  getCellValue : function(row,column){
    if (row==0) return false;
    if (column.id == "object_vis") {
      //var obj = this.mParent.mSceneMgr.invoke1("getObject", nid);
      return this.mParent.mVisibleData[row].visible;
    }
    return;
  },

  setCellValue : function(row,column,value){
    if (column.id == "object_vis") {
      if (value=="true")
        this.mParent.mVisibleData[row].visible = true;
      else
        this.mParent.mVisibleData[row].visible = false;
      this.mParent.changeVisibility(this.mParent.mVisibleData[row]);
      this.treebox.invalidateRow(row);
    }
    return;
  },

  isEditable : function(row,column){
    if (row==0) return false;
    if (column.id == "object_vis") {
      return true;
    }
    return false;
  },

  // cycleHeader: function(col, elem) {},
    
  isContainer: function(row){
      // dump("isContainer called\n");
    if (row==0) return false;
    return (this.mParent.mVisibleData[row].parent==-1);
/*    if (this.mParent.mVisibleData[row].parent==-1)
      if (this.mParent.mVisibleData[row].nchild>0)
        return true;
    return false;*/
    
  },
  isContainerOpen: function(row){
      //dump("isContainerOpen called\n");
    if (this.mParent.mVisibleData[row].parent==-1)
      return this.mParent.mVisibleData[row].open;
    return false;
  },
  isContainerEmpty: function(row){
      //dump("isContainerEmpty called\n");
    if (this.mParent.mVisibleData[row].parent==-1) {
      if (this.mParent.mVisibleData[row].nchild==0)
        return true;
      else
        return false;
    }
    return true;
  },

  getParentIndex: function(row) {
      var res = this.mParent.mVisibleData[row].parent;
      dump("getParentIndex("+row+") called, "+res+"\n");
      // dump("getParentIndex("+row+") called, "+JSON.stringify(this.mParent.mVisibleData)+"\n");
      // return -1;

      //var pop = this.mParent.mVisibleData[res].open;
      //dump("   parent open = "+pop+"\n");
      return res;
  },
  hasNextSibling: function(rowIndex, afterIndex) {
      //dump("hasNextSibling called\n");
      return true;
  },
  getLevel: function(row){
      if (this.mParent.mVisibleData[row].parent==-1)
	return 0;
      return 1;
  },

  isSeparator: function(row){ return false; },
  isSorted: function(){ return false; },

  getImageSrc: function(row,col){ return null; },
  getRowProperties: function(row,props){},
  getCellProperties: function(row,col,props){},
  getColumnProperties: function(colid,col,props){},
  // performActionOnCell: function(action, row, col) {},

  toggleOpenState: function(row) {
    dump("toggle "+row+": called\n");

    var lastRowCount = this.rowCount;
    // change |open| property
    this.mParent.mVisibleData[row].open = !this.mParent.mVisibleData[row].open;
    this.mParent.buildVisibleData();

    this.treebox.rowCountChanged(row+1, this.rowCount - lastRowCount);
    // need this to update the -/+ sign when called by pressing enter key
    this.treebox.invalidateRow(row);
 
    // dump("toggle "+row+": nchange="+(this.rowCount - lastRowCount)+"\n");
  }

  };
	
  //dd("***** treeview parent: "+this.mTree.parentNode.localName);
  //dd("***** treeview parent parent: "+this.mTree.parentNode.parentNode.localName);
  //dd("***** treeview parent parent parent: "+this.mTree.parentNode.parentNode.parentNode.localName);

  this.mTree.view = this.mTreeView;
  //this.mQM = Cc["@cuemol.org/XPCCueMol"].getService(Ci.qICueMol);
  this.mSceneMgr = cuemol.xpc.getService("SceneManager");
  this.mCbID = null;
  
  this.mMainWnd = document.getElementById("main_view");

  //
  // setup tab-event handler for the MainTabView
  //
  this._mainViewEventHandler = {
    //readonly="true"
  panel: this,
  handleEvent: function handleEvent(aEvent) {
    var mainwnd = aEvent.target.parentNode.parentNode;
    //window.alert('ObjectPanel onselect: '+mainwnd.localName);
    //window.alert('ObjectPanel onselect: THIS.panel='+this.panel);
    
    var scid = mainwnd.getCurrentSceneID();
    //var sc = mainwnd.getCurrentScene();
    
    if (scid != this.panel.mTgtSceneID) {
      this.panel.targetSceneChanged(scid);
    }
  }
  };
  this.mMainWnd.mPanelContainer.addEventListener("select", this._mainViewEventHandler, false);

  //
  // setup the target scene
  //
  var scid = this.mMainWnd.getCurrentSceneID();
  if (scid && scid>0) {
    this.targetSceneChanged(scid);
  }
  else {
    this.mTgtSceneID = -1;
  }
  dump("ObjectPanel Ctor: MainView="+this.mMainWnd+", target scene="+this.mTgtSceneID+"\n");

  //window.alert("ObjectPanel.init: "+this.mTree+"\n");
  dump("ObjectPanel.init: "+this.mTree+"\n");
},

////////////////////

fini: function () {
  dump("ObjectPanel.fini: scene ID="+this.mTgtSceneID+", callbackID = "+this.mCbID+"\n");

  this.mMainWnd.removeEventListener("select", this._mainViewEventHandler, false);
  var scene = this.mSceneMgr.invoke1("getScene", this.mTgtSceneID);

  if (this.mCbID!=null && scene)
    scene.invoke1("removeListener", this.mCbID);
},

///////////////////////////////////////////////

buildVisibleData : function() {
  var visibleData = [];
  var nrow = 0;
  for (var i=0; i<this.mObjData.length; ++i) {
    var elem = this.mObjData[i];
    elem.irow = nrow;
    elem.parent = -1;
    elem.nchild = elem.rends.length;
    visibleData.push(elem);
    var nparw = nrow;
    ++nrow;

    if (!elem.open) {
      for (var j=0; j<elem.rends.length; ++j) {
        elem.rends[j].irow = -1;
      }
      continue;
    }
    
    for (var j=0; j<elem.rends.length; ++j) {
      var je = elem.rends[j];
      je.irow = nrow;
      je.parent = nparw;
      je.nchild = 0;
      visibleData.push(je);
      ++nrow;
    }

    /*
    if (elem.parent==-1) {
      // this is an object node (always shown)
      elem.nchild = 0;
      elem.nParentRow = -1;
      visibleData.push(elem);
      ++ nrow;
    }
    else {
      // the renderer node is shown, when its parent is open
      var parRow = findObjData(elem.parent);
      if (parRow==-1) {
      }
      var npar = elem.parent;
      this.mObjData[npar].nchild ++;
      if (this.mObjData[npar].open)
        visibleData.push(elem);
    }*/
    
  }
  this.mVisibleData = visibleData;
  this.mTreeView.rowCount = this.mVisibleData.length;
},

syncContents: function(scid) {
  if (!scid) {
    dump("ObjPanel.Sync failed. (scene is null "+scid+") \n");
    return;
  }
  var scene = this.mSceneMgr.invoke1("getScene", scid);
  if (!scene) {
    dump("ObjPanel.Sync failed. (scene is null "+scid+") \n");
    return;
  }
  
  this.clearContents();
  
  //this.mObjIDs = scene.invoke0("getAllObjectUIDs");
  var json = scene.invoke0("getObjectTreeJSON");
  // dump("getObjectTreeJSON: "+json+"\n");
  this.mObjData = eval("("+json+")");
  this.buildVisibleData();

  dump("this.mObjData.length: "+this.mObjData.length+"\n");
  
  this.mTreeView.treebox.rowCountChanged(0, this.mTreeView.rowCount);
},

clearContents: function() {
  var lastRowCount = this.mTreeView.rowCount;
  this.mObjData = [];
  this.mVisibleData = [];
  this.mTreeView.rowCount = 0;
  this.mTreeView.treebox.rowCountChanged(0, -lastRowCount);
},

findAndRemove: function(aObjID) {
  // find aObjID in the mObjData
  var i, j;
  for (i=0; i<this.mObjData.length; ++i) {
    var elem = this.mObjData[i];
    if (elem.ID==aObjID) {
      var ret = elem.irow;
      this.mObjData.splice(i, 1);
      return ret;
    }

    for (j=0; j<elem.rends.length; ++j) {
      if (elem.rends[j].ID==aObjID) {
        var ret = elem.rends[j].irow;
        elem.rends.splice(j, 1);
        return ret;
      }
    }
  }
  return -1;
},

removeObject: function(aObjID) {

  // update datastructure mObjData
  var vrow = this.findAndRemove(aObjID);

  // update the visible data structure
  var lastRowCount = this.mTreeView.rowCount;
  this.buildVisibleData();
  this.mTreeView.treebox.rowCountChanged(vrow, this.mTreeView.rowCount - lastRowCount);
  // need this to update the -/+ sign when called by pressing enter key
  //this.mTreeView.treebox.invalidateRow(vrow);

  /*
  // update the mVisibleData
  this.mVisibleData.splice(vrow, 1);

  // update the view
  this.mTreeView.rowCount -= 1;
  this.mTreeView.treebox.rowCountChanged(vrow, -1);
*/
  
  //window.alert("removeObject OK "+aObjID);
},

////////////////////

targetSceneChanged: function (scid) {
  
  if (scid==this.mTgtSceneID) return;
  var oldid = this.mTgtSceneID;

  // detach from the previously active scene
  if (oldid>0) {
    var oldscene = this.mSceneMgr.invoke1("getScene", oldid);
    if (oldscene && this.mCbID!=null)
      oldscene.invoke1("removeListener", this.mCbID);
  }

  this.mCbID = null;
  this.mTgtSceneID = scid;
  this.syncContents(scid);
  dump("ObjectPanel change the tgt scene to: "+this.mTgtSceneID+"\n");

  // attach to the new active scene
  // window.alert("XXX getScnene" + scid);
  if (scid>0) {
    var scene = this.mSceneMgr.invoke1("getScene", scid);
    this.mCbID = scene.invokeWithCallback1("addListener", new SceneEventListener(this));
  }
},

};

//////////////////////////////////////////////
// Left click (context-menu) handling

gObjectPanel.onDeleteObject = function(event) {
  dump("this.mMenuTgt"+this.mMenuTgt+"\n");
  if (!this.mMenuTgt)
    return;
  // window.alert("delete object: "+this.mMenuTgt.ID);
  deleteObject(this.mMenuTgt.ID);
}

gObjectPanel.onDeleteRend = function(event) {
  dump("this.mMenuTgt"+this.mMenuTgt+"\n");
  if (!this.mMenuTgt)
    return;
  // window.alert("delete renderer: "+this.mMenuTgt.ID);
  gQm2Main.deleteRendByID(this.mMenuTgt.ID);
}

gObjectPanel.onNewRend = function(event) {
  dump("this.mMenuTgt"+this.mMenuTgt+"\n");
  if (!this.mMenuTgt)
    return;
  // window.alert("new renderer: "+this.mMenuTgt.ID);
  gQm2Main.setupRendByObjID(this.mMenuTgt.ID);
}

gObjectPanel.openPropDialog = function (targetObj)
{

  // var osx_style = "chrome,titlebar,centerscreen,modal";
  var style = "chrome,modal,resizable=yes,dependent,centerscreen";
  var parent_win = window;

/*
  window.openDialog("chrome://cuemol2/content/objPropDetailDlg.xul",
                    "Object properties",
                    style, targetObj);
*/  

  var ww = Cc["@mozilla.org/embedcomp/window-watcher;1"].getService(Ci.nsIWindowWatcher);

  var win = ww.openWindow(parent_win,
			  "chrome://cuemol2/content/objPropDetailDlg.xul",
                          "Object properties",
                          style, targetObj);

}


gObjectPanel.onSceneProp = function(event)
{
  var scene = this.mSceneMgr.invoke1("getScene", this.mMenuTgt.ID);
  if (!scene) return;
  this.openPropDialog(scene);
  //window.alert("onSceneProp: "+scene);
}

gObjectPanel.onObjProp = function(event)
{
  //window.alert("onObjProp");
  var obj = this.mSceneMgr.invoke1("getObject", this.mMenuTgt.ID);
  if (!obj) return;
  this.openPropDialog(obj);
}

gObjectPanel.onRendProp = function(event)
{
  // this.mRendCtxtMenu.hidePopup();
  var obj = this.mSceneMgr.invoke1("getRenderer", this.mMenuTgt.ID);
  if (!obj) return;

  //var that = this;
  //setTimeout( function () { that.openPropDialog(obj) } , 0 );

  this.openPropDialog(obj);
}

gObjectPanel.changeVisibility = function (elem)
{
  var obj;
  if (elem.parent==-1) {
    // object
    obj = this.mSceneMgr.invoke1("getObject", elem.ID);
  }
  else {
    // renderer
    obj = this.mSceneMgr.invoke1("getRenderer", elem.ID);
  }

  if (!obj) return;

  // EDIT TXN START //
  var scene = this.mSceneMgr.invoke1("getScene", this.mTgtSceneID);
  scene.invoke1("startUndoTxn", "Change visibility");
  try {
    obj.setProp("visible", elem.visible);
  }
  catch (e) {
    dump("***** ERROR: Change visibility "+e+"\n");
  }
  scene.invoke0("commitUndoTxn");
  // EDIT TXN END //

}

///////////////////////

gObjectPanel.ctor();

