// -*-Mode: C++;-*-
//
// workspace-panel.js: workspace sidepanel implementation
//
// $Id: workspace_panel.js,v 1.39 2011/04/24 15:05:49 rishitani Exp $
//

if (!("workspace" in cuemolui.panels)) {

( function () {

var ws = cuemolui.panels.workspace = new Object();

// panel's ID
ws.id = "workspace-panel";
  
  // // initialization method
  // init : function workspace_panel_init() {
  //   //dd("workspace_panel init called");
  // },
  
ws.collapsed = false;
ws.command_id = "menu-workspace-panel-toggle";
  
ws._callbackID = null;
ws.mTgtSceneID = -1;

ws.mViewObj = new cuemolui.TreeView(window, "objectTree");
ws.mViewObj.clickHandler = function (ev, row, col) {
  try { ws.onTreeItemClick(ev, row, col); } catch (e) { debug.exception(e); }
}
//ws.mViewObj.addContextMenuHandler(function(event) {ws.doContextMenu(event);});
  
/*ws.mViewObj.setData([
  { "name": "aaa", values: {"object_id": 123} },
  { "name": "bbb", values: {"object_id": 3} },
  { "name": "ccc", values: {"object_id": 5}, childNodes: [
    {"name": "xyzz", values: {"object_id": 53} },
    {"name": "d903", values: {"object_id": 312} },
    {"name": "-0fgl3", values: {"object_id": 5343} }
    ], collapsed: true },
  { "name": "ddd", values: {"object_id": 35} }
]);*/

window.addEventListener("load", function(){ws.onLoad();}, false);
window.addEventListener("unload", function() {ws.onUnLoad();}, false);

ws.mSceneCtxtMenuID = "wspcPanelSceneCtxtMenu";
ws.mObjCtxtMenuID = "wspcPanelObjCtxtMenu";
ws.mRendCtxtMenuID = "wspcPanelRendCtxtMenu";

ws._nodes = null;

//////////////////////////
// methods

ws.syncContents = function (scid)
{
  var scene = cuemol.getScene(scid);
  if (!scene) {
    dd("Workspace panel: syncContents failed, invalid scene: "+scid);
    return;
  }

  var json_str = scene.getObjectTreeJSON();
  // dd("objtree json: "+json_str);
  var data;
  try {
    data = JSON.parse(json_str);
  }
  catch (e) {
    dd("error : "+json_str);
    require("debug_util").exception(e);
    return;
  }

  var nodes = new Array();
  var i, nlen = data.length;

  // scene
  var elem = data[0];
  var node = new Object();
  node.name = "Scene: "+elem.name;
  node.menu_id = this.mSceneCtxtMenuID;
  node.obj_id = elem.ID;
  node.type = "scene";
  nodes.push(node);
  node.props = { object_name: "noindent" };

  // objects and renderers
  for (i=1; i<nlen; ++i) {
    elem = data[i];
    node = new Object();
    node.name = elem.name + " ("+elem.type+")";
    //node.values = { object_vis: elem.visible };
    node.props = {
      object_vis: (elem.visible?"visible":"invisible"),
      object_lck: (elem.locked?"locked":"unlocked")
    };
    node.collapsed = false;
    node.menu_id = this.mObjCtxtMenuID;
    node.obj_id = elem.ID;
    node.type = "object";
    if (elem.rends && elem.rends.length>0) {
      node.childNodes = new Array();
      var j, njlen = elem.rends.length;
      for (j=0; j<njlen; ++j) {
        var rend = elem.rends[j];
        var rnode = new Object();
        rnode.name = rend.name + " ("+rend.type+")";
        rnode.type_name = rend.type;
        //rnode.values = { object_vis: rend.visible };

        var rvis = "invisible";
        if (rend.visible) {
          if (elem.visible)
            rvis = "visible";
          else
            rvis = "disabled";
        }
        rnode.props = {
          object_vis: rvis,
          object_lck: (rend.locked?"locked":"unlocked")
        };

        rnode.menu_id = this.mRendCtxtMenuID;
        rnode.obj_id = rend.ID;
        rnode.type = "renderer";
        node.childNodes.push(rnode);
      }
    }
    nodes.push(node);
  }

  //dd("Workspace Panel: syncContents data="+require("debug_util").dumpObjectTree(data, 1));
  //dd("Workspace Panel: syncContents nodes="+require("debug_util").dumpObjectTree(nodes, 1));

  // cameras
  json_str = scene.getCameraInfoJSON();
  dd("CameraInfo json: "+json_str);
  try {
    data = JSON.parse(json_str);
  }
  catch (e) {
    dd("error : "+json_str);
    require("debug_util").exception(e);
    return;
  }
  
  node = new Object();
  node.name = "Camera";
  node.collapsed = true;
  node.obj_id = "camera_topnode";
  node.type = "cameraRoot";
  nlen = data.length;
  if (nlen>0) {
    node.childNodes = new Array();
    for (i=0; i<nlen; ++i) {
      var rnode = new Object();
      rnode.name = data[i];
      rnode.obj_id = data[i];
      rnode.menu_id = "wspcPanelCameraCtxtMenu";
      // rnode.menu_id = this.mObjCtxtMenuID;
      // rnode.obj_id = elem.ID;
      rnode.type = "camera";
      node.childNodes.push(rnode);
    }
  }
  nodes.push(node);

  dd("Workspace Panel: cameraInfo="+require("debug_util").dumpObjectTree(data, 1));
  //dd("Workspace Panel: syncContents nodes="+require("debug_util").dumpObjectTree(nodes, 1));

  this._nodes = nodes;
  this.mViewObj.setData(this._nodes);
  this.mViewObj.restoreOpenState(scid);
  this.mViewObj.buildView();
}

ws.syncContentsPropChg = function (srcUID, propname)
{
  var node = this.findNodeByObjId(srcUID);
  
  var src;
  var type2;
  if (node.type=="object") {
    src = cuemol.getObject(srcUID);
    type2 = src._wrapped.getClassName();
  }
  else if (node.type=="renderer") {
    src = cuemol.getRenderer(srcUID);
    type2 = src.type_name;
    //dd(debug.dumpObjectTree(src));
    //type2 = src._wrapped.getProp("type_name");
  }
  else if (node.type=="scene") {
    src = cuemol.getScene(srcUID);
    type2 = "";
  }
  else
    return;

  if (propname=="visible") {
    var newval = src.visible;
    if (node.type=="renderer") {
      node.props.object_vis = newval?"visible":"invisible";
    }
    else {
      node.props.object_vis = newval?"visible":"invisible";
      const nch = (node.childNodes)? node.childNodes.length : 0;
      for (var i=0; i<nch; ++i) {
        var rnode = node.childNodes[i];
        if (newval) {
          if (rnode.props.object_vis=="disabled")
            rnode.props.object_vis = "visible";
        }
        else {
          if (rnode.props.object_vis=="visible")
            rnode.props.object_vis = "disabled";
        }
      }
      this.mViewObj.invalidate();
      return;
    }
  }
  else if (propname=="locked") {
    var newval = src.locked;
    node.props.object_lck = newval?"locked":"unlocked";
    dd("syncContPropChg> locked, newval="+newval+", props="+node.props.object_lck);
  }
  else if (propname=="name") {
    if (node.type=="scene") {
      node.name = "Scene: "+ src.name;
    }
    else {
      var newval = src.name + " ("+type2+")";
      dd("SyncContPropChg name UID: "+srcUID+", name="+newval);
      node.name = newval;
    }
  }
  else
    return;

  //this.mViewObj._tvi.invalidate();
  this.mViewObj.updateNode( function(elem) {
    return (elem.obj_id==srcUID)?true:false;
  } );
}

ws.removeObject = function (aId)
{
  dd("WS.removeObject ID="+aId);
  this.mViewObj.removeNode( function(elem) {
    return (elem.obj_id==aId)?true:false;
  } );
}

ws.findNodeByObjId = function (aId)
{
  if (!this._nodes)
    return null;

  var elem, jelem;
  var i, j, imax = this._nodes.length, jmax;
  for (i=0; i<imax; ++i) {
    elem = this._nodes[i];
    if (elem.obj_id==aId)
      return elem;
      //return {"pary": this._nodes, "ind": i};

    if (!("childNodes" in elem))
      continue;

    jmax = elem.childNodes.length;
    dd("#### "+elem.childNodes);

    for (j=0; j<jmax; ++j) {
      jelem = elem.childNodes[j];
      if (jelem.obj_id==aId)
        return jelem;
        //return {"pary": elem.childNodes, "ind": j};
    }
  }

  return null;
}

//////////////////////////
// Camera manipulations

ws.createCamera = function ()
{
  // TO DO: edit txn
  var scene = this._mainWnd.currentSceneW;
  var view = this._mainWnd.currentViewW;
  var i, name;
  for (i=0; ; ++i) {
    name = "camera_"+i;
    if (!scene.getCamera(name)) {
      var res = util.prompt(window, "Name for new camera: ", name);
      if (res===null) return;
      scene.saveViewToCam(view.uid, res);
      break;
    }
  }
}

ws.destroyCamera = function (name)
{
  // TO DO: edit txn
  var scene = this._mainWnd.currentSceneW;
  util.alert(window, "Delete camera: "+name);
  scene.destroyCamera(name);
}

//////////////////////////
// event handlers

ws.onLoad = function ()
{
  var that = this;
  var mainWnd = this._mainWnd = document.getElementById("main_view");

  //
  // for toolbar buttons
  //
  this.mBtnNew = document.getElementById("wspcPanelAddBtn");
  this.mBtnDel = document.getElementById("wspcPanelDeleteBtn");
  this.mBtnProp = document.getElementById("wspcPanelPropBtn");
  this.mBtnZoom = document.getElementById("wspcPanelZoomBtn");

  $("#objectTree")[0].addEventListener("select", function(e) { that.onTreeSelChanged(); }, false);

  //
  // setup the target scene
  //
  var scid = mainWnd.getCurrentSceneID();
  if (scid && scid>0)
    this.targetSceneChanged(scid);

  dd("workspace panel onLoad: MainView="+this._mainWnd+", target scene="+this.mTgtSceneID);

  //
  // setup tab-event handler for the MainTabView
  //
  mainWnd.mPanelContainer.addEventListener("select", function(aEvent) {
    var scid = mainWnd.getCurrentSceneID();
    //dd("Workspace panel: onSelect called: "+scid+", cur="+that.mTgtSceneID);
    if (scid != that.mTgtSceneID)
      that.targetSceneChanged(scid);
  }, false);

  /*
  this.mSceneCtxtMenu = $("#wspcPanelSceneCtxtMenu")[0];
  this.mObjCtxtMenu = $("#wspcPanelObjCtxtMenu")[0];
  this.mRendCtxtMenu = $("#wspcPanelRendCtxtMenu")[0];
   */
  //this.onTreeSelChanged();
}

ws.onUnLoad = function ()
{
  dd("Workspace Panel Unloading: scene ID="+this.mTgtSceneID+", callbackID = "+this._callbackID);
  // dd("Workspace Panel Unloading: scenemgr ="+this._scMgr._wrapped);

  // this._mainWnd.removeEventListener("select", this._mainViewEventHandler, false);
  var scene = cuemol.getScene(this.mTgtSceneID);

  dd("Workspace Panel Unloading: scene ="+scene);

  if (this._callbackID!=null && scene)
    scene.removeListener(this._callbackID);

  delete this._node;
  delete this.mViewObj;
  // delete this.mSceneCtxtMenuID;
  // delete this.mObjCtxtMenuID;
  // delete this.mRendCtxtMenuID;

  // dd(require("traceback").format());
  // window.alert('ws.fini');
}

ws._attachScene = function (scid)
{
  var scene = cuemol.getScene(scid);
  if (!scene)
    return;

  this.mTgtSceneID = scid;
  this.syncContents(scid);
  dd("WorkspacePanel: change the tgt scene to "+this.mTgtSceneID);

  var that = this;
  var handler = function (args) {
    switch (args.evtType) {
    case cuemol.evtMgr.SEM_ADDED:
      //window.alert("Scene event: SCE_OBJ_ADDED "+args);
      that.mViewObj.saveOpenState(args.srcUID);
      that.syncContents(args.srcUID);
      break;

    case cuemol.evtMgr.SEM_REMOVING:
      if (args.method=="cameraChanged")
        that.removeObject(args.obj.name);
      else
        that.removeObject(args.obj.target_uid);
      break;

    case cuemol.evtMgr.SEM_CHANGED:
      if (args.method=="sceneAllCleared")
        that.syncContents(args.srcUID);
      break;

    case cuemol.evtMgr.SEM_PROPCHG:
      //dd(debug.dumpObjectTree(args.obj));
      //dd("%%% WORKSPACE evtMgr.SEM_PROPCHG propname = "+args.obj.propname);
      if ("propname" in args.obj && (
        args.obj.propname=="name" ||
        args.obj.propname=="visible" ||
        args.obj.propname=="locked")) {
        // that.mViewObj.saveOpenState(args.srcUID);
        that.syncContentsPropChg(args.obj.target_uid, args.obj.propname);
      }
      break;
    }
  };
  
  this._callbackID = cuemol.evtMgr.addListener("",
                                               cuemol.evtMgr.SEM_SCENE|
                                               cuemol.evtMgr.SEM_OBJECT|
                                               cuemol.evtMgr.SEM_RENDERER|
                                               cuemol.evtMgr.SEM_CAMERA, // source type
                                               cuemol.evtMgr.SEM_ANY, // event type
                                               scene.uid, // source UID
                                               handler);

  /*
  // window.alert("XXX getScnene" + scid);
  if (scid>0) {
    var scene = cuemol.getScene(scid);
    this._callbackID = scene.addListener(new SceneEventListener(this));
  }
   */
}

// detach from the previous active scene
ws._detachScene = function (oldid)
{
  if (oldid<0) return;

  var oldscene = cuemol.getScene(oldid);
  if (oldscene && this._callbackID)
    cuemol.evtMgr.removeListener(this._callbackID);
  this._callbackID = null;

  // dd("===================");
  this.mViewObj.saveOpenState(oldid);
}

ws.targetSceneChanged = function (scid)
{
  try {
    if (scid==this.mTgtSceneID)
      return;
    //var oldid = this.mTgtSceneID;

    this._detachScene(this.mTgtSceneID);

    // attach to the new active scene
    this._attachScene(scid);

    this.onTreeSelChanged();
  }
  catch (e) {
    dd("Error in WS.targetSceneChanged !!");
    debug.exception(e);
  }
}

ws.onPanelShown = function ()
{
  this.mViewObj.ressignTreeView();
}
ws.onPanelMoved = function ()
{
  this.mViewObj.ressignTreeView();
}

ws.onNewCmd = function (aEvent)
{
  var elem = this.mViewObj.getSelectedNode();
  if (!elem) return;
  var id = elem.obj_id;

  if (elem.type=="object") {
    //var obj = ws._scMgr.getObject(id);
    gQm2Main.setupRendByObjID(id);
  }
  else if (elem.type=="renderer") {
    var rend = cuemol.getRenderer(id);
    var obj = rend.getClientObj();
    gQm2Main.setupRendByObjID(obj.uid);
  }
  else if (elem.type=="camera"||elem.type=="cameraRoot") {
    this.createCamera();
  }
  //else
  //return;
}

ws.onDeleteCmd = function (aEvent)
{
  var elem = this.mViewObj.getSelectedNode();
  if (!elem) return;
  var id = elem.obj_id;

  if (elem.type=="object") {
    deleteObject(id);
  }
  else if (elem.type=="renderer") {
    gQm2Main.deleteRendByID(id);
  }
  else if (elem.type=="camera") {
    this.destroyCamera(id);
  }

}

ws.onPropCmd = function ()
{
  var elem = this.mViewObj.getSelectedNode();
  if (!elem) return;
  //dd("onNewCmd elem="+require("debug_util").dumpObjectTree(elem, 1));
  var id = elem.obj_id;

  var target, scene;
  if (elem.type=="scene") {
    scene = target = cuemol.getScene(id);
  }
  else if (elem.type=="object") {
    target = cuemol.getObject(id);
    scene = target.getScene();
  }
  else if (elem.type=="renderer") {
    target = cuemol.getRenderer(id);
    scene = target.getScene();
    //dd("rend target: "+target._wrapped);
  }
  else if (elem.type=="camera") {
    scene = this._mainWnd.currentSceneW;
    target = scene.getCamera(elem.obj_id);
  }
  else
    return;
  
  gQm2Main.showPropDlg(target, scene, window, elem.type);
}

ws.onBtnZoomCmd = function ()
{
  var elem = this.mViewObj.getSelectedNode();
  if (!elem) return;
  //dd("onNewCmd elem="+require("debug_util").dumpObjectTree(elem, 1));
  var id = elem.obj_id;

  var target;
  var view = this._mainWnd.currentViewW;
  if (elem.type=="object") {
    target = cuemol.getObject(id);
    if (!('fitView' in target))
      return;
    target.fitView(false, view);
  }
  else if (elem.type=="renderer") {
    var rend = cuemol.getRenderer(id);
    target = rend.getClientObj();
    if (!('sel' in rend) || !('fitView' in target))
      return;
    target.fitView2(rend.sel, view);
  }
  else {
    return;
  }

  delete sel;
  delete target;

/*
  try {
    mol.fitView(true, view);
  }
  catch(e) {
    dd("SetCenter error");
    debug.exception(e);
  }
*/
}


ws.onLoadSaveCam = function (aEvent, aLoad)
{
  var elem = this.mViewObj.getSelectedNode();
  if (elem.type!="camera") return;

  var scene = this._mainWnd.currentSceneW;
  var view = this._mainWnd.currentViewW;
  if (!scene || !view) return;

  if (aLoad)
    scene.loadViewFromCam(view.uid, elem.obj_id);
  else 
    scene.saveViewToCam(view.uid, elem.obj_id);

}

ws.onCtxtMenu = function (aEvent)
{
  var tgtid = aEvent.target.id;
  /*
  if (tgtid=="wspc-bg-white") {
    var scene = this._mainWnd.currentSceneW;
    
  }
  else if (tgtid=="wspc-bg-black") {
  }
  */
}

ws.onTreeSelChanged = function ()
{
  //dd("******** ontreeselchanged called");
  var elem = this.mViewObj.getSelectedNode();
  if (elem) {
    if (elem.type=="scene") {
      this.mBtnNew.disabled = true;
      this.mBtnDel.disabled = true;
      this.mBtnProp.disabled = false;
      this.mBtnZoom.disabled = true;
      return;
    }
    else if (elem.type=="object") {
      this.mBtnNew.disabled = false;
      this.mBtnDel.disabled = false;
      this.mBtnProp.disabled = false;
      this.mBtnZoom.disabled = false;
      return;
    }
    else if (elem.type=="renderer") {
      this.mBtnNew.disabled = false;
      this.mBtnDel.disabled = false;
      this.mBtnProp.disabled = false;
      this.mBtnZoom.disabled = false;
      return;
    }
    else if (elem.type=="camera") {
      this.mBtnNew.disabled = false;
      this.mBtnDel.disabled = false;
      this.mBtnProp.disabled = false;
      //this.mBtnProp.disabled = true;
      this.mBtnZoom.disabled = true;
      return;
    }
    else if (elem.type=="cameraRoot") {
      this.mBtnNew.disabled = false;
      this.mBtnDel.disabled = true;
      this.mBtnProp.disabled = true;
      this.mBtnZoom.disabled = true;
      return;
    }
  }
  this.mBtnNew.disabled = true;
  this.mBtnDel.disabled = true;
  this.mBtnProp.disabled = true;
  this.mBtnZoom.disabled = true;
}

ws.onTreeItemClick = function (aEvent, elem, col)
{
  //dd("WS onClick: row="+row+", col="+col);
  // dd("WS onClick: detail="+aEvent.detail);

  if (col=="object_vis") {
    this.toggleVisible(elem);
  }
  else if (col=="object_lck") {
    dd("WS> Toggle LCK, obj_id="+elem.obj_id);
    dd("    Toggle LCK, object_lck="+elem.props.object_lck);

    this.toggleLocked(elem);

  }
  else if (aEvent.detail==2) {
    if (elem.type=="camera") {
      var scene = this._mainWnd.currentSceneW;
      var view = this._mainWnd.currentViewW;
      if (!scene || !view) return;
      scene.loadViewFromCam(view.uid, elem.obj_id);
      aEvent.preventDefault();
      aEvent.stopPropagation();
      return;
    }
    else {
      this.onPropCmd();
      return;
    }
  }
  
  aEvent.preventDefault();
  aEvent.stopPropagation();
}

ws.toggleVisible = function (aElem)
{
  var obj = null;
  if (aElem.type=="object")
    obj = cuemol.getObject(aElem.obj_id);
  else if (aElem.type=="renderer")
    obj = cuemol.getRenderer(aElem.obj_id);
  if (!obj) return;

  var scene = cuemol.getScene(this.mTgtSceneID);
  if (!scene) return;

  // EDIT TXN START //
  scene.startUndoTxn("Change visibility");
  try {
    obj.visible = !obj.visible;
  }
  catch (e) {
    dd("***** ERROR: Change visibility "+e);
    debug.exception(e);
  }
  scene.commitUndoTxn();
  // EDIT TXN END //
}

ws.toggleLocked = function (aElem)
{
  var obj = null;
  if (aElem.type=="object")
    obj = cuemol.getObject(aElem.obj_id);
  else if (aElem.type=="renderer")
    obj = cuemol.getRenderer(aElem.obj_id);
  if (!obj) return;

  var scene = cuemol.getScene(this.mTgtSceneID);
  if (!scene) return;

  var msg;
  if (obj.locked)
    msg="Unlock "+aElem.type;
  else
    msg="Lock "+aElem.type;

  // EDIT TXN START //
  scene.startUndoTxn(msg);
  try {
    obj.locked = !obj.locked;
  }
  catch (e) {
    dd("***** ERROR: Change locked "+e);
    debug.exception(e);
  }
  scene.commitUndoTxn();
  // EDIT TXN END //

  dd(">WS tglLck result, locked="+obj.locked);
}

ws.selectMol = function (aSelStr)
{
  var elem = this.mViewObj.getSelectedNode();
  if (elem.type!="object") return;

  var target = cuemol.getObject(elem.obj_id);
  if (!('sel' in target))
    return;

  var scene = target.getScene();
  var sel;

  // EDIT TXN START //
  if (aSelStr) {
    sel = cuemol.makeSel(aSelStr);
    scene.startUndoTxn("Select molecule");
  }
  else {
    sel = cuemol.createObj("SelCommand");
    scene.startUndoTxn("Unselect molecule");
  }

  try {
    target.sel = sel;
  }
  catch(e) {
    dd("SetProp error");
    debug.exception(e);
    scene.rollbackUndoTxn();
    return;
  }

  scene.commitUndoTxn();
  // EDIT TXN END //

  // Save to history
  util.selHistory.append(aSelStr);
}

ws.invertMolSel = function ()
{
  var elem = this.mViewObj.getSelectedNode();
  if (elem.type!="object") return;

  var target = cuemol.getObject(elem.obj_id);
  if (!('sel' in target))
    return;

  var scene = target.getScene();
  var sel = target.sel;

  sel = cuemol.makeInvSel(sel);

  // EDIT TXN START //
  scene.startUndoTxn("Invert mol selection");

  try {
    target.sel = sel;
  }
  catch(e) {
    dd("WS> SetProp error");
    debug.exception(e);
    scene.rollbackUndoTxn();
    return;
  }

  scene.commitUndoTxn();
  // EDIT TXN END //
}

ws.coloringMol = function (aEvent)
{
  var elem = this.mViewObj.getSelectedNode();
  if (elem.type!="renderer") return;

  var target = cuemol.getRenderer(elem.obj_id);
  if (!('coloring' in target)) {
    dd("WS.coloringMol> Error, coloring not supported in rend, "+elem.obj_id);
    return;
  }

  //alert("event value="+aEvent.target.value);
  gQm2Main.setRendColoring(aEvent.target.value, target);
}

ws.checkPaintColoring = function ()
{
  var elem = this.mViewObj.getSelectedNode();
  if (elem.type!="renderer") return null;

  var coloring;
  var target = cuemol.getRenderer(elem.obj_id);
  if ('coloring' in target)
    coloring = target.coloring;
  else {
    dd("WS.coloringMol> Error, coloring not supported in rend, "+elem.obj_id);
    return null;
  }

  var clsname = coloring._wrapped.getClassName();
  if (clsname!="PaintColoring") {
    dd("WS.coloringMol> Error, not paint coloring");
    return null;
  }

  return [coloring, target];
}

ws.paintMol = function (aEvent)
{
  dd("WS.paintMol: "+aEvent.target.localName);
  var value = aEvent.target.value;
  dd("WS.paintMol: "+value);

  var res = this.checkPaintColoring();
  var coloring = res[0];
  var target = res[1];
  var mol = target.getClientObj();
  var sel = mol.sel;
  if (sel.isEmpty()) {
    dd("WS.coloringMol> Error, cur sel is empty");
    return;
  }

  var scene = mol.getScene();

  // EDIT TXN START //
  scene.startUndoTxn("Insert paint entry");

  try {
    coloring.insertBefore(0, sel, cuemol.makeColor(value));
  }
  catch (e) {
    dd("***** ERROR: insewrtBefore "+e);
    debug.exception(e);
    scene.rollbackUndoTxn();
    return;
  }

  scene.commitUndoTxn();
  // EDIT TXN END //
};

ws.onStyleShowing = function (aEvent)
{
  try {

    var elem = this.mViewObj.getSelectedNode();
    //dd("elem.type_name="+elem.type_name);

    if (elem.type!="renderer") return;
    var regex = null;
    if (elem.type_name == "ribbon") {
      regex = /Ribbon$/;
    }
    else if (elem.type_name == "ballstick") {
      regex = /BallStick$/;
    }
    else if (elem.type_name == "atomintr") {
      regex = /AtomIntr$/;
    }

    var menu = aEvent.currentTarget.menupopup;
    cuemol.populateStyleMenus(this.mTgtSceneID, menu, regex);
    
  } catch (e) { debug.exception(e); }
}

ws.styleMol = function (aEvent)
{
  try {

    var elem = this.mViewObj.getSelectedNode();
    if (elem.type!="renderer")
      return;
    var rend = cuemol.getRenderer(elem.obj_id);

    var value = aEvent.target.value;
    var remove_re = aEvent.target.getAttribute("remove_re");
    var scene = rend.getScene();

    var style = value.substr("style-".length);
    dd("style: "+style);
    remove_re = remove_re.substr(1, remove_re.length-2);
    dd("remove_re: "+remove_re);

    // EDIT TXN START //
    scene.startUndoTxn("Change style");

    try {
      rend.removeStyleRegex(remove_re);
      rend.pushStyle(style);
    }
    catch (e) {
      dd("***** ERROR: pushStyle "+e);
      debug.exception(e);
      scene.rollbackUndoTxn();
      return;
    }
    scene.commitUndoTxn();
    // EDIT TXN END //

  } catch (e) { debug.exception(e); }
};

ws.setRendSel = function (aSelStr)
{
  var elem = this.mViewObj.getSelectedNode();
  if (elem.type!="renderer") return;

  var rend = cuemol.getRenderer(elem.obj_id);
  var mol = rend.getClientObj();
  if (!('sel' in rend) || !('sel' in mol))
    return;

  var sel;

  if (aSelStr=='current') {
    sel = mol.sel;
  }
  else {
    sel = cuemol.makeSel(aSelStr);
  }

  var scene = rend.getScene();

  // EDIT TXN START //
  scene.startUndoTxn("Set renderer sel");

  try {
    rend.sel = sel;
  }
  catch(e) {
    dd("SetProp error");
    debug.exception(e);
    scene.rollbackUndoTxn();
    return;
  }

  scene.commitUndoTxn();
  // EDIT TXN END //
}

ws.onRendCtxtMenuShowing = function (aEvent)
{
  var paintitem = document.getElementById("wspcPanelPaintMenu");
  var editiitem = document.getElementById("wspcPanelEditIntrMenu");
  paintitem.hidden = true;
  editiitem.hidden = true;

  if (this.checkPaintColoring()!==null)
    paintitem.hidden = false;

  if (this.checkIntrRend()!=null)
    editiitem.hidden = false;
}

ws.checkIntrRend = function ()
{
  var elem = this.mViewObj.getSelectedNode();
  if (elem.type!="renderer") return null;

  var target = cuemol.getRenderer(elem.obj_id);
  if (target.type_name !== "atomintr")
    return null;
  return target;
}

ws.onEditIntr = function ()
{
  var rend = this.checkIntrRend();
  
  var args = Cu.getWeakReference({target: rend});
  window.openDialog("chrome://cuemol2/content/aintr-edit-dlg.xul",
                    null,
                    "chrome,modal,resizable=no,dependent,centerscreen",
                    args);
}

} )();

}

