/* -*- Mode: C++; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*-
*/

/*
var EXPORTED_SYMBOLS = ["foo", "bar"];

function foo() {
  return "foo";
}

var bar = {
  name : "bar",
  size : "3"
};

var dummy = "dummy";
*/

const Cc = Components.classes;
const Ci = Components.interfaces;
const Cu = Components.utils;
const Cr = Components.results;
var manager = Components.manager.QueryInterface(Ci.nsIComponentRegistrar);

var ios = Cc['@mozilla.org/network/io-service;1'].getService(Ci.nsIIOService);
var gHarness;

//dump("******** jpk_hns.js executing ********** \n");

var resProt = ios.getProtocolHandler("resource").QueryInterface(Ci.nsIResProtocolHandler);
var fileProt = ios.getProtocolHandler("file").QueryInterface(Ci.nsIFileProtocolHandler);
var appURI = resProt.getSubstitution("app");
var installPath = fileProt.getFileFromURLSpec(appURI.spec);

//var dirsvc = Cc["@mozilla.org/file/directory_service;1"].getService(Ci.nsIProperties);
//var curproc_dir = dirsvc.get("CurProcD", Ci.nsIFile);
//var installPath = curproc_dir;

//dump("********"+ installPath.path +"\n");

(function setupHarness(installPath, loadReason) {
   var harnessJs = installPath.clone();
  harnessJs.append("resources");
  harnessJs.append("harness.js");
  var path = ios.newFileURI(harnessJs).spec;
  var harness = {};
  var loader = Cc["@mozilla.org/moz/jssubscript-loader;1"]
               .getService(Ci.mozIJSSubScriptLoader);
  loader.loadSubScript(path, harness);

  var defaults = harness.getDefaults(installPath);
  var HarnessService = harness.buildHarnessService(
    installPath,
    defaults.dump,
    defaults.logError,
    defaults.onQuit,
    defaults.options
  );

  var factory = HarnessService.prototype._xpcom_factory;
  var proto = HarnessService.prototype;

  // We want to keep this factory around for the lifetime of
  // the addon so legacy code with access to Components can
  // access the addon if needed.
  manager.registerFactory(proto.classID,
                          proto.classDescription,
                          proto.contractID,
                          factory);

  var harnessService = factory.createInstance(null, Ci.nsISupports);
  harnessService = harnessService.wrappedJSObject;

  gHarness = {
    service: harnessService,
    classID: proto.classID,
    contractID: proto.contractID,
    factory: factory
  };

dump("proto.contractID: "+proto.contractID+"\n");
dump("proto.classID: "+proto.classID+"\n");
  harnessService.load(loadReason);
})(installPath, "startup");

function require(a) {
  return gHarness.service.loader.require(a);
}

var EXPORTED_SYMBOLS = ["require", "gHarness"];

