
function openPDB(aPath, newobj_name)
{
  var StrMgr = getService("StreamManager");
  var reader = StrMgr.createHandler("pdb", 0);
  reader.setPath(aPath);

  scene.startUndoTxn("Open file");
  var newobj=null;
  try {
    newobj = reader.createDefaultObj();
    reader.attach(newobj);
    reader.read();
    reader.detach();
    
    newobj.name = newobj_name;
    scene.addObject(newobj);
  }
  catch (e) {
    print("File Open Error: "+e.message);
    scene.rollbackUndoTxn();
    return;
  }
  scene.commitUndoTxn();
  // EDIT TXN END //

  return newobj;
}

function dumpObjectTree (o, recurse, compress, level)
{
  var s = "";
  var pfx = "";

  if (typeof recurse == "undefined")
    recurse = 0;
  if (typeof level == "undefined")
    level = 0;
  if (typeof compress == "undefined")
    compress = true;

  for (var i = 0; i < level; i++)
    pfx += (compress) ? "| " : "|  ";

  var tee = (compress) ? "+ " : "+- ";

  for (i in o) {
    var t;
    try {
      t = typeof o[i];

      switch (t) {
      case "function":
        var sfunc = String(o[i]).split("\n");
        if (sfunc[2] == "    [native code]")
          sfunc = "[native code]";
        else
          sfunc = sfunc.length + " lines";
        s += pfx + tee + i + " (function) " + sfunc + "\n";
        break;

      case "object":
        s += pfx + tee + i + " (object) " + o[i] + "\n";
        if (!compress)
          s += pfx + "|\n";
        if ((i != "parent") && (recurse))
          s += dumpObjectTree (o[i], recurse - 1,
                               compress, level + 1);
        break;

      case "string":
        if (o[i].length > 200)
          s += pfx + tee + i + " (" + t + ") " +
            o[i].length + " chars\n";
        else
          s += pfx + tee + i + " (" + t + ") '" + o[i] + "'\n";
        break;

      default:
        s += pfx + tee + i + " (" + t + ") " + o[i] + "\n";
      }
    }
    catch (ex) {
      s += pfx + tee + i + " (exception) " + ex + "\n";
    }

    if (!compress)
      s += pfx + "|\n";

  }

  s += pfx + "*\n";

  return s;

}

print("Utils loaded.");

