#!/bin/sh

cwd=`pwd`

top_srcdir=$cwd/../src/
install_dir=$top_srcdir/xul_gui/
#debug="--disable-debug"
debug="--enable-debug"

##

gecko_sdk_dir=$HOME/proj/xulrunner-sdk/
# gecko_sdk_dir=$HOME/src/xulrunner-1.9.1.2/obj-xr/dist
# gecko_sdk_dir=$HOME/src/xulrunner-1.9.1.2-sdk/

boost_dir=$HOME/proj/boost/
fftw_dir=$HOME/proj/
libpng_dir=$HOME/proj/

#######################

config_scr=../src/configure

if test ! -f $config_scr; then
    (
	cd ../src
	aclocal; glibtoolize --force; aclocal; autoheader; automake -a; autoconf;
	cd js
	aclocal; autoheader; automake -a; autoconf;
    )	
fi

$config_scr \
--prefix=$install_dir \
--with-xulrunner-sdk=$gecko_sdk_dir \
--with-boost=$boost_dir \
--with-fftw=$fftw_dir \
--with-libpng=$libpng_dir \
$debug \
--enable-xpcom

# --enable-npruntime
