// -*-Mode: C++;-*-
//
//  Backbone tube renderer
//

#ifndef TUBE_RENDERER_HPP_INCLUDED
#define TUBE_RENDERER_HPP_INCLUDED

#include "molvis.hpp"

#include "SplineRenderer.hpp"
#include "TubeSection.hpp"

namespace molvis {

class TubeRenderer : public SplineRenderer
{
  MC_SCRIPTABLE;
  MC_CLONEABLE;

private:

  typedef SplineRenderer super_t;

  /// Tube section data
  TubeSectionPtr m_pts;

  //////////////////////////////////////////////////////

public:
  TubeRenderer();
  virtual ~TubeRenderer();

  // virtual Renderer *create();

  virtual const char *getTypeName() const;

  //////////////////////////////////////////////////////

  virtual void beginRend(DisplayContext *pdl);

  // virtual void endSegment(DisplayCommand *pdl, MolResidue *pRes);
  // virtual void display(DisplayContext *pdc);
  // virtual void rendHitResid(DisplayCommand *phl, MolResidue *pRes);

  //////////////////////////////////////////////////////

  virtual void renderSpline(DisplayContext *pdl, SplineCoeff *pCoeff,
                            MolResiduePtr pStartRes, double fstart,
                            MolResiduePtr pEndRes, double fend);

  ////////////////////////////////////////////
  // property handling

  virtual void propChanged(qlib::LPropEvent &ev);


  //////////////////////////////////////////////////////

  TubeSectionPtr getTubeSection() const {
    return m_pts;
  }

  //void setTubeSection(TubeSectionPtr pts) {
  //m_pts = pts;
  //}

  void setWidth(double f) {
    m_pts->setWidth(f);
  }

  double getWidth() const {
    return m_pts->getWidth();
  }

  void setTuber(double f) {
    m_pts->setTuber(f);
  }


};

} // namespace molvis

#endif

