// -*-Mode: C++;-*-
//
// $Id: cuemol2-utils.js,v 1.19 2011/05/01 09:28:03 rishitani Exp $
//

const Cc = Components.classes;
const Ci = Components.interfaces;
const Cu = Components.utils;
const Cr = Components.results;

// Cu.import("resource://app/resources/jpk_hns.js");
Cu.import("resource://app/components/appboots.js");

var appStartup = Cc['@mozilla.org/toolkit/app-startup;1'].getService(Ci.nsIAppStartup);

const XPCCUEMOL_CID = "@cuemol.org/XPCCueMol";
if (!(XPCCUEMOL_CID in Cc)) {
  alert("FATAL ERROR!!\nCueMol XPCOM component is not registered!!");
  appStartup.quit(appStartup.eForceQuit);
}

var cuemol = require("cuemol");

var cuemolui = new Object();

const debug = require("debug_util");
const dd = debug.dd;
const util = require("util");

 /*
function extendClass(subclass, superclass)
{
  var f = function() {};
  f.prototype = superclass.prototype;
  subclass.prototype = new f();
  subclass.prototype.constructor = subclass;
  subclass.superclass = superclass.prototype;
  if (superclass.prototype.constructor == Object.prototype.constructor) {
    superclass.prototype.constructor = superclass;
  }
};
function extendClass(s, c)
{
  function f(){};
  f.prototype = s.prototype;
  c.prototype = new f();
  c.prototype.__super__ = s.prototype;
  c.prototype.__super__.constructor = s;
  c.prototype.constructor = c;
  return c;
};
*/

////////////////////////////////

cuemolui.onPaintColShowing = function (aEvent)
{
  try {
    var scene_id = gQm2Main.mMainWnd.getCurrentSceneID();
    var menu = aEvent.currentTarget.menupopup;
    cuemolui.populateStyleMenus(scene_id, menu, /Paint$/);
  } catch (e) { debug.exception(e); }
};

cuemolui.populateStyleMenus = function (scene_id, menu, regexp)
{
  util.clearMenu(menu);

  if (regexp==null) {
    var item = util.appendMenu(document, menu, "", "(no styles)");
    //item.disabled = true;
    item.setAttribute("disabled", "true");
    return;
  }

  var stylem = cuemol.getService("StyleManager");

  json = stylem.getStyleNamesJSON(0);
  //dd("JSON: "+json);
  var names = JSON.parse(json);

  //dd("StyleSet JSON (system): "+stylem.getStyleSetsJSON(0));

  if (scene_id!=null) {
    json = stylem.getStyleNamesJSON(scene_id);
    //dd("JSON: "+json);
    names = names.concat( JSON.parse(json) );
    //dd("StyleSet JSON (scene): "+stylem.getStyleSetsJSON(scene_id));
  }
  
  //dd("MenuElem: "+menu.localName);
  var nitems = names.length;
  var name, value, label, res;
  for (var i=0; i<nitems; ++i) {
    name = names[i].name;
    res = name.match(regexp);
    if (res==null) {
      //dd("Style "+name+" no match: "+regexp);
      continue;
    }
    value = "style-"+name;
    label = names[i].desc;
    if (!label)
      label = name;
    var item = util.appendMenu(document, menu, value, label);
    item.setAttribute("remove_re", regexp);

    dd("PaintColAddMenu = "+name+", desc="+label);
  }
};

