//
// Protein secondary structure calculation tool
//

cuemolui.onProt2ndry = function ()
{
  var stylestr = "chrome,resizable=no,dependent,centerscreen,modal";

  var scene_id = gQm2Main.mMainWnd.getCurrentSceneID();
  var view_id = gQm2Main.mMainWnd.getCurrentViewID();
  var win = gQm2Main.mWinMed.getMostRecentWindow("CueMol2:Prot2ndry");

  if (win) {
    win.focus();
  }
  else
    window.openDialog("chrome://cuemol2/content/tools/prot2ndry-tool-dlg.xul", "",
		      stylestr, scene_id, view_id);
};

//
// Dialog implementation
//
if (!("Prot2ndryTool" in cuemolui)) {

  cuemolui.Prot2ndryTool = ( function() {

    // constructor
    var ctor = function ()
    {
      var that = this;

      this.mTargetSceneID = window.arguments[0];
      this.mTargetViewID = window.arguments[1];

      var filter_fn = function (elem) {
	return cuemol.implIface(elem.type, "MolCoord");
      };

      this.mTargMol = new cuemolui.ObjMenuList(
	"targ_mol",
	window, filter_fn,
	cuemol.evtMgr.SEM_OBJECT);
      this.mTargMol._tgtSceID = this.mTargetSceneID;

      window.addEventListener("load", function(){that.onLoad();}, false);
    };

    var klass = ctor.prototype;

    ////////////////////////////////////////////////

    // private initialization routine
    klass.onLoad = function ()
    {
      let that = this;

      this.mHbMax = document.getElementById('hbmax');

      this.mTargMol.addSelChanged(function(aEvent) {
	try { that.onTargMolChanged(aEvent);}
	catch (e) { debug.exception(e); }
      });

      this.mTargSel = document.getElementById('targ_molsel');
      this.mTargSel.targetSceID = this.mTargetSceneID;
      
      this.mSecTypeSel = document.getElementById('sec_type');

      this.mRadRecalc = document.getElementById('radio_recalc');
      this.mRadRecalc.addEventListener("command",
				       function (e) { that.onRadSelChg(e.target.id); },
				       false);
      this.mRadAsgn = document.getElementById('radio_assign');
      this.mRadAsgn.addEventListener("command",
				     function (e) { that.onRadSelChg(e.target.id); },
				     false);

      if (this.mTargMol._widget.itemCount==0) {
	// no mol object in the scene
	document.documentElement.getButton("accept").disabled = true;
	this.mTargSel.disabled = true;
	this.mRadRecalc.disabled = true;
	this.mRadAsgn.disabled = true;
	this.mSecTypeSel.disabled = true;
	dd("Prot2ndry> No mol in the scene!!");
	return;
      }

      this.mTargMol._widget.selectedIndex = 0;
      this.onTargMolChanged();
      this.mTargSel.buildBox();

      this.onRadSelChg("radio_recalc");
    };
    
    klass.onRadSelChg = function (tgtid)
    {
      //let tgtid = aEvent.target.id;
      dd("onRadioSelChanged: "+tgtid);
      if (tgtid=="radio_recalc") {
	this.mHbMax.disabled = false;
	this.mTargSel.disabled = true;
	this.mSecTypeSel.disabled = true;
      }
      else if (tgtid=="radio_assign") {
	this.mHbMax.disabled = true;
	this.mTargSel.disabled = false;
	this.mSecTypeSel.disabled = false;
      }
    };

    klass.onTargMolChanged = function ()
    {
      var mol = this.mTargMol.getSelectedObj();
      if (mol)
	this.mTargSel.molID = mol.uid;
    };

    klass.onDialogAccept = function ()
    {
      let tgtmol = this.mTargMol.getSelectedObj();
      if (tgtmol==null) {
	dd("IntrTool: mol not selected!!");
	util.alert(window, "Mol is not selected.");
	return false;
      }

      if (document.getElementById('radio_recalc').selected)
	return this.doRecalc(tgtmol);
      else
	return this.doAssign(tgtmol);
      
    }

    klass.doRecalc = function (tgtmol)
    {
      let scene = tgtmol.getScene();

      // dd("DlgAcc> min="+this.mMinDist.value);
      let hbmax = parseFloat(this.mHbMax.value);
      if (isNaN(hbmax))
	return false;

      /////////////////////////////////////

      let mgr = cuemol.getService("MolAnlManager");

      // EDIT TXN START //
      scene.startUndoTxn("Recalc protein secondary str");

      try {
	mgr.calcProt2ndry(tgtmol, hbmax);
      }
      catch (e) {
	dd("calcProt2ndry Error!!");
	debug.exception(e);
	scene.rollbackUndoTxn();
	return false;
      }

      scene.commitUndoTxn();
      // EDIT TXN END //

      return true;
    };
    
    klass.doAssign = function (tgtmol)
    {
      let scene = tgtmol.getScene();
      let tgtsel = this.mTargSel.selectedSel;
      let nsectype = this.mSecTypeSel.selectedItem.value;

      dd("Target sel: "+tgtsel);
      dd("Sec type: "+nsectype);

      /////////////////////////////////////

      let mgr = cuemol.getService("MolAnlManager");

      // EDIT TXN START //
      scene.startUndoTxn("Assign protein secondary str");

      try {
	mgr.setProt2ndry(tgtmol, tgtsel, nsectype);
      }
      catch (e) {
	dd("setProt2ndry Error!!");
	debug.exception(e);
	scene.rollbackUndoTxn();
	return false;
      }

      scene.commitUndoTxn();
      // EDIT TXN END //

      return true;
    };

    return ctor;

  } )();

}

