//
//
//

dump("########## cuemol.js loading ... ##########\n");

const {Cc,Ci,Cu,Cr} = require("chrome");
var debug = require("debug_util");
var tbk = require("traceback");

//const debug = require("debug_util");
var dd = debug.dd;

const XPCCUEMOL_CID = "@cuemol.org/XPCCueMol";

var xpc = exports.xpc = Cc[XPCCUEMOL_CID].getService(Ci.qICueMol);

var wr_classes = new Object();

var dummy = {
  utils: {}
};

function getWrapperCtor(class_name)
{
  var wrClassName = "wrapper_" + class_name;
  var ctor;

  if (wrClassName in wr_classes) {
    //dd("NEW using loaded: "+filenm);
    ctor = wr_classes[wrClassName];
  }
  else {
    // wrapper class is not loaded
    filenm = "resource://app/resources/cuemol-wrappers/"+class_name+".js";
    //dd("NEW Loading: "+filenm);
    Cu.import(filenm, wr_classes);
    ctor = wr_classes[wrClassName];
  }

  return ctor;
};

convPolymObj =
exports.convPolymObj =
dummy.utils.convPolymObj =
function convPolymObj(aWrapped)
{
  //dd("cuemol(module).convPolymObj called.");

  if (typeof(aWrapped) === 'undefined') return null;

  var clsnm, wrclsnm, filenm;
  try {
    clsnm = aWrapped.getClassName();
    var ctor = getWrapperCtor(clsnm);
    var obj = new ctor (aWrapped, dummy);
    if (debug.isdebug()) {
      // set debug message (stack frame info)
      aWrapped.setDbgMsg( tbk.format() );
    }
    return obj;
  }
  catch(e) {
    debug.exception(e);
    dd("ERROR: Argument of convPolymObj("+aWrapped+") is not a XPCCueMol object: "+e+"\n");
    return null;
  }

};

exports.implIface = function (aClassName, aIfName)
{
  var key = "@implements_"+aIfName;
  try {
    var ctor = getWrapperCtor(aClassName);
    if (key in ctor)
      return true;
    else
      return false;
  }
  catch(e) {
    debug.exception(e);
    dd("ERROR: implementsIface\n");
    return false;
  }
};

exports.getErrMsg = function ()
{
  return xpc.getErrMsg();
};

exports.getService = function (name)
{
  if (!xpc.isInitialized())
    return null;
  var obj = xpc.getService(name);
  return convPolymObj(obj);
};

exports.createObj = function (name)
{
  if (!xpc.isInitialized())
    return null;

  var obj = xpc.createObj(name);
  return convPolymObj(obj);
};

exports.__defineGetter__("sceMgr", function() {
  if (!xpc.isInitialized())
    return null;
  if (this._sceMgr==null)
    this._sceMgr = exports.getService("SceneManager");
  return this._sceMgr;
});

exports.getUIDObj = function (aObjID)
{
  return exports.sceMgr.getUIDObj(aObjID);
};

exports.getObject = function (aObjID)
{
  return exports.sceMgr.getObject(aObjID);
};

exports.getScene = function (aID)
{
  return exports.sceMgr.getScene(aID);
};

exports.getRenderer = function (aID)
{
  return exports.sceMgr.getRenderer(aID);
};

exports.getView = function (aID)
{
  return exports.sceMgr.getView(aID);
};

///////////////////////////////////////////////
// helper methods

exports.makeSel = function(selstr, uid)
{
  var sel = exports.createObj("SelCommand");
  if (uid) {
    if (!sel.compile(selstr, uid))
      return null;
  }
  else {
    if (!sel.compile(selstr, 0))
      return null;
  }
  return sel;
};

exports.makeInvSel = function(sel)
{
  var selstr = sel.toString();
  var invsel;
  if (selstr=="") {
    invsel = "*";
  }
  else {
    var res = selstr.match(/!\s*\((.+)\)/);
    if (res==null)
      invsel = "!("+selstr+")";
    else 
      invsel = res[1];
  }
  dd("MakeInvSel invsel="+invsel);
  return exports.makeSel(invsel);
};


exports.makeColor = function(str, uid)
{
  var stylem = exports.getService("StyleManager");
  var color = null;
  if (uid) {
    color = stylem.compileColor(str, uid);
  }
  else {
    color = stylem.compileColor(str, 0);
  }

  return color;
};

exports.resetProp = function (obj, propname)
{
  obj._wrapped.resetProp(propname);
};

exports.hasProp = function (obj, propname)
{
  return obj._wrapped.hasProp(propname);
};

exports.getClassName = function (obj)
{
  return obj._wrapped.getClassName();
};

exports.instanceOf = function (obj, ifname)
{
  return obj._wrapped.instanceOf(ifname);
};


exports.putLogMsg = function (msg)
{
  var logMgr = exports.getService("MsgLog");
  logMgr.writeln(msg);
};

//dump("########## cuemol.js loaded ##########\n");

