/*
 * Cueplot: a GUI front-end to gnuplot
 * Copyright (C) 2007, 2008 Muneyuki Noguchi
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation, 
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
#include "ConsoleDialog.h"
#include "ConsoleScrollArea.h"

#include <QtCore/QCoreApplication>
#include <QtGui/QVBoxLayout>

ConsoleDialog::ConsoleDialog(QWidget *parent)
: QDialog(parent)
{
	setWindowTitle(tr("Console") + " - " 
			+ QCoreApplication::applicationName());

	consoleTextEdit = new ConsoleScrollArea;
	connect(consoleTextEdit, SIGNAL(executed(const QString &)),
			this, SIGNAL(executed(const QString &)));

	QVBoxLayout *mainLayout = new QVBoxLayout;
	mainLayout->addWidget(consoleTextEdit);

	setLayout(mainLayout);
}

void ConsoleDialog::execute(const QString &command)
{
	if (consoleTextEdit->isLocked()) {
		consoleTextEdit->setLocked(false);
	} else {
		consoleTextEdit->append(command + '\n');
	}
}

void ConsoleDialog::readStandardError(const QByteArray &output)
{
	QString command = QString(output.data());
	if (!command.trimmed().isEmpty()) {
		// エラー出力は赤で表示
		consoleTextEdit->append("<font color=\"red\">" 
				+ command + "</font>\n");
	}
}
