/*
 * Cueplot: a GUI front-end to gnuplot
 * Copyright (C) 2007, 2008 Muneyuki Noguchi
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation, 
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
#ifndef MAIN_WINDOW_INCLUDED
#define MAIN_WINDOW_INCLUDED

class PlotDataWidget;
class PlotInputWidget;
class Process;

#include <QtGui/QMainWindow>
class QCloseEvent;

//! メインウィンドウ
class MainWindow : public QMainWindow
{
	Q_OBJECT

	public:
		explicit MainWindow(QWidget *parent = 0);

	private slots:
		//! plot コマンドを実行する
		void plot();
		//! splot コマンドを実行する
		void splot();
		//! save コマンドを実行する
		void save();
		//! ファイル名を指定して save コマンドを実行する
		void saveAs();
		//! load コマンドを実行する
		void load();
		//! 「生のコマンド」ダイアログを表示する
		void rawCommand();
		//! 「フィッティング」ダイアログを表示する
		void fit();
		//! 「オプション」ダイアログを表示する
		void set();
		//! 「設定」メニューを開く際にダイアログの表示/非表示を調べる
		void setSettingsAction();
		/*! 
		 * \brief「コンソール」ダイアログを表示するかどうかを設定する
		 * \param visible 表示させるときは true
		 */
		void console(bool visible);
		//! 「Cueplot を設定」ダイアログを表示する
		void config();
		//! 「これは何?」
		void whatsThis();
		//! 「Cueplot について」ダイアログを表示する
		void about();

	private:
		// don't implement these
		MainWindow(const MainWindow &);
		MainWindow &operator=(const MainWindow &);

		//! QAction オブジェクトを生成する
		void createActions();
		//! メニューを作成する
		void createMenus();
		//! Cleanlooks (GNOME) 用メニューを作成する
		void createCleanlooksMenus();
		//! Mac OS X 用メニューを作成する
		void createMacMenus();
		//! Plastique (KDE) 用メニューを作成する
		void createPlastiqueMenus();
		//! Windows 用メニューを作成する
		void createWindowsMenus();
		//! ツールバーを作成する
		void createToolBars();
		//! 設定を読み込む
		void readSettings();
		//! 設定を書き込む
		void writeSettings();
		//! ウィンドウを閉じるときの処理をする
		void closeEvent(QCloseEvent *event);
		PlotDataWidget *plotDataWidget;
		PlotInputWidget *plotInputWidget;
		Process *process;
		//! 開いている gnuplot ファイル
		QString currentFile;
		QToolBar *toolBar;
		QAction *loadAct;
		QAction *saveAct;
		QAction *saveAsAct;
		QAction *quitAct;
		QAction *plotAct;
		QAction *splotAct;
		QAction *rawCommandAct;
		QAction *fitAct;
		QAction *setAct;
		QAction *toolBarAct;
		QAction *statusBarAct;
		QAction *consoleAct;
		QAction *configAct;
		QAction *whatsThisAct;
		QAction *aboutAct;
		QAction *aboutQtAct;
};
#endif // MAIN_WINDOW_INCLUDED
