/*
 * Cueplot: a GUI front-end to gnuplot
 * Copyright (C) 2007, 2008 Muneyuki Noguchi
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation, 
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
#include "AnglesOptionWidget.h"
#include "Angles.h"

#include <QtGui/QRadioButton>
#include <QtGui/QVBoxLayout>

AnglesOptionWidget::AnglesOptionWidget(QWidget *parent)
: OptionWidget(parent), angles(0)
{
	setWindowTitle(tr("Angles"));
}

AnglesOptionWidget::~AnglesOptionWidget()
{
	delete angles;
}

void AnglesOptionWidget::construct()
{
	setWhatsThis("set angles");

	degreesRadioButton = new QRadioButton;
	degreesRadioButton->setText(tr("D&egrees"));
	connect(degreesRadioButton, SIGNAL(toggled(bool)),
			this, SIGNAL(modified()));

	radiansRadioButton = new QRadioButton;
	radiansRadioButton->setText(tr("&Radians"));
	connect(radiansRadioButton, SIGNAL(toggled(bool)),
			this, SIGNAL(modified()));

	QVBoxLayout *mainLayout = new QVBoxLayout;
	mainLayout->addWidget(degreesRadioButton);
	mainLayout->addWidget(radiansRadioButton);
	mainLayout->addStretch();

	setLayout(mainLayout);
}

void AnglesOptionWidget::init()
{
	delete angles;
	angles = new Angles;
	setWidget();
}

void AnglesOptionWidget::apply()
{
	angles->setDegrees(degreesRadioButton->isChecked());

	emit executed(angles->command());
}

void AnglesOptionWidget::setWidget()
{
	bool isDegrees = angles->isDegrees();
	degreesRadioButton->setChecked(isDegrees);
	radiansRadioButton->setChecked(!isDegrees);
}
