/*
 * Cueplot: a GUI front-end to gnuplot
 * Copyright (C) 2007, 2008 Muneyuki Noguchi
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation, 
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
#include "GridOptionWidget.h"
#include "Grid.h"

#include <QtGui/QCheckBox>
#include <QtGui/QGridLayout>

GridOptionWidget::GridOptionWidget(QWidget *parent)
: OptionWidget(parent), grid(0)
{
	setWindowTitle(tr("Grid"));
}

GridOptionWidget::~GridOptionWidget()
{
	while (!gridCheckBoxList.isEmpty()) {
		delete gridCheckBoxList.takeFirst();
	}
	delete grid;
}

void GridOptionWidget::construct()
{
	setWhatsThis("set grid");

	for (int i = 0; !Grid::AXIS[i].isEmpty(); i++) {
		QCheckBox *gridCheckBox = new QCheckBox;
		gridCheckBox->setText(Grid::AXIS[i] + tr(" axis"));
		connect(gridCheckBox, SIGNAL(toggled(bool)),
				this, SIGNAL(modified()));
		gridCheckBoxList.append(gridCheckBox);
	}

	const int num = 2;

	QGridLayout *mainLayout = new QGridLayout;
	for (int i = 0; !Grid::AXIS[i].isEmpty(); i++) {
		mainLayout->addWidget(gridCheckBoxList[i], i / num, i % num);
	}
	mainLayout->addItem(new QSpacerItem(0, 0, 
				QSizePolicy::Expanding, QSizePolicy::Minimum), 0, num + 1);
	mainLayout->addItem(new QSpacerItem(0, 0,
				QSizePolicy::Minimum, QSizePolicy::Expanding),
			gridCheckBoxList.size() / num, 0);

	setLayout(mainLayout);
}

void GridOptionWidget::init()
{
	delete grid;
	grid = new Grid;
	setWidget();
}
void GridOptionWidget::apply()
{
	for (int i = 0; !Grid::AXIS[i].isEmpty(); i++) {
		grid->setGrid(i, gridCheckBoxList.at(i)->isChecked());
	}
	emit executed(grid->command());
}

void GridOptionWidget::setWidget()
{
	for (int i = 0; !Grid::AXIS[i].isEmpty(); i++) {
		gridCheckBoxList[i]->setChecked(grid->isGrid(i));
	}
}
