/*
 * Cueplot: a GUI front-end to gnuplot
 * Copyright (C) 2007 Muneyuki Noguchi
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation, 
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
#ifndef SAMPLES_OPTION_WIDGET_INCLUDED
#define SAMPLES_OPTION_WIDGET_INCLUDED

#include "OptionWidget.h"

class Samples;

class QSpinBox;

//! set samples コマンドのオプションを扱うウィジェット
class SamplesOptionWidget : public OptionWidget
{
	Q_OBJECT

	public:
		explicit SamplesOptionWidget(QWidget *parent = 0);
		~SamplesOptionWidget();

		void construct();

	private:
		// don't implement these
		SamplesOptionWidget(const SamplesOptionWidget &);
		SamplesOptionWidget &operator=(const SamplesOptionWidget &);

		void init();
		void apply();
		void setWidget();
		Samples *samples;
		QSpinBox *oneSpinBox;
		QSpinBox *twoSpinBox;
};
#endif // SAMPLES_OPTION_WIDGET_INCLUDED
