/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.clustering.tribes;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.axis2.clustering.tribes.TribesUtil;
import org.apache.catalina.tribes.ChannelMessage;
import org.apache.catalina.tribes.group.ChannelInterceptorBase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AtMostOnceInterceptor
extends ChannelInterceptorBase {
    private static Log log = LogFactory.getLog((Class)AtMostOnceInterceptor.class);
    private static final Map receivedMessages = new HashMap();
    private static final int TIMEOUT = 300000;

    public AtMostOnceInterceptor() {
        Thread cleanupThread = new Thread(new MessageCleanupTask());
        cleanupThread.setPriority(1);
        cleanupThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void messageReceived(ChannelMessage msg) {
        Map map = receivedMessages;
        synchronized (map) {
            if (receivedMessages.get(msg) == null) {
                receivedMessages.put(msg, new Long(System.currentTimeMillis()));
                super.messageReceived(msg);
            } else {
                log.info((Object)("Duplicate message received from " + TribesUtil.getHost(msg.getAddress())));
            }
        }
    }

    private class MessageCleanupTask
    implements Runnable {
        private MessageCleanupTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (true) {
                try {
                    Thread.sleep(300000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                try {
                    ArrayList<ChannelMessage> toBeRemoved = new ArrayList<ChannelMessage>();
                    Thread.yield();
                    Map map = receivedMessages;
                    synchronized (map) {
                        ChannelMessage msg;
                        Iterator<Object> iterator = receivedMessages.keySet().iterator();
                        while (iterator.hasNext()) {
                            msg = (ChannelMessage)iterator.next();
                            long arrivalTime = (Long)receivedMessages.get(msg);
                            if (System.currentTimeMillis() - arrivalTime < 300000L) continue;
                            toBeRemoved.add(msg);
                            if (toBeRemoved.size() <= 10000) continue;
                            break;
                        }
                        iterator = toBeRemoved.iterator();
                        while (iterator.hasNext()) {
                            msg = (ChannelMessage)iterator.next();
                            receivedMessages.remove(msg);
                            if (!log.isDebugEnabled()) continue;
                            log.debug((Object)"Cleaned up message ");
                        }
                        continue;
                    }
                }
                catch (Exception e) {
                    log.error((Object)"Exception occurred while trying to cleanup messages", (Throwable)e);
                    continue;
                }
                break;
            }
        }
    }
}

