/*
 * Aipo is a groupware program developed by Aimluck,Inc.
 * http://aipostyle.com/
 * 
 * Copyright(C) 2011 avanza Co.,Ltd. All rights reserved.
 * http://www.avnz.co.jp/
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

package com.aimluck.eip.common;

import com.aimluck.commons.field.ALNumberField;
import com.aimluck.commons.field.ALStringField;

/**
 * 役割情報を表すクラスです。 <br />
 * 
 */
public class ALEipRole implements ALData {

  /** 役割ID */
  private ALNumberField role_id;

  /** 役割名 */
  private ALStringField role_name;

  /**
   * 
   */
  public void initField() {
    role_id = new ALNumberField();
    role_name = new ALStringField();
  }

  /**
   * @return
   */
  public ALNumberField getRoleId() {
    return role_id;
  }

  /**
   * @return
   */
  public ALStringField getRoleName() {
    return role_name;
  }

  /**
   * @param id
   */
  public void setRoleId(int id) {
    role_id.setValue(id);
  }

  /**
   * @param string
   */
  public void setRoleName(String string) {
    role_name.setValue(string);
  }
}
