/*
 * Aipo is a groupware program developed by Aimluck,Inc.
 * Copyright (C) 2004-2011 Aimluck,Inc.
 * http://www.aipo.com
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.aimluck.eip.user.beans;

import com.aimluck.commons.field.ALNumberField;
import com.aimluck.commons.field.ALStringField;
import com.aimluck.eip.common.ALData;

/**
 * ユーザーのBeanです。 <br />
 * 
 */
public class UserLiteBean implements ALData, Cloneable {

  /** ID */
  private ALNumberField user_id;

  /** 名前 */
  private ALStringField name;

  /** 名前（アプリケーション） */
  private ALStringField alias_name;

  // add start
  /** メールアドレス */
  private ALStringField mail_address;

  /** 表示名 */
  private ALStringField display_name;

  // add end

  /**
   * 
   * 
   */
  public void initField() {
    user_id = new ALNumberField();
    name = new ALStringField();
    alias_name = new ALStringField();
    // add start
    mail_address = new ALStringField();
    display_name = new ALStringField();
    // add end
  }

  /**
   * 
   * @param string
   */
  public void setName(String string) {
    name.setValue(string);
  }

  /**
   * 
   * @param firstName
   * @param lastName
   */
  public void setAliasName(String firstName, String lastName) {
    alias_name.setValue(new StringBuffer().append(lastName).append(" ").append(
      firstName).toString());
  }

  /**
   * 
   * @return
   */
  public String getName() {
    return name.getValue();
  }

  /**
   * 
   * @return
   */
  public String getAliasName() {
    return alias_name.getValue();
  }

  /**
   * @return
   */
  public String getUserId() {
    return user_id.toString();
  }

  /**
   * @param field
   */
  public void setUserId(int number) {
    user_id.setValue(number);
  }

  // add start

  /**
   * 
   * @param string
   */
  public void setMailAddress(String string) {
    mail_address.setValue(string);
  }

  /**
   * 
   * @return
   */
  public String getMailAddress() {
    return mail_address.getValue();
  }

  /**
   * @return display_name
   */
  public String getDisplayName() {
    return display_name.getValue();
  }

  /**
   * @param display_name
   */
  public void setDisplayName(String string) {
    display_name.setValue(string);
  }

  // add end

}
