/*
 * Aipo is a groupware program developed by Aimluck,Inc.
 * Copyright (C) 2004-2011 Aimluck,Inc.
 * http://www.aipo.com
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.aimluck.eip.user.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;

import com.aimluck.eip.cayenne.om.account.AvzMGroupsend;
import com.aimluck.eip.cayenne.om.account.AvzMGroupsendPosition;
import com.aimluck.eip.cayenne.om.account.AvzMRole;
import com.aimluck.eip.cayenne.om.account.AvzMUserGroupsend;
import com.aimluck.eip.cayenne.om.account.AvzMUserRole;
import com.aimluck.eip.cayenne.om.account.EipMPosition;
import com.aimluck.eip.cayenne.om.account.EipMPost;
import com.aimluck.eip.cayenne.om.portlet.EipMMailAccount;
import com.aimluck.eip.cayenne.om.security.TurbineGroup;
import com.aimluck.eip.cayenne.om.security.TurbineUser;
import com.aimluck.eip.cayenne.om.security.TurbineUserGroupRole;
import com.aimluck.eip.common.ALDBErrorException;
import com.aimluck.eip.common.ALEipGroup;
import com.aimluck.eip.common.ALEipGroupSend;
import com.aimluck.eip.common.ALEipManager;
import com.aimluck.eip.common.ALEipPost;
import com.aimluck.eip.common.ALEipRole;
import com.aimluck.eip.orm.Database;
import com.aimluck.eip.orm.query.SelectQuery;
import com.aimluck.eip.query.ALUserDirectSelectQuery;
import com.aimluck.eip.user.beans.UserEmailLiteBean;
import com.aimluck.eip.user.beans.UserGroupLiteBean;
import com.aimluck.eip.user.beans.UserGroupPositionLiteBean;
import com.aimluck.eip.user.beans.UserLiteBean;
import com.aimluck.eip.user.beans.UserWebmailAccountLiteBean;
import com.aimluck.eip.util.ALEipUtils;

/**
 * ユーザーのユーティリティクラスです。 <br />
 * 
 */
public class UserUtils {

  /** logger */
  private static final JetspeedLogger logger =
    JetspeedLogFactoryService.getLogger(UserUtils.class.getName());

  /**
   * 
   * @param rundata
   * @return
   */
  public static synchronized List<UserLiteBean> getUserLiteBeansFromGroup(
      RunData rundata, String groupname, boolean includeLoginuser) {
    int login_user_id = null != rundata ? ALEipUtils.getUserId(rundata) : 0;
    // /** SQLを構築してデータベース検索 */
    ArrayList<UserLiteBean> list = new ArrayList<UserLiteBean>();

    // mod by motegi start グループ送信対応
    // StringBuffer statement = new StringBuffer();
    // statement.append("SELECT DISTINCT ");
    // statement
    // .append(" B.USER_ID, B.LOGIN_NAME, B.FIRST_NAME, B.LAST_NAME, D.POSITION
    // ");
    // statement.append("FROM turbine_user_group_role as A ");
    // statement.append("LEFT JOIN turbine_user as B ");
    // statement.append(" on A.USER_ID = B.USER_ID ");
    // statement.append("LEFT JOIN turbine_group as C ");
    // statement.append(" on A.GROUP_ID = C.GROUP_ID ");
    // statement.append("LEFT JOIN eip_m_user_position as D ");
    // statement.append(" on A.USER_ID = D.USER_ID ");
    // statement.append("WHERE B.USER_ID > 3 AND B.DISABLED = 'F'");
    // statement.append(" AND C.GROUP_NAME = #bind($groupname) ");
    // statement.append("ORDER BY D.POSITION");
    //
    // String query = statement.toString();
    //
    // List<TurbineUser> list2 =
    // Database
    // .sql(TurbineUser.class, query)
    // .param("groupname", groupname)
    // .fetchList();

    ALUserDirectSelectQuery query = new ALUserDirectSelectQuery();
    if (ALEipUtils.isGroupSendId(groupname)) {
      query.setGroupSendId(groupname);
    } else {
      query.setGroupName(groupname);
    }
    List<TurbineUser> list2 = query.getResultList();
    // mod end

    UserLiteBean user;
    // ユーザデータを作成し、返却リストへ格納
    for (TurbineUser tuser : list2) {
      user = new UserLiteBean();
      user.initField();
      user.setUserId(tuser.getUserId());
      user.setName(tuser.getLoginName());
      user.setAliasName(tuser.getFirstName(), tuser.getLastName());
      // add start
      user.setMailAddress(tuser.getEmail());
      user.setDisplayName(tuser.getDisplayName());
      // add end
      list.add(user);
    }

    if (!includeLoginuser && login_user_id > 3) {
      /** 返り値からログインユーザを除く */
      for (int i = 0; i < list.size(); i++) {
        user = list.get(i);
        if (Integer.valueOf(user.getUserId()) == login_user_id) {
          list.remove(i);
          break;
        }
      }
    }
    return list;
  }

  /**
   * 
   * @param rundata
   * @return
   */
  public static synchronized List<UserEmailLiteBean> getUserEmailLiteBeansFromGroup(
      RunData rundata, String groupname, boolean includeLoginuser) {
    int login_user_id = null != rundata ? ALEipUtils.getUserId(rundata) : 0;
    ArrayList<UserEmailLiteBean> list = new ArrayList<UserEmailLiteBean>();
    // SQLの作成
    StringBuffer statement = new StringBuffer();
    statement.append("SELECT DISTINCT ");
    statement
      .append("  B.USER_ID, B.LOGIN_NAME, B.FIRST_NAME, B.LAST_NAME, B.EMAIL, D.POSITION ");
    statement.append("FROM turbine_user_group_role as A ");
    statement.append("LEFT JOIN turbine_user as B ");
    statement.append("  on A.USER_ID = B.USER_ID ");
    statement.append("LEFT JOIN turbine_group as C ");
    statement.append("  on A.GROUP_ID = C.GROUP_ID ");
    statement.append("LEFT JOIN eip_m_user_position as D ");
    statement.append("  on A.USER_ID = D.USER_ID ");
    statement.append("WHERE B.USER_ID > 3 AND B.DISABLED = 'F'");
    statement.append(" AND C.GROUP_NAME = #bind($groupname) ");
    statement.append("ORDER BY D.POSITION");
    String query = statement.toString();

    List<TurbineUser> list2 =
      Database
        .sql(TurbineUser.class, query)
        .param("groupname", groupname)
        .fetchList();

    UserEmailLiteBean user;
    // ユーザデータを作成し、返却リストへ格納
    for (TurbineUser tuser : list2) {
      user = new UserEmailLiteBean();
      user.initField();
      user.setUserId(tuser.getUserId());
      user.setName(tuser.getLoginName());
      user.setAliasName(tuser.getFirstName(), tuser.getLastName());
      user.setEmail(tuser.getEmail());
      list.add(user);
    }

    if (!includeLoginuser && login_user_id > 3) {
      /** 返り値からログインユーザを除く */
      for (int i = 0; i < list.size(); i++) {
        user = list.get(i);
        if (Integer.valueOf(user.getUserId()) == login_user_id) {
          list.remove(i);
          break;
        }
      }
    }
    return list;
  }

  /**
   * 
   * @param rundata
   * @return
   */
  public static List<UserGroupLiteBean> getUserGroupLiteBeans(RunData rundata,
      boolean isMygroup, boolean isPost) {
    List<UserGroupLiteBean> list = new ArrayList<UserGroupLiteBean>();
    UserGroupLiteBean bean;
    try {
      if (isMygroup) {
        List<ALEipGroup> mygroup = ALEipUtils.getMyGroups(rundata);
        int size1 = mygroup.size();
        for (int i = 0; i < size1; i++) {
          ALEipGroup group = mygroup.get(i);
          bean = new UserGroupLiteBean();
          bean.initField();
          bean.setGroupId(group.getName().getValue());
          bean.setName(group.getAliasName().getValue());
          list.add(bean);
        }
      }
      if (isPost) {
        Map<Integer, ALEipPost> postmap =
          ALEipManager.getInstance().getPostMap();
        for (Iterator<ALEipPost> i = postmap.values().iterator(); i.hasNext();) {
          ALEipPost post = i.next();
          bean = new UserGroupLiteBean();
          bean.initField();
          bean.setGroupId(post.getGroupName().getValue());
          bean.setName(post.getPostName().getValue());
          list.add(bean);
        }
      }
    } catch (Exception e) {
      logger.error("[UserUtils]", e);
    }
    return list;
  }

  // add by motegi start 代理送信対応
  // /**
  // *
  // * @param rundata
  // * @return
  // */
  // public static List<UserWebmailAccountLiteBean>
  // getUserAccountLiteBeansFromGroup(
  // int login_user_id, String groupname) {
  //
  // ArrayList<UserWebmailAccountLiteBean> list =
  // new ArrayList<UserWebmailAccountLiteBean>();
  // // SQLの作成
  // StringBuffer statement = new StringBuffer();
  // statement
  // .append("SELECT DISTINCT Z.USER_ID, Z.ACCOUNT_ID, Z.ACCOUNT_NAME,
  // Z.MAIL_USER_NAME from eip_m_mail_account Z ");
  // statement.append("INNER JOIN (SELECT DISTINCT B.USER_ID, D.POSITION ");
  // statement.append(" FROM turbine_user_group_role as A ");
  // statement.append(" LEFT JOIN turbine_user as B ");
  // statement.append(" on A.USER_ID = B.USER_ID ");
  // statement.append(" LEFT JOIN turbine_group as C ");
  // statement.append(" on A.GROUP_ID = C.GROUP_ID ");
  // statement.append(" LEFT JOIN eip_m_user_position as D ");
  // statement.append(" on A.USER_ID = D.USER_ID ");
  // statement.append(" WHERE B.USER_ID > 3 AND B.DISABLED = 'F'");
  // statement.append(" AND C.GROUP_NAME = #bind($groupname) ");
  // statement.append(" ORDER BY D.POSITION");
  // statement.append(") Y on Y.USER_ID = Z.USER_ID ");
  // String query = statement.toString();
  //
  // List<EipMMailAccount> dbList =
  // Database
  // .sql(EipMMailAccount.class, query)
  // .param("groupname", groupname)
  // .fetchList();
  //
  // // ユーザデータを作成し、返却リストへ格納
  // for (EipMMailAccount ac : dbList) {
  //
  // if (login_user_id == ac.getUserId().intValue()) {
  // // ログインユーザーはスキップ
  // continue;
  // }
  //
  // UserWebmailAccountLiteBean bean = new UserWebmailAccountLiteBean();
  // bean.initField();
  // bean.setAccountId(ac.getAccountId());
  // bean.setAccountName(ac.getMailUserName()
  // + "<"
  // + ac.getMailAddress()
  // + ">");
  // list.add(bean);
  // }
  // return list;
  // }

  /**
   * 部署1情報取得
   * 
   * @author T.Motegi （部署階層化対応）
   * @param rundata
   * @param groupsend_mode
   *            ・"none"：返却値に"グループ送信"選択肢を含めない
   *            ・"all"：返却値に名前"グループ送信"、値"groupsend"の選択肢を含める。
   *            ・"without_post"：返却値に名前"グループ送信"、値"groupsend_without_post"の選択肢を含める。
   * @return 部署1情報リスト
   * @throws ALDBErrorException
   */
  public static List<UserGroupLiteBean> getUserParentGroupLiteBeans(
      RunData rundata, String groupsend_mode) throws ALDBErrorException {

    List<UserGroupLiteBean> list = new ArrayList<UserGroupLiteBean>();
    try {
      // Map<Integer, ALEipPost> postmap =
      // ALEipManager.getInstance().getPost1Map();
      // for (Iterator<ALEipPost> i = postmap.values().iterator(); i.hasNext();)
      // {
      // ALEipPost post = i.next();
      // UserGroupLiteBean bean = new UserGroupLiteBean();
      // bean.initField();
      // bean.setGroupId(post.getGroupName().getValue());
      // bean.setName(post.getPostName().getValue());
      // list.add(bean);
      // }

      List<ALEipPost> postmap = null;
      if ("none".equals(groupsend_mode)) {
        // "グループ送信"選択肢を含めない
        postmap = ALEipUtils.getPostMap(false, false);
      } else if ("all".equals(groupsend_mode)) {
        // 返却値に名前"グループ送信"、値"groupsend"の選択肢を含める。
        postmap = ALEipUtils.getPostMap(true, false);
      } else {
        // 返却値に名前"グループ送信"、値"groupsend_without_post"の選択肢を含める。
        postmap = ALEipUtils.getPostMap(false, true);
      }

      for (ALEipPost post : postmap) {
        UserGroupLiteBean bean = new UserGroupLiteBean();
        bean.initField();
        bean.setGroupId(post.getGroupName().getValue());
        bean.setName(post.getPostName().getValue());
        list.add(bean);
      }
    } catch (Exception e) {
      logger.error("部署1情報取得", e);
      throw new ALDBErrorException();
    }
    return list;
  }

  /**
   * 部署2プルダウン情報取得
   * 
   * 指定した部署1グループ名の配下の部署2情報リストを取得する。また、"GROUPSEND"を
   * 指定された場合はグループ送信情報リスト、"POSITION"を指定された場合は役職情報リスト、
   * "ROLE"を指定された場合は役割情報リストを取得する。
   * 
   * @author add by motegi （部署階層化対応）
   * @param rundata
   * @return 部署2情報リスト
   */
  public static List<UserGroupLiteBean> getPost2LiteBeans(
      String parent_group_name) {
    return getPost2LiteBeans(parent_group_name, true, true, false);
  }

  /**
   * 部署2プルダウン情報取得
   * 
   * @author add by motegi （部署階層化対応）
   * 
   * @param parent_group_name
   *            部署1グループ名
   * @param hasPost1
   *            true:リスト先頭に親部署を付けたす false:付けたさない
   * @param hasHead
   *            true:リスト先頭に"すべて"を付けたす false:付けたさない
   * @param hasGroupSendHead
   *            グループ送信の場合に true:リスト先頭に"(選択して下さい)"を付けたす false:付けたさない
   * @return 部署2情報リスト
   */
  public static List<UserGroupLiteBean> getPost2LiteBeans(
      String parent_group_name, boolean hasPost1, boolean hasHead,
      boolean hasGroupSendHead) {
    List<UserGroupLiteBean> list = new ArrayList<UserGroupLiteBean>();
    try {
      if (parent_group_name == null || "".equals(parent_group_name)) {
        return new ArrayList<UserGroupLiteBean>(0);
      }

      if (ALEipUtils.GROUPSEND.equals(parent_group_name)
        || ALEipUtils.GROUPSEND_WITHOUT_POST.equals(parent_group_name)) {
        Map<Integer, ALEipGroupSend> postmap =
          ALEipManager.getInstance().getGroupSendsMap();
        for (Iterator<ALEipGroupSend> i = postmap.values().iterator(); i
          .hasNext();) {

          ALEipGroupSend gs = i.next();

          String category = gs.getCategory().toString();
          if (ALEipUtils.GROUPSEND_WITHOUT_POST.equals(parent_group_name)
            && AvzMGroupsend.GROUPSEND_CATEGORY_POST.equals(category)) {
            continue;
          }

          UserGroupLiteBean bean = new UserGroupLiteBean();
          bean.initField();
          bean.setGroupId(gs.getGroupSendId().toString());
          bean.setName(gs.getGroupSendName().getValue());
          list.add(bean);
        }

        if (hasGroupSendHead) {
          UserGroupLiteBean bean = new UserGroupLiteBean();
          bean.initField();
          bean.setGroupId("0");
          bean.setName("(選択して下さい)");
          list.add(0, bean);
        }

      } else {
        // 部署1の情報を取得
        ALEipPost parent =
          ALEipManager.getInstance().getPostMapByGroupName(parent_group_name);

        // 部署1配下の部署2の情報を取得
        // Map<Integer, ALEipPost> postmap =
        // ALEipManager.getInstance().getPost2Map(parent_group_name);
        // for (Iterator<ALEipPost> i = postmap.values().iterator();
        // i.hasNext();)
        // {
        // ALEipPost post = i.next();
        // if (post.getParentPostId().getValue() ==
        // parent.getPostId().getValue())
        // {
        // UserGroupLiteBean bean = new UserGroupLiteBean();
        // bean.initField();
        // bean.setGroupId(post.getGroupName().getValue());
        // bean.setName(post.getPostName().getValue());
        // list.add(bean);
        // }
        // }

        List<ALEipPost> postmap =
          ALEipManager.getInstance().getPost2Map(parent_group_name);
        for (ALEipPost post : postmap) {
          if (post.getParentPostId().getValue() == parent
            .getPostId()
            .getValue()) {
            UserGroupLiteBean bean = new UserGroupLiteBean();
            bean.initField();
            bean.setGroupId(post.getGroupName().getValue());
            bean.setName(post.getPostName().getValue());
            list.add(bean);
          }
        }

        if (hasPost1 && parent != null) {
          // リスト先頭に親部署を付けたし
          UserGroupLiteBean bean = new UserGroupLiteBean();
          bean.initField();
          bean.setGroupId(parent.getGroupName().getValue());
          bean.setName(parent.getPostName().getValue());
          list.add(0, bean);
        }

        if (hasHead) {
          // リスト先頭に付けたし
          UserGroupLiteBean bean = new UserGroupLiteBean();
          bean.initField();
          bean.setGroupId("ALL");
          bean.setName("すべて");
          list.add(0, bean);
        }
      }

    } catch (Exception e) {
      logger.error("部署2プルダウン情報取得の取得に失敗しました。", e);
      return null;
    }
    return list;
  }

  /**
   * ユーザーの所属する部署を取得します。
   * 
   * @param id
   *            ユーザーID
   * @return 所属する部署リスト
   * @author motegi （部署階層化対応）
   */
  public static List<TurbineUserGroupRole> getPostList(int id) {
    SelectQuery<TurbineUserGroupRole> query =
      Database.query(TurbineUserGroupRole.class);
    Expression exp1 =
      ExpressionFactory.matchExp(
        TurbineUserGroupRole.TURBINE_USER_PROPERTY,
        Integer.valueOf(id));
    Expression exp2 =
      ExpressionFactory.greaterExp(
        TurbineUserGroupRole.TURBINE_GROUP_PROPERTY,
        Integer.valueOf(3));
    Expression exp3 =
      ExpressionFactory.matchExp(TurbineUserGroupRole.TURBINE_GROUP_PROPERTY
        + "."
        + TurbineGroup.OWNER_ID_PROPERTY, Integer.valueOf(1));
    query.setQualifier(exp1);
    query.andQualifier(exp2);
    query.andQualifier(exp3);
    List<TurbineUserGroupRole> list = query.fetchList();
    return list;
  }

  // add by motegi start 役割属性追加
  /**
   * 全役割情報を取得する
   * 
   * @param rundata
   * @return 役割情報リスト（役割名でソート済み）
   * @author motegi （部署階層化対応）
   * @throws ALDBErrorException
   */
  public static List<UserGroupLiteBean> getUserRoleLiteBeans(RunData rundata)
      throws ALDBErrorException {
    List<UserGroupLiteBean> list = new ArrayList<UserGroupLiteBean>();
    UserGroupLiteBean bean;
    try {
      Map<Integer, ALEipRole> map = ALEipManager.getInstance().getRoleMap();
      for (Iterator<ALEipRole> i = map.values().iterator(); i.hasNext();) {
        ALEipRole role = i.next();
        bean = new UserGroupLiteBean();
        bean.initField();
        bean.setGroupId(role.getRoleId().getValueAsString());
        bean.setName(role.getRoleName().getValue());
        list.add(bean);
      }
    } catch (Exception e) {
      logger.error("役割情報リストの取得に失敗しました。", e);
      throw new ALDBErrorException();
    }
    return list;
  }

  /**
   * 全グループ送信情報を取得する
   * 
   * @param rundata
   * @return グループ送信情報リスト（グループ送信表示順番でソート済み）
   * @author motegi （部署階層化対応）
   * @throws ALDBErrorException
   */
  public static List<UserGroupLiteBean> getUserGroupSendLiteBeans(
      RunData rundata) throws ALDBErrorException {
    List<UserGroupLiteBean> list = new ArrayList<UserGroupLiteBean>();
    UserGroupLiteBean bean;
    try {
      Map<Integer, ALEipGroupSend> map =
        ALEipManager.getInstance().getGroupSendsMap();
      for (Iterator<ALEipGroupSend> i = map.values().iterator(); i.hasNext();) {
        ALEipGroupSend role = i.next();
        bean = new UserGroupLiteBean();
        bean.initField();
        bean.setGroupId(role.getGroupSendId().getValueAsString());
        bean.setName(role.getGroupSendName().getValue());
        list.add(bean);
      }

    } catch (Exception e) {
      logger.error("グループ送信情報リストの取得に失敗しました。", e);
      throw new ALDBErrorException();
    }
    return list;
  }

  // add by motegi start 部署階層化対応
  /**
   * ユーザー部署・役職情報取得
   * 
   * ユーザーの所属する[部署1・部署2・役職]の一覧を取得します。
   * 
   * @param uid
   *            ユーザーID
   * @return ユーザーの[部署1・部署2・役職]リスト
   * @author motegi （部署階層化対応）
   */
  public static List<UserGroupPositionLiteBean> getPostPositionBeanList(int uid) {

    // SelectQuery<TurbineUserGroupRole> query =
    // Database.query(TurbineUserGroupRole.class);
    // Expression exp1 =
    // ExpressionFactory.matchExp(
    // TurbineUserGroupRole.TURBINE_USER_PROPERTY,
    // Integer.valueOf(uid));
    // Expression exp2 =
    // ExpressionFactory.greaterExp(
    // TurbineUserGroupRole.TURBINE_GROUP_PROPERTY,
    // Integer.valueOf(3));
    // Expression exp3 =
    // ExpressionFactory.matchExp(TurbineUserGroupRole.TURBINE_GROUP_PROPERTY
    // + "."
    // + TurbineGroup.OWNER_ID_PROPERTY, Integer.valueOf(1));
    // query.setQualifier(exp1);
    // query.andQualifier(exp2);
    // query.andQualifier(exp3);
    //
    // query.orderAscending(TurbineUserGroupRole.EIP_MPOSITION_PROPERTY
    // + "."
    // + EipMPosition.AVZ_MPOSITION_POSITION_ARRAY_PROPERTY
    // + "."
    // + AvzMPositionPosition.POSITION_PROPERTY);
    //
    // List<TurbineUserGroupRole> list = query.fetchList();

    StringBuffer statement = new StringBuffer();
    statement.append("SELECT DISTINCT ");
    statement.append(" A.ID, C.POSITION ");
    statement.append("FROM turbine_user_group_role as A ");
    statement.append("INNER JOIN turbine_group as B ");
    statement.append(" on A.GROUP_ID = B.GROUP_ID ");
    statement.append("LEFT JOIN avz_m_position_position as C ");
    statement.append(" on A.POSITION_ID = C.POSITION_ID ");
    statement.append("WHERE A.USER_ID = #bind($userid 'INTEGER')");
    statement.append(" AND B.OWNER_ID = 1 ");
    statement.append(" ORDER BY C.POSITION");
    String query = statement.toString();

    List<TurbineUserGroupRole> list =
      Database.sql(TurbineUserGroupRole.class, query).param(
        "userid",
        Integer.valueOf(uid)).fetchList();

    if (list == null || list.size() < 0) {
      return null;
    }

    List<UserGroupPositionLiteBean> resultList =
      new ArrayList<UserGroupPositionLiteBean>();

    TurbineUserGroupRole ugr = null;
    TurbineGroup group = null;
    UserGroupPositionLiteBean bean = null;
    int size = list.size();
    for (int i = 0; i < size; i++) {
      ugr = list.get(i);
      // リレーションテーブルを取得するため再取得する
      ugr = Database.get(TurbineUserGroupRole.class, ugr.getId());

      group = ugr.getTurbineGroup();
      EipMPost post2 = group.getEipMPost();
      EipMPosition position = ugr.getEipMPosition();
      bean = new UserGroupPositionLiteBean();
      bean.initField();

      String tmp_name = null;
      String tmp_group_name = null;
      if (post2.getParentPostId().intValue() == 0) {
        tmp_name = post2.getPostName();
        tmp_group_name = post2.getGroupName();

      } else {
        tmp_name = ALEipUtils.getPostName(post2.getParentPostId());
        tmp_group_name =
          ALEipUtils.convertGroupId2GroupName(post2.getParentPostId());
      }
      bean.setPost1Name(tmp_name);
      bean.setPost1GroupName(tmp_group_name);
      bean.setPost2Name(post2.getPostName());
      bean.setPost2GroupName(post2.getGroupName());
      if (position != null) {
        bean.setPositionId(position.getPositionId().toString());
        bean.setPositionName(position.getPositionName());
      }
      resultList.add(bean);
    }
    return resultList;
  }

  /**
   * 指定ユーザーのWebメールアカウントを取得する。
   * 
   * @param rundata
   * @return
   * @author motegi
   */
  public static List<UserWebmailAccountLiteBean> getUserWebmailAccountLiteBeanList(
      int user_id) {

    ArrayList<UserWebmailAccountLiteBean> list =
      new ArrayList<UserWebmailAccountLiteBean>();

    SelectQuery<EipMMailAccount> query = Database.query(EipMMailAccount.class);

    query.select(EipMMailAccount.ACCOUNT_ID_PK_COLUMN);
    query.select(EipMMailAccount.ACCOUNT_NAME_COLUMN);
    query.select("MAIL_ADDRESS");
    Expression exp =
      ExpressionFactory.matchExp(EipMMailAccount.USER_ID_PROPERTY, Integer
        .valueOf(user_id));

    List<EipMMailAccount> dbList = query.setQualifier(exp).fetchList();

    // ユーザデータを作成し、返却リストへ格納
    for (EipMMailAccount ac : dbList) {

      UserWebmailAccountLiteBean bean = new UserWebmailAccountLiteBean();
      bean.initField();
      bean.setAccountId(ac.getAccountId());
      bean.setAccountName(ac.getAccountName());
      bean.setAddress(ac.getMailAddress());
      list.add(bean);
    }
    return list;
  }

  /**
   * 指定した部署1配下の全ユーザー（部署1および配下の部署2に所属するユーザー）の情報を取得する。
   * 
   * @param rundata
   * @param post1_groupname
   *            部署1グループ名
   * @return ユーザー情報リスト
   * @author motegi （部署階層化対応）
   */
  public static List<UserLiteBean> getUserLiteBeansFromGroups(RunData rundata,
      String post1_groupname, boolean includeLoginuser) {

    int login_user_id = null != rundata ? ALEipUtils.getUserId(rundata) : 0;

    List<String> post2_groups =
      ALEipUtils.getGroupNameList(post1_groupname, true);
    if (post2_groups == null || post2_groups.size() == 0) {
      return new ArrayList<UserLiteBean>();
    }

    // /** SQLを構築してデータベース検索 */
    ArrayList<UserLiteBean> resultList = new ArrayList<UserLiteBean>();
    // StringBuffer statement = new StringBuffer();
    // statement.append("SELECT DISTINCT ");
    // statement
    // .append(" B.USER_ID, B.LOGIN_NAME, B.FIRST_NAME, B.LAST_NAME,
    // B.DISPLAY_NAME, D.POSITION ");
    // statement.append("FROM turbine_user_group_role as A ");
    // statement.append("LEFT JOIN turbine_user as B ");
    // statement.append(" on A.USER_ID = B.USER_ID ");
    // statement.append("LEFT JOIN turbine_group as C ");
    // statement.append(" on A.GROUP_ID = C.GROUP_ID ");
    // statement.append("LEFT JOIN eip_m_user_position as D ");
    // statement.append(" on A.USER_ID = D.USER_ID ");
    // statement.append("WHERE B.USER_ID > 3 AND B.DISABLED = 'F'");
    // statement.append(" AND C.GROUP_NAME IN (#bind($groupname 'VARCHAR')) ");
    // statement.append(" ORDER BY B.DISPLAY_NAME, D.POSITION");
    // String query = statement.toString();
    //
    // List<TurbineUser> list2 =
    // Database
    // .sql(TurbineUser.class, query)
    // .param("groupname", post2_groups)
    // .fetchList();

    ALUserDirectSelectQuery query = new ALUserDirectSelectQuery();
    query.setGroupNames(post2_groups);
    List<TurbineUser> tmpList = query.fetchList();

    UserLiteBean user;
    // ユーザデータを作成し、返却リストへ格納
    for (TurbineUser tuser : tmpList) {
      user = new UserLiteBean();
      user.initField();
      user.setUserId(tuser.getUserId());
      user.setName(tuser.getLoginName());
      user.setAliasName(tuser.getFirstName(), tuser.getLastName());
      // add start
      user.setMailAddress(tuser.getEmail());
      user.setDisplayName(tuser.getDisplayName());
      // add end
      resultList.add(user);
    }

    if (!includeLoginuser && login_user_id > 3) {
      /** 返り値からログインユーザを除く */
      for (int i = 0; i < resultList.size(); i++) {
        user = resultList.get(i);
        if (Integer.valueOf(user.getUserId()) == login_user_id) {
          resultList.remove(i);
          break;
        }
      }
    }

    return resultList;
  }

  /**
   * 指定したユーザーの役割情報リストを取得する。
   * 
   * @param uid
   *            ユーザーID
   * @return
   * @throws ALDBErrorException
   */
  public static List<ALEipRole> getRoleBeanList(int uid)
      throws ALDBErrorException {

    try {
      SelectQuery<AvzMUserRole> query = Database.query(AvzMUserRole.class);
      Expression exp1 =
        ExpressionFactory.matchExp(AvzMUserRole.USER_ID_PROPERTY, uid);
      query.setQualifier(exp1);
      query.orderAscending(AvzMUserRole.TO_AVZ_MROLE_PROPERTY
        + "."
        + AvzMRole.ROLE_NAME_PROPERTY);

      List<AvzMUserRole> roles = query.fetchList();
      if (roles == null || roles.size() == 0) {
        return null;
      }

      List<ALEipRole> resultList = new ArrayList<ALEipRole>();
      for (AvzMUserRole role : roles) {
        AvzMRole e = role.getToAvzMRole();

        ALEipRole b = new ALEipRole();
        b.initField();
        b.setRoleId(e.getRoleId());
        b.setRoleName(e.getRoleName());

        resultList.add(b);
      }

      return resultList;
    } catch (Exception ex) {
      logger.error("役割情報リストの取得に失敗しました。", ex);
      throw new ALDBErrorException();
    }
  }

  /**
   * 指定したユーザーのグループ送信情報リストを取得する。
   * 
   * @param uid
   *            ユーザーID
   * @return
   * @throws ALDBErrorException
   */
  // public static List<ALEipGroupSend> getGroupSendBeanList(int uid)
  // throws ALDBErrorException {
  //
  // try {
  // SelectQuery<AvzMUserGroupsend> query =
  // Database.query(AvzMUserGroupsend.class);
  // Expression exp1 =
  // ExpressionFactory.matchExp(AvzMUserGroupsend.USER_ID_PROPERTY, uid);
  // query.setQualifier(exp1);
  //
  // List<AvzMUserGroupsend> groupsends = query.fetchList();
  // if (groupsends == null || groupsends.size() == 0) {
  // return null;
  // }
  //
  // List<ALEipGroupSend> resultList = new ArrayList<ALEipGroupSend>();
  // for (AvzMUserGroupsend groupsend : groupsends) {
  // AvzMGroupsend e = groupsend.getToAvzMGroupsend();
  //
  // ALEipGroupSend b = new ALEipGroupSend();
  // b.initField();
  // b.setGroupSendId(e.getGroupsendId());
  // b.setGroupSendName(e.getGroupsendName());
  //
  // resultList.add(b);
  // }
  //
  // return resultList;
  // } catch (Exception ex) {
  // logger.error("グループ送信情報リストの取得に失敗しました。", ex);
  // throw new ALDBErrorException();
  // }
  // }
  public static List<ALEipGroupSend> getGroupSendBeanList(int uid)
      throws ALDBErrorException {

    try {
      SelectQuery<AvzMGroupsend> query = Database.query(AvzMGroupsend.class);
      Expression exp1 =
        ExpressionFactory.matchExp(
          AvzMGroupsend.AVZ_MUSERGROUPSEND_ARRAY_PROPERTY
            + "."
            + AvzMUserGroupsend.USER_ID_PROPERTY,
          uid);
      query.setQualifier(exp1);
      query.orderAscending(
        AvzMGroupsend.AVZ_MGROUPSEND_POSITION_ARRAY_PROPERTY
          + "."
          + AvzMGroupsendPosition.POSITION_PROPERTY).fetchList();

      List<AvzMGroupsend> groupsends = query.fetchList();
      if (groupsends == null || groupsends.size() == 0) {
        return null;
      }

      List<ALEipGroupSend> resultList = new ArrayList<ALEipGroupSend>();
      for (AvzMGroupsend groupsend : groupsends) {
        ALEipGroupSend b = new ALEipGroupSend();
        b.initField();
        b.setGroupSendId(groupsend.getGroupsendId());
        b.setGroupSendName(groupsend.getGroupsendName());

        resultList.add(b);
      }

      return resultList;
    } catch (Exception ex) {
      logger.error("グループ送信情報リストの取得に失敗しました。", ex);
      throw new ALDBErrorException();
    }
  }
}
