/*
 * Aipo is a groupware program developed by Aimluck,Inc.
 * Copyright (C) 2004-2011 Aimluck,Inc.
 * http://www.aipo.com
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.aimluck.eip.account;

import java.util.jar.Attributes;

import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

import com.aimluck.eip.account.util.AccountUtils;
import com.aimluck.eip.cayenne.om.account.AvzMPositionPosition;
import com.aimluck.eip.cayenne.om.account.EipMPosition;
import com.aimluck.eip.common.ALAbstractSelectData;
import com.aimluck.eip.common.ALDBErrorException;
import com.aimluck.eip.common.ALPageNotFoundException;
import com.aimluck.eip.modules.actions.common.ALAction;
import com.aimluck.eip.orm.Database;
import com.aimluck.eip.orm.query.ResultList;
import com.aimluck.eip.orm.query.SelectQuery;

/**
 * 役職の検索用データクラスです。
 * 
 */
public class AccountPositionSelectData extends
    ALAbstractSelectData<EipMPosition, EipMPosition> {

  /** logger */
  private static final JetspeedLogger logger =
    JetspeedLogFactoryService.getLogger(AccountPositionSelectData.class
      .getName());

  /**
   * 初期処理
   * 
   * @param action
   *            アクションクラス
   * @param rundata
   *            JetSpeedランデータ
   * @param context
   *            JetSpeedコンテキスト
   * @throws ALPageNotFoundException,
   *             ALDBErrorException
   */
  @Override
  public void init(ALAction action, RunData rundata, Context context)
      throws ALPageNotFoundException, ALDBErrorException {
    // remove start
    // String sort = ALEipUtils.getTemp(rundata, context, LIST_SORT_STR);
    // if (sort == null || sort.equals("")) {
    // ALEipUtils.setTemp(rundata, context, LIST_SORT_STR, ALEipUtils
    // .getPortlet(rundata, context)
    // .getPortletConfig()
    // .getInitParameter("p1b-sort"));
    // }
    // remove end
    super.init(action, rundata, context);
  }

  /**
   * 一覧データを取得します。
   * 
   * @param rundata
   *            JetSpeedランデータ
   * @param context
   *            JetSpeedコンテキスト
   * @return 役職情報リスト
   */
  @Override
  protected ResultList<EipMPosition> selectList(RunData rundata, Context context) {
    try {
      SelectQuery<EipMPosition> query = getSelectQuery(rundata, context);
      buildSelectQueryForListView(query);
      // del start
      // buildSelectQueryForListViewSort(query, rundata, context);
      // del end

      return query.getResultList();

    } catch (Exception ex) {
      logger.error("役職情報の一覧取得に失敗しました。", ex);
      return null;
    }
  }

  /**
   * 検索条件を設定した SelectQuery を返します。 <BR>
   * 
   * @param rundata
   *            JetSpeedランデータ
   * @param context
   *            JetSpeedコンテキスト
   * @return SQLオブジェクト
   */
  private SelectQuery<EipMPosition> getSelectQuery(RunData rundata,
      Context context) {
    SelectQuery<EipMPosition> query = Database.query(EipMPosition.class);
    // add start
    query.orderAscending(EipMPosition.AVZ_MPOSITION_POSITION_ARRAY_PROPERTY
      + "."
      + AvzMPositionPosition.POSITION_PROPERTY);
    // add end
    return buildSelectQueryForFilter(query, rundata, context);
  }

  /**
   * 詳細データを取得します。 <BR>
   * 
   * @param rundata
   *            JetSpeedランデータ
   * @param context
   *            JetSpeedコンテキスト
   * @return DBから取得した役職情報
   * @throws ALPageNotFoundException
   */
  @Override
  protected EipMPosition selectDetail(RunData rundata, Context context)
      throws ALPageNotFoundException {
    // change start
    // return AccountUtils.getEipMPosition(rundata, context);
    try {
      EipMPosition position = AccountUtils.getEipMPosition(rundata, context);
      return position;
    } catch (Exception e) {
      logger.error("役職情報の詳細取得に失敗しました。", e);
      throw new ALPageNotFoundException();
    }
    // change end
  }

  /**
   * ResultData に値を格納して返します。（一覧データ） <BR>
   * 
   * @param obj
   *            DBから取得した役職情報
   * @return 画面表示用データ
   */
  @Override
  protected Object getResultData(EipMPosition record) {
    AccountPositionResultData rd = new AccountPositionResultData();
    rd.initField();
    rd.setPositionId(record.getPositionId().intValue());
    rd.setPositionName(record.getPositionName());
    return rd;
  }

  /**
   * ResultData に値を格納して返します。（詳細データ） <BR>
   * 
   * @param obj
   *            DBから取得した役職情報
   * @return 画面表示用役職情報
   */
  @Override
  protected Object getResultDataDetail(EipMPosition record) {
    AccountPositionResultData rd = new AccountPositionResultData();
    rd.initField();
    rd.setPositionId(record.getPositionId().intValue());
    rd.setPositionName(record.getPositionName());
    return rd;
  }

  /**
   * ※未使用
   */
  @Override
  protected Attributes getColumnMap() {
    Attributes map = new Attributes();
    // del start
    // map.putValue("position_name", EipMPosition.POSITION_NAME_PROPERTY);
    // del end
    return map;
  }

}
