/*
 * Aipo is a groupware program developed by Aimluck,Inc.
 * http://aipostyle.com/
 *
 * Copyright(C) 2011 avanza Co.,Ltd. All rights reserved.
 * http://www.avnz.co.jp/
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

package com.aimluck.eip.addressbook;

import java.util.List;
import java.util.jar.Attributes;

import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

import com.aimluck.eip.common.ALAbstractSelectData;
import com.aimluck.eip.common.ALDBErrorException;
import com.aimluck.eip.common.ALEipManager;
import com.aimluck.eip.common.ALEipPost;
import com.aimluck.eip.common.ALPageNotFoundException;
import com.aimluck.eip.modules.actions.common.ALAction;
import com.aimluck.eip.orm.query.ResultList;
import com.aimluck.eip.user.beans.UserGroupLiteBean;
import com.aimluck.eip.user.util.UserUtils;
import com.aimluck.eip.util.ALEipUtils;

/**
 * アドレス帳(携帯・スマートフォン)ポートレット所属部署1情報取得用のクラスです。
 */
public class AddressBookPost1SelectData extends
    ALAbstractSelectData<UserGroupLiteBean, UserGroupLiteBean> {

  /** logger */
  private static final JetspeedLogger logger =
    JetspeedLogFactoryService.getLogger(AddressBookPost1SelectData.class
      .getName());

  /** 部署1情報を格納するリスト */
  public List<UserGroupLiteBean> post1_list;

  /**
   * 共通メソッドを呼び出して部署1リストを生成します。
   * 
   * @param action
   *          アクションクラス
   * @param rundata
   *          JetSpeedランデータ
   * @param context
   *          JetSpeedコンテキスト
   * @throws ALPageNotFoundException
   * @throws ALDBErrorException
   */
  @Override
  public void init(ALAction action, RunData rundata, Context context)
      throws ALPageNotFoundException, ALDBErrorException {
    post1_list = UserUtils.getUserParentGroupLiteBeans(rundata, null);
    super.init(action, rundata, context);
  }

  /**
   * 画面で表示する部署1リスト取得メソッドです。
   * 
   * @return 部署1リスト
   */
  public List<UserGroupLiteBean> getPostMap() {
    return post1_list;
  }

  /**
   * 部署1一覧取得処理(WebMailポートレット向け)
   * 
   * 部署1一覧を取得します。
   * 
   * @return 部署1一覧
   */
  public static List<ALEipPost> getPostMapForWebMail() {
    List<ALEipPost> rtn = ALEipManager.getInstance().getPost1Map();
    ALEipPost gs = new ALEipPost();
    gs.initField();
    gs.setGroupName(ALEipUtils.GROUPSEND_WITHOUT_POST);
    gs.setPostName("役職・役割から選ぶ");
    rtn.add(0, gs);

    ALEipPost gs_without_post = new ALEipPost();
    gs_without_post.initField();
    gs_without_post.setGroupName(ALEipUtils.GROUPSEND);
    gs_without_post.setPostName("グループ送信");
    rtn.add(gs_without_post);
    return rtn;
  }

  /**
   * ※未使用
   */
  @Override
  protected Attributes getColumnMap() {
    return null;
  }

  /**
   * ※未使用
   */
  @Override
  protected Object getResultData(UserGroupLiteBean obj)
      throws ALPageNotFoundException, ALDBErrorException {
    return null;
  }

  /**
   * ※未使用
   */
  @Override
  protected Object getResultDataDetail(UserGroupLiteBean obj)
      throws ALPageNotFoundException, ALDBErrorException {
    return null;
  }

  /**
   * ※未使用
   */
  @Override
  protected UserGroupLiteBean selectDetail(RunData rundata, Context context)
      throws ALPageNotFoundException, ALDBErrorException {
    return null;
  }

  /**
   * ※未使用
   */
  @Override
  protected ResultList<UserGroupLiteBean> selectList(RunData rundata,
      Context context) throws ALPageNotFoundException, ALDBErrorException {
    return null;
  }

}
