/*
 * Aipo is a groupware program developed by Aimluck,Inc.
 * http://aipostyle.com/
 * 
 * Copyright(C) 2011 avanza Co.,Ltd. All rights reserved.
 * http://www.avnz.co.jp/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.aimluck.eip.schedule;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

import com.aimluck.eip.common.ALData;

/**
 * １日スケジュールのコンテナです。
 * 
 */
public class ScheduleReferOnedayWorkingContainer implements ALData {

  /** <code>list</code> スケジュールリスト */
  private final List<ScheduleReferOnedayResultData> list =
    new ArrayList<ScheduleReferOnedayResultData>();

  /*
   * ※未使用
   */
  public void initField() {
  }

  /**
   * 格納された予定データをグルーピングします。時間が重なっている予定をまとめていく。
   */
  public void grouping() {

    // 開始日時->終了日時でソートする
    Collections.sort(list, new Comparator<ScheduleReferOnedayResultData>() {
      public int compare(ScheduleReferOnedayResultData t1,
          ScheduleReferOnedayResultData t2) {
        int rtn =
          t1.getStartDate().getValue().compareTo(t2.getStartDate().getValue());
        if (rtn != 0) {
          return rtn;
        }
        return t1.getEndDate().getValue().compareTo(t2.getEndDate().getValue());
      }
    });

    // グルーピング結果格納リスト
    List<ScheduleReferOnedayResultData> destList =
      new ArrayList<ScheduleReferOnedayResultData>();

    // System.out.println("★★");

    // グルーピング処理
    for (ScheduleReferOnedayResultData rd : list) {

      // System.out.println("開始日時："
      // + rd.getStartDate().toString()
      // + " 終了日時："
      // + rd.getEndDate().toString());

      if (destList.size() == 0) {
        // 先ずは１件目を格納
        rd.addDisplaySchedule(rd);
        destList.add(rd);
      } else {
        ScheduleReferOnedayResultData target =
          destList.get(destList.size() - 1);
        if (rd.getStartDate().getValue().before(target.getEndDate().getValue())) {
          // 既に格納済みの予定と重なっている
          if (target.getEndDate().getValue().before(rd.getEndDate().getValue())) {
            target.setEndDate(rd.getEndDate().getValue());
          }
          // 重複スケジュールを登録
          target.addDisplaySchedule(rd);
        } else {
          // 重なっていない場合はそのまま格納する。
          rd.addDisplaySchedule(rd);
          destList.add(rd);
        }
      }
    }

    // System.out.println("addResultData:");
    // for (ScheduleReferOnedayResultData t : destList) {
    // System.out.println(t.getName()
    // + " "
    // + t.getStartDate().toString()
    // + "-"
    // + t.getEndDate().toString());
    // }
  }

  /**
   * スケジュールを追加します。
   * 
   * @param rd
   *            スケジュール
   */
  public void addResultData(ScheduleReferOnedayResultData rd) {
    list.add(rd);
  }

  /**
   * スケジュールリストを取得します。
   * 
   * @return
   */
  public List<ScheduleReferOnedayResultData> getSchedule() {
    return list;
  }

}
