//_hasResource checks added by build. Do not use _hasResource directly in your code.
if(!dojo._hasResource["aipo.schedule.oneday"]){

    dojo._hasResource["aipo.schedule.oneday"] = true;
/*
 * Aipo is a groupware program developed by Aimluck,Inc.
 * http://www.aipo.com/
 *
 * Copyright(C) 2012 avanza Co.,Ltd. All rights reserved.
 * http://www.avnz.co.jp/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

// 1日スケジュール共通処理
dojo.provide("aipo.schedule.oneday");

dojo.require("aipo.schedule.common");
dojo.require("aipo.schedule.dnd.OneDaySpanScheduleAreaMove");
dojo.require("aipo.schedule.dnd.OneDaySpanScheduleMove");
dojo.require("aipo.schedule.dnd.OneDaySpanScheduleMove");
dojo.require("aipo.schedule.dnd.ScheduleToolTipFoundation");

/** 初期化用オブジェクト配列(通常/期間のドラッグ&ドロップ、期間予定ツールチップ等) */
aipo.schedule.oneday.objectlist = Array();

/** 通常予定ツールチップ土台 */
aipo.schedule.oneday.dummyDivObj = null;

/**
 * 予定読み込み
 * @param _portletId ポートレットID
 * @param 予定読み込みサーバー処理向けリクエストの追加パラメータ
 */
aipo.schedule.oneday.loadSchedule = function(/*String*/_portletId, /*String*/params) {

    // リクエストパラメータ
    var _params;

    // エラーメッセージ領域初期化
    errorArea = dojo.byId('error-'+_portletId);
    errorArea.innnerHTML="";
    dojo.style(errorArea, "display" , "none")

    // 再読み込み準備
    djConfig.usePlainJson=true;
    ptConfig[_portletId].reloadFunction = aipo.schedule.oneday.loadSchedule;

    // 予定サブ情報ツールチップ土台の初期化
    ptConfig[_portletId].isTooltipEnable = false;
    if(aipo.schedule.oneday.dummyDivObj){
         aipo.schedule.oneday.dummyDivObj.destroy();
         aipo.schedule.oneday.dummyDivObj = null;
    }

    // 予定取得URLのパラメータ作成
    // パラメータチェック
    if (typeof params == "undefined") {
       _params = "";
    } else {
       _params = params;
    }

    // セキュリティIDを追加
    var secid = dojo.byId("secid-" + _portletId);
    if(secid){
       _params += "&secid=" + secid.value;
    }

    // 閲覧メンバー
    var member_to = dojo.byId('member_to-' + _portletId);
    if(member_to) {
        _params += "&m_id=";
        var t_o = member_to.options;
        for(var i = 0 ; i < t_o.length; i++ ) {
            if(i > 0){
                _params += ",";
            }
            t_o[i].selected = true;
            _params += t_o[i].value;
        }
        if(t_o.length == 0){
            _params += aipo.schedule.login_id;
        }
    }

    // 処理対象日
    var targetDate = dojo.byId('targetDate-' + _portletId);
    if(targetDate){
        _params += "&view_start=" + targetDate.value;
     }

    // スケジュール取得サーバー処理を非同期実行
    dojo.xhrGet({
        portletId: _portletId,
        url: ptConfig[_portletId].jsonUrl + _params,
        encoding: "utf-8",
        handleAs: "json-comment-filtered",
        timeout: 30000,
        load: function(data, event) {
            //権限チェック
            obj_error = dojo.byId('error-'+_portletId);
            dojo.style(obj_error, "display" , "none");
            if("PermissionError" == data[0]){
               // 権限エラー処理
               dojo.style(obj_error, "display" , "block");
               obj_error.innerHTML = data[1];
               obj_content = dojo.byId('content-'+_portletId);
               dojo.style(obj_content,  "display" , "none");
               obj_indicator = dojo.byId('indicator-'+_portletId);
               dojo.style(obj_indicator, "display" , "none")
               return;
            } else if(data["errList"]){
                // その他エラー処理
               if("UpdateError" == data.errList[0]){
                     // 更新エラー
                     dojo.style(obj_error, "display" , "block");
                     obj_error.innerHTML = "<ul><li><span class=\"caution\">"+data.errList[1]+"</span></li></ul>";
                     obj_content = dojo.byId('content-'+_portletId);
                     dojo.style(obj_content, "visibility" , "visible");
                     obj_indicator = dojo.byId('indicator-'+_portletId);
                     dojo.style(obj_indicator, "display" , "none")
                }else if("FatalError" == data.errList[0]){
                    // 致命的エラー
                    dojo.style(obj_error, "display" , "block");
                    var errMsg = "";
                    for(var i=1; i < data.errList.length; i++){
                        errMsg += "<ul><li><span class=\"caution\">"+data.errList[i]+"</span></li></ul>";
                    }
                    obj_error.innerHTML = errMsg;
                    obj_content = dojo.byId('content-'+_portletId);
                    dojo.style(obj_content, "visibility" , "hidden");
                    obj_indicator = dojo.byId('indicator-'+_portletId);
                    dojo.style(obj_indicator, "display" , "none")
                    return;
                }
            }
            // 閲覧不可エラー表示
            obj_referenceErr = dojo.byId('referenceErr-'+_portletId);
            dojo.style(obj_referenceErr, "display" , "none");
            obj_referenceErr.innerHTML = "";
            if(data.referenceErr){
                dojo.style(obj_referenceErr, "display" , "block");
                obj_referenceErr.innerHTML += "<ul><li><span class=\"caution\">"+data.referenceErr+"</span></li></ul>";
            }

            //オブジェクト配列の初期化
            var i;
            if(!!aipo.schedule.oneday.objectlist){
                var o_size = aipo.schedule.oneday.objectlist.length;
                for(i = 0; i < o_size; i++){
                    var obj = aipo.schedule.oneday.objectlist[i];
                    if(obj.portletId == _portletId){
                        obj.destroy();
                    }
                }
            }

            // JSON戻り値に"error"値がある場合、再読み込み
            if (!aipo.errorTreatment(data, ptConfig[_portletId].thisUrl)) {
                return;
            }
            // ポートレット定義にJSON戻り値を格納
            ptConfig[_portletId].jsonData = data;

            var app_list = dojo.byId('app_member_to-' + _portletId);
            var obj_print = dojo.byId('submitPrint-' + _portletId);
            var obj_print_indicator = dojo.byId('printIndicator-' + _portletId);
            var app_list_o = app_list.options;
            var app_count = 0;
            // 初期化して設定
            app_list_o.length = 0;
            // 閲覧可メンバーを再設定する
            dojo.forEach(data.approvalMemberList, function(appList) {
                app_list_o[app_count] = new Option(appList.aliasName,appList.usetIdValue);
                app_count++;
            });
            // 閲覧可メンバーがいなければ、印刷不可。
            // また、印刷中（indicatorのstyle.displayがblock）の場合は、印刷不可。
            if((app_list.options.length == 0) || ("block" == obj_print_indicator.style.display)) {
                obj_print.disabled = true;
            } else {
                obj_print.disabled = "";
            }

            // 閲覧メンバー（select）
            var member_to = dojo.byId('member_to-' + _portletId);
            // 予定インデックス
            var count = 0;
            // 期間行インデックス
            var l_count = 0;

            // 現在日の表示
            var viewDateM = data.startDate.substring(5,7).replace(/^0+([0-9]+)/,"$1");
            var viewDateD = data.startDate.substring(8,10).replace(/^0+([0-9]+)/,"$1");
            dojo.byId('viewDate-' + _portletId).innerHTML = data.startDate.substring(0,4) + " 年 " + viewDateM + " 月 " + viewDateD + " 日 " + data.dayOfWeek;
            dojo.byId('viewHoliDay-' + _portletId).innerHTML = data.holiday;

            // カレンダーウィジット取得
            var cal = dijit.byId("onedayCal-" + _portletId);

            // カレンダーの日付決定
            cal.changeBaseDate(data.startDate);

            // ユーザー別期間予定領域文字列
            var userSpanCol = new Array(member_to.options.length);
            for(var i = 0;i < member_to.options.length; i++) {
                userSpanCol[i] = "";
            }

            // 期間予定領域の表示
            dojo.forEach(data.spanSchedule, function(itemList) {
                // 複数列・行の出力
                for(var i = 0;i < member_to.options.length; i++) {
                    userSpanCol[i] += '<div class="onedaySpanScheduleGrid" id="spanScheduleItemGarage-' + l_count + '-' + i + '_' + _portletId + '"></div>';
                    // 期間予定行1件の場合は2行にする
                    if(this.length == 1){
                        userSpanCol[i] += '<div class="onedaySpanScheduleGrid" id="spanScheduleItemGarage-1-' + i + '_' + _portletId + '"></div>';
                    }
                }
                // 期間予定行1件の場合は2行扱いにする
                if(this.length == 1){
                    l_count++;
                }
                l_count++;
            }, data.spanSchedule);
            // 期間予定行0件の場合は2行にする
            if(l_count == 0){
                for(var i = 0;i < member_to.options.length; i++) {
                    userSpanCol[i] = '<div class="onedaySpanScheduleGrid" id="spanScheduleItemGarage-0-' + i + '_' + _portletId + '"></div>';
                    userSpanCol[i] += '<div class="onedaySpanScheduleGrid" id="spanScheduleItemGarage-1-' + i + '_' + _portletId + '"></div>';
                }
                l_count = 2;
            }

            // 外枠の縦幅を設定
            var headLeftDiv = "";
            var headRightDiv = "";
            for(var i=0; i < l_count; i++){
                headLeftDiv += '<div class="weeklyTermLeftTop">&nbsp;</div>';
                headRightDiv += '<div class="onedaySpanAreaRightItem">&nbsp;</div>';
            }
            dojo.byId("spanAreaLeft-" + _portletId).innerHTML = headLeftDiv;
            var spanAreaRight = dojo.byId("spanAreaRight-" + _portletId);
            if(spanAreaRight){
                spanAreaRight.innerHTML = headRightDiv;
            }

            // ユーザー別期間予定領域に期間予定要素（列）を出力する
            for(var i = 0;i < member_to.options.length; i++) {
                dojo.byId("spanScheduleColumn-" + i + "_" + _portletId).innerHTML = userSpanCol[i];
            }

/*  期間予定領域の操作を無効化する
            // 期間予定領域ドラッグ＆ドロップ設定
            for(var i = 0;i < member_to.options.length; i++){
                for(var j=0; j < l_count; j++){
                    var spanArea = dojo.byId("spanScheduleItemGarage-" + j + "-" + i + "_" + _portletId);
                    var draggableWorkObj = new aipo.schedule.dnd.OneDaySpanScheduleAreaDraggable(spanArea, {pid:_portletId, idx: i});
                    draggableWorkObj.targetUserId = member_to.options[i].value;
                    var acl = dojo.byId("acl-" + i + "_" + _portletId).value;
                    if("M" == acl || "S" == acl){
                        draggableWorkObj.canCreate = true;
                    }
                    // 初期化用配列に格納
                    aipo.schedule.oneday.objectlist.push(draggableWorkObj);
                    // クリック処理をバインド
                    dojo.connect(spanArea,"onclick", draggableWorkObj, "onScheduleClick");
                }
            }
*/

            // 予定列のスタイル設定
            for(var i = 0;i < member_to.options.length; i++) {
                // 通常予定領域
                var tmpNode2 = dojo.byId('timeColumn-' + i + '_' + _portletId);
                // 期間予定領域
                var tmpNode3 = dojo.byId('spanScheduleColumn-' + i + '_' + _portletId);
                // スタイルの解除
                dojo.removeClass(tmpNode2, "saturday");
                dojo.removeClass(tmpNode2, "sunday");
                dojo.removeClass(tmpNode2, "holiday");
                dojo.removeClass(tmpNode3, "saturday");
                dojo.removeClass(tmpNode3, "sunday");
                dojo.removeClass(tmpNode3, "holiday");

                // 土日スタイルのON/OFF
                if (data.dayOfWeek == "（土）") {
                    dojo.addClass(tmpNode2, "saturday");
                    dojo.addClass(tmpNode3, "saturday");
                } else if (data.dayOfWeek == "（日）") {
                    dojo.addClass(tmpNode2, "sunday");
                    dojo.addClass(tmpNode3, "sunday");
                }
                // 祝日スタイルのON/OFF
                if (data.holiday) {
                    dojo.addClass(tmpNode2, "holiday");
                    dojo.addClass(tmpNode3, "holiday");
                }
            }

            // 描画HTML
            var html = "";
            // 高さチェック配列
            var tmpHeightList = [];
            // 高さ最小値
            var rowHeight = ptConfig[_portletId].rowHeight;
            // 通常予定（単発・日またぎ・繰り返し）の表示
            dojo.forEach(data.schedule, function(item) {
                // 縦開始位置
                var top = item.startDateHour * rowHeight * 2 + item.startDateMinute * rowHeight / 30;
                // 高さ
                var height = item.endDateHour * rowHeight * 2 + item.endDateMinute * rowHeight / 30 - top;
                // 高さが30分未満か否かを配列に格納
                if(height < rowHeight) {
                    // 30分未満の場合
                    // 実際の高さを保持する
                    tmpHeightList[count] = height;
                    // 高さを最小縦幅に変更する
                    height = rowHeight;
                } else {
                    // 30分超の場合、-1を保持する
                    tmpHeightList[count] = -1;
                }
                // 横開始位置
                var left = 100 / member_to.options.length * item.index;
                // 横幅
                var width = 100 / member_to.options.length * 0.99;
                // 予定名
                var name = item.name;
                // 予定開始日時
                var startDate = item.startDate;
                // 予定終了日時
                var endDate = item.endDate;
                // 時刻セパレーター
                var sepalater = '-';
                // 予定ID
                var scheduleId = item.scheduleId;

                // スタイル番号
                var styleNum = "0";
                var t_o = member_to.options;
                for(i = 0 ; i < t_o.length; i++ ) {
                  if((item.ownerId == t_o[i].value)){
                      styleNum = i %  oneday_member_maximum_to;
                      break;
                  }
                }

                // 形式
                var formName = "";
                if(item.memberList.length > 1) {
                    formName = "[会議]";
                }
                // 重要
                var priority = "";
                if(item.priority){
                    priority = "<span class=\"caution\">【重要】</span>";
                    name = "<span style='font-weight: bold;'>" + name + "</span>";
                }
                // 場所
                var place = "";
                if(item.place != ""){
                    place = "（" + item.place + "）";
                }
                // add start 要件No.9 スケジュール表示 （仮の予定、確定した予定）
                var scheduleDivBackColor = "scheduleDivColor";
                var temporary = "";
                if (item.temporary && item.showDetail) {
                  temporary = "<span class='temporaryCaution'>[仮]</span>";
                  scheduleDivBackColor = "temporaryColorStyle";
                }
                // add end
                // add start 要件No.26 スケジュール個別色換え
                var scheduleDivBackStyle = "";
                if(item.loginuser && item.individualColor != ""){
                    scheduleDivBackStyle = "background-color:#" + item.individualColor + ";";
                }
                // add end
                // 予定形式アイコン
                var icon = "";
                // add start 要件No.18 会議案内ファイル添付
                if(item.withfiles) {
                    icon += '<img src="images/schedule/schedule_withfiles.gif" border="0" width="16" height="16" alt="添付ファイル有" title="添付ファイル有" align="top" class="icon" />';
                }
                // add end
                if(!item['public']) {
                    icon += '<img src="images/schedule/schedule_secret.gif" border="0" width="16" height="16" alt="非公開" title="非公開" align="top" class="icon" />';
                }
                if(item.duplicate) {
                    icon += '<img src="images/schedule/schedule_duplicate.gif" border="0" width="16" height="16" alt="重複スケジュール" title="重複スケジュール" align="top" class="icon" />';
                }
                if(item.repeat) {
                    icon += '<img src="images/schedule/schedule_repeat.gif" border="0" width="16" height="16" alt="繰り返し" title="繰り返し" align="top" class="icon" />';
                }
                // 回答状態
                if(item.status == "T"){
                    icon += '<img src="images/schedule/schedule_tmpreserve.gif" border="0" width="16" height="16" alt="未回答" title="未回答" align="top" class="icon" />';
                }else if(item.status == "C") {
                    icon += '<img src="images/schedule/schedule_reserve.gif" border="0" width="16" height="16" alt="承諾" title="承諾" align="top" class="icon" />';
                }else if(item.status == "P") {
                    icon += '<img src="images/schedule/schedule_prereserve.gif" border="0" width="16" height="16" alt="仮承諾" title="仮承諾" align="top" class="icon" />';
                }else if(item.status == "V") {
                    icon += '<img src="images/schedule/schedule_veto.gif" border="0" width="16" height="16" alt="欠席" title="欠席" align="top" class="icon" />';
                }
                if(icon != ""){
                    icon = '<div>' + icon + '</div>';
                }
                // 時刻の表示判定
                // 開始時刻が≠00分かつ≠30分　または　終了時刻が≠00分かつ≠30分の場合に表示
                if((item.startDateMinute != "0" && item.startDateMinute != "30")
                        || item.endDateMinute != "0" && item.endDateMinute != "30") {
                    timeDisplayStyle = "";
                }else{
                    timeDisplayStyle = "none";
                }
                // 予定表示
                // change start 要件No.9 スケジュール表示 （仮の予定、確定した予定） 要件No.26 スケジュール個別色換え
                //html += '<div id="schedule-' + count + '_' + _portletId+'" class="scheduleDiv color'+styleNum+'" style="top: '+ top +'px; left: ' + left + '%; height: '+ height + 'px; width: '+ width + '%; z-index: 0; visibility: hidden;">'
                html += '<div id="schedule-' + count + '_' + _portletId+'" class="scheduleDiv color'+styleNum+' ' + scheduleDivBackColor + '" style="top: '+ top +'px; left: ' + left + '%; height: '+ height + 'px; width: '+ width + '%; z-index: 0; visibility: hidden;' + scheduleDivBackStyle + '">'
                // change end
                      + '<div class="scheduleDivName color'+styleNum+'">'
                      + '<div style ="word-break: break-all">' + formName + priority
                      // add start 要件No.9 スケジュール表示 （仮の予定、確定した予定）
                      + temporary
                      // add end
                      + '<span id="scheduleDivTime-'+ count + '_' + _portletId + '" style="display:' + timeDisplayStyle + ' ">' + startDate + sepalater + endDate + '</span>'
                      + name + place
                      + '</div>'
                      + icon
                      + '</div>'
                      + '<div class="scheduleDivLastLine color'+styleNum+'"><center><div class="handleDiv color'+styleNum+'" align="center">&nbsp;</div></center></div>'
                      + '</div>';
                count++;
            });
            html += "<div id=\"dummy_div_" +  _portletId + "\" class=\"scheduleDivAdd dummy_div\" style=\" position:absolute; width: 0px; height : 0px; left: 0px; top: -10000px; Filter: Alpha(Opacity=10);opacity:.10; background-color:#FFFFFF; \">&nbsp;</div>"
            dojo.byId('scheduleGarage_' + _portletId).innerHTML = html;

            // 通常予定の再配置
            // ユーザー別予定要素配列を生成
            var scheduleColumns = Array();
            for(var i=0;i<member_to.options.length;i++) {
                scheduleColumns[i] = Array();
            }
            // 予定をユーザー別予定要素配列に格納
            dojo.forEach(data.schedule, function(item, i) {
                // 対象の予定要素
                var scheduleDiv = dojo.byId("schedule-" + i + "_" + _portletId);
                // 予定に重複予定数を定義
                scheduleDiv.overlapCount = 0;
                // 列配列に予定要素を追加
                scheduleColumns[item.index].push(scheduleDiv);
            });
            // ユーザー別に再配置処理を実行
            for(var i=0; i<member_to.options.length; i++) {
                aipo.schedule.oneday.relocation(scheduleColumns[i], (100 / member_to.options.length * i), member_to.options.length);
                scheduleColumns[i] = null;
            }

            // 通常予定（単発・日またぎ・繰り返し）のドラッグ＆ドロップ可否判定
            count = 0;
            dojo.forEach(data.schedule, function(item) {
                // 対象の予定要素ID
                var draggableId = "schedule-" + count + "_" + _portletId;
                // 予定要素
                var draggable = dojo.byId(draggableId);
                // 予定要素に紐づく通常予定ドラッグ＆ドロップウィジットのインスタンスを生成
                var tmpDraggable = new aipo.schedule.dnd.OneDayScheduleDraggable(draggable, {pid:_portletId});
                // 初期化用配列に格納
                aipo.schedule.oneday.objectlist.push(tmpDraggable);

                // 属性を設定
                // ドラッグ可否
                if(item.owner){
                    tmpDraggable.isDraggable = true;
                }else{
                    tmpDraggable.isDraggable = false;
                }
                // 照会可否
                if(item.member || item.loginuser || item.owner || item.public){
                    tmpDraggable.canReference = true;
                } else {
                    tmpDraggable.canReference = false;
                }
                // 日またぎ位置
                tmpDraggable.strloc = item.strLoc;
                // 予定
                tmpDraggable.schedule = item;
                // 列インデックス
                tmpDraggable.tmpIndex = item.index;
                // 予定通し番号
                tmpDraggable.count = count;
                // 30分未満判定値
                tmpDraggable.tmpHeight = tmpHeightList[count];

                // 照会可の場合のみ
                // 予定要素にドラッグ＆ドロップウィジットのマウスオーバー処理をバインド
                if(tmpDraggable.canReference){
                    dojo.connect(draggable,"onclick", tmpDraggable, "onScheduleClick");
                    // ツールチップ表示判定で可の場合のみ、ツールチップイベントハンドラを設定する
                    var hasToolTip = false;
                    if(item.hasToolTip){
                        // サーバー処理でツールチップ表示判定が可
                        hasToolTip = true;
                    }else{
                        if(draggable.overlapCount > 0){
                            // 重複予定の場合、文字数 > 基準値 / 重複数 が真の場合のみ可
                            if(item.viewInfoLength > (item.viewInfoLengthForHasToolTip / (draggable.overlapCount+1))){
                                hasToolTip = true;
                            }
                        }
                    }
                    if(hasToolTip){
                        dojo.connect(draggable,"onmouseover", tmpDraggable, "onScheduleOver");
                    }

                    // add start 要件No.16 スケジュール画面（月単位／週単位／日単位）右クリックメニュー
                    dojo.connect(draggable,"oncontextmenu", tmpDraggable, "onRightClick");
                    // add end
                } else {
                    // add start 要件No.16 スケジュール画面（月単位／週単位／日単位）右クリックメニュー
                    //閲覧権限の無いスケジュールの場合は、右クリックされても何もしない
                    dojo.connect(draggable,"oncontextmenu", tmpDraggable, "onRightClickForNonPulic");
                    // add end
                }

                // 列配列に予定要素を追加
                //scheduleColumns[item.index].push(draggable);

                count++;
            });

            // 各種インデックスを初期化
            count = 0;
            l_count = 0;

            // 期間予定の表示
            dojo.forEach(data.spanSchedule, function(itemList) {
                var item = null;
                var spanHtml = "";

                for (var k = 0; k < itemList.length ; k++){
                    item = itemList[k];
                    // 予定名
                    var name = item.name;
                    // 予定ID
                    var scheduleId = item.scheduleId;

                    // スタイル番号
                    var styleNum = "0";
                    var t_o = member_to.options;
                    for(i = 0 ; i < t_o.length; i++ ) {
                      if((item.ownerId == t_o[i].value)){
                          styleNum = i %  oneday_member_maximum_to;
                          break;
                      }
                    }
                    // 形式
                    var formName = "";
                    if(item.memberList.length > 1) {
                        formName = "[会議]";
                    }
                    // 重要
                    var priority = "";
                    if(item.priority){
                        priority = '<span class="caution">【重要】</span>';
                        name = '<span style="font-weight: bold;">' + name + '</span>';
                    }
                    // add start 要件No.9 スケジュール表示 （仮の予定、確定した予定）
                    var spanScheduleBackColor = "spanScheduleColor";
                    var temporary = "";
                    if (item.temporary && item.showDetail) {
                        temporary = '<span class="temporaryCaution">[仮]</span>';
                        spanScheduleBackColor = "temporaryColorStyle";
                    }
                    // add end
                    // add start 要件No.26 スケジュール個別色換え
                    var spanScheduleBackStyle = "";
                    if(item.loginuser && item.individualColor != ""){
                        spanScheduleBackStyle = "background-color:#" + item.individualColor + ";";
                    }
                    // add end
                    // 形式アイコン
                    // add start 要件No.18 会議案内ファイル添付
                    if(item.withfiles) {
                        name += '<img src="images/schedule/schedule_withfiles.gif" border="0" width="16" height="16" alt="添付ファイル有" title="添付ファイル有" align="top" class="icon" />';
                    }
                    // add end
                    if(!item['public']) {
                        name += '<img src="images/schedule/schedule_secret.gif" border="0" width="16" height="16" alt="非公開" title="非公開" align="top" class="icon" />';
                    }
                    if(item.duplicate) {
                        name += '<img src="images/schedule/schedule_duplicate.gif" border="0" width="16" height="16" alt="重複スケジュール" title="重複スケジュール" align="top" class="icon" />';
                    }
                    if(item.repeat) {
                        name += '<img src="images/schedule/schedule_repeat.gif" border="0" width="16" height="16" alt="繰り返し" title="繰り返し" align="top" class="icon" />';
                    }
                    // 回答状態
                    if(item.status == "T"){
                        name += '<img src="images/schedule/schedule_tmpreserve.gif" border="0" width="16" height="16" alt="未回答" title="未回答" align="top" class="icon" />';
                    }else if(item.status == "C") {
                        name += '<img src="images/schedule/schedule_reserve.gif" border="0" width="16" height="16" alt="承諾" title="承諾" align="top" class="icon" />';
                    }else if(item.status == "P") {
                        name += '<img src="images/schedule/schedule_prereserve.gif" border="0" width="16" height="16" alt="仮承諾" title="仮承諾" align="top" class="icon" />';
                    }else if(item.status == "V") {
                        name += '<img src="images/schedule/schedule_veto.gif" border="0" width="16" height="16" alt="欠席" title="欠席" align="top" class="icon" />';
                    }
                    // 開始終了日
                    var startEndDate = "";
                    if(item.viewStartEndDate != ""){
                        startEndDate = "（" + item.viewStartEndDate + "）";
                    }
                    // change start 要件No.9 スケジュール表示 （仮の予定、確定した予定）
                    //spanHtml = '<div id="spanSchedule-' + count + '_' + _portletId +'" class="spanScheduleDiv" style="width:100%;">'
                    //         + '<div class="spanScheduleName">' + formName + priority + name + startEndDate + '</div>'
                    //         + '</div>';
                    spanHtml = '<div id="spanSchedule-' + count + '_' + _portletId +'" class="spanScheduleDiv ' + spanScheduleBackColor + '" style="width:99.9%;word-break: break-all;' + spanScheduleBackStyle + '">'
                             + '<div class="spanScheduleName">' + formName + priority + temporary + name + startEndDate + '</div>'
                             + '</div>';
                    // change end
                    dojo.byId('spanScheduleItemGarage-' + l_count + '-' + item.index + '_' + _portletId).innerHTML = spanHtml;
                    count++;
                }
                l_count++;
            });

            // 期間予定のドラッグ＆ドロップ可否判定
            count = 0;
            l_count = 0;
            dojo.forEach(data.spanSchedule, function(itemList) {
                var item = null;
                for (var k = 0; k < itemList.length ; k++){
                    // 対象の予定データ
                    item = itemList[k];
                    // 対象の予定要素ID
                    var draggableId = "spanSchedule-" + count + "_" + _portletId;
                    // 予定要素
                    var draggable = dojo.byId(draggableId);
                    // 予定要素に紐づく期間予定ドラッグ＆ドロップウィジットのインスタンスを生成
                    var tmpDraggable = new aipo.schedule.dnd.OneDaySpanScheduleDraggable(draggable,{pid:_portletId});
                    // 初期化用配列に格納
                    aipo.schedule.oneday.objectlist.push(tmpDraggable);

                    // 属性を設定
                    // 予定
                    tmpDraggable.schedule = item;
                    // 照会可否判定
                    if(item.member || item.loginuser || item.owner || item.public){
                        tmpDraggable.canReference = true;
                    } else {
                        tmpDraggable.canReference = false;
                    }

                    // 照会可の場合のみ
                    // 予定要素にドラッグ＆ドロップウィジットのクリック処理とマウスオーバー処理をバインド
                    if(tmpDraggable.canReference){
                        // ツールチップ表示判定で可の場合のみ、ツールチップイベントハンドラを埋め込む
                        if(item.hasToolTip){
                            dojo.connect(draggable,"onmouseover", tmpDraggable, "onScheduleOver");
                        }
                        dojo.connect(draggable,"onclick", tmpDraggable, "onScheduleClick");
                        // add start 要件No.16 スケジュール画面（月単位／週単位／日単位）右クリックメニュー
                        dojo.connect(draggable,"oncontextmenu", tmpDraggable, "onRightClick");
                        // add end
                    } else {
                        // add start 要件No.16 スケジュール画面（月単位／週単位／日単位）右クリックメニュー
                        dojo.connect(draggable,"oncontextmenu", tmpDraggable, "onRightClickForNonPulic");
                        // add end
                    }

                    count++;
                }
                l_count++;
            });

            // メインコンテンツ表示/インジケーター非表示
            obj_content = dojo.byId('content-'+_portletId);
            dojo.style(obj_content, "visibility" , "visible");
            obj_indicator = dojo.byId('indicator-'+_portletId);
            dojo.style(obj_indicator, "display" , "none")

            // 時刻スクロールトップ位置の変更
            if (!ptConfig[_portletId].isScroll) {
                dojo.byId('weeklyScrollPane_'+_portletId).scrollTop = ptConfig[_portletId].contentScrollTop;
                ptConfig[_portletId].isScroll = true;
            }
            // ツールチップ表示開始
            ptConfig[_portletId].isTooltipEnable = true;

            // カレンダー状態表示
            cal.updateDisplay();

        },
        error: function (res, args) {
            errorArea = dojo.byId('error-'+_portletId);
            errorArea.innerHTML="予定の読み込みに失敗しました。";
            dojo.style(errorArea, "display" , "block");
        }
    });
};

/**
 * 通常予定の再配置(横位置、横幅設定）
 * @param scheduleList 予定列に属する予定配列
 * @param scheduleDivLeft 予定開始位置基準値
 * @col 列数
 */
aipo.schedule.oneday.relocation = function(/*Array*/scheduleList, /*Number*/scheduleDivLeft, /*Number*/col) {
    // 横幅係数
    var offsetW = 0.996;
    var offsetSingleW = 0.995;
    // 列横幅
    var scheduleDivWidth = 100 / col;
    // 重複予定集合の終端予定インデックス
    var endoverlapSchedule=0;
    // 重複予定集合の最大横開始位置
    var positionLeftArrayMax=0;
    // 重複予定集合の最大縦開始位置（開始時刻）
    var bottomLineMax=0;
    // 重複予定集合の先頭予定インデックス
    var targetNum=0;
    // 重複予定集合の最大縦終了位置（終了時刻）
    var divBottom = 0;
    // 予定が所属する重複予定集合の予定数
    var overlapNumArray = new Array(scheduleList.length);
    // 予定の横開始位置基準値
    var positionLeftArray = new Array(scheduleList.length);
    // 予定の横幅補正基準値
    var resizeWidthArray = new Array(scheduleList.length);

    // 横方向ソート
    scheduleList.sort(aipo.schedule.oneday.sortByRegion);

    // Z座標設定（後の方が前面表示）
    for (var i=0; i<scheduleList.length; i++) {
        scheduleList[i].style.zIndex = i+1;
    }

    // 予定のループ
    for (var i=0; i<scheduleList.length; i=endoverlapSchedule) {

        // 基準予定の重複予定集合より、終端予定インデックスを確定
        endoverlapSchedule = aipo.schedule.oneday.getOverlapScheduleTerminationIndex(scheduleList,i,i,++endoverlapSchedule);

        // 新規の重複予定集合か判定（基準の縦開始位置を特定し、最大横開始位置を初期化）
        if (bottomLineMax <= parseInt(dojo.getComputedStyle(scheduleList[i]).top)) {
            targetNum = i;
            bottomLineMax = parseInt(dojo.getComputedStyle(scheduleList[i]).top);
            positionLeftArrayMax = 0;
        }

        // 重複予定集合の最大縦終了位置を特定
        for (var j=targetNum; j<endoverlapSchedule; j++) {
            divBottom = parseInt(dojo.getComputedStyle(scheduleList[j]).top) + parseInt(dojo.getComputedStyle(scheduleList[j]).height);
            if (bottomLineMax < divBottom) {
                bottomLineMax = divBottom;
            }
        }

        // 予定の横開始位置基準値を算出
        for (var j=targetNum; j<endoverlapSchedule; j++) {
            positionLeftArray[j] = aipo.schedule.oneday.getDivPositionLeft(scheduleList,positionLeftArray,targetNum,j,0);
            if (positionLeftArray[j] > positionLeftArrayMax) {
                positionLeftArrayMax = positionLeftArray[j];
            }
        }

        // 予定の横幅基準値を算出
        /*
        for (var j=targetNum; j<endoverlapSchedule; j++) {
            resizeWidthArray[j] = aipo.schedule.oneday.getDivWidth(scheduleList,positionLeftArray,positionLeftArrayMax,targetNum,j);
        }
        */

        // 重複予定集合の予定数を設定
        for (var j=targetNum; j<endoverlapSchedule; j++) {
            overlapNumArray[j] = positionLeftArrayMax;
            scheduleList[i].overlapCount = positionLeftArrayMax;
        }
    }

    // 全予定の左開始位置と横幅の設定
    for (var i=0; i<scheduleList.length; i++) {
        if (overlapNumArray[i] != 0) {
            /*
            if (positionLeftArray[i] < positionLeftArray[i+1]) {
                dojo.style(scheduleList[i], "width", (scheduleDivWidth / (overlapNumArray[i]+1) * offsetW) + "%");
            } else if (resizeWidthArray[i]==0) {
                dojo.style(scheduleList[i], "width", (scheduleDivWidth - (scheduleDivWidth/(overlapNumArray[i]+1))*positionLeftArray[i]) * offsetW +"%");
            } else {
                dojo.style(scheduleList[i], "width", (scheduleDivWidth - (scheduleDivWidth/(overlapNumArray[i]+1))*positionLeftArray[i] - (scheduleDivWidth*2/(overlapNumArray[i]+1))*0.2 - (scheduleDivWidth/(overlapNumArray[i]+1))*(resizeWidthArray[i]-1)) * offsetW +"%");
            }
            */
            dojo.style(scheduleList[i], "width", (scheduleDivWidth / (overlapNumArray[i]+1) * offsetW) + "%");
        } else {
            dojo.style(scheduleList[i], "width", scheduleDivWidth * offsetSingleW +"%");
        }

        dojo.style(scheduleList[i], "left", (scheduleDivLeft + ((scheduleDivWidth/(overlapNumArray[i]+1))*positionLeftArray[i]))+"%");
        dojo.style(scheduleList[i], "visibility", "visible" );
     }
};

/**
 * 重複している予定の範囲を返す
 * @param scheduleList 予定列に属する予定配列
 * @param mostLeftNum 比較開始予定インデックス
 * @param startNum 比較元予定インデックス
 * @param endNum 比較先予定インデックス
 * @return 重複予定の最終インデックス+1
 */
aipo.schedule.oneday.getOverlapScheduleTerminationIndex = function(/*Array*/scheduleList, /*Number*/mostLeftNum, /*Number*/startNum, /*Number*/endNum) {
    var mostLeftDivBottom = parseInt(dojo.getComputedStyle(scheduleList[mostLeftNum]).top) + parseInt(dojo.getComputedStyle(scheduleList[mostLeftNum]).height);
    var startNumBottom = parseInt(dojo.getComputedStyle(scheduleList[startNum]).top) + parseInt(dojo.getComputedStyle(scheduleList[startNum]).height);

    var endNumTop;
    if(scheduleList[endNum]){
        endNumTop = parseInt(dojo.getComputedStyle(scheduleList[endNum]).top);
    }else {
        endNumTop = 'NaN';
    }

    if ((endNum > scheduleList.length - 1)
        || (mostLeftDivBottom <= endNumTop)
        || (startNumBottom <= endNumTop)) {
        return endNum;
    } else {
        endNum = aipo.schedule.oneday.getOverlapScheduleTerminationIndex(scheduleList, mostLeftNum, endNum, ++endNum);
    }
    endNum = aipo.schedule.oneday.getOverlapScheduleTerminationIndex(scheduleList, mostLeftNum, startNum, endNum);
    return endNum;
};

/**
 * 通常予定DIVの横開始位置算出
 * @param scheduleList 予定列に属する予定配列
 * @param positionLeftArray 予定開始位置の配列
 * @param startNum 比較開始インデックス
 * @param endNum 比較終了インデックス
 * @param positionLeft 予定開始位置の基準値
 * @return 横開始位置
 */
aipo.schedule.oneday.getDivPositionLeft = function(/*Array*/scheduleList, /*Array*/positionLeftArray, /*Number*/startNum, /*Number*/endNum, /*Number*/positionLeft) {
    var endNumTop = parseInt(dojo.getComputedStyle(scheduleList[endNum]).top);
    for (var i=startNum; i < endNum; i++) {
        var tmpDivTop = parseInt(dojo.getComputedStyle(scheduleList[i]).top);
        var tmpDivBottom = tmpDivTop + parseInt(dojo.getComputedStyle(scheduleList[i]).height);
        if ((tmpDivTop <= endNumTop)
            && (tmpDivBottom > endNumTop)
            && (positionLeftArray[i]==positionLeft)) {
                positionLeft = aipo.schedule.oneday.getDivPositionLeft(scheduleList, positionLeftArray, startNum, endNum, ++positionLeft);
        }
    }
    return positionLeft;
};

/**
 * 通常予定DIVの横幅算出
 * @param scheduleList 予定列に属する予定配列
 * @param positionLeftArray 予定開始位置の配列
 * @param overlapNumArrayMax 予定列の予定の最大開始位置
 * @param startNum 比較開始インデックス
 * @param endNum 比較終了インデックス
 * @return 横幅
 */
aipo.schedule.oneday.getDivWidth = function(/*Array*/scheduleList, /*Array*/positionLeftArray, /*Number*/overlapNumArrayMax, /*Number*/startNum, /*Number*/endNum) {
    var resizeWidth=0;
    var endNumTop = parseInt(dojo.getComputedStyle(scheduleList[endNum]).top);
    for (i=startNum; i<endNum; i++) {
        var tmpDivTop = parseInt(dojo.getComputedStyle(scheduleList[i]).top);
        var tmpDivBottom = tmpDivTop + parseInt(dojo.getComputedStyle(scheduleList[i]).height);
        if ((tmpDivTop <= endNumTop)
            && (tmpDivBottom > endNumTop)
            && (positionLeftArray[i]>positionLeftArray[endNum])
            && ((overlapNumArrayMax-positionLeftArray[i]+1)>resizeWidth)) {
                resizeWidth = overlapNumArrayMax - positionLeftArray[i] + 1;
        }
    }
    return resizeWidth;
};

/**
 * 通常予定DIVの横方向ソート
 * @param a 比較元要素
 * @param b 比較先要素
 * @return 要素Aが先の場合マイナス、要素Bが先の場合プラス、同じ場合は0
 */
aipo.schedule.oneday.sortByRegion = function(/*Node*/a, /*Node*/b) {
    var aTop = parseInt(dojo.getComputedStyle(a).top);
    var bTop = parseInt(dojo.getComputedStyle(b).top);
    var aBottom = aTop + parseInt(dojo.getComputedStyle(a).height);
    var bBottom = bTop + parseInt(dojo.getComputedStyle(b).height);

    if (aTop == bTop) {
        // 開始時刻が一致する場合は、終了時刻の降順
        return bBottom - aBottom;
    } else {
        // 開始時刻の昇順
        return aTop - bTop;
    }
};

/**
 * YYYY-MM-DD文字列の日付計算
 * ex: inputDate = "2007-01-01"
 *     days = "3"
 *     return = "2007-01-04"
 * @param thisDate YYYY-MM-DD形式の日付
 * @param days 加算日
 * @return thisDateにdaysの日数を加算したYYYY-MM-DD形式の日付
 */
aipo.schedule.oneday.getDate = function (/*String*/thisDate, /*Number*/days) {
    tmpYear = parseInt(thisDate.substring(0,4),10);
    tmpMonth = parseInt(thisDate.substring(5,7),10);
    tmpDay = parseInt(thisDate.substring(8,10),10);
    if (days > 0) {
        do {
            tmpMonthDays = aipo.schedule.oneday.getDay(tmpYear,tmpMonth);
            if (tmpDay + days <= tmpMonthDays) {
                tmpDay = tmpDay + days;
                if ((tmpMonth < 10) && (tmpDay < 10)) {
                    date = tmpYear + "-0" + tmpMonth + "-0" + tmpDay;
                } else if ((tmpMonth < 10) && !(tmpDay < 10)) {
                    date = tmpYear + "-0" + tmpMonth + "-" + tmpDay;
                } else if (!(tmpMonth < 10) && (tmpDay < 10)) {
                    date = tmpYear + "-" + tmpMonth + "-0" + tmpDay;
                } else {
                    date = tmpYear + "-" + tmpMonth + "-" + tmpDay;
                }
                days = -1;
            } else {
                days = days - (tmpMonthDays - tmpDay) - 1;
                if (tmpMonth == 12) {
                    tmpYear++;
                    tmpMonth=1;
                } else {
                    tmpMonth++;
                }
                tmpDay = 1;
            }
        } while (days >= 0)
    } else if (days < 0) {
        do {
            if (tmpDay + days > 0) {
                tmpDay = tmpDay + days;
                if ((tmpMonth < 10) && (tmpDay < 10)) {
                    date = tmpYear + "-0" + tmpMonth + "-0" + tmpDay;
                } else if ((tmpMonth < 10) && !(tmpDay < 10)) {
                    date = tmpYear + "-0" + tmpMonth + "-" + tmpDay;
                } else if (!(tmpMonth < 10) && (tmpDay < 10)) {
                    date = tmpYear + "-" + tmpMonth + "-0" + tmpDay;
                } else {
                    date = tmpYear + "-" + tmpMonth + "-" + tmpDay;
                }
                days = 1;
            } else {
                if (tmpMonth == 1) {
                    tmpYear--;
                    tmpMonth=12;
                } else {
                    tmpMonth--;
                }
                tmpMonthDays = aipo.schedule.oneday.getDay(tmpYear,tmpMonth);
                days = days + tmpDay;
                tmpDay = tmpMonthDays;
            }
        } while (days <= 0)
    } else {
        date = thisDate;
    }
    return date;
};

/**
 * 月の最終日取得
 * @param year 年
 * @param month 月
 * @return 月の最終日
 */
aipo.schedule.oneday.getDay = function (/*Number*/year, /*Number*/month) {
    if ( month == 2 ) {
        if ( !(year % 4)  && ( (year % 100) || !(year % 400) ) ) {
            return 29;
        } else {
            return 28;
        }
    } else if ( month == 4 || month == 6 || month == 9 || month == 11 ) {
        return 30;
    } else {
        return 31;
    }
};

/** グリッド配列 */
aipo.schedule.oneday.gridArray = null;

/**
 * 列グリッド配列作成
 * @param _portletId ポートレットID
 * @param _colSize 列数
 */
aipo.schedule.oneday.setGridArray = function(/*String*/_portletId, /*Number*/_colSize) {
    var tmpX = 0;
    if(aipo.schedule.oneday.gridArray) {
        delete(aipo.schedule.oneday.gridArray);
    }
    aipo.schedule.oneday.gridArray = new Array(_colSize);
    for(i = 0 ; i < _colSize ; i++){
        tmpX = dojo._abs(dojo.byId("userHead-"+ i +"_" + _portletId), true).x;
        aipo.schedule.oneday.gridArray[i]=tmpX;
    }
};

/**
 * マウスポインタが示しているグリッドX座標取得(編集エリア限定)
 * @param e イベント
 * @return index:グリッド横番号（左から0,1,2…)、x:グリッド左端のX座標
 */
aipo.schedule.oneday.getCurrentMouseX = function(/*Event*/e){
       if(aipo.schedule.oneday.gridArray == null) {
           return {index: -1, x: 0};
       }
       var startX = aipo.schedule.oneday.gridArray[0];
       var _tmpIndex= 0 ;
       var i;
       if(e.pageX > startX){
           var max = aipo.schedule.oneday.gridArray.length - 1;
           for(i = max; i > -1 ; i-- ) {
               if(e.pageX > aipo.schedule.oneday.gridArray[i]){
                   _tmpIndex = i;
                   break;
               }
           }
       }else {
           _tmpIndex = 0;
       }
       var _tmpX = aipo.schedule.oneday.gridArray[_tmpIndex] - startX;
       return {index: _tmpIndex, x: _tmpX};
};

/**
 * 1日スケジュール用ツールチップ表示
 * @param url スケジュールサブ情報取得処理URL
 * @param portlet_id ポートレットID
 * @param containerNode ツールチップ部品のノード
 */
aipo.schedule.oneday.showTooltip = function(url, portlet_id, containerNode){

    var datehtml = "";
    var rmbhtml = "";
    var smbhtml = "";
    var placehtml = "";

    dojo.xhrGet({
        portletId: portlet_id,
        url: url,
        encoding: "utf-8",
        handleAs: "json-comment-filtered",
        load: function(schedule, event) {
            if (schedule.length <= 0) {
                return;
            }

            // 期間でない場合、開始時刻と終了時刻を設定
            if (!schedule.isSpan) {
                datehtml = "<span style=\"font-size: 0.90em;\">" + schedule.date + "</span><br/>";
            }

            // 場所
            if(schedule.place != ""){
                placehtml = "<span style=\"font-size: 0.90em;\">場所</span><br/><ul>・" + schedule.place + "</ul>";
            }
            // add start 二次開発受入テスト仕様変更対応
            // 参加必須メンバー
            rmbhtml = aipo.schedule.common.getMemberListHtml(schedule.reqMemberList);
            if(rmbhtml != ""){
                rmbhtml = "<span style=\"font-size: 0.90em;\">【参加必須】</span><br/><ul>" + rmbhtml + "</ul>";
            }

            // 参加任意メンバー
            smbhtml = aipo.schedule.common.getMemberListHtml(schedule.subMemberList);
            if(smbhtml != ""){
                smbhtml = "<span style=\"font-size: 0.90em;\">【参加任意】</span><br/><ul>" + smbhtml + "</ul>";
            }
            // add end

            // ツールチップ表示
            // change start 二次開発受入テスト仕様変更対応
            // １日スケジュールツールチップで参加者を表示する。
            // var tooltiphtml = "<h4>" + schedule.name + "</h4>" + datehtml + placehtml;
            var tooltiphtml = "<h4>" + schedule.name + "</h4>" + datehtml + rmbhtml + smbhtml + placehtml;
            // change end
            containerNode.innerHTML = tooltiphtml;
        },
        error: function (res, args) {
            containerNode.innerHTML = "ツールチップの読み込みに失敗しました。";
        }
    });

};

/**
 * スケジュール作成ウインドウ表示（終日）
 * @param portletId ポートレットID
 * @param userId ユーザーID
 */
aipo.schedule.oneday.showFormWindow = function(portletId, userId){
    var targetDate = ptConfig[portletId].jsonData.formDateTime;
    aipo.common.showWindow(
        ptConfig[portletId].formUrl
        + "&entityid=new&mode=form&is_span=TRUE"
        + "&form_start=" + targetDate + '&form_end=' + targetDate
        + '&userid=' + userId,
        portletId,
        aipo.schedule.onLoadScheduleDialog );
};

}