/*
 * Aipo is a groupware program developed by Aimluck,Inc.
 * http://aipostyle.com/
 *
 * Copyright(C) 2011 avanza Co.,Ltd. All rights reserved.
 * http://www.avnz.co.jp/
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

package com.aimluck.eip.webmail;

import java.util.List;

import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

import com.aimluck.eip.cayenne.om.portlet.AvzTMailBatch;
import com.aimluck.eip.common.ALAbstractFormData;
import com.aimluck.eip.common.ALDBErrorException;
import com.aimluck.eip.common.ALPageNotFoundException;
import com.aimluck.eip.modules.actions.common.ALAction;
import com.aimluck.eip.orm.Database;
import com.aimluck.eip.util.ALEipUtils;
import com.aimluck.eip.webmail.util.WebMailUtils;

/**
 * メール一括処理の退避ファイル削除を管理するクラスです。
 * 
 */
public class WebMailPackageProcessDeleteFormData extends ALAbstractFormData {

  /** logger */
  private static final JetspeedLogger logger =
    JetspeedLogFactoryService
      .getLogger(WebMailPackageProcessDeleteFormData.class.getName());

  /** ログインユーザーのID * */
  private int user_id;

  /** ログインユーザー名 * */
  private String login_user_name;

  /** ログ出力用メッセージ(一括処理呼出) * */
  private final String ERROR_MESSAGE_ASYNCHRONOUS_PROCESS = "一括処理呼出に失敗しました";

  /**
   * 初期処理
   * 
   * @param action
   *            アクションクラス
   * @param rundata
   *            JetSpeedランデータ
   * @param context
   *            JetSpeedコンテキスト
   * @throws ALPageNotFoundException
   * @throws ALDBErrorException
   */
  @Override
  public void init(ALAction action, RunData rundata, Context context)
      throws ALPageNotFoundException, ALDBErrorException {
    super.init(action, rundata, context);

    // ログインユーザーID取得
    user_id = ALEipUtils.getUserId(rundata);
    // ログインユーザー名取得
    login_user_name = ALEipUtils.getUserFullName(user_id);
  }

  /**
   * Webメール一括処理レコード更新処理
   * 
   * @param rundata
   *            JetSpeedランデータ
   * @param context
   *            JetSpeedコンテキスト
   * @param msgList
   *            エラーメッセージリスト
   * @return 処理結果(正常：true、異常:false)
   * @see com.aimluck.eip.common.ALAbstractFormData#updateFormData(org.apache.turbine.util.RunData,
   *      org.apache.velocity.context.Context, java.util.ArrayList)
   */
  @Override
  protected boolean updateFormData(RunData rundata, Context context,
      List<String> msgList) {

    // Webメール一括処理レコード更新（退避ファイルダウンロード後の退避ファイル削除の場合
    AvzTMailBatch mailBatch = WebMailUtils.getAvzTMailBatchResultList(user_id);
    if (WebMailConsts.BATCH_TYPE_SAVE.equals(mailBatch.getType())) {
      // 処理種別を「フォルダ内削除」に変更
      mailBatch.setType(WebMailConsts.BATCH_TYPE_DELETE);
      // 処理ステータスを「一括処理中」に変更
      mailBatch.setStatus(WebMailConsts.BATCH_PROCESSING);
      // 更新日は処理開始日時の格納用に使用する
      // mailBatch.setUpdateDate(Calendar.getInstance().getTime());
      // 一括処理レコードを更新
      Database.commit();
    }

    // 「退避ファイルを削除する」
    Runnable runnable = null;
    try {
      runnable =
        new WebMailPackageProcessFolderDeleteThread(Database
          .createDataContext(Database.getDomainName()), user_id, true);
    } catch (Exception ex) {
      logger.error(ERROR_MESSAGE_ASYNCHRONOUS_PROCESS + login_user_name, ex);
      return false;
    }
    Thread thread = new Thread(runnable);
    thread.start();
    return true;
  }

  /**
   * 画面フィールド初期化
   * 
   * @see com.aimluck.eip.common.ALData#initField()
   */
  @Override
  public void initField() {
  }

  /**
   * バリデータ初期化
   * 
   * @see com.aimluck.eip.common.ALAbstractFormData#setValidator()
   */
  @Override
  protected void setValidator() {
  }

  /**
   * バリデーション
   * 
   * @param msgList
   *            エラーメッセージリスト
   * @return 処理結果(正常：true、異常:false)
   * @see com.aimluck.eip.common.ALAbstractFormData#validate(java.util.ArrayList)
   */
  @Override
  protected boolean validate(List<String> msgList) {
    return (msgList.size() == 0);
  }

  /**
   * 抽象クラスのloadFormDataメソッドをオーバライドする必要があるため、 処理がなくても記述する必要がある。
   * 
   * @param rundata
   *            JetSpeedランデータ
   * @param context
   *            JetSpeedコンテキスト
   * @param msgList
   *            エラーメッセージリスト
   * @return 処理結果(正常：true、異常:false)
   * @see com.aimluck.eip.common.ALAbstractFormData#loadFormData(org.apache.turbine.util.RunData,
   *      org.apache.velocity.context.Context, java.util.ArrayList)
   */
  @Override
  protected boolean loadFormData(RunData rundata, Context context,
      List<String> msgList) {
    return true;
  }

  /**
   * 抽象クラスのdeleteFormDataメソッドをオーバライドする必要があるため、 処理がなくても記述する必要がある。
   * 
   * @param rundata
   *            JetSpeedランデータ
   * @param context
   *            JetSpeedコンテキスト
   * @param msgList
   *            エラーメッセージリスト
   * @return 処理結果(正常：true、異常:false)
   * @see com.aimluck.eip.common.ALAbstractFormData#deleteFormData(org.apache.turbine.util.RunData,
   *      org.apache.velocity.context.Context, java.util.ArrayList)
   */
  @Override
  protected boolean deleteFormData(RunData rundata, Context context,
      List<String> msgList) {
    return true;
  }

  /**
   * 抽象クラスのinsertFormDataメソッドをオーバライドする必要があるため、 処理がなくても記述する必要がある。
   * 
   * @param rundata
   *            JetSpeedランデータ
   * @param context
   *            JetSpeedコンテキスト
   * @param msgList
   *            エラーメッセージリスト
   * @return 処理結果(正常：true、異常:false)
   * @see com.aimluck.eip.common.ALAbstractFormData#insertFormData(org.apache.turbine.util.RunData,
   *      org.apache.velocity.context.Context, java.util.ArrayList)
   */
  @Override
  protected boolean insertFormData(RunData rundata, Context context,
      List<String> msgList) throws ALDBErrorException {
    return true;
  }

}
