package aipo.webservice.soap.axis2.bean;

/*
 * Aipo is a groupware program developed by Aimluck,Inc.
 * Copyright (C) 2004-2011 Aimluck,Inc.
 * http://www.aipo.com
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

/**
 * <HR>
 * Outlookのスケジュール情報格納用Bean
 * <p>
 * 
 * Outlookのスケジュール情報格納用Beanクラス
 * <P>
 * <HR>
 * <P>
 * 
 */
public class OutlookScheduleBean {

  /** Outlookスケジュール公開フラグ：公開 */
  private static final String OUTLOOK_SCHEDULE_PUBLIC_FLAG_STANDARD = "0";

  /** スケジュール公開フラグ：公開 */
  private static final String EIP_T_SCHEDULE_PUBLIC_FLAG_OPEN = "O";

  /** スケジュール公開フラグ：非公開 */
  private static final String EIP_T_SCHEDULE_PUBLIC_FLAG_CLOSED = "C";

  /** スケジュールマップ状態：所有者 */
  private static final String EIP_T_SCHEDULE_MAP_STATUS_OWNER = "O";

  /** スケジュールマップ状態：共有メンバー（未回答） */
  private static final String EIP_T_SCHEDULE_MAP_STATUS_UNANSWERED = "T";

  /** スケジュールマップ状態：共有メンバー（仮承諾） */
  private static final String EIP_T_SCHEDULE_MAP_STATUS_PROVISIONAL = "P";

  /** スケジュールマップ状態：共有メンバー（承諾） */
  private static final String EIP_T_SCHEDULE_MAP_STATUS_CONSENT = "C";

  /** スケジュールマップ状態：共有メンバー（辞退） */
  private static final String EIP_T_SCHEDULE_MAP_STATUS_VETO = "V";

  /** スケジュールマップ必須フラグ：必須 */
  private static final String EIP_T_SCHEDULE_MAP_REQUIERED_REQUIERED = "R";

  /** スケジュールマップ必須フラグ：任意 */
  private static final String EIP_T_SCHEDULE_MAP_REQUIERED_SELECTABLE = "S";

  /** 件名 */
  private String subject;

  /** 場所 */
  private String location;

  /** 終日フラグ */
  private String allDayEvent;

  /** 内容 */
  private String body;

  /** 公開フラグ */
  private String sensitivity;

  /** 重要度 */
  private String importance;

  /** 繰り返し有無 */
  private String isRecurring;

  /** 繰り返しタイプ */
  private String recurrenceType;

  /** 開始時刻 */
  private String start;

  /** 終了時刻 */
  private String end;

  /** 開始日 */
  private String patternStartDate;

  /** 終了日有無 */
  private String noEndDate;

  /** 終了日 */
  private String patternEndDate;

  /** 頻度 */
  private String interval;

  /** 曜日 */
  private String dayOfWeekMask;

  /** 日付 */
  private String dayOfMonth;

  /** 月 */
  private String monthOfYear;

  /** N回目 */
  private String instance;

  /** 回数 */
  private String occurrences;

  /** 返信状況 */
  private String meetingStatus;

  /** 会議出席者のメールアドレス */
  private String[] recipientsAddress;

  /** 会議出席種類 */
  private String[] recipientsType;

  /** 会議出席依頼への返信 */
  private String[] meetingResponseStatus;

  /** 予定の作成者 */
  private String organizerName;

  /** 予定の作成者かどうか */
  private String isOrganizer;

  /**
   * 件名を取得します。
   * 
   * @return 件名
   */
  public String getSubject() {
    return subject;
  }

  /**
   * 件名を設定します。
   * 
   * @param subject
   *          件名
   */
  public void setSubject(String subject) {
    this.subject = subject;
  }

  /**
   * 場所を取得します。
   * 
   * @return 場所
   */
  public String getLocation() {
    return location;
  }

  /**
   * 場所を設定します。
   * 
   * @param location
   *          場所
   */
  public void setLocation(String location) {
    this.location = location;
  }

  /**
   * 終日フラグを取得します。
   * 
   * @return 終日フラグ
   */
  public String getAllDayEvent() {
    return allDayEvent;
  }

  /**
   * 終日フラグを設定します。
   * 
   * @param allDayEvent
   *          終日フラグ
   */
  public void setAllDayEvent(String allDayEvent) {
    this.allDayEvent = allDayEvent;
  }

  /**
   * 繰り返しタイプを取得します。
   * 
   * @return 繰り返しタイプ
   */
  public String getRecurrenceType() {
    return recurrenceType;
  }

  /**
   * 繰り返しタイプを設定します。
   * 
   * @param recurrenceType
   *          繰り返しタイプ
   */
  public void setRecurrenceType(String recurrenceType) {
    this.recurrenceType = recurrenceType;
  }

  /**
   * 内容を取得します。
   * 
   * @return 内容
   */
  public String getBody() {
    return body;
  }

  /**
   * 内容を設定します。
   * 
   * @param body
   *          内容
   */
  public void setBody(String body) {
    this.body = body;
  }

  /**
   * 開始時刻を取得します。
   * 
   * @return 開始時刻
   */
  public String getStart() {
    return start;
  }

  /**
   * 開始時刻を設定します。
   * 
   * @param start
   *          開始時刻
   */
  public void setStart(String start) {
    this.start = start;
  }

  /**
   * 重要度を取得します。
   * 
   * @return importance
   */
  public String getImportance() {
    return importance;
  }

  /**
   * 重要度を設定します。
   * 
   * @param importance
   *          セットする 重要度
   */
  public void setImportance(String importance) {
    this.importance = importance;
  }

  /**
   * 終了時刻を取得します。
   * 
   * @return 終了時刻
   */
  public String getEnd() {
    return end;
  }

  /**
   * 終了時刻を設定します。
   * 
   * @param end
   *          終了時刻
   */
  public void setEnd(String end) {
    this.end = end;
  }

  /**
   * 公開フラグを取得します。
   * 
   * @return 公開フラグ
   */
  public String getSensitivity() {
    return sensitivity;
  }

  /**
   * 公開フラグを設定します。
   * 
   * @param sensitivity
   *          公開フラグ
   */
  public void setSensitivity(String sensitivity) {
    this.sensitivity = sensitivity;
  }

  /**
   * 繰り返し有無を取得します。
   * 
   * @return 繰り返し有無
   */
  public String getIsRecurring() {
    return isRecurring;
  }

  /**
   * 繰り返し有無を設定します。
   * 
   * @param isRecurring
   *          セットする 繰り返し有無
   */
  public void setIsRecurring(String isRecurring) {
    this.isRecurring = isRecurring;
  }

  /**
   * 開始日を取得します。
   * 
   * @return 開始日
   */
  public String getPatternStartDate() {
    return patternStartDate;
  }

  /**
   * 開始日を設定します。
   * 
   * @param patternStartDate
   *          開始日
   */
  public void setPatternStartDate(String patternStartDate) {
    this.patternStartDate = patternStartDate;
  }

  /**
   * 終了日有無を取得します。
   * 
   * @return 終了日有無
   */
  public String getNoEndDate() {
    return noEndDate;
  }

  /**
   * 終了日有無を設定します。
   * 
   * @param noEndDate
   *          終了日有無
   */
  public void setNoEndDate(String noEndDate) {
    this.noEndDate = noEndDate;
  }

  /**
   * 終了日を取得します。
   * 
   * @return 終了日
   */
  public String getPatternEndDate() {
    return patternEndDate;
  }

  /**
   * 終了日を設定します。
   * 
   * @param patternEndDate
   *          終了日
   */
  public void setPatternEndDate(String patternEndDate) {
    this.patternEndDate = patternEndDate;
  }

  /**
   * 頻度を取得します。
   * 
   * @return 頻度
   */
  public String getInterval() {
    return interval;
  }

  /**
   * 頻度を設定します。
   * 
   * @param Stringerval
   *          頻度
   */
  public void setInterval(String interval) {
    this.interval = interval;
  }

  /**
   * 曜日を取得します。
   * 
   * @return 曜日
   */
  public String getDayOfWeekMask() {
    return dayOfWeekMask;
  }

  /**
   * 曜日を設定します。
   * 
   * @param dayOfWeekMask
   *          曜日
   */
  public void setDayOfWeekMask(String dayOfWeekMask) {
    this.dayOfWeekMask = dayOfWeekMask;
  }

  /**
   * 日付を取得します。
   * 
   * @return 日付
   */
  public String getDayOfMonth() {
    return dayOfMonth;
  }

  /**
   * 日付を設定します。
   * 
   * @param dayOfMonth
   *          日付
   */
  public void setDayOfMonth(String dayOfMonth) {
    this.dayOfMonth = dayOfMonth;
  }

  /**
   * 月を取得します。
   * 
   * @return 月
   */
  public String getMonthOfYear() {
    return monthOfYear;
  }

  /**
   * 月を設定します。
   * 
   * @param monthOfYear
   *          月
   */
  public void setMonthOfYear(String monthOfYear) {
    this.monthOfYear = monthOfYear;
  }

  /**
   * N回目を取得します。
   * 
   * @return N回目
   */
  public String getInstance() {
    return instance;
  }

  /**
   * N回目を設定します。
   * 
   * @param instance
   *          N回目
   */
  public void setInstance(String instance) {
    this.instance = instance;
  }

  /**
   * 回数を取得します。
   * 
   * @return 回数
   */
  public String getOccurrences() {
    return occurrences;
  }

  /**
   * 回数を設定します。
   * 
   * @param occurrences
   *          回数
   */
  public void setOccurrences(String occurrences) {
    this.occurrences = occurrences;
  }

  /**
   * 返信状況への返信を取得します。
   * 
   * @return meetingStatus
   */
  public String getMeetingStatus() {
    return meetingStatus;
  }

  /**
   * 返信状況を設定します。
   * 
   * @param meetingStatus
   *          セットする 返信状況
   */
  public void setMeetingStatus(String meetingStatus) {
    this.meetingStatus = meetingStatus;
  }

  /**
   * 会議出席者のメールアドレスを取得します。
   * 
   * @return recipientsAddress
   */
  public String[] getRecipientsAddress() {
    return recipientsAddress;
  }

  /**
   * 会議出席者のメールアドレスを設定します。
   * 
   * @param recipientsAddress
   *          セットする 会議出席者のメールアドレス
   */
  public void setRecipientsAddress(String[] recipientsAddress) {
    this.recipientsAddress = recipientsAddress;
  }

  /**
   * 会議出席種類を取得します。
   * 
   * @return requiredAttendees
   */
  public String[] getRecipientsType() {
    return recipientsType;
  }

  /**
   * 会議出席種類を設定します。
   * 
   * @param requiredAttendees
   *          セットする 会議出席種類
   */
  public void setRecipientsType(String recipientsType[]) {
    this.recipientsType = recipientsType;
  }

  /**
   * 会議出席依頼への返信を取得します。
   * 
   * @return meetingResponseStatus
   */
  public String[] getMeetingResponseStatus() {
    return meetingResponseStatus;
  }

  /**
   * 会議出席依頼への返信を設定します。
   * 
   * @param meetingResponseStatus
   *          セットする 会議出席依頼への返信
   */
  public void setMeetingResponseStatus(String[] meetingResponseStatus) {
    this.meetingResponseStatus = meetingResponseStatus;
  }

  /**
   * 予定の作成者名を取得します。
   * 
   * @return organizerName
   */
  public String getOrganizerName() {
    return organizerName;
  }

  /**
   * 予定の作成者名を設定します。
   * 
   * @param organizerName
   *          セットする 予定の作成者名
   */
  public void setOrganizerName(String organizerName) {
    this.organizerName = organizerName;
  }

  /**
   * 予定の作成者かどうかを取得します。
   * 
   * @return organizer
   */

  public String getIsOrganizer() {
    return isOrganizer;
  }

  /**
   * 予定の作成者かどうかを設定します。
   * 
   * @param organizer
   *          セットする 予定の作成者かどうか
   */
  public void setIsOrganizer(String organizer) {
    this.isOrganizer = organizer;
  }

  /**
   * スケジュールの公開フラグをコード変換する。
   * <p>
   * 標準の秘密度："0"⇒公開（全員に公開）："O" それ以外⇒"C"<br>
   * 
   * @param str
   *          文字列
   * @return String コード変換後の文字列
   */

  public String getPublicFlgString() {
    if (this.sensitivity == null) {
      return "";
    }
    // 0:標準の秘密度
    if (this.sensitivity.equals(OUTLOOK_SCHEDULE_PUBLIC_FLAG_STANDARD)) {
      // 公開
      return EIP_T_SCHEDULE_PUBLIC_FLAG_OPEN;
    }
    // 非公開
    return EIP_T_SCHEDULE_PUBLIC_FLAG_CLOSED;
  }

  /**
   * スケジュールマップの会議への返信状況をコード変換する。
   * <p>
   * 
   * @param meetingResponseStatus
   *          文字列
   * @return String コード変換後の文字列
   */

  public String getMeetingResponseStatusString(String meetingResponseStatus) {

    switch (Integer.parseInt(meetingResponseStatus)) {
      case 0: // 返信不要→共有メンバー（未回答）
        return EIP_T_SCHEDULE_MAP_STATUS_UNANSWERED;
      case 1: // 所有者→所有者
        return EIP_T_SCHEDULE_MAP_STATUS_OWNER;
      case 2: // 仮承諾→共有メンバー（仮承諾）
        return EIP_T_SCHEDULE_MAP_STATUS_PROVISIONAL;
      case 3: // 承諾→共有メンバー（承諾）
        return EIP_T_SCHEDULE_MAP_STATUS_CONSENT;
      case 4: // 辞退→共有メンバー（拒否）
        return EIP_T_SCHEDULE_MAP_STATUS_VETO;
      case 5: // 未返信→共有メンバー（未回答）
        return EIP_T_SCHEDULE_MAP_STATUS_UNANSWERED;
      default:
        return "";
    }
  }

  /**
   * スケジュールマップの受信者タイプをコード変換する。
   * <p>
   * 
   * @param str
   *          文字列
   * @return String コード変換後の文字列
   */

  public String getRecipientTypeString(int type) {
    if (type == 1) {
      return EIP_T_SCHEDULE_MAP_REQUIERED_REQUIERED;
    } else if (type == 2) {
      return EIP_T_SCHEDULE_MAP_REQUIERED_SELECTABLE;
    }
    return "";
  }

}
