/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.corba.receivers;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPFactory;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.corba.deployer.CorbaConstants;
import org.apache.axis2.corba.exceptions.CorbaException;
import org.apache.axis2.corba.exceptions.CorbaInvocationException;
import org.apache.axis2.corba.idl.IDLProcessor;
import org.apache.axis2.corba.idl.types.AbstractCollectionType;
import org.apache.axis2.corba.idl.types.ArrayType;
import org.apache.axis2.corba.idl.types.CompositeDataType;
import org.apache.axis2.corba.idl.types.DataType;
import org.apache.axis2.corba.idl.types.EnumType;
import org.apache.axis2.corba.idl.types.ExceptionType;
import org.apache.axis2.corba.idl.types.IDL;
import org.apache.axis2.corba.idl.types.Member;
import org.apache.axis2.corba.idl.types.PrimitiveDataType;
import org.apache.axis2.corba.idl.types.SequenceType;
import org.apache.axis2.corba.idl.types.Struct;
import org.apache.axis2.corba.idl.types.Typedef;
import org.apache.axis2.corba.idl.types.UnionMember;
import org.apache.axis2.corba.idl.types.UnionType;
import org.apache.axis2.corba.idl.types.ValueType;
import org.apache.axis2.corba.idl.values.AbstractCollectionValue;
import org.apache.axis2.corba.idl.values.AbstractValue;
import org.apache.axis2.corba.idl.values.AliasValue;
import org.apache.axis2.corba.idl.values.ArrayValue;
import org.apache.axis2.corba.idl.values.EnumValue;
import org.apache.axis2.corba.idl.values.ExceptionValue;
import org.apache.axis2.corba.idl.values.ObjectByValue;
import org.apache.axis2.corba.idl.values.SequenceValue;
import org.apache.axis2.corba.idl.values.StreamableValueFactory;
import org.apache.axis2.corba.idl.values.StructValue;
import org.apache.axis2.corba.idl.values.UnionValue;
import org.apache.axis2.corba.receivers.CorbaInvokerFactory;
import org.apache.axis2.corba.receivers.Invoker;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.description.java2wsdl.TypeTable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.omg.CORBA.Any;
import org.omg.CORBA.Object;
import org.omg.CORBA.TypeCode;
import org.omg.CORBA_2_3.ORB;
import org.omg.CORBA_2_3.portable.OutputStream;
import org.omg.CosNaming.NamingContextExt;
import org.omg.CosNaming.NamingContextExtHelper;
import org.omg.CosNaming.NamingContextPackage.CannotProceed;
import org.omg.CosNaming.NamingContextPackage.InvalidName;
import org.omg.CosNaming.NamingContextPackage.NotFound;

public class CorbaUtil
implements CorbaConstants {
    private static Map IDL_CACHE = new HashMap();
    private static final Log log = LogFactory.getLog((Class)CorbaUtil.class);

    public static ORB getORB(AxisService service) {
        Parameter orbClass = service.getParameter("orbClass");
        Parameter orbSingletonClass = service.getParameter("orbSingletonClass");
        Properties props = System.getProperties();
        if (orbClass != null) {
            props.put("org.omg.CORBA.ORBClass", orbClass.getValue());
        } else {
            props.put("org.omg.CORBA.ORBClass", "org.apache.yoko.orb.CORBA.ORB");
        }
        if (orbSingletonClass != null) {
            props.put("org.omg.CORBA.ORBSingletonClass", orbSingletonClass.getValue());
        } else {
            props.put("org.omg.CORBA.ORBSingletonClass", "org.apache.yoko.orb.CORBA.ORBSingleton");
        }
        return (ORB)ORB.init((String[])new String[0], (Properties)props);
    }

    public static Object resolveObject(AxisService service, ORB orb) throws CorbaInvocationException {
        Object obj;
        block8: {
            try {
                Parameter namingServiceUrl = service.getParameter("namingServiceUrl");
                Parameter objectName = service.getParameter("objectName");
                Parameter iorFilePath = service.getParameter("iorFilePath");
                Parameter iorString = service.getParameter("iorString");
                if (namingServiceUrl != null && objectName != null) {
                    obj = orb.string_to_object((String)namingServiceUrl.getValue());
                    NamingContextExt nc = NamingContextExtHelper.narrow((Object)obj);
                    obj = nc.resolve(nc.to_name((String)objectName.getValue()));
                    break block8;
                }
                if (iorFilePath != null) {
                    FileReader fileReader = new FileReader((String)iorFilePath.getValue());
                    char[] buf = new char[1000];
                    fileReader.read(buf);
                    obj = orb.string_to_object(new String(buf).trim());
                    break block8;
                }
                if (iorString != null) {
                    obj = orb.string_to_object((String)iorString.getValue());
                    break block8;
                }
                throw new CorbaInvocationException("cannot resolve object");
            }
            catch (NotFound notFound) {
                throw new CorbaInvocationException("cannot resolve object", notFound);
            }
            catch (CannotProceed cannotProceed) {
                throw new CorbaInvocationException("cannot resolve object", cannotProceed);
            }
            catch (InvalidName invalidName) {
                throw new CorbaInvocationException("cannot resolve object", invalidName);
            }
            catch (IOException e) {
                throw new CorbaInvocationException("cannot resolve object", e);
            }
        }
        return obj;
    }

    public static IDL getIDL(AxisService service, ORB orb, String dirName) throws CorbaException {
        Map types;
        Parameter idlFile = service.getParameter("idlFile");
        String idlFileName = (String)idlFile.getValue();
        String cacheKey = dirName + File.separator + idlFileName;
        IDL idl = (IDL)IDL_CACHE.get(cacheKey);
        if (idl == null) {
            try {
                InputStream stream;
                File file = new File(dirName);
                if (file.isDirectory()) {
                    stream = new FileInputStream(cacheKey);
                } else {
                    ZipEntry entry;
                    ZipInputStream zin = new ZipInputStream(new FileInputStream(file));
                    boolean found = false;
                    while ((entry = zin.getNextEntry()) != null) {
                        if (!entry.getName().equalsIgnoreCase(idlFileName)) continue;
                        found = true;
                        break;
                    }
                    if (!found) {
                        new CorbaInvocationException("cannot find " + idlFileName + " in " + file.getPath());
                    }
                    stream = zin;
                }
                IDLProcessor idlProcessor = new IDLProcessor(stream);
                idl = idlProcessor.process();
                ((InputStream)stream).close();
                IDL_CACHE.put(cacheKey, idl);
            }
            catch (IOException e) {
                throw new CorbaInvocationException("cannot process idl file", e);
            }
        }
        if ((types = idl.getCompositeDataTypes()) != null) {
            Iterator iter = types.values().iterator();
            while (iter.hasNext()) {
                DataType type = (DataType)iter.next();
                if (!(type instanceof ValueType)) continue;
                StreamableValueFactory.register(orb, (ValueType)type);
            }
        }
        return idl;
    }

    public static Invoker getInvoker(AxisService service, Object obj, IDL idl, String methodName) throws CorbaInvocationException {
        CorbaInvokerFactory invokerFactory = new CorbaInvokerFactory(idl);
        Parameter interfaceName = service.getParameter("interfaceName");
        if (interfaceName == null) {
            throw new CorbaInvocationException("interfaceName cannot be null");
        }
        return invokerFactory.newInvoker((String)interfaceName.getValue(), methodName, obj);
    }

    public static java.lang.Object[] extractParameters(OMElement methodElement, Member[] parameterMembers) throws CorbaInvocationException {
        if (parameterMembers == null) {
            return new java.lang.Object[0];
        }
        java.lang.Object[] retObjs = new java.lang.Object[parameterMembers.length];
        if (methodElement == null) {
            return retObjs;
        }
        Iterator paramsIter = methodElement.getChildElements();
        HashMap paramsMap = new HashMap();
        while (paramsIter != null && paramsIter.hasNext()) {
            OMElement param = (OMElement)paramsIter.next();
            String localName = param.getLocalName();
            if (paramsMap.containsKey(localName)) {
                java.lang.Object value = paramsMap.get(localName);
                if (value instanceof List) {
                    ((List)value).add(param);
                    continue;
                }
                ArrayList<java.lang.Object> valueList = new ArrayList<java.lang.Object>();
                valueList.add(value);
                valueList.add(param);
                paramsMap.put(localName, valueList);
                continue;
            }
            paramsMap.put(localName, param);
        }
        for (int i = 0; i < parameterMembers.length; ++i) {
            String paramName = parameterMembers[i].getName();
            retObjs[i] = CorbaUtil.extractValue(parameterMembers[i].getDataType(), paramsMap.get(paramName));
        }
        return retObjs;
    }

    private static java.lang.Object extractValue(DataType dataType, java.lang.Object param) throws CorbaInvocationException {
        if (dataType instanceof Typedef) {
            Typedef typedef = (Typedef)dataType;
            AliasValue aliasValue = new AliasValue(typedef);
            if (!(param instanceof OMElement)) {
                return null;
            }
            OMElement paramElement = (OMElement)param;
            DataType aliasType = typedef.getDataType();
            if (!(aliasType instanceof AbstractCollectionType || (paramElement = paramElement.getFirstElement()) != null && "item".equals(paramElement.getLocalName()))) {
                return null;
            }
            aliasValue.setValue(CorbaUtil.extractValue(aliasType, paramElement));
            return aliasValue;
        }
        if (dataType instanceof PrimitiveDataType) {
            if (param != null) {
                return CorbaUtil.parseValue(dataType, ((OMElement)param).getText());
            }
        } else {
            if (dataType instanceof AbstractCollectionType) {
                AbstractCollectionValue collectionValue;
                AbstractCollectionType collectionType = (AbstractCollectionType)dataType;
                if (!(param instanceof OMElement)) {
                    return null;
                }
                OMElement paramElement = (OMElement)param;
                Iterator paramsIter = paramElement.getChildElements();
                ArrayList<java.lang.Object> children = new ArrayList<java.lang.Object>();
                while (paramsIter.hasNext()) {
                    children.add(CorbaUtil.extractValue(collectionType.getDataType(), paramsIter.next()));
                }
                if (collectionType.isArray()) {
                    collectionValue = new ArrayValue((ArrayType)collectionType);
                } else if (collectionType.isSequence()) {
                    collectionValue = new SequenceValue((SequenceType)collectionType);
                } else {
                    return null;
                }
                collectionValue.setValues(children.toArray());
                return collectionValue;
            }
            if (dataType instanceof EnumType) {
                EnumType enumType = (EnumType)dataType;
                String enumText = ((OMElement)param).getText();
                int index = enumType.getEnumMembers().indexOf(enumText);
                if (index >= 0) {
                    EnumValue enumValue = new EnumValue(enumType);
                    enumValue.setValue(index);
                    return enumValue;
                }
            } else {
                if (dataType instanceof UnionType) {
                    UnionType unionType = (UnionType)dataType;
                    OMElement unElement = ((OMElement)param).getFirstElement();
                    String unionMemberName = unElement.getLocalName();
                    UnionValue unionValue = new UnionValue(unionType);
                    unionValue.setMemberName(unionMemberName);
                    Member[] members = unionType.getMembers();
                    UnionMember member = null;
                    for (int i = 0; i < members.length && !(member = (UnionMember)members[i]).getName().equals(unionMemberName); ++i) {
                    }
                    if (member != null) {
                        unionValue.setMemberValue(CorbaUtil.extractValue(member.getDataType(), unElement));
                    }
                    return unionValue;
                }
                if (dataType instanceof CompositeDataType) {
                    AbstractValue value;
                    CompositeDataType compositeType = (CompositeDataType)dataType;
                    Member[] compositeMembers = compositeType.getMembers();
                    java.lang.Object[] compositeValues = CorbaUtil.extractParameters((OMElement)param, compositeMembers);
                    if (compositeType instanceof ValueType) {
                        value = new ObjectByValue((ValueType)compositeType);
                    } else if (compositeType instanceof Struct) {
                        value = new StructValue((Struct)compositeType);
                    } else {
                        throw new CorbaInvocationException("Parameter type not supported");
                    }
                    value.setMemberValues(compositeValues);
                    return value;
                }
            }
        }
        return null;
    }

    public static void processResponse(java.lang.Object resObject, Member[] params, java.lang.Object[] outParamValues, DataType dataType, AxisService service, String methodName, SOAPFactory fac, String messageNameSpace, MessageContext outMessage) throws AxisFault {
        boolean qualified = service.isElementFormDefault();
        OMNamespace ns = fac.createOMNamespace(messageNameSpace, service.getSchemaTargetNamespacePrefix());
        OMElement bodyContent = fac.createOMElement(methodName + "Response", ns);
        OMElement child = qualified ? fac.createOMElement("return", ns) : fac.createOMElement("return", null);
        bodyContent.addChild((OMNode)child);
        if (dataType != null && !CorbaUtil.getQualifiedName(dataType).equals("void") && resObject != null) {
            CorbaUtil.processResponse(child, bodyContent, resObject, dataType, fac, ns, qualified, service);
        } else {
            child.addAttribute("nil", "true", fac.createOMNamespace("http://www.w3.org/2001/XMLSchema-instance", "xsi"));
        }
        List<java.lang.Object> outParamList = Arrays.asList(outParamValues);
        Iterator<java.lang.Object> paramsIter = outParamList.iterator();
        for (int i = 0; i < params.length; ++i) {
            Member param = params[i];
            if (!"inout".equals(param.getMode()) && !"out".equals(param.getMode())) continue;
            child = qualified ? fac.createOMElement(param.getName(), ns) : fac.createOMElement(param.getName(), null);
            bodyContent.addChild((OMNode)child);
            CorbaUtil.processResponse(child, bodyContent, paramsIter.next(), param.getDataType(), fac, ns, qualified, service);
        }
        SOAPEnvelope envelope = fac.getDefaultEnvelope();
        envelope.getBody().addChild((OMNode)bodyContent);
        outMessage.setEnvelope(envelope);
    }

    private static void processResponse(OMElement child, OMElement bodyContent, java.lang.Object resObject, DataType dataType, SOAPFactory fac, OMNamespace defaultNS, boolean qualified, AxisService service) {
        if (dataType instanceof PrimitiveDataType) {
            child.addChild((OMNode)fac.createOMText((OMContainer)child, resObject.toString()));
        } else if (dataType instanceof Typedef) {
            Typedef typedef = (Typedef)dataType;
            AliasValue aliasValue = (AliasValue)resObject;
            OMNamespace ns = CorbaUtil.getNameSpaceForType(fac, service, typedef);
            OMElement item = fac.createOMElement("item", ns, (OMContainer)child);
            CorbaUtil.processResponse(item, child, aliasValue.getValue(), typedef.getDataType(), fac, ns, qualified, service);
        } else if (dataType instanceof AbstractCollectionType) {
            AbstractCollectionType collectionType = (AbstractCollectionType)dataType;
            AbstractCollectionValue collectionValue = (AbstractCollectionValue)resObject;
            java.lang.Object[] values = collectionValue.getValues();
            int length = values.length;
            for (int i = 0; i < length; ++i) {
                OMElement outer = bodyContent;
                if (collectionType.getDataType() instanceof AbstractCollectionType) {
                    outer = child;
                    child = qualified ? fac.createOMElement("item", defaultNS) : fac.createOMElement("item", null);
                    outer.addChild((OMNode)child);
                }
                CorbaUtil.processResponse(child, outer, values[i], collectionType.getDataType(), fac, defaultNS, qualified, service);
                if (i >= length - 1) continue;
                child = qualified ? fac.createOMElement("item", defaultNS) : fac.createOMElement("item", null);
                bodyContent.addChild((OMNode)child);
            }
        } else if (dataType instanceof ValueType || dataType instanceof Struct) {
            AbstractValue resValue = (AbstractValue)resObject;
            Member[] members = resValue.getMembers();
            java.lang.Object[] memberValues = resValue.getMemberValues();
            OMNamespace ns = CorbaUtil.getNameSpaceForType(fac, service, (CompositeDataType)dataType);
            for (int i = 0; i < memberValues.length; ++i) {
                OMElement memberElement = fac.createOMElement(members[i].getName(), ns);
                CorbaUtil.processResponse(memberElement, bodyContent, memberValues[i], members[i].getDataType(), fac, ns, qualified, service);
                child.addChild((OMNode)memberElement);
            }
        } else if (dataType instanceof UnionType) {
            UnionValue unionValue = (UnionValue)resObject;
            OMNamespace ns = CorbaUtil.getNameSpaceForType(fac, service, (CompositeDataType)dataType);
            OMElement unMember = qualified ? fac.createOMElement(unionValue.getMemberName(), ns) : fac.createOMElement(unionValue.getMemberName(), null);
            CorbaUtil.processResponse(unMember, child, unionValue.getMemberValue(), unionValue.getMemberType(), fac, ns, qualified, service);
            child.addChild((OMNode)unMember);
        } else if (dataType instanceof EnumType) {
            EnumValue enumValue = (EnumValue)resObject;
            child.addChild((OMNode)fac.createOMText((OMContainer)child, enumValue.getValueAsString()));
        }
    }

    private static OMNamespace getNameSpaceForType(SOAPFactory fac, AxisService service, CompositeDataType dataType) {
        TypeTable typeTable = service.getTypeTable();
        String fullname = dataType.getModule() != null ? dataType.getModule() + dataType.getName() : dataType.getName();
        QName qname = typeTable.getQNamefortheType(fullname = fullname.replaceAll("::", "."));
        if (qname == null) {
            return null;
        }
        return fac.createOMNamespace(qname.getNamespaceURI(), qname.getPrefix());
    }

    public static String getQualifiedName(DataType type) {
        if (type instanceof CompositeDataType) {
            CompositeDataType compositeType = (CompositeDataType)type;
            String module = compositeType.getModule();
            module = module == null ? "" : module.replaceAll("::", ".");
            return module + compositeType.getName();
        }
        if (type instanceof PrimitiveDataType) {
            PrimitiveDataType primitiveDataType = (PrimitiveDataType)type;
            return primitiveDataType.getTypeName();
        }
        return null;
    }

    public static void insertValue(Any arg, DataType type, java.lang.Object value) {
        switch (type.getTypeCode().kind().value()) {
            case 3: {
                arg.insert_long(((Integer)value).intValue());
                break;
            }
            case 5: {
                arg.insert_ulong(((Integer)value).intValue());
                break;
            }
            case 23: {
                arg.insert_longlong(((Long)value).longValue());
                break;
            }
            case 24: {
                arg.insert_ulonglong(((Long)value).longValue());
                break;
            }
            case 2: {
                arg.insert_short(((Short)value).shortValue());
                break;
            }
            case 4: {
                arg.insert_ushort(((Short)value).shortValue());
                break;
            }
            case 6: {
                arg.insert_float(((Float)value).floatValue());
                break;
            }
            case 7: {
                arg.insert_double((double)((Double)value).floatValue());
                break;
            }
            case 9: {
                arg.insert_char(((Character)value).charValue());
                break;
            }
            case 26: {
                arg.insert_wchar(((Character)value).charValue());
                break;
            }
            case 8: {
                arg.insert_boolean(((Boolean)value).booleanValue());
                break;
            }
            case 10: {
                arg.insert_octet(((Byte)value).byteValue());
                break;
            }
            case 18: {
                arg.insert_string((String)value);
                break;
            }
            case 27: {
                arg.insert_wstring((String)value);
                break;
            }
            case 11: {
                arg.insert_any((Any)value);
                break;
            }
            case 29: {
                arg.insert_Value((Serializable)value);
                break;
            }
            case 14: {
                arg.insert_Object((Object)value);
                break;
            }
            case 15: {
                StructValue structValue = (StructValue)value;
                OutputStream outputStream = (OutputStream)arg.create_output_stream();
                arg.type(structValue.getTypeCode());
                structValue.write(outputStream);
                arg.read_value(outputStream.create_input_stream(), structValue.getTypeCode());
                break;
            }
            case 17: {
                EnumValue enumValue = (EnumValue)value;
                OutputStream outputStream = (OutputStream)arg.create_output_stream();
                arg.type(enumValue.getTypeCode());
                enumValue.write(outputStream);
                arg.read_value(outputStream.create_input_stream(), enumValue.getTypeCode());
                break;
            }
            case 16: {
                UnionValue unionValue = (UnionValue)value;
                OutputStream outputStream = (OutputStream)arg.create_output_stream();
                arg.type(unionValue.getTypeCode());
                unionValue.write(outputStream);
                arg.read_value(outputStream.create_input_stream(), unionValue.getTypeCode());
                break;
            }
            case 21: {
                AliasValue aliasValue = (AliasValue)value;
                OutputStream outputStream = (OutputStream)arg.create_output_stream();
                arg.type(aliasValue.getTypeCode());
                aliasValue.write(outputStream);
                arg.read_value(outputStream.create_input_stream(), aliasValue.getTypeCode());
                break;
            }
            case 19: {
                SequenceValue sequenceValue = (SequenceValue)value;
                OutputStream outputStream = (OutputStream)arg.create_output_stream();
                arg.type(sequenceValue.getTypeCode());
                sequenceValue.write(outputStream);
                arg.read_value(outputStream.create_input_stream(), sequenceValue.getTypeCode());
                break;
            }
            case 20: {
                ArrayValue arrayValue = (ArrayValue)value;
                OutputStream outputStream = (OutputStream)arg.create_output_stream();
                arg.type(arrayValue.getTypeCode());
                arrayValue.write(outputStream);
                arg.read_value(outputStream.create_input_stream(), arrayValue.getTypeCode());
                break;
            }
            default: {
                log.error((java.lang.Object)"ERROR! Invalid dataType");
            }
        }
    }

    public static java.lang.Object extractValue(DataType returnType, Any returned) {
        java.lang.Object returnValue = null;
        TypeCode typeCode = returnType.getTypeCode();
        switch (typeCode.kind().value()) {
            case 1: {
                returnValue = null;
                break;
            }
            case 3: {
                returnValue = new Integer(returned.extract_long());
                break;
            }
            case 5: {
                returnValue = new Integer(returned.extract_ulong());
                break;
            }
            case 23: {
                returnValue = new Long(returned.extract_longlong());
                break;
            }
            case 24: {
                returnValue = new Long(returned.extract_ulonglong());
                break;
            }
            case 2: {
                returnValue = new Short(returned.extract_short());
                break;
            }
            case 4: {
                returnValue = new Short(returned.extract_ushort());
                break;
            }
            case 6: {
                returnValue = new Float(returned.extract_float());
                break;
            }
            case 7: {
                returnValue = new Double(returned.extract_double());
                break;
            }
            case 9: {
                returnValue = new Character(returned.extract_char());
                break;
            }
            case 26: {
                returnValue = new Character(returned.extract_wchar());
                break;
            }
            case 8: {
                returnValue = returned.extract_boolean();
                break;
            }
            case 10: {
                returnValue = new Byte(returned.extract_octet());
                break;
            }
            case 18: {
                returnValue = returned.extract_string();
                break;
            }
            case 27: {
                returnValue = returned.extract_wstring();
                break;
            }
            case 11: {
                returnValue = returned.extract_any();
                break;
            }
            case 29: {
                returnValue = returned.extract_Value();
                break;
            }
            case 14: {
                returnValue = returned.extract_Object();
                break;
            }
            case 15: {
                Struct struct = (Struct)returnType;
                StructValue structValue = new StructValue(struct);
                org.omg.CORBA_2_3.portable.InputStream inputStream = (org.omg.CORBA_2_3.portable.InputStream)returned.create_input_stream();
                structValue.read(inputStream);
                returnValue = structValue;
                break;
            }
            case 22: {
                ExceptionType exceptionType = (ExceptionType)returnType;
                ExceptionValue exceptionValue = new ExceptionValue(exceptionType);
                org.omg.CORBA_2_3.portable.InputStream inputStream = (org.omg.CORBA_2_3.portable.InputStream)returned.create_input_stream();
                exceptionValue.read(inputStream);
                returnValue = exceptionValue;
                break;
            }
            case 17: {
                EnumType enumType = (EnumType)returnType;
                EnumValue enumValue = new EnumValue(enumType);
                org.omg.CORBA_2_3.portable.InputStream inputStream = (org.omg.CORBA_2_3.portable.InputStream)returned.create_input_stream();
                enumValue.read(inputStream);
                returnValue = enumValue;
                break;
            }
            case 16: {
                UnionType unionType = (UnionType)returnType;
                org.omg.CORBA_2_3.portable.InputStream inputStream = (org.omg.CORBA_2_3.portable.InputStream)returned.create_input_stream();
                UnionValue unionValue = new UnionValue(unionType);
                unionValue.read(inputStream);
                returnValue = unionValue;
                break;
            }
            case 21: {
                Typedef typedef = (Typedef)returnType;
                org.omg.CORBA_2_3.portable.InputStream inputStream = (org.omg.CORBA_2_3.portable.InputStream)returned.create_input_stream();
                AliasValue aliasValue = new AliasValue(typedef);
                aliasValue.read(inputStream);
                returnValue = aliasValue;
                break;
            }
            case 19: {
                SequenceType sequenceType = (SequenceType)returnType;
                org.omg.CORBA_2_3.portable.InputStream inputStream = (org.omg.CORBA_2_3.portable.InputStream)returned.create_input_stream();
                SequenceValue sequenceValue = new SequenceValue(sequenceType);
                sequenceValue.read(inputStream);
                returnValue = sequenceValue;
                break;
            }
            case 20: {
                ArrayType arrayType = (ArrayType)returnType;
                org.omg.CORBA_2_3.portable.InputStream inputStream = (org.omg.CORBA_2_3.portable.InputStream)returned.create_input_stream();
                ArrayValue arrayValue = new ArrayValue(arrayType);
                arrayValue.read(inputStream);
                returnValue = arrayValue;
                break;
            }
            default: {
                log.error((java.lang.Object)"ERROR! Invalid dataType");
            }
        }
        return returnValue;
    }

    public static java.lang.Object parseValue(DataType type, String value) {
        if (value == null) {
            return null;
        }
        value = value.trim();
        java.lang.Object ret = null;
        switch (type.getTypeCode().kind().value()) {
            case 3: {
                ret = Integer.valueOf(value);
                break;
            }
            case 5: {
                ret = Integer.valueOf(value);
                break;
            }
            case 23: {
                ret = Long.valueOf(value);
                break;
            }
            case 24: {
                ret = Long.valueOf(value);
                break;
            }
            case 2: {
                ret = Short.valueOf(value);
                break;
            }
            case 4: {
                ret = Short.valueOf(value);
                break;
            }
            case 6: {
                ret = Float.valueOf(value);
                break;
            }
            case 7: {
                ret = Double.valueOf(value);
                break;
            }
            case 9: {
                ret = Character.valueOf(value.charAt(0));
                break;
            }
            case 26: {
                ret = Character.valueOf(value.charAt(0));
                break;
            }
            case 8: {
                ret = Boolean.valueOf(value);
                break;
            }
            case 10: {
                ret = Byte.valueOf(value);
                break;
            }
            case 18: {
                ret = value;
                break;
            }
            case 27: {
                ret = value;
                break;
            }
            case 17: {
                EnumType enumType = (EnumType)type;
                EnumValue enumValue = new EnumValue(enumType);
                int i = enumType.getEnumMembers().indexOf(value);
                enumValue.setValue(i);
                ret = enumValue;
                break;
            }
            default: {
                log.error((java.lang.Object)"ERROR! Invalid dataType");
            }
        }
        return ret;
    }

    public static java.lang.Object getEmptyValue(DataType type) {
        switch (type.getTypeCode().kind().value()) {
            case 3: {
                return new Integer(0);
            }
            case 5: {
                return new Integer(0);
            }
            case 23: {
                return new Long(0L);
            }
            case 24: {
                return new Long(0L);
            }
            case 2: {
                return new Short("0");
            }
            case 4: {
                return new Short("0");
            }
            case 6: {
                return new Float(0.0f);
            }
            case 7: {
                return new Double(0.0);
            }
            case 9: {
                return new Character('0');
            }
            case 26: {
                return new Character('0');
            }
            case 8: {
                return Boolean.FALSE;
            }
            case 10: {
                return new Byte("0");
            }
            case 18: {
                return "";
            }
            case 27: {
                return "";
            }
            case 29: {
                return "";
            }
            case 15: {
                return new StructValue((Struct)type);
            }
            case 17: {
                return new EnumValue((EnumType)type);
            }
            case 16: {
                return new UnionValue((UnionType)type);
            }
            case 21: {
                return new AliasValue((Typedef)type);
            }
            case 19: {
                return new SequenceValue((SequenceType)type);
            }
            case 20: {
                return new ArrayValue((ArrayType)type);
            }
        }
        log.error((java.lang.Object)"ERROR! Invalid dataType");
        return null;
    }
}

