/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.jaxws.dispatchers;

import java.util.ArrayList;
import java.util.Iterator;
import javax.xml.namespace.QName;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPHeaderBlock;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.AxisDescription;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.Parameter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MustUnderstandUtils {
    private static final Log log = LogFactory.getLog(MustUnderstandUtils.class);

    public static void markUnderstoodHeaderParameters(MessageContext msgContext) {
        if (msgContext == null) {
            return;
        }
        SOAPEnvelope envelope = msgContext.getEnvelope();
        if (envelope.getHeader() == null) {
            return;
        }
        ArrayList understoodHeaderQNames = MustUnderstandUtils.getHeaderParamaterList(msgContext);
        if (understoodHeaderQNames == null) {
            return;
        }
        Iterator headerBlocks = envelope.getHeader().getHeadersToProcess(null);
        while (headerBlocks.hasNext()) {
            SOAPHeaderBlock headerBlock = (SOAPHeaderBlock)headerBlocks.next();
            QName headerQN = headerBlock.getQName();
            if (!understoodHeaderQNames.contains(headerQN)) continue;
            headerBlock.setProcessed();
            if (!log.isDebugEnabled()) continue;
            log.debug((Object)("Header marked as processed by JAXWS MustUnderstandChecker: " + headerQN));
        }
    }

    public static ArrayList getHeaderParamaterList(MessageContext msgContext) {
        ArrayList returnList = new ArrayList();
        AxisService axisService = msgContext.getAxisService();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Building list of understood headers for all operations under " + axisService));
        }
        if (axisService != null) {
            ArrayList understoodHeaders;
            Iterator operationIterator = axisService.getOperations();
            if (operationIterator != null) {
                while (operationIterator.hasNext()) {
                    AxisOperation operation = (AxisOperation)operationIterator.next();
                    understoodHeaders = MustUnderstandUtils.getSEIMethodHeaderParameterList(operation);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Adding headers from operation " + operation + "; headers = " + understoodHeaders));
                    }
                    if (understoodHeaders == null || understoodHeaders.isEmpty()) continue;
                    returnList.addAll(understoodHeaders);
                }
            }
            understoodHeaders = MustUnderstandUtils.getHandlersHeaderParameterList(axisService);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Adding headers from SOAP handlers; headers = " + understoodHeaders));
            }
            if (understoodHeaders != null && !understoodHeaders.isEmpty()) {
                returnList.addAll(understoodHeaders);
            }
        }
        return returnList;
    }

    public static ArrayList getSEIMethodHeaderParameterList(AxisOperation axisOperation) {
        return MustUnderstandUtils.getHeaderParameterList((AxisDescription)axisOperation, "org.apache.axis2.jaxws.description.OperationDescription.headerParameterQNames");
    }

    public static ArrayList getHandlersHeaderParameterList(AxisService axisService) {
        return MustUnderstandUtils.getHeaderParameterList((AxisDescription)axisService, "org.apache.axis2.jaxws.description.EndpointDescription.handlerParameterQNames");
    }

    private static ArrayList getHeaderParameterList(AxisDescription axisDescription, String paramName) {
        Parameter headerQNamesParameter = axisDescription.getParameter(paramName);
        if (headerQNamesParameter == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Parameter not on " + axisDescription + "; " + paramName));
            }
            return null;
        }
        ArrayList understoodHeaderQNames = (ArrayList)headerQNamesParameter.getValue();
        if (understoodHeaderQNames == null || understoodHeaderQNames.isEmpty()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Parameter value is empty: " + axisDescription + "; " + paramName));
            }
            return null;
        }
        return understoodHeaderQNames;
    }
}

