/*
 * Aipo is a groupware program developed by Aimluck,Inc.
 * Copyright (C) 2004-2011 Aimluck,Inc.
 * http://www.aipo.com
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.aimluck.eip.filter;

import java.io.IOException;

import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.conf.Configuration;
import org.apache.cayenne.conf.ServletUtil;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.jetspeed.services.resources.JetspeedResources;

import com.aimluck.eip.http.HttpServletRequestLocator;
import com.aimluck.eip.http.HttpServletResponseLocator;
import com.aimluck.eip.http.ServletContextLocator;
import com.aimluck.eip.orm.Database;

/**
 * 
 */
public class ALBaseFilter implements Filter {

  private static final JetspeedLogger logger =
    JetspeedLogFactoryService.getLogger(ALBaseFilter.class.getName());

  private FilterConfig filterConfig;

  /**
   * 
   */
  @Override
  public void destroy() {
  }

  /**
   * @param request
   * @param response
   * @param filterChain
   * @throws IOException
   * @throws ServletException
   */
  @Override
  public void doFilter(ServletRequest request, ServletResponse response,
      FilterChain filterChain) throws IOException, ServletException {
    ServletContext prevServletContext = ServletContextLocator.get();
    HttpServletRequest prevHttpServletRequest = HttpServletRequestLocator.get();
    HttpServletResponse prevHttpServletResponse =
      HttpServletResponseLocator.get();
    try {
      DataContext dataContext = null;
      try {
        dataContext =
          Database.createDataContext(getCurrentOrgId(
            (HttpServletRequest) request,
            (HttpServletResponse) response));
      } catch (Exception e) {
        logger.error(e, e);
      }

      // add start
      boolean do_performance_test =
        JetspeedResources.getBoolean("aipo.do_performance_test", false);
      boolean outputPerformanceLog = false;
      String displayString = null;
      if (do_performance_test) {
        String mode = ((HttpServletRequest) request).getParameter("mode");
        // if (mode == null) {
        // mode = "";
        // }
        // displayString =
        // getLoginName(request)
        // + ((HttpServletRequest) request).getRequestURI()
        // + "?"
        // + ((HttpServletRequest) request).getQueryString()
        // + " mode:"
        // + mode;
        displayString =
          ((HttpServletRequest) request).getRequestURI()
            + "?"
            + ((HttpServletRequest) request).getQueryString()
            + " mode:"
            + mode;
        logger.info("【開始】" + displayString);
        outputPerformanceLog = true;

        // Enumeration<?> names = request.getParameterNames();
        // while (names.hasMoreElements()) {
        //
        // String name = (String) names.nextElement();
        // if ("template".equals(name)) {
        // if ("ScheduleWeeklyJSONScreen".equals(request.getParameter(name))) {
        // logger.info("カレンダー表示処理開始" + getLoginName(request));
        // outputPerformanceLog = true;
        // break;
        // } else if ("ScheduleFormJSONScreen".equals(request
        // .getParameter(name))
        // && "insert".equals(request.getParameter("mode"))) {
        // logger.info("スケジュール追加処理開始" + getLoginName(request));
        // outputPerformanceLog = true;
        // }
        // } else if ("action".equals(name)) {
        // if ("ALJLoginUser".equals(request.getParameter(name))) {
        // logger.info("ログイン処理開始"
        // + "【"
        // + request.getParameter("username")
        // + "】");
        //
        // outputPerformanceLog = true;
        // }
        // }
        // if (outputPerformanceLog) {
        // break;
        // }
        // }
      }
      // add end

      ServletContextLocator.set(filterConfig.getServletContext());
      HttpServletRequestLocator.set((HttpServletRequest) request);
      HttpServletResponseLocator.set((HttpServletResponse) response);
      DataContext.bindThreadDataContext(dataContext);
      filterChain.doFilter(request, response);

      // add start
      if (outputPerformanceLog) {
        logger.info("【終了】" + displayString);
      }
      // add end
    } finally {
      ServletContextLocator.set(prevServletContext);
      HttpServletRequestLocator.set(prevHttpServletRequest);
      HttpServletResponseLocator.set(prevHttpServletResponse);
      Database.tearDown();
    }
  }

  /**
   * @param filterConfig
   * @throws ServletException
   */
  @Override
  public void init(FilterConfig filterConfig) throws ServletException {
    this.filterConfig = filterConfig;
    Configuration.configureCommonLogging(null);
    ServletUtil.initializeSharedConfiguration(filterConfig.getServletContext());
    Database.initialize(filterConfig.getServletContext());
  }

  protected String getCurrentOrgId(HttpServletRequest request,
      HttpServletResponse response) {
    return Database.DEFAULT_ORG;
  }

  // add start
  /**
   * リクエストURLからログイン名を取得する
   * 
   * @param request
   *            サーブレットリクエスト
   * @return ログイン名
   */
  private String getLoginName(ServletRequest request) {
    String login_name =
      ((HttpServletRequest) request).getRequestURL().toString();
    int index = login_name.indexOf("/user/");
    if (index < 0) {
      return "";
    }

    login_name = login_name.substring(login_name.indexOf("/user/") + 6);
    login_name = login_name.substring(0, login_name.indexOf("/"));
    return "【" + login_name + "】";
  }
  // add end
}
