/*
 * Aipo is a groupware program developed by Aimluck,Inc.
 * http://aipostyle.com/
 * 
 * Copyright(C) 2010 avanza Co.,Ltd. All rights reserved.
 * http://www.avnz.co.jp/
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */
package com.aimluck.eip.mail;

import java.util.ArrayList;
import java.util.List;

import com.aimluck.commons.field.ALStringField;

/**
 * 文書管理のフォルダ階層の情報を表すクラス．
 * 
 */
public class ALExtFolderInfo implements Cloneable {

  private List<ALExtFolderInfo> colist = null;

  /** フォルダ階層のインデックス番号 */
  private int index = -1;

  /** フォルダ名 */
  private ALStringField folder_name = null;

  /** 表示用フォルダ名（標準画面のプルダウンでのみ使用する） */
  private ALStringField folder_name_display = null;

  /** フォルダ ID */
  private int folder_id = -1;

  /** 親フォルダ ID */
  private int parent_folder_id = -1;

  private boolean visible = true;

  /** 権限的に可視であるか */
  private boolean authorized_visible = true;

  private boolean opened = false;

  /** 登録者名 */
  private int create_user_id;

  public ALExtFolderInfo() {
    folder_name = new ALStringField();
    folder_name_display = new ALStringField();
    colist = new ArrayList<ALExtFolderInfo>();
  }

  public void setList(List<ALExtFolderInfo> list) {
    colist.addAll(list);
  }

  public List<ALExtFolderInfo> getList() {
    return colist;
  }

  public int getHierarchyIndex() {
    return index;
  }

  public void setHierarchyIndex(int index) {
    this.index = index;
  }

  public void setHierarchyIndex(String str) {
    index = Integer.parseInt(str);
  }

  public boolean visible() {
    return visible;
  }

  public void setFolderName(String fname) {
    folder_name.setValue(fname);
  }

  public String getFolderName() {
    return folder_name.toString();
  }

  public void setFolderNameDisplay(String fname) {
    folder_name_display.setValue(fname);
  }

  public String getFolderNameDisplay() {
    return folder_name_display.toString();
  }

  public int getFolderId() {
    return folder_id;
  }

  public void setFolderId(int id) {
    folder_id = id;
  }

  public void setFolderId(String id) {
    folder_id = Integer.parseInt(id);
  }

  public int getParentFolderId() {
    return parent_folder_id;
  }

  public void setParentFolderId(int id) {
    parent_folder_id = id;
  }

  public void setParentFolderId(String id) {
    parent_folder_id = Integer.parseInt(id);
  }

  public void setVisible(boolean bool) {
    visible = bool;
  }

  public boolean isOpened() {
    return opened;
  }

  public void setOpened(boolean bool) {
    opened = bool;
  }

  public boolean isAuthorizedVisible() {
    return authorized_visible;
  }

  public void setAuthorizedVisible(boolean authorized_visible) {
    this.authorized_visible = authorized_visible;
  }

  public int getCreateUserId() {
    return create_user_id;
  }

  public void setCreateUserId(int id) {
    create_user_id = id;
  }

  @Override
  public Object clone() {
    try {
      return (super.clone());
    } catch (CloneNotSupportedException e) {
      throw (new InternalError(e.getMessage()));
    }
  }
}
