/*
 * Aipo is a groupware program developed by Aimluck,Inc.
 * Copyright (C) 2004-2011 Aimluck,Inc.
 * http://www.aipo.com
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.aimluck.eip.modules.actions.addressbook;

import org.apache.jetspeed.portal.portlets.VelocityPortlet;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

import com.aimluck.eip.addressbook.AbstractAddressBookWordSelectData;
import com.aimluck.eip.addressbook.AddressBookCompanyWordSelectData;
import com.aimluck.eip.addressbook.AddressBookCorpFilterdSelectData;
import com.aimluck.eip.addressbook.AddressBookFilterdSelectData;
import com.aimluck.eip.addressbook.AddressBookGroupSelectData;
import com.aimluck.eip.addressbook.AddressBookPost1SelectData;
import com.aimluck.eip.addressbook.AddressBookPost2SelectData;
import com.aimluck.eip.addressbook.CellAddressBookGroupSelectData;
import com.aimluck.eip.common.ALEipConstants;
import com.aimluck.eip.modules.actions.common.ALBaseAction;
import com.aimluck.eip.util.ALEipUtils;

/**
 * アドレス帳のアクションクラスです。
 * 
 */
public class CellAddressBookAction extends ALBaseAction {

  /** logger */
  private static final JetspeedLogger logger =
    JetspeedLogFactoryService.getLogger(CellAddressBookAction.class.getName());

  private static final String MODE_SEARCH = "search";

  // add strat
  // セッションキー名追加
  private static final String IS_SEARCH_PAGE = "is_search_page";

  private static final String SEARCH_WORD = "search_word";

  // add end
  /**
   * 
   * @param portlet
   * @param context
   * @param rundata
   * @throws Exception
   */
  @Override
  protected void buildNormalContext(VelocityPortlet portlet, Context context,
      RunData rundata) throws Exception {
  }

  /**
   * 最大化表示の際の処理を記述します。
   * 
   * @param portlet
   * @param context
   * @param rundata
   */
  @Override
  protected void buildMaximizedContext(VelocityPortlet portlet,
      Context context, RunData rundata) {
    // MODEを取得
    String mode = rundata.getParameters().getString(ALEipConstants.MODE);
    try {
      if (ALEipConstants.MODE_FORM.equals(mode)) {
      } else if (ALEipConstants.MODE_DETAIL.equals(mode)) {
        doAddressbook_detail(rundata, context);
      } else if ("search".equals(mode)) {
      } else if (ALEipConstants.MODE_LIST.equals(mode)) {
        String currentTab = ALEipUtils.getTemp(rundata, context, "tab");
        if (currentTab == null
          || currentTab.trim().length() == 0
          || "syagai".equals(currentTab)) {
          doAddressbook_list(rundata, context);
        } else {
          doAddressbook_corp_list(rundata, context);
        }
      }

      if (getMode() == null || ALEipConstants.MODE_LIST.equals(mode)) {
        doAddressbook_menu(rundata, context);
      }
    } catch (Exception ex) {
      logger.error("Exception", ex);
    }
  }

  /**
   * アドレス帳のメニューを表示する．
   * 
   * @param rundata
   * @param context
   * @throws Exception
   */
  public void doAddressbook_menu(RunData rundata, Context context)
      throws Exception {
    // add start
    // 「個人アドレス一覧へ」リンク対応
    // 遷移元画面判別フラグ、検索ワードセッション初期化
    ALEipUtils.removeTemp(rundata, context, IS_SEARCH_PAGE);
    ALEipUtils.removeTemp(rundata, context, SEARCH_WORD);
    // add end
    putData(rundata, context);
    setTemplate(rundata, "addressbook-menu");
  }

  /**
   * アドレス情報の表示を行います。(社外アドレス、一覧表示)
   * 
   * @param rundata
   * @param context
   * @throws Exception
   */
  public void doAddressbook_list(RunData rundata, Context context) {
    ALEipUtils.setTemp(rundata, context, "tab", "syagai");
    AddressBookFilterdSelectData listData = new AddressBookFilterdSelectData();
    listData.setRowsNum(Integer.parseInt(ALEipUtils
      .getPortlet(rundata, context)
      .getPortletConfig()
      .getInitParameter("p1a-rows")));
    listData.doViewList(this, rundata, context);
    listData.loadGroups(rundata, context);
    setTemplate(rundata, "addressbook-list");
  }

  /**
   * アドレス情報の表示を行います。（社内アドレス、一覧表示）
   * 
   * @param rundata
   * @param context
   */
  public void doAddressbook_corp_list(RunData rundata, Context context) {
    ALEipUtils.setTemp(rundata, context, "tab", "corp");
    AddressBookCorpFilterdSelectData listData =
      new AddressBookCorpFilterdSelectData();
    // del by motegi start 個人アドレス帳
    // listData.loadMygroupList(rundata, context);
    // del end
    // 部署選択後は「検索ワードからの遷移フラグ」削除
    if (rundata.getParameters().containsKey("from_busyo")) {
      ALEipUtils.removeTemp(rundata, context, IS_SEARCH_PAGE);
    }
    listData.setRowsNum(Integer.parseInt(ALEipUtils
      .getPortlet(rundata, context)
      .getPortletConfig()
      .getInitParameter("p1a-rows")));
    listData.doViewList(this, rundata, context);
    setTemplate(rundata, "addressbook-corplist");
  }

  public void doAddressbook_detail(RunData rundata, Context context)
      throws Exception {
    // 「個人アドレス一覧」遷移先判別

    AddressBookFilterdSelectData detailData =
      new AddressBookFilterdSelectData();
    detailData.initField();
    if (detailData.doViewDetail(this, rundata, context)) {
      // add start
      String par1 = ALEipUtils.getTemp(rundata, context, SEARCH_WORD);
      context.put("sword", par1);
      // add end
      setTemplate(rundata, "addressbook-detail");
    } else {
      doAddressbook_list(rundata, context);
    }
  }

  public void doAddressbook_corp_detail(RunData rundata, Context context)
      throws Exception {
    AddressBookCorpFilterdSelectData detailData =
      new AddressBookCorpFilterdSelectData();
    // add start
    if (!(null == ALEipUtils.getTemp(rundata, context, IS_SEARCH_PAGE) || ""
      .equals(ALEipUtils.getTemp(rundata, context, IS_SEARCH_PAGE)))) {
      context.put("isSerchRes", Boolean.valueOf(true));
      context.put("sword", ALEipUtils.getTemp(
        rundata,
        context,
        "AddressBooksword"));
    }
    // add end
    detailData.initField();
    if (detailData.doViewDetail(this, rundata, context)) {
      setTemplate(rundata, "addressbook-corpdetail");
    } else {
      doAddressbook_corp_list(rundata, context);
    }
  }

  // change by motegi start 個人アドレス帳対応
  // public void doAddressbook_company_list(RunData rundata, Context context)
  // throws Exception {
  // AddressBookCompanySelectData listData = new AddressBookCompanySelectData();
  // listData.setRowsNum(Integer.parseInt(ALEipUtils
  // .getPortlet(rundata, context)
  // .getPortletConfig()
  // .getInitParameter("p1a-rows")));
  // listData.doViewList(this, rundata, context);
  // setTemplate(rundata, "addressbook-company-list");
  // }
  public void doAddressbook_company_list(RunData rundata, Context context)
      throws Exception {
    // change start
    // AddressBookGroupSelectData listData = new AddressBookGroupSelectData();
    CellAddressBookGroupSelectData listData =
      new CellAddressBookGroupSelectData();
    // change end
    listData.setRowsNum(Integer.parseInt(ALEipUtils
      .getPortlet(rundata, context)
      .getPortletConfig()
      .getInitParameter("p1a-rows")));
    listData.doViewList(this, rundata, context);
    setTemplate(rundata, "addressbook-company-list");
  }

  // change end

  /**
   * 会社情報の詳細を表示します。
   * 
   * @param rundata
   * @param context
   * @throws Exception
   */
  public void doAddressbook_company_detail(RunData rundata, Context context)
      throws Exception {
    // change start
    // AddressBookCompanySelectData detailData =
    // new AddressBookCompanySelectData();
    // detailData.initField();
    // if (detailData.doViewDetail(this, rundata, context)) {
    // setTemplate(rundata, "addressbook-company-detail");
    // } else {
    // doAddressbook_company_list(rundata, context);
    // }
    // 「個人アドレス詳細画面」リンク対応
    if (null == ALEipUtils.getTemp(rundata, context, IS_SEARCH_PAGE)
      || "".equals(ALEipUtils.getTemp(rundata, context, IS_SEARCH_PAGE))) {
      // 個人アドレス一覧画面からの場合は「個人アドレス一覧」リンクの遷移先を
      // 会社詳細画面にする。
      AddressBookGroupSelectData detailData = new AddressBookGroupSelectData();
      detailData.initField();
      if (detailData.doViewDetail(this, rundata, context)) {
        setTemplate(rundata, "addressbook-company-detail");
      } else {
        doAddressbook_company_list(rundata, context);
      }
    } else {
      // 検索ページからの場合は「個人アドレス一覧」リンクの遷移先を
      // 検索結果一覧画面にする。
      // 検索ワードセット
      rundata.getParameters().setString(
        "sword",
        ALEipUtils.getTemp(rundata, context, SEARCH_WORD));
      doAddressbook_addr_search_list(rundata, context);
    }
    // change end
  }

  public void doAddressbook_addr_search(RunData rundata, Context context)
      throws Exception {
    this.setMode(MODE_SEARCH);

    String address_type =
      ALEipUtils
        .getPortlet(rundata, context)
        .getPortletConfig()
        .getInitParameter("p2a-type");
    context.put("address_type", address_type);
    putData(rundata, context);
    setTemplate(rundata, "addressbook-addr-search");
  }

  /**
   * 検索ワードによる検索処理を行います。
   * 
   * @param rundata
   * @param context
   * @throws Exception
   */
  public void doAddressbook_addr_search_list(RunData rundata, Context context)
      throws Exception {
    // add start
    // 個人アドレス詳細もしくは社内アドレス詳細からの遷移以外の場合、セッションの検索ワードを破棄
    if (!("true".equals(ALEipUtils.getTemp(rundata, context, IS_SEARCH_PAGE)))) {
      ALEipUtils.setTemp(rundata, context, "AddressBooksword", "");
    }
    // 検索文字が無い場合は自画面遷移
    String sword = rundata.getParameters().getString("sword");
    String addressBooksword =
      ALEipUtils.getTemp(rundata, context, "AddressBooksword");
    if ((null == sword || "".equals(sword))
      && (null == addressBooksword || "".equals(addressBooksword))) {
      doAddressbook_addr_search(rundata, context);
    } else {
      // add end
      context.put("isSerchRes", Boolean.valueOf(true));
      AbstractAddressBookWordSelectData<?, ?> listData =
        AbstractAddressBookWordSelectData.createAddressBookWordSelectData(
          rundata,
          context);
      listData.doViewList(this, rundata, context);
      listData.loadGroups(rundata, context);

      if (listData.getCurrentTab().equals("syagai")) {
        // add start
        // 「個人アドレス一覧」遷移元判別用セッション格納
        ALEipUtils.setTemp(rundata, context, IS_SEARCH_PAGE, "true");
        ALEipUtils.setTemp(rundata, context, SEARCH_WORD, sword);
        // ページングgetパラメータ用検索ワード
        context.put("sword", ALEipUtils.getTemp(
          rundata,
          context,
          "AddressBooksword"));
        // add end
        setTemplate(rundata, "addressbook-list");
      } else {
        ALEipUtils.setTemp(rundata, context, IS_SEARCH_PAGE, "true");
        if (!rundata.getParameters().containsKey("return_corpdetail")) {
          ALEipUtils.setTemp(rundata, context, SEARCH_WORD, sword);
        } else {
          ALEipUtils.setTemp(
            rundata,
            context,
            "AddressBooksword",
            addressBooksword);
        }
        setTemplate(rundata, "addressbook-corplist");
      }
    }
  }

  public void doAddressbook_company_search(RunData rundata, Context context)
      throws Exception {
    this.setMode(MODE_SEARCH);
    putData(rundata, context);
    setTemplate(rundata, "addressbook-company-search");
  }

  /**
   * 会社情報を検索ワードで検索する．
   * 
   * @param rundata
   * @param context
   * @throws Exception
   */
  // change by motegi start
  // public void doAddressbook_company_search_list(RunData rundata, Context
  // context)
  // throws Exception {
  // AddressBookCompanyWordSelectData listData =
  // new AddressBookCompanyWordSelectData();
  // listData.setRowsNum(Integer.parseInt(ALEipUtils
  // .getPortlet(rundata, context)
  // .getPortletConfig()
  // .getInitParameter("p1a-rows")));
  // listData.doViewList(this, rundata, context);
  //
  // context.put("isSerchRes", Boolean.valueOf(true));
  //
  // setTemplate(rundata, "addressbook-company-list.vm");
  // }
  public void doAddressbook_company_search_list(RunData rundata, Context context)
      throws Exception {

    String word = rundata.getParameters().getString("sword");
    if (word == null || "".equals(word)) {
      doAddressbook_company_search(rundata, context);
    } else {
      AddressBookCompanyWordSelectData listData =
        new AddressBookCompanyWordSelectData();
      listData.setRowsNum(Integer.parseInt(ALEipUtils.getPortlet(
        rundata,
        context).getPortletConfig().getInitParameter("p1a-rows")));
      listData.doViewList(this, rundata, context);

      context.put("isSerchRes", Boolean.valueOf(true));

      setTemplate(rundata, "addressbook-company-list.vm");
    }

  }

  // change end

  // add start
  /**
   * 社内アドレス所属部署1選択画面を表示する．
   * 
   * @param rundata
   * @param context
   * @throws Exception
   */
  public void doAddressbook_post1_search(RunData rundata, Context context)
      throws Exception {
    AddressBookPost1SelectData listData = new AddressBookPost1SelectData();
    listData.doViewList(this, rundata, context);
    putData(rundata, context);
    setTemplate(rundata, "addressbook-post1-search");
  }

  /**
   * 社内アドレス所属部署2選択画面を表示する．
   * 
   * @param rundata
   * @param context
   * @throws Exception
   */
  public void doAddressbook_post2_search(RunData rundata, Context context)
      throws Exception {
    AddressBookPost2SelectData listData = new AddressBookPost2SelectData();
    listData.doViewList(this, rundata, context);
    putData(rundata, context);
    setTemplate(rundata, "addressbook-post2-search");
  }
  // add end
}
