/*
 * Aipo is a groupware program developed by Aimluck,Inc.
 * http://aipostyle.com/
 *
 * Copyright(C) 2012 avanza Co.,Ltd. All rights reserved.
 * http://www.avnz.co.jp/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.aimluck.eip.modules.screens;

import java.util.Map;

import javax.servlet.http.HttpServletResponse;

import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

import com.aimluck.eip.common.ALEipConstants;
import com.aimluck.eip.schedule.SchedulePrintMonthlySelectData;
import com.aimluck.eip.services.orgutils.ALOrgUtilsService;
import com.aimluck.eip.util.ALCommonUtils;
import com.aimluck.eip.util.ALEipUtils;

/**
 * スケジュールの印刷用画面を処理するクラスです。 <br />
 * 
 */
public class ScheduleMonthlyPrintScreen extends ALVelocityScreen {

  /** logger */
  private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger(ScheduleMonthlyPrintScreen.class.getName());

  /**
   * スケジュールの印刷用画面表示処理
   * 
   * @param rundata
   *          JetSpeedランデータ
   * @param context
   *          JetSpeedコンテキスト
   */
  @Override
  protected void doOutput(RunData rundata, Context context) throws Exception {

    try {

      SchedulePrintMonthlySelectData listData = new SchedulePrintMonthlySelectData();
      listData.initField();
      listData.doViewList(this, rundata, context);

      String layout_template = null;
      if (listData.doViewList(this, rundata, context)) {
        layout_template = "portlets/html/ja/ajax-print-calendar-monthly.vm";
      } else {
        layout_template = "portlets/html/ja/DBErrorForWindow.vm";
      }

      context.put("theme", ALOrgUtilsService.getTheme());
      context.put("utils", new ALCommonUtils());
      Map<String, String> attribute = ALOrgUtilsService.getParameters();
      for (Map.Entry<String, String> e : attribute.entrySet()) {
        context.put(e.getKey(), e.getValue());
      }

      HttpServletResponse response = rundata.getResponse();
      response.setContentType("text/html; " + ALEipConstants.DEF_CONTENT_ENCODING);

      setTemplate(rundata, context, layout_template);

    } catch (Exception ex) {
      logger.error("[ScheduleMonthlyPrintScreen] Exception.", ex);
      ALEipUtils.redirectDBError(rundata);
    }
  }

}
