/*
 * Aipo is a groupware program developed by Aimluck,Inc.
 * http://aipostyle.com/
 *
 * Copyright(C) 2011 avanza Co.,Ltd. All rights reserved.
 * http://www.avnz.co.jp/
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

package com.aimluck.eip.schedule;

import java.util.Calendar;

/**
 * スケジュールポートレット共通定数
 */
public class ScheduleConst {

  // add start 要件No.8 スケジュール画面（日単位）
  /** ポートレット名（タブID取得用）：月間スケジュール */
  public static final String PORTLET_NAME_DAILY_SCHEDULE = "１日スケジュール";

  /** ポートレット名（タブID取得用）：週間スケジュール */
  public static final String PORTLET_NAME_WEEKLY_SCHEDULE = "週間スケジュール";

  /** ポートレット名（タブID取得用）：月間スケジュール */
  public static final String PORTLET_NAME_MONTHLY_SCHEDULE = "月間スケジュール";

  // add end

  /** 必須フラグ：必須 */
  public static final String SCHEDULEMAP_REQUIRED_T = "R";

  /** 必須フラグ：任意 */
  public static final String SCHEDULEMAP_REQUIRED_F = "S";

  /** 重要フラグ：重要データ */
  public static final String SCHEDULEMAP_PRIORITY_T = "T";

  /** 重要フラグ：通常データ */
  public static final String SCHEDULEMAP_PRIORITY_F = "F";

  /** ダミー未回答フラグ：ダミー未回答データ */
  public static final String SCHEDULEMAP_DUMMY_NON_RES_T = "T";

  /** ダミー未回答フラグ：通常データ */
  public static final String SCHEDULEMAP_DUMMY_NON_RES_F = "F";

  /** スケジュール制御 権限種類 参照 */
  public static final String SCHEDULEACL_ACL_REF = "R";

  /** スケジュール制御 権限種類 更新 */
  public static final String SCHEDULEACL_ACL_UPDATE = "U";

  /** スケジュール制御 適用タイプ グループ送信 */
  public static final String SCHEDULEACL_TARGET_GROUP = "G";

  /** スケジュール制御 適用タイプ ユーザー */
  public static final String SCHEDULEACL_TARGET_USER = "U";

  /** スケジュール制御 [予定権限] [本人] */
  public static final String SCHEDULE_ACL_MYSELF = "M";

  /** スケジュール制御 [予定権限] [秘書] */
  public static final String SCHEDULE_ACL_SECRETARY = "S";

  /** スケジュール制御 [予定権限] [公開] */
  public static final String SCHEDULE_ACL_PUBLIC = "P";

  /** スケジュール制御 [予定権限] [不可] */
  public static final String SCHEDULE_ACL_REFUSAL = "R";

  /** 状態：所有者 */
  public static final String SCHEDULEMAP_STATUS_OWNER = "O";

  /** 状態：共有メンバー（未回答） */
  public static final String SCHEDULEMAP_STATUS_NON_RES = "T";

  /** 状態：共有メンバー（仮承諾） */
  public static final String SCHEDULEMAP_STATUS_PROVISIONAL = "P";

  /** 状態：共有メンバー（承諾） */
  public static final String SCHEDULEMAP_STATUS_CONSENT = "C";

  /** 状態：共有メンバー（削除） */
  public static final String SCHEDULEMAP_STATUS_REMOVE = "R";

  /** 状態：共有メンバー（辞退） */
  public static final String SCHEDULEMAP_STATUS_VETO = "V";

  /** 状態：ダミー */
  public static final String SCHEDULEMAP_STATUS_DUMMY = "D";

  /** 繰り返しパターン：単発 */
  public static final String SCHEDULE_PATTERN_ONEDAY = "N";

  /** 繰り返しパターン：期間 */
  public static final String SCHEDULE_PATTERN_SPAN = "S";

  /** 繰り返しパターン：日またぎ */
  public static final String SCHEDULE_PATTERN_DAYS = "Z";

  /** 繰り返しパターン：日パターン */
  public static final String SCHEDULE_PATTERN_DAILY = "A";

  /** 繰り返しパターン：週パターン */
  public static final String SCHEDULE_PATTERN_WEEKLY = "B";

  /** 繰り返しパターン：月・日パターン */
  public static final String SCHEDULE_PATTERN_MONTHLY_DAY = "C";

  /** 繰り返しパターン：月・曜日パターン */
  public static final String SCHEDULE_PATTERN_MONTHLY_WEEK = "E";

  /** 繰り返しパターン：年・月・日パターン */
  public static final String SCHEDULE_PATTERN_YEARLY_DAY = "F";

  /** 繰り返しパターン：年・月・週パターン */
  public static final String SCHEDULE_PATTERN_YEARLY_WEEK = "G";

  /** 繰り返しパターン：終端 */
  public static final String SCHEDULE_PATTERN_TERMINATION = "L";

  /** 日付：最終日 */
  public static final String SCHEDULE_REPEAT_PATTERN_LAST = "99";

  /** 日付：最終日(名称) */
  public static final String SCHEDULE_REPEAT_PATTERN_LAST_NAME = "最終日";

  /** 有効期限終了日未定 */
  public static final String SCHEDULE_LIMIT_ENDDATE_NONEND = "99991231";

  /** 入力用繰り返しパターン：日 */
  public static final String REPEAT_TYPE_DAY = "day";

  /** 入力用繰り返しパターン：週 */
  public static final String REPEAT_TYPE_WEEK = "week";

  /** 入力用繰り返しパターン：月 */
  public static final String REPEAT_TYPE_MONTH = "month";

  /** 入力用繰り返しパターン：年 */
  public static final String REPEAT_TYPE_YEAR = "year";

  /** 週チェックボックス：選択済み */
  public static final String DOW_CHECKED = "TRUE";

  /** 週チェックボックス：未選択 */
  public static final String DOW_UNCHECKED = "FALSE";

  /** 月パターン：月日 */
  public static final String MONTH_TYPE_MD = "month_day";

  /** 月パターン：月・曜日 */
  public static final String MONTH_TYPE_MW = "month_week";

  /** 年パターン：月日 */
  public static final String YEAR_TYPE_MD = "year_md";

  /** 年パターン：月・曜日 */
  public static final String YEAR_TYPE_MW = "year_mw";

  /** 繰り返し有効期限パターン：終了日なし */
  public static final String LIMIT_TYPE_NONEND = "non";

  /** 繰り返し有効期限パターン：反復回数 */
  public static final String LIMIT_TYPE_NOFT = "noft";

  /** 繰り返し有効期限パターン：終了日 */
  public static final String LIMIT_TYPE_DATE = "date";

  /** 予定登録先 */
  public static final String SCHEDULE_LOCATION_USER_ID = "scheduleLocationUserId";

  /** リクエストパラメータ名(携帯)部署1名 */
  public static final String CURRENT_PARENT_GROUP_NAME = "current_parent_group_name";

  /** 携帯入力用繰り返しパターン：日 */
  public static final String CELL_REPEAT_TYPE_DAY = "D";

  /** 携帯入力用繰り返しパターン：週 */
  public static final String CELL_REPEAT_TYPE_WEEK = "W";

  /** 携帯入力用繰り返しパターン：月->日 */
  public static final String CELL_REPEAT_TYPE_MONTH_DAY = "MD";

  /** 携帯入力用繰り返しパターン：月->曜日 */
  public static final String CELL_REPEAT_TYPE_MONTH_WEEK = "MW";

  /** 携帯入力用繰り返しパターン：年->月 */
  public static final String CELL_REPEAT_TYPE_YEAR_MONTH = "YM";

  /** 携帯入力用繰り返しパターン：年->曜日 */
  public static final String CELL_REPEAT_TYPE_YEAR_WEEK = "YW";

  /** 1日のミリ秒数 */
  public static final int BASE_SEC = 86400000;

  /** 期間スケジュール表示判定用定数 */
  public static final int ADD_COL = 1;

  /** 期間スケジュール表示判定用定数 */
  public static final int WEEK_COUNT = 7;

  /** (携帯・スマートフォン)「削除」フラグ0 */
  public static final String DEL_FLAG_0 = "0";

  /** (携帯・スマートフォン)「削除」フラグ1 */
  public static final String DEL_FLAG_1 = "1";

  /** (携帯・スマートフォン)「削除」フラグ2 */
  public static final String DEL_FLAG_2 = "2";

  /** (携帯・スマートフォン)「削除」フラグ3 */
  public static final String DEL_FLAG_3 = "3";

  /** (携帯・スマートフォン)「メンバー削除」フラグ */
  public static final String DEL_FLAG = "del_flag";

  /** (携帯・スマートフォン)「メンバー削除」フラグ */
  public static final String DEL_MEMBER_FLAG = "del_member_flag";

  /** (携帯・スマートフォン)「期間削除」フラグ */
  public static final String DEL_RANGE_FLAG = "del_range_flag";

  /**
   * 曜日列挙体
   */
  public enum DayOfWeek {
    // remove start 2次開発受入テスト障害No.9（運用フェーズ課題・障害台帳No.174）
    // SUNDAY {
    // @Override
    // public int getNumber() {
    // return Calendar.SUNDAY;
    // }
    //
    // @Override
    // public String getShortName() {
    // return "日";
    // }
    //
    // @Override
    // public String getLongName() {
    // return "日曜日";
    // }
    // },
    // remove end
    MONDAY {
      @Override
      public int getNumber() {
        return Calendar.MONDAY;
      }

      @Override
      public String getShortName() {
        return "月";
      }

      @Override
      public String getLongName() {
        return "月曜日";
      }
    },
    TUESDAY {
      @Override
      public int getNumber() {
        return Calendar.TUESDAY;
      }

      @Override
      public String getShortName() {
        return "火";
      }

      @Override
      public String getLongName() {
        return "火曜日";
      }
    },
    WEDNESDAY {
      @Override
      public int getNumber() {
        return Calendar.WEDNESDAY;
      }

      @Override
      public String getShortName() {
        return "水";
      }

      @Override
      public String getLongName() {
        return "水曜日";
      }
    },
    THURSDAY {
      @Override
      public int getNumber() {
        return Calendar.THURSDAY;
      }

      @Override
      public String getShortName() {
        return "木";
      }

      @Override
      public String getLongName() {
        return "木曜日";
      }
    },
    FRIDAY {
      @Override
      public int getNumber() {
        return Calendar.FRIDAY;
      }

      @Override
      public String getShortName() {
        return "金";
      }

      @Override
      public String getLongName() {
        return "金曜日";
      }
    },
    SATURDAY {
      @Override
      public int getNumber() {
        return Calendar.SATURDAY;
      }

      @Override
      public String getShortName() {
        return "土";
      }

      @Override
      public String getLongName() {
        return "土曜日";
      }
    },
    // add start 2次開発受入テスト障害No.9（運用フェーズ課題・障害台帳No.174）
    SUNDAY {
      @Override
      public int getNumber() {
        return Calendar.SUNDAY;
      }

      @Override
      public String getShortName() {
        return "日";
      }

      @Override
      public String getLongName() {
        return "日曜日";
      }
    }
    // add end
    ;
    /**
     * Calendarクラスの曜日の番号を返します。
     * 
     * @return 曜日の番号
     */
    abstract public int getNumber();

    /**
     * Calendarクラスの曜日のコードを返します。
     * 
     * @return 曜日のコード
     */
    public String getCode() {
      return Integer.toString(getNumber());
    };

    /**
     * 曜日の短縮名（日～土）を返します。
     * 
     * @return 曜日の短縮名
     */
    abstract public String getShortName();

    /**
     * 曜日の名称（日曜日～土曜日）を返します。
     * 
     * @return 曜日の短縮名
     */
    abstract public String getLongName();
  }

  /**
   * 日種類列挙体
   */
  public enum DayType {
    WEEKDAY {
      @Override
      public String getCode() {
        return "A";
      }

      @Override
      public String getName() {
        return "平日";
      }
    },
    WEEKEND {
      @Override
      public String getCode() {
        return "B";
      }

      @Override
      public String getName() {
        return "週末";
      }
    };
    /**
     * 要素のコードを返します。
     * 
     * @return 要素のコード
     */
    abstract public String getCode();

    /**
     * 要素の名称を返します。
     * 
     * @return 要素の名称
     */
    abstract public String getName();
  }

  /**
   * 繰り返し期間終了パターン列挙体
   */
  public enum ScheduleLimitPattern {
    NON_END {
      @Override
      public String getCode() {
        return "1";
      }

      @Override
      public String getName() {
        return "終了日未定";
      }
    },
    N_OF_T {
      @Override
      public String getCode() {
        return "2";
      }

      @Override
      public String getName() {
        return "反復回数";
      }
    },
    DATE {
      @Override
      public String getCode() {
        return "3";
      }

      @Override
      public String getName() {
        return "終了日";
      }
    };
    /**
     * 要素のコードを返します。
     * 
     * @return 要素のコード
     */
    abstract public String getCode();

    /**
     * 要素の名称を返します。
     * 
     * @return 要素の名称
     */
    abstract public String getName();
  }

  /**
   * 第何週列挙体
   */
  public enum ScheduleWeekNumber {
    FIRST {
      @Override
      public String getCode() {
        return "1";
      }

      @Override
      public String getName() {
        return "第1";
      }
    },
    SECOND {
      @Override
      public String getCode() {
        return "2";
      }

      @Override
      public String getName() {
        return "第2";
      }
    },
    THIRD {
      @Override
      public String getCode() {
        return "3";
      }

      @Override
      public String getName() {
        return "第3";
      }
    },
    FOURTH {
      @Override
      public String getCode() {
        return "4";
      }

      @Override
      public String getName() {
        return "第4";
      }
    },
    LAST {
      @Override
      public String getCode() {
        return "5";
      }

      @Override
      public String getName() {
        return "最終";
      }
    };
    /**
     * 要素のコードを返します。
     * 
     * @return 要素のコード
     */
    abstract public String getCode();

    /**
     * 要素の名称を返します。
     * 
     * @return 要素の名称
     */
    abstract public String getName();
  }

  // add start
  // 運用課題No.34
  /** エラー状態：エラーなし */
  public static final String ERR_STATUS_ERR_NONE = "ERR_NONE";

  /** エラー状態：通常エラー */
  public static final String ERR_STATUS_NORMAL = "NORMAL_ERR";

  /** エラー状態：データなしエラー */
  public static final String ERR_STATUS_NO_DATA = "NO_DATA_ERR";

  // add end

  // add start No.4 スケジュール印刷（週単位）
  /** 仮予定フラグ：重要データ */
  public static final String SCHEDULE_TEMPORARY_FLAG_T = "T";

  /** 仮予定フラグ：通常データ */
  public static final String SCHEDULE_TEMPORARY_FLAG_F = "F";
  // add end

}
