/*
 * Aipo is a groupware program developed by Aimluck,Inc.
 * http://aipostyle.com/
 *
 * Copyright(C) 2011 avanza Co.,Ltd. All rights reserved.
 * http://www.avnz.co.jp/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.aimluck.eip.schedule;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 日時調整画面用の予定データを管理するクラスです。
 * 
 */
public class ScheduleReferOnedayResultData extends ScheduleOnedayResultData {

  /** <code>dList</code> グルーピングスケジュールリスト */
  private final List<ScheduleReferOnedayResultData> dList = new ArrayList<ScheduleReferOnedayResultData>();

  /**
   * 日付を取得します。
   * 
   * @return
   */
  @Override
  public String getDate() {
    return new StringBuffer().append(getStartDate().toString()).append('-').append(getEndDate().toString()).toString();
  }

  /**
   * グルーピングスケジュールリストを取得します。
   * 
   * @return
   */
  public List<ScheduleReferOnedayResultData> getDisplaySchedule() {
    return dList;
  }

  /**
   * 予定データをセットする <br/>
   * 表示幅調節用の日時の書き換えと、表示用のデータを分けるためコピーする。
   * 
   * @param rd
   *          予定データ
   */
  public void addDisplaySchedule(ScheduleReferOnedayResultData rd) {

    ScheduleReferOnedayResultData rd3 = new ScheduleReferOnedayResultData();
    rd3.initField();
    rd3.setScheduleId((int) rd.getScheduleId().getValue());
    rd3.setParentId((int) rd.getParentId().getValue());
    rd3.setName(rd.getName().getValue());
    // 開始日を設定し直す
    rd3.setStartDate(new Date(rd.getStartDate().getValue().getTime()));
    // 終了日を設定し直す
    rd3.setEndDate(new Date(rd.getEndDate().getValue().getTime()));
    rd3.setTmpreserve(rd.isTmpreserve());
    rd3.setPublic(rd.isPublic());
    rd3.setHidden(rd.isHidden());
    rd3.setDummy(rd.isDummy());
    rd3.setLoginuser(rd.isLoginuser());
    rd3.setOwner(rd.isOwner());
    rd3.setMember(rd.isMember());
    rd3.setType(rd.getType());
    // // 繰り返しはON
    rd3.setRepeat(true);
    // 場所
    rd3.setPlace(rd.getPlace().getValue());
    // add start
    // 状態
    rd3.setStatus(rd.getStatus());
    // 重要フラグ
    rd3.setPriority(rd.getPriority());
    // 必須／任意フラグ
    rd3.setRequired(rd.getRequired());
    // add start 要件No.9 スケジュール表示 （仮の予定、確定した予定）
    rd3.setTemporaryFlag(rd.getTemporaryFlag());
    // add end
    dList.add(rd3);
  }
}
