/*
 * Aipo is a groupware program developed by Aimluck,Inc.
 * Copyright (C) 2004-2011 Aimluck,Inc.
 * http://www.aipo.com
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.aimluck.eip.schedule;

import java.util.ArrayList;
import java.util.List;
import java.util.jar.Attributes;

import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.services.TurbineServices;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

import com.aimluck.commons.field.ALDateTimeField;
import com.aimluck.eip.cayenne.om.portlet.AvzTScheduleFile;
import com.aimluck.eip.cayenne.om.portlet.EipTMail;
import com.aimluck.eip.cayenne.om.portlet.EipTSchedule;
import com.aimluck.eip.common.ALAbstractSelectData;
import com.aimluck.eip.common.ALDBErrorException;
import com.aimluck.eip.common.ALEipConstants;
import com.aimluck.eip.common.ALEipUser;
import com.aimluck.eip.common.ALPageNotFoundException;
import com.aimluck.eip.common.ALPermissionException;
import com.aimluck.eip.facilities.FacilityResultData;
import com.aimluck.eip.fileupload.beans.FileuploadBean;
import com.aimluck.eip.fileupload.util.FileuploadUtils;
import com.aimluck.eip.modules.actions.common.ALAction;
import com.aimluck.eip.orm.Database;
import com.aimluck.eip.orm.query.ResultList;
import com.aimluck.eip.orm.query.SelectQuery;
import com.aimluck.eip.schedule.data.ScheduleMemberUser;
import com.aimluck.eip.schedule.util.ScheduleUtils;
import com.aimluck.eip.services.accessctl.ALAccessControlConstants;
import com.aimluck.eip.services.accessctl.ALAccessControlFactoryService;
import com.aimluck.eip.services.accessctl.ALAccessControlHandler;
import com.aimluck.eip.util.ALEipUtils;

/**
 * スケジュール詳細表示の検索結果を管理するクラスです。
 * 
 */
public class ScheduleSelectData extends ALAbstractSelectData<EipTSchedule, EipTSchedule> {

  /** <code>logger</code> logger */
  private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger(ScheduleSelectData.class.getName());

  /** <code>members</code> 共有メンバー */
  private List<ALEipUser> members;

  // add start
  /** <code>reqMembers</code> 参加必須の共有メンバー */
  private List<ScheduleMemberUser> reqMembers;

  /** <code>subMembers</code> 参加任意の共有メンバー */
  private List<ScheduleMemberUser> subMembers;

  // add end

  // remove start
  // 参加メンバーの状態は参加メンバー自体に格納するため廃止
  // /** <code>statusList</code> メンバーの状態 */
  // private Map<Integer, String> statusList;
  // remove end

  /** <code>userid</code> 対象ユーザーID（ユーザ or 施設） */
  private int userid;

  /** <code>type</code> マップ種別（ユーザ or 施設） */
  private String type;

  /** <code>loginuserid</code> ログインユーザーID */
  private int loginuserid;

  // add start
  /** <code>loginUserName</code> ログインユーザー名 */
  private String loginUserName;

  /** <code>scheduleAcl</code> 閲覧権限 */
  private String scheduleAcl = "";

  // add end

  /** <code>viewDate</code> 表示する日 */
  private ALDateTimeField view_date;

  /** <code>facilities</code> 共有施設 */
  private List<FacilityResultData> facilities;

  /** <code>hasAuthorityOtherEdit</code> アクセス権限 */
  private boolean hasAuthorityOtherEdit = false;

  /** <code>hasAuthorityOtherDelete</code> アクセス権限 */
  private boolean hasAuthorityOtherDelete = false;

  /** <code>hasAuthoritySelfInsert</code> アクセス権限 */
  private boolean hasAuthoritySelfInsert = false;

  /** <code>hasAuthoritySelfEdit</code> アクセス権限 */
  private boolean hasAuthoritySelfEdit = false;

  /** <code>hasAuthoritySelfDelete</code> アクセス権限 */
  private boolean hasAuthoritySelfDelete = false;

  /** アクセスコントロール用の変数 */
  private String aclPortletFeature;

  // add start
  /** エラー状態 */
  private String errStatus;

  /**
   * 現在のエラー状態を返します。
   * 
   * @return errStatus エラー状態
   */
  public String getErrStatus() {
    return errStatus;
  }

  // add end

  // add start 要件No.1 スケジュール案内受信
  /** <code>mailid</code> 会議案内メールのメールID */
  private String mailid;

  /** 代理受信アカウントフラグ */
  private boolean isRepresent;

  // add end

  // add start 要件No.26 スケジュール個別色換え
  /**
   * 分類名リストを返します。
   * 
   * @return 分類名リスト
   */
  public List<String> getScheduleCategoryNameList() {
    return ScheduleUtils.SCHEDULE_CATEGORY_NAME_LIST;
  }

  /**
   * 色コードリストを返します。
   * 
   * @return 色コードリスト
   */
  public List<String> getScheduleCategoryColorList() {
    return ScheduleUtils.SCHEDULE_CATEGORY_COLOR_LIST;
  }

  // add end

  /**
   * 
   * @param action
   * @param rundata
   * @param context
   * @throws ALPageNotFoundException
   * @throws ALDBErrorException
   */
  @Override
  public void init(ALAction action, RunData rundata, Context context) throws ALPageNotFoundException, ALDBErrorException {
    // 展開されるパラメータは以下の通りです。
    // ・userid 形式 int

    // スーパークラスのメソッドを呼び出す。
    super.init(action, rundata, context);
    // add start
    // エラー状態：なし
    errStatus = ScheduleConst.ERR_STATUS_ERR_NONE;
    // add end
    view_date = new ALDateTimeField("yyyy-MM-dd");
    if (ALEipUtils.isMatch(rundata, context)) {
      if (rundata.getParameters().containsKey("view_date")) {
        String tmpViewDate = rundata.getParameters().getString("view_date");
        view_date.setValue(tmpViewDate);
        if (!view_date.validate(new ArrayList<String>())) {
          logger.debug("[ScheduleSelectData] Parameter cannot validate");
          // remove start
          // 別ウインドウ表示でリダイレクト処理が実行されると想定外の動作をするため削除
          // ALEipUtils.redirectPageNotFound(rundata);
          // remove end
          return;
        }
      }
    }

    // change start
    ALEipUser loginUser = ALEipUtils.getALEipUser(rundata);
    loginuserid = (int) loginUser.getUserId().getValue();
    loginUserName = loginUser.getName().toString();
    // loginuserid = ALEipUtils.getUserId(rundata);
    // change end
    // remove start
    // 参加メンバーの状態は参加メンバー自体に格納するため廃止
    // statusList = new HashMap<Integer, String>();
    // remove end

    // 対象者のユーザーID取得
    if (rundata.getParameters().containsKey("userid")) {
      String tmpid = rundata.getParameters().getString("userid");
      if (tmpid != null && tmpid.startsWith(ScheduleUtils.TARGET_FACILITY_ID)) {
        userid = Integer.parseInt(tmpid.substring(ScheduleUtils.TARGET_FACILITY_ID.length(), tmpid.length()));
        type = ScheduleUtils.SCHEDULEMAP_TYPE_FACILITY;
      } else {
        userid = rundata.getParameters().getInt("userid");
        type = ScheduleUtils.SCHEDULEMAP_TYPE_USER;
      }
    } else if (rundata.getParameters().containsKey("facilityid")) {
      userid = Integer.parseInt(rundata.getParameters().getString("facilityid"));
      type = ScheduleUtils.SCHEDULEMAP_TYPE_FACILITY;
    } else {
      userid = loginuserid;
      type = ScheduleUtils.SCHEDULEMAP_TYPE_USER;
    }

    // add start
    // メール異常系用セッション削除
    ScheduleFormData.doRemoveSendMailInfoFromSession(rundata);
    // スケジュールIDをチェック
    String scheduleId = ALEipUtils.getTemp(rundata, context, ALEipConstants.ENTITY_ID);
    // エンティティIDが基幹処理でセッションへ設定されない場合、リクエストパラメータから取得して設定する
    if (null == scheduleId || "".equals(scheduleId)) {
      if (rundata.getParameters().containsKey(ALEipConstants.ENTITY_ID)) {
        scheduleId = rundata.getParameters().getString(ALEipConstants.ENTITY_ID);
        ALEipUtils.setTemp(rundata, context, ALEipConstants.ENTITY_ID, scheduleId);
      }
    }
    // add end

    // 閲覧権限取得
    scheduleAcl = ScheduleUtils.getScheduleAcl(Integer.toString(loginuserid), Integer.toString(userid));
    // add end

    // change start
    // 既存のアクセス権チェックは使用しない
    // // 自分に関係のある予定なのかどうか判断する
    // if (!ScheduleUtils.hasRelation(rundata)) {
    // aclPortletFeature =
    // ALAccessControlConstants.POERTLET_FEATURE_SCHEDULE_OTHER;
    // } else {
    // aclPortletFeature =
    // ALAccessControlConstants.POERTLET_FEATURE_SCHEDULE_SELF;
    // }
    aclPortletFeature = ALAccessControlConstants.POERTLET_FEATURE_SCHEDULE_SELF;
    // change end

    // add start 要件No.1 スケジュール案内受信
    mailid = rundata.getParameters().getString("mailid");
    String tmpRepresent = rundata.getParameters().getString("represent");
    isRepresent = false;
    if (tmpRepresent != null && !"".equals(tmpRepresent)) {
      isRepresent = Boolean.valueOf(tmpRepresent);
    }
    // add end

    // アクセス権限
    ALAccessControlFactoryService aclservice =
      (ALAccessControlFactoryService) ((TurbineServices) TurbineServices.getInstance()).getService(ALAccessControlFactoryService.SERVICE_NAME);
    ALAccessControlHandler aclhandler = aclservice.getAccessControlHandler();

    hasAuthorityOtherEdit =
      aclhandler.hasAuthority(loginuserid, ALAccessControlConstants.POERTLET_FEATURE_SCHEDULE_OTHER, ALAccessControlConstants.VALUE_ACL_UPDATE);

    hasAuthorityOtherDelete =
      aclhandler.hasAuthority(loginuserid, ALAccessControlConstants.POERTLET_FEATURE_SCHEDULE_OTHER, ALAccessControlConstants.VALUE_ACL_DELETE);

    hasAuthoritySelfInsert =
      aclhandler.hasAuthority(loginuserid, ALAccessControlConstants.POERTLET_FEATURE_SCHEDULE_SELF, ALAccessControlConstants.VALUE_ACL_INSERT);

    hasAuthoritySelfEdit =
      aclhandler.hasAuthority(loginuserid, ALAccessControlConstants.POERTLET_FEATURE_SCHEDULE_SELF, ALAccessControlConstants.VALUE_ACL_UPDATE);

    hasAuthoritySelfDelete =
      aclhandler.hasAuthority(loginuserid, ALAccessControlConstants.POERTLET_FEATURE_SCHEDULE_SELF, ALAccessControlConstants.VALUE_ACL_DELETE);
  }

  /**
   * 
   * @param rundata
   * @param context
   * @return
   */
  @Override
  protected ResultList<EipTSchedule> selectList(RunData rundata, Context context) {
    // このメソッドは利用されません。
    return null;
  }

  /**
   * 
   * @param rundata
   * @param context
   * @return
   * @throws ALPageNotFoundException
   * @throws ALDBErrorException
   */
  @Override
  protected EipTSchedule selectDetail(RunData rundata, Context context) throws ALPageNotFoundException, ALDBErrorException {
    // change start
    // return ScheduleUtils.getEipTScheduleDetail(rundata, context, type);
    EipTSchedule result = null;
    // 閲覧権限をチェック（閲覧権限が[不可]の場合、nullを返しエラー画面へ遷移させる）
    if (!ScheduleConst.SCHEDULE_ACL_REFUSAL.equals(scheduleAcl)) {
      // 閲覧権限が[不可]でない場合、詳細画面用スケジュール取得処理を実行
      // add start
      // 運用課題No.34
      // 例外のハンドリングをおこなう
      try {
        // add end
        result = ScheduleUtils.getEipTScheduleDetail(rundata, context, type);
        // add start
        // 運用課題No.34
      } catch (ALPageNotFoundException ex) {
        // データなし例外の場合、データなしエラーとする。
        result = null;
        errStatus = ScheduleConst.ERR_STATUS_NO_DATA;
      } catch (Exception ex) {
        // その他の例外は、通常エラーとする。
        result = null;
        errStatus = ScheduleConst.ERR_STATUS_NORMAL;
      }
      // add end
      // change start
      // 運用課題No.34
      // }
    } else {
      result = null;
      // 閲覧権限なしの場合、データなしエラーとする。
      errStatus = ScheduleConst.ERR_STATUS_NO_DATA;
    }

    // add start ２次開発受入テスト障害No.10(運用フェーズ課題・障害台帳No.176)
    if (!ScheduleConst.ERR_STATUS_ERR_NONE.equals(errStatus)) {
      if (mailid != null && !"".equals(mailid) && !isRepresent) {
        try {
          SelectQuery<EipTMail> query = Database.query(EipTMail.class);
          Expression exp = ExpressionFactory.matchDbExp(EipTMail.MAIL_ID_PK_COLUMN, mailid);
          EipTMail mail = query.andQualifier(exp).fetchSingle();
          if (mail != null) {
            mail.setReadFlg("T");
            Database.commit();
          }
        } catch (Exception e) {
          Database.rollback();
          logger.error("スケジュール詳細の取得に失敗しました。ログインユーザー:" + loginUserName + "/メールID:" + mailid + "/対象ユーザー:" + userid, e);
        }
      }
      // add end
    }
    // add end

    // change end
    return result;
    // change end
  }

  /**
   * 
   * @param obj
   * @return
   */
  @Override
  protected Object getResultData(EipTSchedule obj) {
    // このメソッドは利用されません。
    return null;
  }

  /**
   * 
   * @param record
   * @return
   * @throws ALPageNotFoundException
   * @throws ALDBErrorException
   */
  @Override
  protected Object getResultDataDetail(EipTSchedule record) throws ALPageNotFoundException, ALDBErrorException {
    ScheduleDetailResultData rd = new ScheduleDetailResultData();
    rd.initField();
    // add start
    // 必須と任意参加メンバー一覧を初期化
    reqMembers = new ArrayList<ScheduleMemberUser>(0);
    subMembers = new ArrayList<ScheduleMemberUser>(0);
    members = new ArrayList<ALEipUser>(0);
    // add end
    try {

      // change start
      // ユーザー表示順のスケジュールマップを取得する
      List<ScheduleMemberUser> list = ScheduleUtils.getScheduleMemberUsers(record.getScheduleId());
      for (ScheduleMemberUser smUser : list) {
        // 対象ユーザーの場合
        if (smUser.getUserId().getValue() == userid) {
          // ステータスを設定
          rd.setStatus(smUser.getStatus());
          // 重要フラグ
          rd.setPriority(smUser.getPriority());
          // ダミー未回答フラグ
          rd.setDummyNonResponse(smUser.getDummyNonResponse());
          // 必須フラグ
          rd.setRequired(smUser.getRequired());
          // add start 要件No.26 スケジュール個別色換え
          // 個別色（色コード）
          rd.setIndividualColor(smUser.getIndividualColor());
          // add end
          // ユーザー
          rd.setUser(smUser);
        }
        // 参加メンバーを必須と任意で仕分け
        if (smUser.isRequired()) {
          reqMembers.add(smUser);
        } else {
          subMembers.add(smUser);
        }
        // デグレード対応
        members.add(smUser);
      }

      // // 選択した予定に対するダミースケジュールを検索
      // SelectQuery<EipTSchedule> schedulequery =
      // Database.query(EipTSchedule.class);
      // Expression exp1 =
      // ExpressionFactory.matchExp(EipTSchedule.PARENT_ID_PROPERTY, record
      // .getScheduleId());
      // Expression exp2 =
      // ExpressionFactory.matchExp(EipTSchedule.START_DATE_PROPERTY, view_date
      // .getValue());
      // schedulequery.setQualifier(exp1);
      // schedulequery.andQualifier(exp2);
      // List<Integer> scheduleList = new ArrayList<Integer>();
      // List<EipTSchedule> dummyScheduleList = schedulequery.fetchList();
      //
      // scheduleList.add(record.getScheduleId());
      // for (EipTSchedule dummy : dummyScheduleList) {
      // scheduleList.add(dummy.getScheduleId());
      // }
      //
      // // 元のスケジュール及びダミースケジュールに登録されているマップを検索
      // SelectQuery<EipTScheduleMap> mapquery =
      // Database.query(EipTScheduleMap.class);
      // Expression mapexp1 =
      // ExpressionFactory.inExp(
      // EipTScheduleMap.SCHEDULE_ID_PROPERTY,
      // scheduleList);
      // mapquery.setQualifier(mapexp1);
      // mapquery.orderAscending(EipTScheduleMap.SCHEDULE_ID_PROPERTY);
      //
      // List<EipTScheduleMap> list = mapquery.fetchList();

      // List<Integer> users = new ArrayList<Integer>();
      // List<Integer> facilityIds = new ArrayList<Integer>();
      // int size = list.size();
      // for (int i = 0; i < size; i++) {
      // EipTScheduleMap map = list.get(i);
      // if (ScheduleUtils.SCHEDULEMAP_TYPE_USER.equals(map.getType())) {
      // statusList.put(map.getUserId(), map.getStatus());
      // // 表示するユーザーの場合
      // if (map.getUserId().intValue() == userid) {
      // // 仮スケジュールかどうか
      // rd.setTmpreserve("T".equals(map.getStatus()));
      // // 確定スケジュールかどうか
      // rd.setConfirm("C".equals(map.getStatus()));
      // }
      // users.add(map.getUserId());
      //
      // if (userid == map.getUserId().intValue()) {
      // EipTCommonCategory category = map.getEipTCommonCategory();
      // if (category == null) {
      // rd.setCommonCategoryName(null);
      // } else {
      // rd.setCommonCategoryName(category.getName());
      // }
      // }
      //
      // } else {
      // facilityIds.add(map.getUserId());
      // }
      // }
      // change end

      // remove start
      // 冗長な処理のため削除
      // SelectQuery<TurbineUser> query = Database.query(TurbineUser.class);
      // Expression exp =
      // ExpressionFactory.inDbExp(TurbineUser.USER_ID_PK_COLUMN, users);
      // query.setQualifier(exp);
      // members = ALEipUtils.getUsersFromSelectQuery(query);
      // // members = ALEipUtils.getUsersFromCriteria(rundata, new
      // // Criteria().addIn(
      // // TurbineUserConstants.USER_ID, users));

      // if (facilityIds.size() > 0) {
      // SelectQuery<EipMFacility> fquery = Database.query(EipMFacility.class);
      // Expression fexp =
      // ExpressionFactory.inDbExp(
      // EipMFacility.FACILITY_ID_PK_COLUMN,
      // facilityIds);
      // fquery.setQualifier(fexp);
      // facilities = FacilitiesUtils.getFacilitiesFromSelectQuery(fquery);
      // }
      // remove end
      // facilities = FacilitiesUtils.getFacilitiesFromCriteria(org_id,
      // new Criteria().addIn(EipMFacilityConstants.FACILITY_ID, facilityIds));

      // remove start
      // if (ScheduleUtils.SCHEDULEMAP_TYPE_FACILITY.equals(type)) {
      // // 施設
      // ALEipUser facilityuser = new ALEipUser();
      // facilityuser.initField();
      // facilityuser.setUserId(userid);
      // facilityuser.setName("");
      // facilityuser.setAliasName("", getFacilityName(facilities, userid));
      // rd.setUser(facilityuser);
      // } else {
      // // ユーザー
      // rd.setUser(ALEipUtils.getALEipUser(userid));
      // }
      // remove end

      // タイプ
      rd.setType(type);
      // 開始日時
      rd.setStartDate(record.getStartDate());
      // オーナー
      // change starrt
      // 対象者と主催者が同一かつ権限が[本人]または[秘書]の場合、主催者扱いにする
      // rd.setOwner(record.getOwnerId().intValue() == loginuserid);
      if (record.getOwnerId().intValue() == userid
        && (ScheduleConst.SCHEDULE_ACL_MYSELF.equals(scheduleAcl) || ScheduleConst.SCHEDULE_ACL_SECRETARY.equals(scheduleAcl))) {
        rd.setOwner(true);
      } else {
        rd.setOwner(false);
        // 対象者が主催者でない かつ 権限が[本人]または[秘書]の場合、参加メンバー扱いにする
        if (ScheduleConst.SCHEDULE_ACL_MYSELF.equals(scheduleAcl) || ScheduleConst.SCHEDULE_ACL_SECRETARY.equals(scheduleAcl)) {
          rd.setMember(true);
        } else {
          rd.setMember(false);
        }
      }
      // change end
      // 終了日時
      rd.setEndDate(record.getEndDate());
      // 予定
      rd.setName(record.getName());
      // ID
      rd.setScheduleId(record.getScheduleId().intValue());
      // 場所
      rd.setPlace(record.getPlace());
      // 内容
      rd.setNote(record.getNote());
      // 公開するかどうか
      rd.setPublic("O".equals(record.getPublicFlag()));
      // 非表示にするかどうか
      rd.setHidden("P".equals(record.getPublicFlag()));
      // 共有メンバーによる編集／削除フラグ
      rd.setEditFlag("T".equals(record.getEditFlag()));

      // add start 要件No.9 スケジュール表示 （仮の予定、確定した予定）
      rd.setTemporaryFlag(record.getTemporaryFlag());
      // add end

      // DN -> 毎日 (A = N -> 期限なし A = L -> 期限あり)
      // WnnnnnnnN W01111110 -> 毎週(月～金用)
      // MnnN M25 -> 毎月25日
      // S -> 期間での指定
      String ptn = record.getRepeatPattern();

      // change start
      if (ptn.startsWith(ScheduleConst.SCHEDULE_PATTERN_ONEDAY)) {
        // 単発
        rd.setSpan(false);
        rd.setRepeat(false);
      } else if (ptn.startsWith(ScheduleConst.SCHEDULE_PATTERN_SPAN)) {
        // 期間
        rd.setSpan(true);
        rd.setRepeat(false);
      } else if (ptn.startsWith(ScheduleConst.SCHEDULE_PATTERN_DAYS)) {
        // 日またぎ
        rd.setSpan(false);
        rd.setRepeat(false);
      } else {
        // 繰り返し予定
        rd.setSpan(false);
        rd.setRepeat(true);
        // スケジュール定型文
        rd.addText(ScheduleUtils.getRepeatScheduleFixedText(ptn));
        // 有効期限
        rd.addLimitText("（");
        rd.addLimitText(rd.getStartDate().getYear() + "年");
        rd.addLimitText(rd.getStartDate().getMonth() + "月");
        rd.addLimitText(rd.getStartDate().getDay() + "日 から " + ScheduleUtils.getRepeatLimitEndDateFixedText(rd.getEndDate().getValue(), "yyyy'年'M'月'd'日 まで'"));
        rd.addLimitText("）");
      }
      // int count = 0;
      // boolean is_repeat = true;
      // rd.setRepeat(true);
      // // 毎日
      // if (ptn.charAt(0) == 'D') {
      // rd.addText("毎日");
      // count = 1;
      // // 毎週
      // } else if (ptn.charAt(0) == 'W') {
      // rd.addText(new StringBuffer().append("毎週 ").append(
      // ptn.charAt(1) != '0' ? "日" : "").append(
      // ptn.charAt(2) != '0' ? "月" : "").append(
      // ptn.charAt(3) != '0' ? "火" : "").append(
      // ptn.charAt(4) != '0' ? "水" : "").append(
      // ptn.charAt(5) != '0' ? "木" : "").append(
      // ptn.charAt(6) != '0' ? "金" : "").append(
      // ptn.charAt(7) != '0' ? "土" : "").append(" 曜日").toString());
      // count = 8;
      // // 毎月
      // } else if (ptn.charAt(0) == 'M') {
      // rd.addText(new StringBuffer().append("毎月 ").append(
      // Integer.parseInt(ptn.substring(1, 3))).append("日").toString());
      // count = 3;
      // // 期間
      // } else if (ptn.charAt(0) == 'S') {
      // rd.setSpan(true);
      // rd.setRepeat(false);
      // is_repeat = false;
      // } else {
      // rd.setRepeat(false);
      // is_repeat = false;
      //
      // }
      // if (is_repeat) {
      // if (ptn.charAt(count) == 'N') {
      // rd.setLimit(false);
      // } else {
      // rd.setLimit(true);
      // // 期限
      // rd.addText(new StringBuffer().append(" （").append(
      // rd.getStartDate().getYear()).append("年").append(
      // rd.getStartDate().getMonth()).append("月").append(
      // rd.getStartDate().getDay()).append("日 から ").append(
      // rd.getEndDate().getYear()).append("年").append(
      // rd.getEndDate().getMonth()).append("月").append(
      // rd.getEndDate().getDay()).append("日 まで）").toString());
      // }
      // }
      // change end

      // add start
      // 主催者
      rd.setOwnerUser(ALEipUtils.getALEipUser(record.getOwnerId().intValue()));
      // add end

      // 登録者
      rd.setCreateUser(ALEipUtils.getALEipUser(record.getCreateUserId().intValue()));
      // 更新者
      rd.setUpdateUser(ALEipUtils.getALEipUser(record.getUpdateUserId().intValue()));
      // 登録日時
      rd.setCreateDate(record.getCreateDate());
      // 更新日時
      rd.setUpdateDate(record.getUpdateDate());
      // remove start
      // // 対象者がログインユーザーか否か
      // rd.setLoginuser(loginuserid == userid);
      // remove end
      // Calendar cal = Calendar.getInstance();
      // cal.setTime(record.getStartDate());
      // cal.set(Calendar.HOUR, 0);
      // cal.set(Calendar.MINUTE, 0);
      // view_date.setValue(cal.getTime());

      // add start 要件No.18 会議案内ファイル添付
      rd.setAttachmentFiles(getAttachmentFiles(record.getScheduleId()));
      // add end

      // add start 要件No.1 スケジュール案内受信
      if (mailid != null && !"".equals(mailid) && !isRepresent) {
        SelectQuery<EipTMail> query = Database.query(EipTMail.class);
        Expression exp = ExpressionFactory.matchDbExp(EipTMail.MAIL_ID_PK_COLUMN, mailid);
        EipTMail mail = query.andQualifier(exp).fetchSingle();
        if (mail != null) {
          mail.setReadFlg("T");
          Database.commit();
        }
      }
      // add end

    } catch (Exception e) {
      // add start 要件No.1 スケジュール案内受信
      Database.rollback();
      // add end

      // change start
      // logger.error("Exception", e);
      logger.error("スケジュール詳細の取得に失敗しました。ログインユーザー:" + loginUserName + "/スケジュールID:" + record.getScheduleId() + "/対象ユーザー:" + userid, e);
      // change end
      return null;
    }
    return rd;
  }

  @Override
  protected Attributes getColumnMap() {
    // このメソッドは利用されません。
    return null;
  }

  // remove start
  // 施設廃止対応
  // private String getFacilityName(List<FacilityResultData> list, int id) {
  // FacilityResultData rd = null;
  // int size = list.size();
  // for (int i = 0; i < size; i++) {
  // rd = list.get(i);
  // if (rd.getFacilityId().getValue() == id) {
  // return rd.getFacilityName().getValue();
  // }
  // }
  // return "";
  // }
  // remove end

  /**
   * 共有メンバーを取得します。
   * 
   * @return
   */
  public List<ALEipUser> getMemberList() {
    return members;
  }

  // add start
  /**
   * 参加必須の共有メンバーを取得します。
   * 
   * @return 参加必須の共有メンバー一覧
   */
  public List<ScheduleMemberUser> getReqMemberList() {
    return reqMembers;
  }

  /**
   * 参加任意の共有メンバーを取得します。
   * 
   * @return 参加任意の共有メンバー一覧
   */
  public List<ScheduleMemberUser> getSubMemberList() {
    return subMembers;
  }

  // add end

  // remove start
  // 参加メンバーの状態は参加メンバー自体に格納するため廃止
  // /**
  // * 状態を取得します。
  // *
  // * @param id
  // * @return
  // */
  // public String getStatus(long id) {
  // return statusList.get(Integer.valueOf((int) id));
  // }
  // remove end

  /**
   * 
   * @return
   */
  public ALDateTimeField getViewDate() {
    return view_date;
  }

  public List<FacilityResultData> getFacilityList() {
    return facilities;
  }

  /**
   * アクセス権限チェック用メソッド。<br />
   * アクセス権限の機能名を返します。
   * 
   * @return
   */
  @Override
  public String getAclPortletFeature() {
    return aclPortletFeature;
  }

  /**
   * アクセス権限用メソッド。<br />
   * アクセス権限の有無を返します。
   * 
   * @return
   */
  public boolean hasAuthorityOtherEdit() {
    return hasAuthorityOtherEdit;
  }

  public boolean hasAuthorityOtherDelete() {
    return hasAuthorityOtherDelete;
  }

  public boolean hasAuthoritySelfEdit() {
    return hasAuthoritySelfEdit;
  }

  public boolean hasAuthoritySelfDelete() {
    return hasAuthoritySelfDelete;
  }

  public boolean hasAuthoritySelfInsert() {
    return hasAuthoritySelfInsert;
  }

  // add start
  /*
   * @see com.aimluck.eip.common.ALAbstractSelectData#doCheckAclPermission(RunData
   *      rundata, Context context,int defineAclType)
   */
  @Override
  protected boolean doCheckAclPermission(RunData rundata, Context context, int defineAclType) throws ALPermissionException {
    // 基幹権限チェックを必ず「可」にする
    return true;
  }

  // add end

  // add start 要件No.1 スケジュール案内受信
  public String getMailId() {
    return mailid;
  }

  // add end

  // add start 要件No.18 会議案内ファイル添付
  /**
   * スケジュールに添付されているファイルリストを取得
   * 
   * @param scheduleid
   *            スケジュールID
   * @return ファイルリスト
   */
  private List<FileuploadBean> getAttachmentFiles(int scheduleid) {
    SelectQuery<AvzTScheduleFile> query = Database.query(AvzTScheduleFile.class);
    Expression exp = ExpressionFactory.matchDbExp(EipTSchedule.SCHEDULE_ID_PK_COLUMN, Integer.valueOf(scheduleid));
    query.setQualifier(exp);
    query.orderAscending(AvzTScheduleFile.UPDATE_DATE_PROPERTY);

    List<AvzTScheduleFile> list = query.fetchList();
    List<FileuploadBean> attachmentFileList = new ArrayList<FileuploadBean>();
    if (list != null && list.size() > 0) {
      FileuploadBean filebean = null;
      AvzTScheduleFile file = null;
      int size = list.size();
      for (int i = 0; i < size; i++) {
        file = list.get(i);
        String realname = file.getFileName();
        javax.activation.DataHandler hData = new javax.activation.DataHandler(new javax.activation.FileDataSource(realname));

        filebean = new FileuploadBean();
        filebean.setFileId(file.getFileId().intValue());
        filebean.setFileName(realname);
        if (hData != null) {
          filebean.setContentType(hData.getContentType());
        }
        filebean.setIsImage(FileuploadUtils.isImage(realname));
        attachmentFileList.add(filebean);
      }
    }

    return attachmentFileList;
  }
  // add end

}
