if(!dojo._hasResource["aipo.schedule.dnd.OneDaySpanScheduleAreaMove"]){
dojo._hasResource["aipo.schedule.dnd.OneDaySpanScheduleAreaMove"] = true;
/*
 * Aipo is a groupware program developed by Aimluck,Inc.
 * http://www.aipo.com/
 *
 * Copyright(C) 2012 avanza Co.,Ltd. All rights reserved.
 * http://www.avnz.co.jp/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

// 1日スケジュール期間予定領域クリック・ドラッグ＆ドロップ
dojo.provide("aipo.schedule.dnd.OneDaySpanScheduleAreaMove");

dojo.require("aimluck.dnd.Draggable");
dojo.require("aipo.common");
dojo.require("aipo.schedule");

/** 
 * 1日スケジュール用期間予定領域ドラッグ＆ドロップコントローラー
 */
dojo.declare("aipo.schedule.dnd.OneDaySpanScheduleAreaDraggable", [aimluck.dnd.Draggable], {
    // 操作対象ユーザーID
    targetUserId: null,
    // 操作可否判定
    canCreate: false,
    /** コンストラクタ */
    constructor: function(node, params){
        this.index = params.idx;
    },
    /** マウス押下 */
    onMouseDown: function(e){
        // 処理なし
    },
    /** クリック */
    onScheduleClick: function(e) {
        // ログインユーザーまたは秘書元ユーザーの領域で無い場合、編集不可にする
        if(!this.canCreate){
            return;
        }
        var targetDate = ptConfig[this.portletId].jsonData.formDateTime;
        aipo.common.showWindow(
            ptConfig[this.portletId].formUrl 
            + "&entityid=new&mode=form&is_span=TRUE" 
            + "&form_start=" + targetDate + '&form_end=' + targetDate 
            + '&userid=' + this.targetUserId, 
            this.portletId, 
            aipo.schedule.onLoadScheduleDialog );
    }
});

}