/*
 * Aipo is a groupware program developed by Aimluck,Inc.
 * Copyright (C) 2004-2011 Aimluck,Inc.
 * http://www.aipo.com
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

dojo.provide("aipo.schedule");

dojo.require("aipo.widget.ToolTip");
dojo.require("aipo.widget.DropdownDatepicker");
dojo.require("aipo.widget.MemberNormalSelectList");
dojo.require("aipo.widget.MemberAbNormalSelectList");
dojo.require("aipo.widget.GroupNormalSelectList");
dojo.require("aipo.widget.MemberGroupSendSelectList");
// add start
dojo.require("aipo.schedule.common");
// add end

var tooltipObjects;

aipo.schedule.closeTooltip = function() {
  if( tooltipObjects ) {
    for( var i = 0; i<tooltipObjects.length; i++ ) {
      var obj = tooltipObjects[i];
      obj.close();
    }
  }
}

aipo.schedule.setupTooltip = function(url, entityids, portlet_id) {

    tooltipObjects = new Array();

    ptConfig[portlet_id].isTooltipEnable = true;

    if (entityids.length <= 0) {
        return;
    }

    // IPADではツールチップ非表示
    if (scheduleTooltipEnable != true) {
        return;
    }

    var entity_ids = entityids.split(",");
    var processed_ids = new Array();
    entity_ids.pop();

    for (var i in entity_ids) {
        entity_ids[i] = dojo.trim(entity_ids[i]);
        if (processed_ids[entity_ids[i]]) {
            continue;
        }
        processed_ids[entity_ids[i]] = true;



        var nodeList = new Array();
        dojo.query('.schedule-' + portlet_id + '-' + entity_ids[i]).forEach(function(node, index, arr){
            nodeList.push(node);
        });

        var tooltipObject = new aipo.widget.ToolTip({
            label: "<div class='indicator'>読み込み中...</div>",
            connectId: nodeList
        }, portlet_id, function(containerNode, node){
            var regExp = new RegExp("schedule-" + portlet_id + "-([0-9]+)");
            var className = node.className.match(regExp);
            if (className) {
                var request_url = url + '&scheduleid=' + className[1];
                // change start
                //aipo.schedule.showTooltip(node, request_url, className[1], portlet_id, containerNode);
                aipo.schedule.common.showTooltip(request_url, portlet_id, containerNode);
                // change end
            }
        });
        // remove start
        // 2重起動防止の前準備と思われるが正しく機能していないため、削除
        dojo.query('.schedule-' + portlet_id + '-' + entity_ids[i]).forEach(function(node, index, arr){
            node.setAttribute('widget_id', tooltipObject.id);
        });
        // remove end

        tooltipObjects.push(tooltipObject);
    }
}

// remove start
//aipo.schedule.showTooltip = function(obj, url, entityid, portlet_id, containerNode) {
//    var tooltipObject;
//
//    var datehtml = "";
//    var mbhtml = "";
//    var mbfhtml = "";
//    var placehtml = "";
//
//    var widget = dijit.byId(obj.getAttribute('widget_id'))
//    if (widget.processed) {
//        return;
//    }
//
//    dojo.xhrGet({
//        portletId: portlet_id,
//        url: url,
//        encoding: "utf-8",
//        handleAs: "json-comment-filtered",
//        load: function(schedule, event) {
//            if (schedule.length <= 0) {
//                return;
//            }
//
//            if (!schedule.isSpan) {
//                datehtml = "<span style=\"font-size: 0.90em;\">" + schedule.date + "</span><br/>";
//            }
//
//            if (schedule.memberList) {
//                var memberSize = schedule.memberList.length;
//                for (var i = 0 ; i < memberSize ; i++) {
//                    mbhtml += "<li>" + schedule.memberList[i].aliasName.value + "</li>";
//                }
//            }
//
//            if (schedule.facilityList) {
//                var facilitySize = schedule.facilityList.length;
//                for (var i = 0 ; i < facilitySize ; i++) {
//                    mbfhtml += "<li>" + schedule.facilityList[i].facilityName.value + "</li>";
//                }
//            }
//
//            if(schedule.place != ""){
//                placehtml = "<span style=\"font-size: 0.90em;\">場所</span><br/><ul><li>" + schedule.place + "</li></ul>";
//            }
//
//            var tooltiphtml = "<h4>" + schedule.name + "</h4>" + datehtml + mbhtml + mbfhtml + placehtml;
//            widget.label = tooltiphtml;
//            widget.processed = true;
//            containerNode.innerHTML = tooltiphtml;
//        }
//    });
//}
//remove end

aipo.schedule.hideDialog = function() {
    var arrDialog = dijit.byId("modalDialog");
    if(arrDialog){
       arrDialog.hide();
    }

    aipo.portletReload('schedule');
};


aipo.schedule.onLoadScheduleDetail = function(portlet_id){
    aipo.portletReload('whatsnew');
}

aipo.schedule.onLoadScheduleDialog = function(portlet_id){

    // 共有カテゴリ連携
    var common_url = dojo.byId('commonUrl'+portlet_id);
    if(common_url){
        var common_category_id = dojo.byId('commonCategoryid'+portlet_id);
        params = {
            url:common_url.value,
            key:"categoryId",
            value:"categoryName",
            selectedId:common_category_id.value,
            preOptions: { key:'1', value:'（未分類）' }
        };
        aimluck.io.createOptions("common_category_id", params);

        var mpicker = dijit.byId("membernormalselect");
        if(mpicker){
            var select = dojo.byId('init_memberlist');
            var i;
            var s_o = select.options;
            if (s_o.length == 1 && s_o[0].value == "") return;
            for(i = 0 ; i < s_o.length; i ++ ) {
                mpicker.addOptionSync(s_o[i].value,s_o[i].text,true);
            }

            // add start
            // 任意／必須対応
            var select = dojo.byId('init_selfish_memberlist');
            var i;
            var s_o = select.options;
            if (s_o.length == 1 && s_o[0].value == "") return;
            for(i = 0 ; i < s_o.length; i ++ ) {
                mpicker.addSelfishOptionSync(s_o[i].value,s_o[i].text,true);
            }
            // add end
        }

        var fpicker = dijit.byId("facilityselect");
        if(fpicker){
            var select = dojo.byId('init_facilitylist');
            var i;
            var s_o = select.options;
            if (s_o.length == 1 && s_o[0].value == "") return;
            for(i = 0 ; i < s_o.length; i ++ ) {
                fpicker.addOptionSync(s_o[i].value,s_o[i].text,true);
            }
        }

        var obj = dojo.byId("name");
        if(obj){
           obj.focus();
        }

        var btn_ma = dojo.byId("button_member_add");
        if(btn_ma){
           dojo.connect(btn_ma, "onclick", function(){
              aipo.schedule.expandMember();
           });
        }

        var btn_mr = dojo.byId("button_member_remove");
        if(btn_mr){
           dojo.connect(btn_mr, "onclick", function(){
              // remove start
              // 主催者も削除可能にする
//              var select = dojo.byId("member_to");
//              if(select.options.length == 0){
//                  if((mpicker) && (aipo.schedule.login_aliasname != "undefined")){
//                      var alias = aipo.schedule.login_aliasname.replace(/&amp;/g, "&").replace(/&quot;/g, "\"").replace(/&lt;/g, "<").replace(/&gt;/g, ">");
//                      mpicker.addOptionSync(aipo.schedule.login_name, alias, true);
//                  }
//              }
              // remove end
              aipo.schedule.expandMember();
           });
        }

        //add start
        // 任意／必須対応
        var btn_sma = dojo.byId("button_selfish_member_add");
        if(btn_sma){
           dojo.connect(btn_sma, "onclick", function(){
              aipo.schedule.expandMember();
           });
        }

        var btn_smr = dojo.byId("button_selfish_member_remove");
        if(btn_smr){
           dojo.connect(btn_smr, "onclick", function(){
              aipo.schedule.expandMember();
           });
        }
        //add end

        var btn_fa = dojo.byId("button_facility_add");
        if(btn_fa){
           dojo.connect(btn_fa, "onclick", function(){
              aipo.schedule.expandFacility();
           });
        }

        var btn_fr = dojo.byId("button_facility_remove");
        if(btn_fr){
           dojo.connect(btn_fr, "onclick", function(){
              aipo.schedule.expandFacility();
           });
        }

        var form = dojo.byId('_scheduleForm');
        if(form){
          form.ignore_duplicate_facility.value = "false";
        }

        aipo.schedule.shrinkMember();
        aipo.schedule.shrinkFacility();

        var spanStart = dijit.byId('startDateSpan');
        var spanEnd = dijit.byId('endDateSpan');
        if (spanStart != null && spanEnd != null) {
            var sDate = spanStart.dropDown.value;
            var eDate = spanEnd.dropDown.value;
            aipo.schedule.spanLength = (eDate - sDate)/86400000;
        } else {
            aipo.schedule.spanLength = 0;
        }
    }
}

aipo.schedule.formPreSubmit = function (form) {
    var member_to = dojo.byId('member_to');
    var facility_to = dojo.byId('facility_to');
    if(member_to) {
        var t_o = member_to.options;
        for(i = 0 ; i < t_o.length; i++ ) {
            t_o[i].selected = true;
        }
    }
    if(facility_to) {
        var f_o = facility_to.options;
        for(i = 0 ; i < f_o.length; i++ ) {
            f_o[i].selected = form.public_flag[0].checked;
        }
    }
    if(form.is_span.value == 'TRUE' || form.is_span.value == 'true') {
        form.start_date_hour.value = 0;
        form.start_date_minute.value = 0;
        form.end_date_hour.value = 0;
        form.end_date_minute.value = 0;
    } else {
        form.end_date_year.value = form.start_date_year.value;
        form.end_date_month.value = form.start_date_month.value;
        form.end_date_day.value = form.start_date_day.value;
    }
}

aipo.schedule.formSwitchRepeat = function(button) {
    if(button.form.is_repeat.value == 'TRUE' || button.form.is_repeat.value == 'true') {
        button.value = '繰り返す';
        aipo.schedule.formRepeatOff(button.form);
    } else {
        button.value = '繰り返さない';
        aipo.schedule.formRepeatOn(button.form);
    }
}


aipo.schedule.isShowFacility = function(scheduleform) {
    var public_flag = scheduleform.public_flag;
    for(var i = 0 ; i < public_flag.length; i++) {
        if (public_flag[i].checked && public_flag[i].value == 'O') {
            return true;
        }
    }
    return false;
}

aipo.schedule.formSwitchAllDay = function(checkbox) {
    if(checkbox.checked) {
        aipo.schedule.formAllDayOn(checkbox);
    } else {
        aipo.schedule.formAllDayOff(checkbox);
    }
}

// add start 要件No.9 スケジュール表示 （仮の予定、確定した予定）
aipo.schedule.formSwitchTemporary = function(checkbox) {
    if(checkbox.checked) {
        aipo.schedule.formTemporaryOn(checkbox);
    } else {
        aipo.schedule.formTemporaryOff(checkbox);
    }
}
// add end

aipo.schedule.formSwitchSpan = function(button) {
    if(button.form.is_span.value == 'TRUE' || button.form.is_span.value == 'true') {
        button.value = '期間で指定する';
        if(button.form.is_repeat.value != 'TRUE' && button.form.is_repeat.value != 'true') {
            button.form.repeat_button.value = '繰り返す';
            aipo.schedule.formRepeatOff(button.form);
        } else {
            button.form.repeat_button.value = '繰り返さない';
            aipo.schedule.formRepeatOn(button.form);
        }
        aipo.schedule.formSpanOff(button.form);
    } else {
        button.value = '時間で指定する';
        aipo.schedule.formSpanOn(button.form);
    }
}

aipo.schedule.formSpanOn = function(form) {
    dojo.byId('repeatField').style.display = "none";
    dojo.byId('timeLabelField').style.display = "none";
    dojo.byId('timeField').style.display = "none";
    dojo.byId('repeatButtonField').style.display = "none";
    dojo.byId('normalField').style.display = "";
    dojo.byId('spanField').style.display = "";
    dojo.byId('allDayField').style.display = "none";

    dojo.byId('facilityField').style.display = "none";
    dojo.byId('facilityFieldButton').style.display = "none";

    form.is_span.value = 'TRUE';
}

aipo.schedule.formSpanOff = function(form) {
    dojo.byId('spanField').style.display = "none";
    dojo.byId('repeatField').style.display = "none";
    dojo.byId('timeLabelField').style.display = "none";
    dojo.byId('repeatButtonField').style.display = "";
    dojo.byId('normalField').style.display = "";
    dojo.byId('timeField').style.display = "";
    dojo.byId('allDayField').style.display = "";

    if (aipo.schedule.isShowFacility(form)) {
        dojo.byId('facilityFieldButton').style.display = "block";
        aipo.schedule.shrinkFacility();
    }

    form.is_repeat.value = 'FALSE';
    form.is_span.value = 'FALSE';
}


aipo.schedule.formRepeatOff = function(form) {
    dojo.byId('repeatField').style.display = "none";
    dojo.byId('timeLabelField').style.display = "none";
    dojo.byId('spanField').style.display = "none";
    dojo.byId('repeatButtonField').style.display = "";

    dojo.byId('normalField').style.display = "";
    dojo.byId('timeField').style.display = "";

    dojo.byId('spanButtonField').style.display = "";

    form.is_repeat.value = 'FALSE';
    form.is_span.value = 'FALSE';
}

aipo.schedule.formEditRepeatOne = function(form) {
    dojo.byId('repeatField').style.display = "none";
    dojo.byId('timeLabelField').style.display = "none";
    dojo.byId('spanField').style.display = "none";
    dojo.byId('spanButtonField').style.display = "none";
    dojo.byId('repeatButtonField').style.display = "none";
    dojo.byId('allDayField').style.display = "none";

    dojo.byId('normalField').style.display = "";
    dojo.byId('timeField').style.display = "";

    form.is_repeat.value = 'FALSE';
    form.is_span.value = 'FALSE';
}

aipo.schedule.formEditRepeatAll = function(form) {
    dojo.byId('normalField').style.display = "none";
    dojo.byId('spanField').style.display = "none";
    dojo.byId('spanButtonField').style.display = "none";
    dojo.byId('repeatField').style.display = "";
    dojo.byId('repeatField').text = '繰り返さない';
    dojo.byId('repeatButtonField').style.display = "";
    dojo.byId('allDayField').style.display = "none";

    dojo.byId('timeLabelField').style.display = "";
    dojo.byId('timeField').style.display = "";

    form.is_repeat.value = 'TRUE';
    form.is_span.value = 'FALSE';
}

aipo.schedule.formRepeatOn = function(form) {
    dojo.byId('normalField').style.display = "none";
    dojo.byId('spanField').style.display = "none";

    dojo.byId('spanButtonField').style.display = "none";
    dojo.byId('repeatField').style.display = "";
    dojo.byId('repeatButtonField').style.display = "";

    dojo.byId('timeLabelField').style.display = "";
    dojo.byId('timeField').style.display = "";

    form.is_repeat.value = 'TRUE';
    form.is_span.value = 'FALSE';
}

aipo.schedule.formAllDayOn = function(checkbox) {
    dojo.byId('spanField').style.display = "none";
    dojo.byId('repeatField').style.display = "none";
    dojo.byId('timeLabelField').style.display = "none";
    dojo.byId('repeatButtonField').style.display = "none";
    dojo.byId('normalField').style.display = "";
    dojo.byId('timeField').style.display = "none";
    dojo.byId('spanButtonField').style.display = "none";

    dojo.byId('facilityFieldButton').style.display = "none";
    aipo.schedule.shrinkFacility();

    checkbox.form.is_repeat.value = 'FALSE';
    checkbox.form.is_span.value = 'TRUE';
}

aipo.schedule.formAllDayOff = function(checkbox) {
    dojo.byId('spanField').style.display = "none";
    dojo.byId('repeatField').style.display = "none";
    dojo.byId('timeLabelField').style.display = "none";
    dojo.byId('repeatButtonField').style.display = "";
    dojo.byId('normalField').style.display = "";
    dojo.byId('timeField').style.display = "";
    dojo.byId('spanButtonField').style.display = "";

    if (aipo.schedule.isShowFacility(checkbox.form)) {
        dojo.byId('facilityFieldButton').style.display = "block";
    }

    checkbox.form.is_repeat.value = 'FALSE';
    checkbox.form.is_span.value = 'FALSE';
}

// add start 要件No.9 スケジュール表示 （仮の予定、確定した予定）
aipo.schedule.formTemporaryOn = function(checkbox) {
  checkbox.form.is_temporary.value = 'TRUE';
}
aipo.schedule.formTemporaryOff = function(checkbox) {
  checkbox.form.is_temporary.value = 'FALSE';
}
// add end

aipo.schedule.formPublicOn = function(form) {
    if(form.is_span.value != 'TRUE' && form.is_span.value != 'true'){
        form.is_facility.value = "TRUE";
    }
    dojo.byId('facilityFieldButton').style.display = "block";
    aipo.schedule.shrinkFacility();
}

aipo.schedule.formPublicOff = function(form) {
    if(form.is_span.value != 'TRUE' && form.is_span.value != 'true'){
        form.is_facility.value = "FALSE";
    }
    dojo.byId('facilityField').style.display = "none";
    dojo.byId('facilityFieldButton').style.display = "none";
}

aipo.schedule.enablePerWeek = function(form){
    form.repeat_type[1].checked = true;
}

aipo.schedule.enableMonth = function(form){
    if(! form.repeat_type[2].checked){
        form.repeat_type[2].checked = true;
    }
}

aipo.schedule.buttonEdit = function(form, editurl) {
    aimluck.io.disableForm(form, true);
    aipo.common.showDialog(editurl);
}

aipo.schedule.buttonChangeStatus = function(form, changeurl, status, indicator_id, portlet_id) {
    form.action = changeurl  + "&status=" + status;
    aimluck.io.submit(form, indicator_id, portlet_id, aipo.schedule.onReceiveMessage);
}

aipo.schedule.delFlag0 = function(form) {
    form.del_member_flag.value = "0";
    form.del_range_flag.value = "0";
}

aipo.schedule.delFlag1 = function(form) {
    form.del_member_flag.value = "0";
    form.del_range_flag.value = "1";
}

aipo.schedule.delFlag2 = function(form) {
    form.del_member_flag.value = "1";
    form.del_range_flag.value = "0";
}

aipo.schedule.delFlag3 = function(form) {
    form.del_member_flag.value = "1";
    form.del_range_flag.value = "1";
}

// remove start
// 無意味な処理であるため削除
//aipo.schedule.changeEnd = function(form) {
//  if(form.end_date_hour.value == 24) {
//    form.end_date_minute.value = 0;
//  }
//}
// remove end

/**
 * スケジュール作成（編集）のSubmit直前に、入力値を変更します。
 * @param form 入力フォーム
 */
aipo.schedule.onSubmit = function(form) {
    if((form.is_span.value != "TRUE") && (form.is_span.value != "true")
      && (form.is_repeat.value != "TRUE") && (form.is_repeat.value != "true")){
        form.end_date.value = form.start_date.value;
        form.end_date_day.value = form.start_date_day.value;
        form.end_date_month.value = form.start_date_month.value;
        form.end_date_year.value = form.start_date_year.value;
        form.limit_end_date.value = form.limit_start_date.value;
        form.limit_end_date_day.value = form.limit_start_date_day.value;
        form.limit_end_date_month.value = form.limit_start_date_month.value;
        form.limit_end_date_year.value = form.limit_start_date_year.value;
    }
}

aipo.schedule.onReceiveMessage = function(msg){
  if(!msg) {
    var arrDialog = dijit.byId("modalDialog");
    if(arrDialog){
      arrDialog.hide();
    }
    aipo.portletReload('schedule');
  }
}

//add start
/**
 * スケジュール作成編集用の参加メンバー文字列を返します。
 *
 * @param reqMembers 必須参加メンバー
 * @param subMembers 任意参加メンバー
 * @return 参加メンバー文字列
 */
aipo.schedule.getMemberHtml = function(reqMembers, subMembers){
    var memberHtml = "";
    // 必須メンバー
    if(reqMembers){
        var t_o = reqMembers.options;
        to_size = t_o.length;

        if( to_size>0 ) {
            // change start
            //memberHtml += "【参加必須】<br/>";
            memberHtml += "【参加必須】&nbsp;";
            // change end
        }

        for(i = 0 ; i < to_size; i++ ) {
            var text = t_o[i].text.replace(/&/g, "&amp;").replace(/"/g, "&quot;").replace(/</g, "&lt;").replace(/>/g, "&gt;");
            memberHtml += "<span>" +  text + "</span>";
            if(i < to_size - 1){
                memberHtml += ",<wbr/>";
            }
        }
    }

    if(reqMembers && reqMembers.options.length > 0 && subMembers && subMembers.options.length > 0){
        memberHtml += "<br/>";
    }

    // 任意メンバー
    if(subMembers){
        var t_o = subMembers.options;
        to_size = t_o.length;

        if( to_size>0 ) {
            // change start
            //memberHtml += "【参加任意】<br/>";
            memberHtml += "【参加任意】&nbsp;";
            // change end
        }

        for(i = 0 ; i < to_size; i++ ) {
            var text = t_o[i].text.replace(/&/g, "&amp;").replace(/"/g, "&quot;").replace(/</g, "&lt;").replace(/>/g, "&gt;");
            memberHtml += "<span>" +  text + "</span>";
            if(i < to_size - 1){
                memberHtml += ",<wbr/>";
            }
        }
    }
    return memberHtml;
}
// add end

/**
 * スケジュール作成編集の参加メンバー欄を描画します。（初期表示時）
 *
 */
aipo.schedule.shrinkMember = function(){
   var node = dojo.byId("memberFieldButton");
   if(node){
       var HTML = "";
       HTML += "<table style=\"width:98%;\"><tbody><tr><td style=\"width:80%; border:none;\">";
       // change start
//     var m_t = dojo.byId("member_to");
//     if(m_t){
//         var t_o = m_t.options;
//         to_size = t_o.length;
//         for(i = 0 ; i < to_size; i++ ) {
//           var text = t_o[i].text.replace(/&/g, "&amp;").replace(/"/g, "&quot;").replace(/</g, "&lt;").replace(/>/g, "&gt;");
//           HTML += "<span>" + text + "</span>";
//           if(i < to_size - 1){
//               HTML += ",<wbr/>";
//           }
//         }
//     }
       // 必須/任意対応
       HTML += aipo.schedule.getMemberHtml(dojo.byId("member_to"), dojo.byId("selfish_member_to"));
       // change end
        HTML += "</td><td style=\"border:none;\">";
        HTML += '<input type=\"button\" class=\"alignright\" value=\"参加メンバー選択\" onclick=\"aipo.schedule.expandMember();\" />'
        HTML += "</td></tr></tbody></table>";
       node.innerHTML = HTML;
   }

   var _node = dojo.byId("memberField");
   if(_node){
       dojo.style(_node, "display" , "none")
   }
}

/**
 * スケジュール作成編集の参加メンバー欄を描画します。（追加/削除時）
 *
 */
aipo.schedule.expandMember = function(){
   var node = dojo.byId("memberFieldButton");
   if(node){
       var HTML = "";
       HTML += "<table style=\"width:98%;\"><tbody><tr><td style=\"width:80%; border:none\">";
       // add start
       // 必須/任意対応
//       var m_t = dojo.byId("member_to");
//       if(m_t){
//            var t_o = m_t.options;
//            to_size = t_o.length;
//            for(i = 0 ; i < to_size; i++ ) {
//              var text = t_o[i].text.replace(/&/g, "&amp;").replace(/"/g, "&quot;").replace(/</g, "&lt;").replace(/>/g, "&gt;");
//              HTML += "<span>" +  text + "</span>";
//              if(i < to_size - 1){
//                  HTML += ",<wbr/>";
//              }
//            }
//       }
       HTML += aipo.schedule.getMemberHtml(dojo.byId("member_to"), dojo.byId("selfish_member_to"));
       // change end
       HTML += "</td><td style=\"border:none;\">";
       HTML += '<input type=\"button\" class=\"alignright\" value=\"選択画面を隠す\" onclick=\"aipo.schedule.shrinkMember();\" />'
       HTML += "</td></tr></tbody></table>";
       node.innerHTML = HTML;
   }

   var _node = dojo.byId("memberField");
   if(_node){
       dojo.style(_node, "display" , "block");
   }
}

aipo.schedule.shrinkFacility = function(){
   var node = dojo.byId("facilityFieldButton");
   if(node){
       var HTML = "";
       HTML += "<table style=\"width:98%;\"><tbody><tr><td style=\"width:80%; border:none;\">";
       var f_t = dojo.byId("facility_to");
        if(f_t){
            var t_o = f_t.options;
            to_size = t_o.length;
            for(i = 0 ; i < to_size; i++ ) {
              HTML += "<span>" +  t_o[i].text + "</span>";
              if(i < to_size - 1){
                  HTML += ",<wbr/>";
              }
            }
        }
        HTML += "</td><td style=\"border:none;\">";
        HTML += '<input type=\"button\" class=\"alignright\" value=\"施設予約\" onclick=\"aipo.schedule.expandFacility();\" />'
        HTML += "</td></tr></tbody></table>";
       node.innerHTML = HTML;
   }

   var _node = dojo.byId("facilityField");
   if(_node){
       dojo.style(_node, "display" , "none")
   }
}

aipo.schedule.expandFacility = function(){
   var node = dojo.byId("facilityFieldButton");
   if(node){
       var HTML = "";
       HTML += "<table style=\"width:98%;\"><tbody><tr><td style=\"width:80%; border:none\">";
       var f_t = dojo.byId("facility_to");
       if(f_t){
            var t_o = f_t.options;
            to_size = t_o.length;
            for(i = 0 ; i < to_size; i++ ) {
              var text = t_o[i].text.replace(/&/g, "&amp;").replace(/"/g, "&quot;").replace(/</g, "&lt;").replace(/>/g, "&gt;");
              HTML += "<span>" +  text + "</span>";
              if(i < to_size - 1){
                  HTML += ",<wbr/>";
              }
            }
       }
       HTML += "</td><td style=\"border:none;\">";
       HTML += '<input type=\"button\" class=\"alignright\" value=\"選択画面を隠す\" onclick=\"aipo.schedule.shrinkFacility();\" />'
       HTML += "</td></tr></tbody></table>";
       node.innerHTML = HTML;
   }

   var _node = dojo.byId("facilityField");
   if(_node){
       dojo.style(_node, "display" , "block");
   }
}

aipo.schedule.onSpanStartChange = function(){
    var spanStart = dijit.byId('startDateSpan');
    var spanEnd = dijit.byId('endDateSpan');
    if (spanStart != null && spanEnd != null) {
        var newDateMillis = spanStart.dropDown.value.getTime() + 86400000 * aipo.schedule.spanLength;
        var newDate = new Date();
        newDate.setTime(newDateMillis);
        spanEnd.dropDown.onChangeNoCallback(newDate);
        spanEnd.dropDown.setValue(newDate);
    }
}

aipo.schedule.onSpanEndChange = function(){
    var spanStart = dijit.byId('startDateSpan');
    var spanEnd = dijit.byId('endDateSpan');
    if (spanStart != null && spanEnd != null && spanStart.dropDown != null && spanEnd.dropDown != null) {
        var spanStartDate = spanStart.dropDown.value;
        var spanEndDate = spanEnd.dropDown.value;
        if(spanStartDate >= spanEndDate) {
            aipo.schedule.spanLength = 0;
            spanStart.dropDown.onChangeNoCallback(spanEndDate);
            spanStart.dropDown.setValue(spanEndDate);
        } else {
            aipo.schedule.spanLength = (spanEndDate - spanStartDate) / 86400000;
        }
    }
}

//add start
/**
 * 日時調整画面を開きます。
 * @param url 日時調整画面アクションURL
 * @param portlet_id ポートレットID
 * @param callback 日時調整画面アクション実行後に実行したい関数（未使用）
 * @param select 必須参加メンバー一覧（ログイン名）
 * @param selfish_member_to_select 任意参加メンバー一覧（ログイン名）
 * @param viewYear 初期表示させたい年
 * @param viewMonth 初期表示させたい月
 * @param viewDay 初期表示させたい日
 */
aipo.schedule.showAjustDateWindow = function(url, portlet_id, callback, select, selfish_member_to_select, viewYear, viewMonth, viewDay) {

    // 必須参加メンバーを設定
    var t_o = select.options;
    for(i = 0 ;i < t_o.length; i ++ ) {
      if( t_o[i].selected ) {
        url = url + "&member_to=" + t_o[i].value
      }
    }

    // 任意参加メンバーを設定
    var st_o = selfish_member_to_select.options;
    for(i = 0 ;i < st_o.length; i ++ ) {
      if( st_o[i].selected ) {
        url = url + "&selfish_member_to=" + st_o[i].value
      }
    }

    // 表示日付を設定
    url = url + "&view_date=" + viewYear + "-" + viewMonth + "-" + viewDay;

    var wx = 840;
    var wy = 300;
    var x = (screen.width  - wx) / 2;
    var y = (screen.height - wy) / 2;

    var attachment_subwin = window.open(url,"AjustDateWindow","left="+x+",top="+y+",width="+wx+",height="+wy+",resizable=yes,status=yes,menubar=no,toolbar=no,location=no,scrollbars=yes");
    attachment_subwin.focus();
}

// change start No.4 スケジュール印刷（週単位）
/**
 * 印刷用画面を開きます。
 * @param url 印刷用画面アクションURL
 * @param name 画面名
 * @param portlet_id ポートレットID
 * @param callback 印刷用画面アクション実行後に実行したい関数（未使用）
 * @param wx ウィンドウサイズ（横幅）
 * @param wy ウィンドウサイズ（縦幅）
 */
//aipo.schedule.showPrintWindow = function(url, portlet_id, callback) {
aipo.schedule.showPrintWindow = function(url, name, portlet_id, indicator_id, callback) {
  wx = 100;
  wy = 100;
  var x = screen.width;
  var y = screen.height;

  // 時分秒を取得
  d = new Date();
  var hh = d.getHours();
  if (hh < 10) { hh = "0" + hh; }
  var mm = d.getMinutes();
  if (mm < 10) { mm = "0" + mm; }
  var ss = d.getSeconds();
  if (ss < 10) { ss = "0" + ss; }
  name = name + hh + mm + ss;

//    var attachment_subwin = window.open(url,"PrintWindow","left="+x+",top="+y+",width="+wx+",height="+wy+",resizable=no,status=yes,menubar=yes,toolbar=yes,location=no,scrollbars=yes");
    var attachment_subwin = window.open(url, name, "left="+x+",top="+y+",width="+wx+",height="+wy+",resizable=no,status=no,menubar=no,toolbar=no,location=no,scrollbars=no");
    attachment_subwin.focus();
}
// change end No.4 スケジュール印刷（週単位）

/**
 * 指定したラジオボタンを選択状態します。
 * @param radio 操作したいラジオボタン
 */
aipo.schedule.radioChecked = function(radio){
    if(radio && !radio.checked){
        radio.checked = true;
    }
}

/**
 * 時間選択ボタンを状態管理
 *
 * @param my クリックされたボタンオブジェクト
 * @param count クリックされたボタンの位置
 */
aipo.schedule.checkSequence = function(my, count){

  //inset 2px：押下状態
  //outset 2px:定常状態

  var left_obj = dojo.byId("hour_button_" + (count-1));
  var right_obj = dojo.byId("hour_button_" + (count+1));
  if( my.style.border.indexOf("inset")>=0 ) {
    //現状が押下状態の場合、定常状態にしていいボタンかどうかチェックする。
    if( left_obj && right_obj ) {
      //両サイドが有効なボタンの場合
      if( left_obj.style.border.indexOf("inset")>=0
        && right_obj.style.border.indexOf("inset")>=0 ) {
         //両サイドが押下状態の場合は、何もしない。
         return;
      }
    }
  }

  if( my.style.border.indexOf("outset")>=0 ) {
    my.style.border='inset 2px';
  } else {
    my.style.border='outset 2px';
  }

  //押下されたボタンの右側に定常状態のボタンがあればそれ以降は定常状態にする。
  //inset 2px：押下状態
  //outset 2px:定常状態
  var found_right_end = false;
  for(i = count + 1 ;i < 24; i++ ) {
    var obj = dojo.byId("hour_button_" + i);
    if( obj ) {
      if( !found_right_end ) {
        var style_str = obj.style.border;
        var index = style_str.indexOf("outset");
        if( index>0 ) {
          found_right_end = true;
        }
      } else {
        obj.style.border = 'outset 2px';
        //alert(obj.id +  "番目 " + obj.style.border)
      }
    }
  }

  //押下されたボタンの左側に定常状態のボタンがあればそれ以降は定常状態にする。
  //inset 2px：押下状態
  //outset 2px:定常状態
  var found_left_end = false;
  for(i = count - 1 ;i > 0; i-- ) {
    var obj = dojo.byId("hour_button_" + i);
    if( obj ) {
      if( !found_left_end ) {
        var style_str = obj.style.border;
        var index = style_str.indexOf("outset");
        if( index>0 ) {
          found_left_end = true;
        }
      } else {
        obj.style.border = 'outset 2px';
      }
    }
  }

}

/**
 * 時間選択ボタンを初期状態にする。
 */
aipo.schedule.resetHourButton = function(){
  for(i = 1 ;i < 24; i++ ) {
    var obj = dojo.byId("hour_button_" + i);
    if( obj ) {
      obj.style.border = 'outset 2px';
    }
  }
}

/**
 * （日時調整用）スケジュール作成（編集）日時設定
 * @param year 年
 * @param month 月
 * @param day 日
 */
aipo.schedule.selectDate = function( year, month, day ) {

  var shour = -1;
  var ehour = -1;
  for(i = 1 ;i < 24; i++ ) {
    var obj = dojo.byId("hour_button_" + i);
    if( obj ) {
      if( obj.style.border.indexOf("inset")>=0 ) {
        shour = obj.value;
        break;
      }
    }
  }

  if( shour == -1 ) {
    return;
  }

  for(i = 24 ;i > 0; i-- ) {
    var obj = dojo.byId("hour_button_" + i);
    if( obj ) {
      if( obj.style.border.indexOf("inset")>=0 ) {
        ehour = obj.value;
        break;
      }
    }
  }

  ehour = Number(ehour) + 1
  ehour = "" + ehour;

  window.opener.aipo.schedule.setDate( year, month, day, shour, ehour )

  window.close();

}

/**
 * セレクト選択値変更
 * @param select セレクト部品オブジェクト
 * @param value 選択値
 */
aipo.schedule.setSelect = function(select, value) {
    var t_o = select.options;
    for(i = 0 ;i < t_o.length; i ++ ) {
      if( t_o[i].value == value ) {
        t_o[i].selected = true;
      }
    }
}

/**
 * スケジュール作成(編集)画面の入力フォームを日時（単発）入力状態にします。
 */
aipo.schedule.changeNormalInputForm = function() {

    var form = dojo.byId("_scheduleForm");

    form.spanField.style.display = "none";
    form.repeatField.style.display = "none";
    form.timeLabelField.style.display = "none";
    form.normal_button.style.display = "none";
    form.repeat_button.style.display = "";
    form.span_button.style.display = "";
    form.straddle_button.style.display = "";
    form.timeField.style.display = "";
    form.allDayField.style.display = "";

    form.is_repeat.value = "false";;
    form.is_span.value = "false";
    form.is_straddle.value = "false";
}

/**
 * （日時調整用）スケジュール作成（編集）初期化・日時設定
 * @param year 年
 * @param month 月
 * @param day 日
 * @param shour 開始時
 * @param ehour 終了時
 */
aipo.schedule.setDate = function( year, month, day, shour, ehour ) {

  //alert("shour:" + shour + " ehour:" + ehour);

  //aipo.schedule.changeNormalInputForm();
  aipo.schedule.form.changeNormalForm();

  var cal = dijit.byId("startDateSpan");
  cal.dropDown.clearDate();
  cal.dropDown.setValue(new Date (year, month-1, day));

  aipo.schedule.setSelect(dojo.byId("start_date_hour"), shour);
  aipo.schedule.setSelect(dojo.byId("start_date_minute"), 0);
  aipo.schedule.setSelect(dojo.byId("end_date_hour"), ehour);
  aipo.schedule.setSelect(dojo.byId("end_date_minute"), 0);
  dojo.byId("tx_start_time").value = shour + ":00";
  dojo.byId("tx_end_time").value = ehour + ":00";
}

// 秘書・公開設定対応
/**
 * 秘書・公開設定初期表示処理
 *
 * @param portlet_id ポートレットID
 */
aipo.schedule.onLoadScheduleAuthorityDialog = function(portlet_id){

  var gspicker = dijit.byId("groupsendnormalselect");
  if(gspicker){
    var select = dojo.byId('init_groupsendlist');
    var i;
    var s_o = select.options;
    if (s_o.length == 1 && s_o[0].value == "") return;

    for(i = 0 ; i < s_o.length; i ++ ) {
      gspicker.addOptionSync(s_o[i].value,s_o[i].text,true);
    }
  }

  var pmpicker = dijit.byId("memberpublicnormalselect");
  if(pmpicker){
    var select = dojo.byId('init_public_memberlist');
    var i;
    var s_o = select.options;
    if (s_o.length == 1 && s_o[0].value == "") return;
    for(i = 0 ; i < s_o.length; i ++ ) {
      pmpicker.addOptionSync(s_o[i].value,s_o[i].text,true);
    }
  }

  var smpicker = dijit.byId("membersecretarynormalselect");
  if(smpicker){
    var select = dojo.byId('init_secretary_memberlist');
    var i;
    var s_o = select.options;
    if (s_o.length == 1 && s_o[0].value == "") return;
    for(i = 0 ; i < s_o.length; i ++ ) {
      smpicker.addOptionSync(s_o[i].value,s_o[i].text,true);
    }
  }

  //** FIXME IEで追加ダイアログを閉じるとスクロールバーのｙ座標が強制的に０になってしまう現象 2011.11.14
  aipo.schedule.tmpScroll = parseInt(dojo.byId('weeklyScrollPane_'+portlet_id)["scrollTop"]);

}

// 別ウインドウ化対応
/**
 * メッセージ受信処理（別ウインドウ表示対応版）
 *
 * エラーメッセージを受信しなかった場合、ウインドウを閉じます。<br/>
 * エラーメッセージを受信した場合、メッセージ表示エリアにそれを表示します。
 *
 * @param msg エラーメッセージ
 */
aipo.schedule.onReceiveMessageForWindow = function(msg){
    if(!msg) {
        window.opener.aipo.portletReload('schedule');
        window.close();
    }

    if(msg != null && msg.match(/duplicate_facility/)){

        if(confirm('既に同じ時間帯に施設が予約されています。スケジュールを登録しますか？')) {
        var form = dojo.byId('_scheduleForm');
        if(form){
          form.ignore_duplicate_facility.value = "true";

           dojo.xhrPost({
                url: form.action,
                timeout: 30000,
                form: form,
                encoding: "utf-8",
                handleAs: "json-comment-filtered",
                headers: { X_REQUESTED_WITH: "XMLHttpRequest" },
                load: function (response, ioArgs){
                },
                error: function (error) {
                }
            });

          aipo.schedule.onReceiveMessage("");
        }
      }
    }else if (dojo.byId('messageDiv')) {
        dojo.byId('messageDiv').innerHTML = msg;
        // add start 要件No.26 スケジュール個別色換え
        dojo.style(dojo.byId("messageDiv"), "display" , "inline");
        // add end
    }
}

/**
 * 月間スケジュール検索
 *
 * @param exec_url screenクラスURL
 * @param p_id ポートレットID
 * @param change_post1 部署1プルダウン選択時「1」
 */
aipo.schedule.onSearchCorpAddressSubmit = function(exec_url, p_id, change_post1){

  var target_parent_group_name =dojo.byId('target_parent_group_name').value;
  var target_group_name =dojo.byId('target_group_name').value;
  var target_user_id =dojo.byId('target_user_id').value;

// add start No.17 月間スケジュールの部署選択（#272）
  // 閲覧ユーザーで"（選択してください）"が選ばれた時は、リロードしない。
  if (target_user_id == "none") {
	return;
  }
// add end No.17 月間スケジュールの部署選択（#272）

  var search_params = [
                   ["ajax_search_corp","1"],
                   ["target_parent_group_name",target_parent_group_name],
                   ["target_group_name",target_group_name],
                   ["target_user_id",target_user_id],
                   ["change_post1",change_post1]
                  ];

  // change start 要件No.15 スケジュール画面（月単位）カレンダー追加
  //aipo.viewPage(exec_url, p_id, search_params);
  aipo.schedule.common.viewPage(exec_url, p_id, search_params);
  // change end
}
//add end

// add start No.17 月間スケジュールの部署選択（#272）
/**
 * 月間スケジュール
 * 部署2変更時の所属ユーザー表示処理
 *
 * @param link 送信先URL
 * @param group 部署2選択値
 * @param userId ユーザー選択値
 */
aipo.schedule.changeInternalGroup = function(link, group, userId) {
	var url = '';
    if(group == "ALL") {
        // 選択した部署2が"すべて"の場合、部署1の全所属ユーザーを表示
    	url = link + "?mode=post1_group&groupname=" + dojo.byId("target_parent_group_name").value + "&inc_luser=true";
    } else {
        // 選択した部署2が"すべて"以外の場合、選択された部署2の全所属ユーザーを表示
    	url = link + "?mode=group&groupname=" + group + "&inc_luser=true";
    }

    // 所属者リスト作成
    aipo.schedule.createOption("target_user_id", url, "userId", "aliasName", userId, true);
}

/**
 * 月間スケジュール
 * 部署1変更時の表示処理
 *
 * @param link 送信先URL
 * @param option_link リストを選択した時の送信先URL
 * @param parent_post_id 部署1の値
 * @param post_id 部署2選択値
 */
aipo.schedule.changeParentGroup = function(link, option_link, parent_post_id, post_id) {
  var pre = false;

  // 初期表示値がない場合、部署2は"すべて"を初期選択
  // グループ送信（個人指定）の場合、部署2は"（選択してください）"
  var post2_group = "";
  if(parent_post_id == "groupsend_without_post") {
    post2_group = "";
    pre = true;
  } else {
      if (post_id == "") {
        post2_group = "ALL";
      } else {
        post2_group = post_id;
      }
  }
  // 部署2プルダウン生成
  aipo.schedule.createOption("target_group_name", link + "&mode=child&parent_group_name=" + parent_post_id, "groupId", "name", post2_group, pre);
  // ユーザープルダウン生成
  aipo.schedule.changeInternalGroup(option_link, post2_group, '');
}


/**
 *
 * 月間スケジュール
 * プルダウン内容再作成処理
 * aimluck.io.createOptionsでは（選択してください）を常に表示できないため別途作成
 *
 * @param selectId selectボックスのID
 * @param url 送信先URL
 * @param key key名
 * @param name value名
 * @param sel 初期選択値L
 * @param pre 未選択を表示するかどうか（True/False）
 */
aipo.schedule.createOption = function(selectId, url, key, name, sel, pre) {

    dojo.xhrPost({
        url: url,
        timeout: 10000,
        encoding: "utf-8",
        handleAs: "json-comment-filtered",
        headers: { X_REQUESTED_WITH: "XMLHttpRequest" },
        load: function (respodatanse, ioArgs){
            var select = dojo.byId(selectId);
            var index = 0;
            // プルダウン初期化
            select.options.length = 0;
            // （選択してください）を追加
            if (pre) {
              select.options[index] = new Option("（選択してください）", "");
              index++;
            }

            // コンボボックスの内容を作成して追加する
            dojo.forEach(respodatanse, function(p) {
              var tmpKeyName = p[name];
              if( tmpKeyName.indexOf(",", 0)>=0 ) {
                tmpKeyName = "\"" + tmpKeyName + "\"";
              }
              // 同じ値があったらselectedにする。
              var selected = false;
              if(p[key] == sel) {
                selected = true;
              }
              // リストのOptionを作成
              select.options[index] = new Option(tmpKeyName, p[key]);
              select.options[index].selected = selected;
              index++;
            });
        }
    });
};

// add end No.17 月間スケジュールの部署選択（#272）
//add start 要件No.7 スケジュール画面（週単位）
/**
 * スケジュール共通
 * 印刷対象者画面 表示判定処理
 *
 * @param sel_url 印刷対象者画面ＵＲＬ
 * @param show_url 印刷画面用ＵＲＬ
 * @param portlet_id ポートレットＩＤ
 * @param mode 処理モード（週：week、日：day）
 */
aipo.schedule.initScheduleSelectPrintDialog = function(sel_url, show_url, portlet_id, mode) {

    var url = show_url;
    var appList = dojo.byId('app_member_to-' + portlet_id);
    var appList_o = appList.options;
    var obj_indicator = dojo.byId('printIndicator-' + portlet_id);
    var obj_print = dojo.byId('submitPrint-' + portlet_id);

    if(appList_o.length > 1) {
      // 閲覧可メンバーが複数の場合は、印刷対象者画面表示
      aipo.common.showDialog(sel_url, portlet_id, aipo.schedule.onLoadScheduleSelectPrintDialog);
    } else {
      // 印刷中メッセージを表示し、印刷するボタンを非活性
      if(obj_indicator){
          dojo.style(obj_indicator, "display" , "block");
      }
      if(obj_print){
          obj_print.disabled = true;
      }
      url += "&target_user_id=" + appList_o[0].value;
      // 印刷画面を表示
      switch(mode) {
        case 'week':
          // 週間スケジュール印刷
          aipo.schedule.showPrintWindow(url, 'WeeklyPrintWindow', portlet_id, 'printIndicator-' + portlet_id, '');
          break;
        case 'day':
          // １日スケジュール印刷
            aipo.schedule.showPrintWindow(url, 'OneDayPrintWindow', portlet_id, 'printIndicator-' + portlet_id, '');
          break;
        default:
          break;
      }
    }
    //** FIXME IEで追加ダイアログを閉じるとスクロールバーのｙ座標が強制的に０になってしまう現象
    aipo.schedule.tmpScroll = parseInt(dojo.byId('weeklyScrollPane_'+portlet_id)["scrollTop"]);

}

/**
 * スケジュール共通
 * 印刷対象者画面 初期表示処理
 *
 */
aipo.schedule.onLoadScheduleSelectPrintDialog = function() {

    // 閲覧可メンバー一覧
    var portletid = dojo.byId('parent_port_id');
    var appList = dojo.byId('app_member_to-' + portletid.value);
    var appList_o = appList.options;
    // 画面表示先
    var printList = dojo.byId('printMember');
    var HTML = "";
    var i;
    printList.innerHTML = "";

    HTML += "<select style=\"width: 100%; height:150px\" id=\"printMemberList\" size=10>";
    for(i = 0 ; i < appList_o.length; i ++ ) {
        HTML += "<option value=" + appList_o[i].value + ">" + appList_o[i].text + "</option>";
    }
    HTML += "</select>";
    printList.innerHTML += HTML;

}
/**
 * スケジュール共通
 * 印刷対象者画面 印刷するボタン押下処理
 *
 * @param portlet_id ポートレットＩＤ
 * @param mode 処理モード（週：week、日：day）
 */
aipo.schedule.onLoadPrintWindow = function(portletid, mode) {

    // 自画面
    var arrDialog = dijit.byId("modalDialog");
    // 印刷対象者
    var printMember = dojo.byId('printMemberList');
    // 週、日 印刷画面ＵＲＬ
    var weekUrl = dojo.byId('printWeekUrl-' + portletid);
    var dayUrl = dojo.byId('printDayUrl-' + portletid);
    // 印刷中メッセージ
    var obj_indicator = dojo.byId('printIndicator-' + portletid);
    // 週、日画面の「印刷する」ボタン
    var obj_print = dojo.byId('submitPrint-' + portletid);

    var url = "";

    if(printMember.selectedIndex >= 0) {
      var selMemberId = printMember.options[printMember.selectedIndex].value;

      // 印刷中メッセージを表示し、印刷するボタンを非活性
      if(obj_indicator){
          dojo.style(obj_indicator, "display" , "block");
      }
      if(obj_print){
          obj_print.disabled = true;
      }
      switch(mode) {
        case 'week':
          url = weekUrl.value;
          url += "&target_user_id=" + selMemberId;
          // 週間スケジュール印刷
          aipo.schedule.showPrintWindow(url, 'WeeklyPrintWindow', portletid, 'printIndicator-' + portletid, '');
          break;
        case 'day':
          url = dayUrl.value;
          url += "&target_user_id=" + selMemberId;
          // １日スケジュール印刷
          aipo.schedule.showPrintWindow(url, 'OnedayPrintWindow', portletid, 'printIndicator-' + portletid, '');
          break;
        default:
          break;
      }
      // 自画面クローズ
      if(arrDialog){
        arrDialog.hide();
      }
    } else {
        alert("印刷対象者が選択されていません。");
    }

}
// add end

// add start 要件No.4 スケジュール印刷（週単位）
/**
 * スケジュール共通
 *
 * 印刷を実行する。
 * @param 用紙方向（true：縦、false：横）
 *
 */
aipo.schedule.printExecute = function(isVertical) {
  try {
    var factory = dojo.byId('factory');
    factory.printing.header = "";
    factory.printing.footer = "";
    factory.printing.portrait = isVertical; // 用紙方向 true: 縦 false: 横
    factory.printing.leftMargin = 5;
    factory.printing.topMargin = 5;
    factory.printing.rightMargin = 5;
    factory.printing.bottomMargin = 5;
    factory.printing.Print(true); // 印刷実行 true: 印刷ダイアログあり false: 印刷ダイアログなし
  }catch(e) {
	  // オブジェクトが見つからない（ActiveXがインストールされていない）場合は画面を閉じる。
    window.close();
  }
}
//add end

//add start 要件No.3 スケジュール印刷（月単位）
/**
 * スケジュール印刷（月単位）
 *
 * 印刷ボタン押下時の処理。
 *
 */
aipo.schedule.printMonthClick = function(url, name, portlet_id, indicator_id, callback) {
  // 印刷中メッセージを表示
  var obj_indicator = dojo.byId(indicator_id);
  if(obj_indicator){
     dojo.style(obj_indicator, "display" , "block");
  }
  var obj_print = dojo.byId('submitPrint-' + portlet_id);
  if(obj_print){
    obj_print.disabled = true;
  }
  aipo.schedule.showPrintWindow(url, name, portlet_id, indicator_id, callback);
}
//add end

// add start 要件No.15 スケジュール画面（月単位）カレンダー追加
/**
 * 親画面判別処理
 *
 * スケジュール詳細画面で、親画面が月間スケジュール画面なのかチェックする。
 *
 */
aipo.schedule.isMonthlySchedule = function() {
  if( dojo.byId("monthlyScheduleSymbol") ) {
    return true;
  }
  return false;
}

/**
 * 月間スケジュール画面リロード
 */
aipo.schedule.reloadMonthlySchedule = function() {
  var portletId = dojo.byId("portletId").value;
  aipo.schedule.common.viewPage(ptConfig[portletId].initUrl, portletId);
};
// add end
// add start 要件No.11 メール作成／詳細（ファイル添付）
/**
 * アップロード開始
 * @param file アップロードファイル
 */
aipo.schedule.fileQueued = function(file) {
    try {
        // メッセージ初期化
        //var message = dojo.byId('messageDiv');
        //message.innerHTML = "";
        // アップロード用メッセージ初期化
        var messageDiv = dojo.byId('messageDivUpload');
        messageDiv.style.display = "none";
        messageDiv.innerHTML = "";
        // ステータス設定
        var attachment_status = dojo.byId('attachment_status');
        attachment_status.value = "FILE_QUEUED";
        // 各種ボタンを非活性にする
        aipo.schedule.multiDisableForm(true);
        // インジケーター表示
        var obj_indicator = dojo.byId("upload_indicator");
        if(obj_indicator){
           dojo.style(obj_indicator, "display" , "");
        }

    } catch (ex) {
        messageDiv.style.display = "";
        messageDiv.innerHTML = "<span class='caution'>ファイルのアップロードに失敗しました。</span>";
    }
}
/**
 * アップロード成功（１ファイル毎）
 * @param file アップロードファイル
 * @param serverData ファイルＩＤ、ファイル名、ディレクトリ名
 */
aipo.schedule.uploadSuccess = function(file, serverData) {
    try {
        // 設定先要素を取得
        var attachments = dojo.byId("attachments");
        var folderName = dojo.byId("folderName");
        var messageDiv = dojo.byId("messageDivUpload");
        var errMessageList = dojo.byId('errMessageList');
        // サーバー戻り値を1ファイル毎に分解しファイル一覧へ設定
        var serverDataArray = serverData.split("/");
        for ( var i=0; i < serverDataArray.length; i++ ) {
            var file_data = serverDataArray[i];
            var folder = "";
            var fileId = "";
            var fileName = "";
            var errMessage = "";
            // aipo.webmail.fileuploadのload後と同等
            if(file_data.search(/Complete/i) != -1){
                file_data = file_data.split(":");
                folder = file_data[0];
                fileId = file_data[1];
                fileName = file_data[2];
                // aipo.fileupload.onAddFileInfoと同等
                attachments.options[attachments.options.length] = new Option(fileName, fileId);
                folderName.value =  folder;
            } else {
                // サーバ側エラーをエラーリストへ設定
                var err_data = serverDataArray[i];
                err_data = err_data.split(":");
                fileName = err_data[0];
                errMessage = err_data[1];
                errMessageList.options[errMessageList.options.length] = new Option(errMessage, fileName);
            }
        }
    } catch (ex) {
        messageDiv.style.display = "";
        messageDiv.innerHTML = "<span class='caution'>ファイルのアップロードに失敗しました。</span>";
    }
}
/**
 * アップロード完了（全ファイル）
 * @param numFilesUploaded アップロードファイル数
 */
aipo.schedule.queueComplete = function(numFilesUploaded) {

    // 添付ファイル一覧を再作成
    aipo.schedule.makeFileList();

    // add start 要件No.24 メール添付ファイルタイムアウト対応
    aipo.schedule.syncAttachmentFile();
    // add end

    // 各種ボタンを活性にする
    aipo.schedule.multiDisableForm(false);
    // インジケーター非表示
    obj_indicator = dojo.byId("upload_indicator");
    if(obj_indicator){
        dojo.style(obj_indicator, "display" , "none");
    }

    // エラーがあれば表示する
    var uploadErrMsg = dojo.byId('messageDivUpload');
    var errMessageList = dojo.byId('errMessageList');
    var errMessageList_o = errMessageList.options;
    var errHTML = "";

    for ( var i = 0; i < errMessageList_o.length; i++ ) {
        errHTML += "<span class='caution'>" + errMessageList_o[i].text + "ファイル名：[" + errMessageList_o[i].value + "]</span><br>";
    }
    if ( errMessageList_o.length > 0 ) {
        uploadErrMsg.style.display = "";
        uploadErrMsg.innerHTML = errHTML;
    }
    // エラーリスト初期化
    // 0byteファイルのエラー表示の為、ここでクリアする。
    errMessageList.options.length = 0;
    // ステータス更新
    var attachment_status = dojo.byId('attachment_status');
    attachment_status.value = "QUEUE_COMPLETE";

}
/**
 * 添付ファイル一覧作成
 */
aipo.schedule.makeFileList = function() {

    var flList = dojo.byId("scheduleFlUploadList");
    while (flList.hasChildNodes()) {
        flList.removeChild(flList.lastChild);
    }

    var HTML ="";
    flList.innerHTML = "";
    HTML  = "<div style=\"overflow-y:scroll; overflow-x:hidden; height:40px; border:1px solid #C9C9C9\">";
    HTML += "<table border=0px rules=\"none\" cellSpacing=0 cellPadding=0 style=\"width:100%; height:100%;border-collapse:collapse\">";

    var attachments = dojo.byId("attachments");
    var attachments_o = attachments.options;
    var attachments_cnt = attachments_o.length;

    var urlList = dojo.byId("attachmentUrl");
    var folderName = dojo.byId("folderName");
    var file_id = "";
    var file_name = "";

    var download_mode = "0";

    var i = 0;
    while (i < attachments_o.length){
        HTML += "<tr>";
        // ２列表示
        for ( var j = 0; j < 2; j++ ) {
            if ( attachments_cnt != 0 ) {
                HTML += "<td style=\"font-size: 75%;border-width:0px;padding:0\"><input type=\"checkbox\" name=chklist id=chklist style=\"height:16px; width:16px; padding-right:2px\" value=" + attachments_o[i].value + ">";
                // ファイル名編集
                file_id = attachments_o[i].value;
                if ( file_id != null ) {
                    if ( file_id.substring(0,1) == "s" ) {
                        // スケジュール更新時は、DBからダウンロード
                        file_id = file_id.substring(1)
                        download_mode = "1";
                    } else {
                        // 新規作成、コピー登録、繰返し予定の編集時は、一時保存領域からダウンロード
                        download_mode = "0";
                    }
                }
                HTML += "<a href=" + urlList.value + "?attachmentIndex=" + file_id + "&download_mode=" + download_mode + "&folder_name=" + folderName.value + ">";
                file_name = aipo.fileupload.fileNameMake(attachments_o[i].text,18,16);
                HTML += file_name;
                HTML += "</a></td>";
                i++;
                attachments_cnt--;
            }
        }
        HTML += "</tr>";
    }
  HTML += "</table></div>";
    flList.innerHTML = HTML;
}
/**
 * 複数ファイル選択・ボタン表示切替
 * @param form 対象フォーム
 * @param bool trueの場合：ファイル選択・ボタン非表示/falseの場合：表示
 */
aipo.schedule.multiDisableForm = function (bool) {

    var mail_form = dojo.byId('_scheduleForm');
    var elements = mail_form.elements;

    for (var i = 0; i < elements.length; i++) {
        if (elements[i].type == 'submit' || elements[i].type == 'button') {
            elements[i].disabled = bool;
        }
    }
}
// add end


// add start 要件No.24 メール添付ファイルタイムアウト対応
/**
 * スケジュールポートレット非同期通信処理
 * @param form 対象フォーム
 * @param indicator_id インジケーターID
 * @param portlet_id ポートレットID
 * @param callback コールバック処理
 */
aipo.schedule.submit = function(form, indicator_id, portlet_id, callback) {
    aimluck.io.disableForm(form, true);

    var obj_indicator = dojo.byId(indicator_id + portlet_id);
    if(obj_indicator){
       dojo.style(obj_indicator, "display" , "");
    }

    try{
        dojo.xhrPost({
            url: form.action,
            //timeout: 30000,
            timeout: 60000,
            form: form,
            encoding: "utf-8",
            handleAs: "json-comment-filtered",
            headers: { X_REQUESTED_WITH: "XMLHttpRequest" },
            load: function (response, ioArgs){
                var html = "";
                if(dojo.isArray(response) && response.length > 0) {
                    if(response[0] == "PermissionError"){
                        html += "<ul>";
                        html += "<li><span class='caution'>" + response[1] + "</span></li>";
                        html += "</ul>";
                    } else if(response[0] == "NoFindFileError"){
                        var idArray = response[1].split(",");
                        dojo.forEach(idArray, function(id) {
                            aipo.schedule.removeOptionById(id);
                        });
                        aipo.schedule.syncAttachmentFile();
                        aipo.schedule.makeFileList();
                        html += "<ul>";
                        html += "<li><span class='caution'>" + response[2] + "</span></li>";
                        html += "</ul>";
                    }else{
                        html += "<ul>";
                        dojo.forEach(response, function(msg) {
                            html += "<li><span class='caution'>" + msg + "</span></li>";
                        });
                        html += "</ul>";
                    }
                }
                callback.call(callback, html);

                obj_indicator = dojo.byId(indicator_id + portlet_id);
                if(obj_indicator){
                   dojo.style(obj_indicator, "display" , "none");
                }

                if (html != "") {
                    aimluck.io.disableForm(form, false);
                }
            },
            error: function (error) {
            }
        });
    } catch(E) {
    };

    return false;
}

/**
 * ファイル名リストを表示しているリストと同期する。
 */
aipo.schedule.syncAttachmentFile = function() {
  var attachments = dojo.byId('attachments');
  var attachmentFileNames = dojo.byId('attachmentFileNames');

  while (attachmentFileNames.hasChildNodes()) {
      attachmentFileNames.removeChild(attachmentFileNames.lastChild);
  }

  var fileList = attachments.options;
  for(var i = 0 ; i < fileList.length; i ++ ) {
      var value = encodeURIComponent(fileList[i].text);
      var text = fileList[i].value;
      aimluck.io.addOption(attachmentFileNames, value, text, false);
  }
}

/**
 * 指定されたファイルをファイル名リストから削除する。
 *
 * @param deleteId 削除対象のファイルID
 */
aipo.schedule.removeOptionById = function(deleteId ){

  var select = dojo.byId('attachments');

  if (document.all) {
    var t_o = select.options;
    for(i = 0 ;i < t_o.length; i ++ ) {
      if( t_o[i].value == deleteId ) {
        t_o.remove(i);
        break;
      }
    }
  } else {
    var t_o = select.options;
    for(i = 0 ;i < t_o.length; i ++ ) {
      if( t_o[i].value == deleteId ) {
        select.removeChild(t_o[i]);
        break;
      }
    }
  }
}
// add end
