/*
 * Aipo is a groupware program developed by Aimluck,Inc.
 * Copyright (C) 2004-2011 Aimluck,Inc.
 * http://www.aipo.com
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.aimluck.eip.webmail;

import com.aimluck.commons.field.ALDateField;
import com.aimluck.commons.field.ALNumberField;
import com.aimluck.commons.field.ALStringField;
import com.aimluck.eip.cayenne.om.portlet.EipTMailFolder;
import com.aimluck.eip.common.ALData;

/**
 * ウェブメールのフォルダのResultDataです。 <BR>
 * 
 */
public class WebMailFolderResultData implements ALData {

  /** Folder ID */
  private Integer folder_id;

  /** フォルダ名 */
  private ALStringField folder_name;

  // 2011.9.21 add start
  /** 親フォルダID */
  private Integer parent_folder_id;

  /** 親フォルダ名 */
  private ALStringField parent_folder_name;

  /** フォルダ容量 */
  private ALNumberField folder_volume;

  /** フォルダタイプ */
  private String folder_type;

  /** 親フォルダパス */
  private String parentFolderPath;

  // 2011.9.21 add end

  /** 登録日 */
  private ALDateField create_date;

  /** 更新日 */
  private ALDateField update_date;

  /** 編集・削除を許可するか */
  private boolean can_update = true;

  public WebMailFolderResultData() {

  }

  public WebMailFolderResultData(EipTMailFolder folder) {
    initField();
    this.folder_id = folder.getFolderId();
    this.folder_name.setValue(folder.getFolderName());

    // add start
    this.parent_folder_id = folder.getParentFolderId();
    this.folder_volume.setValue(folder.getFolderVolume());
    this.folder_type = folder.getFolderType();
    // add end

    this.create_date.setValue(folder.getCreateDate());
    this.update_date.setValue(folder.getUpdateDate());
  }

  /**
   * 
   * 
   */
  @Override
  public void initField() {
    folder_id = 0;
    folder_name = new ALStringField();

    // add start
    parent_folder_id = 0;
    parent_folder_name = new ALStringField();
    folder_volume = new ALNumberField();
    // add end

    create_date = new ALDateField();
    update_date = new ALDateField();
  }

  /**
   * フォルダIDを返します。
   * 
   * @return
   */
  public Integer getFolderId() {
    return folder_id;
  }

  /**
   * フォルダ名を返します。
   * 
   * @return
   */
  public ALStringField getFolderName() {
    return folder_name;
  }

  // add start
  /**
   * 親フォルダIDを返します。
   * 
   * @return
   */
  public Integer getParentFolderId() {
    return parent_folder_id;
  }

  /**
   * 親フォルダ名を返します。
   * 
   * @return
   */
  public ALStringField getParentFolderName() {
    return parent_folder_name;
  }

  /**
   * フォルダ容量を返します。
   * 
   * @return
   */
  public ALNumberField getFolderVolume() {
    return folder_volume;
  }

  /**
   * フォルダタイプを返します。
   * 
   * @return
   */
  public String getFolderType() {
    return folder_type;
  }

  // add end

  /**
   * フォルダ作成日を返します。
   * 
   * @return
   */
  public ALDateField getCreateDate() {
    return create_date;
  }

  /**
   * フォルダ更新日を返します。
   * 
   * @return
   */
  public ALDateField getUpdateDate() {
    return update_date;
  }

  /**
   * フォルダの更新可否を返します。
   * 
   * @return
   */
  public boolean getCanUpdate() {
    return can_update;
  }

  /**
   * フォルダIDをセットします。
   * 
   * @param i
   */
  public void setFolderId(Integer i) {
    folder_id = i;
  }

  /**
   * フォルダIDをセットします。
   * 
   * @param string
   */
  public void setFolderName(String string) {
    folder_name.setValue(string);
  }

  // add start
  /**
   * 親フォルダIDをセットします。
   * 
   * @param Integer
   */
  public void setParentFolderId(Integer i) {
    parent_folder_id = i;
  }

  /**
   * 親フォルダ名をセットします。
   * 
   * @param string
   */
  public void setParentFolderName(String string) {
    parent_folder_name.setValue(string);
  }

  /**
   * フォルダ容量をセットします。
   * 
   * @param string
   */
  public void setFolderVolume(long num) {
    folder_volume.setValue(num);
  }

  /**
   * フォルダタイプをセットします。
   * 
   * @param string
   */
  public void setFolderType(String string) {
    folder_type = string;
  }

  // add end

  /**
   * フォルダ作成日をセットします。
   * 
   * @param string
   */
  public void setCreateDate(String string) {
    create_date.setValue(string);
  }

  /**
   * フォルダ更新日をセットします。
   * 
   * @param string
   */
  public void setUpdateDate(String string) {
    update_date.setValue(string);
  }

  /**
   * フォルダの更新可否をセットします。
   * 
   * @param bool
   */
  public void setCanUpdate(boolean bool) {
    can_update = bool;
  }

  public String getParentFolderPath() {
    return parentFolderPath;
  }

  public void setParentFolderPath(String parentfolderPath) {
    this.parentFolderPath = parentfolderPath;
  }
}
