/*
 * Aipo is a groupware program developed by Aimluck,Inc.
 * Copyright (C) 2004-2011 Aimluck,Inc.
 * http://www.aipo.com
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.aimluck.eip.webmail;

import java.util.ArrayList;
import java.util.List;

import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

import com.aimluck.commons.field.ALStringField;
import com.aimluck.eip.cayenne.om.account.AvzMGroupsend;
import com.aimluck.eip.common.ALAbstractFormData;
import com.aimluck.eip.common.ALDBErrorException;
import com.aimluck.eip.common.ALPageNotFoundException;
import com.aimluck.eip.modules.actions.common.ALAction;
import com.aimluck.eip.orm.Database;
import com.aimluck.eip.orm.query.SelectQuery;
import com.aimluck.eip.user.beans.UserGroupPositionLiteBean;
import com.aimluck.eip.user.beans.UserLiteBean;
import com.aimluck.eip.user.util.UserUtils;
import com.aimluck.eip.util.ALEipUtils;

/**
 * グループ送信の所属者一覧のフォームデータを管理するためのクラスです。 <br />
 */
public class WebMailGroupSendUserFormData extends ALAbstractFormData {

  /** logger */
  private static final JetspeedLogger logger =
    JetspeedLogFactoryService.getLogger(WebMailGroupSendUserFormData.class
      .getName());

  /** ログインユーザーID * */
  private int user_id;

  /** グループ送信ID */
  private String groupSendId;

  /** グループ送信名 */
  private ALStringField groupSendName = null;

  /** グループ送信所属者リスト */
  private List<WebMailGroupSendUserResultData> groupSendUserList = null;

  /**
   * 初期化します。
   * 
   * @param action
   * @param rundata
   * @param context
   * 
   * 
   */
  @Override
  public void init(ALAction action, RunData rundata, Context context)
      throws ALPageNotFoundException, ALDBErrorException {

    super.init(action, rundata, context);

    // ログインユーザーID取得
    user_id = ALEipUtils.getUserId(rundata);

    // 自ポートレットからのリクエストであれば、パラメータを展開しセッションに保存する。
    if (ALEipUtils.isMatch(rundata, context)) {
      try {
        // パラメータにグループ送信情報があった場合
        if (rundata.getParameters().containsKey("groupsendid")) {
          groupSendId = rundata.getParameters().get("groupsendid");
        } else {
          return;
        }
      } catch (Exception e) {
        return;
      }
    }

    groupSendUserList = new ArrayList<WebMailGroupSendUserResultData>();

  }

  /**
   * 各フィールドを初期化します。 <BR>
   * 
   * 
   */
  @Override
  public void initField() {
    // グループ送信ID
    groupSendId = null;
  }

  /**
   * グループ送信ユーザー一覧を画面項目に設定します。
   * <p>
   * 
   * @param rundata
   * @param context
   * @param msgList
   * @return
   */
  @Override
  protected boolean setFormData(RunData rundata, Context context,
      List<String> msgList) throws ALPageNotFoundException, ALDBErrorException {
    boolean res = true;
    try {
      res = super.setFormData(rundata, context, msgList);

      // グループ送信名の設定
      SelectQuery<AvzMGroupsend> query = Database.query(AvzMGroupsend.class);
      Expression exp =
        ExpressionFactory.matchDbExp(
          AvzMGroupsend.GROUPSEND_ID_PK_COLUMN,
          groupSendId);
      AvzMGroupsend groupSend = query.setQualifier(exp).fetchSingle();
      groupSendName = new ALStringField();
      groupSendName.setValue(groupSend.getGroupsendName());

      // グループ送信IDより所属者情報を取得する
      List<UserLiteBean> groupSendUserList =
        UserUtils.getUserLiteBeansFromGroup(rundata, groupSendId, true);

      // 所属者氏名の設定
      List<UserGroupPositionLiteBean> userPostPositionList = null;
      String positionName = null;
      if (res) {
        for (UserLiteBean user : groupSendUserList) {
          // 部署、役職情報取得
          userPostPositionList =
            UserUtils.getPostPositionBeanList(Integer
              .parseInt(user.getUserId()));
          positionName = userPostPositionList.get(0).getPositionName();

          WebMailGroupSendUserResultData rd =
            new WebMailGroupSendUserResultData();
          rd.initField();
          // 役職が設定されている場合は氏名の後に付加
          if (!(null == positionName)) {
            rd.setUserName(new ALStringField(user.getAliasName()
              + " "
              + positionName));
          } else {
            rd.setUserName(new ALStringField(user.getAliasName()));
          }
          this.groupSendUserList.add(rd);
        }
      }
    } catch (Exception ex) {
      logger.error("グループ送信ユーザー情報取得に失敗しました"
        + ALEipUtils.getUserFullName(user_id), ex);
      return false;
    }
    return res;
  }

  /**
   * 各フィールドに対する制約条件を設定します。 <BR>
   * 
   * 
   */
  @Override
  protected void setValidator() {
  }

  /**
   * フォームに入力されたデータの妥当性検証を行います。 <BR>
   * 
   * @param msgList
   * @return
   * 
   */
  @Override
  protected boolean validate(List<String> msgList) {
    return true;
  }

  /**
   * 
   * @param rundata
   * @param context
   * @param msgList
   * @return
   */
  @Override
  protected boolean loadFormData(RunData rundata, Context context,
      List<String> msgList) {
    try {
      return true;
    } catch (Exception e) {
      logger.error("Exception", e);
      return false;
    }
  }

  /**
   * 
   * @param rundata
   * @param context
   * @param msgList
   * @return
   */
  @Override
  protected boolean insertFormData(RunData rundata, Context context,
      List<String> msgList) {
    return false;
  }

  /**
   * 
   * @param rundata
   * @param context
   * @param msgList
   * @return
   */
  @Override
  protected boolean updateFormData(RunData rundata, Context context,
      List<String> msgList) {
    return false;
  }

  /**
   * 
   * @param rundata
   * @param context
   * @param msgList
   * @return
   */
  @Override
  protected boolean deleteFormData(RunData rundata, Context context,
      List<String> msgList) {
    return false;
  }

  /**
   * グループ送信名を取得する．
   * 
   * @return groupSendName
   */
  public ALStringField getGroupSendName() {
    return groupSendName;
  }

  /**
   * 所属者のリストを取得する．
   * 
   * @return
   */
  public List<WebMailGroupSendUserResultData> getGroupSendList() {
    return groupSendUserList;
  }

}
