/*
 * Aipo is a groupware program developed by Aimluck,Inc.
 * Copyright (C) 2004-2011 Aimluck,Inc.
 * http://www.aipo.com
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package aipo.batch.kicker;

import org.apache.axis2.AxisFault;

import aipo.webservice.soap.axis2.MaintenanceServiceStub;
import aipo.webservice.soap.axis2.MaintenanceServiceStub.RecieveMail;

/**
 * <HR>
 * 定期メール受信バッチ起動クラス
 * <p>
 * 
 * メール受信バッチ処理を起動します。
 * <P>
 * <HR>
 * <P>
 * 
 */
public class PeriodicReceiveMailKicker {

  /** ロガー */
  // private static final JetspeedLogger logger =
  // JetspeedLogFactoryService.getLogger(ReceiveMailKicker.class.getName());
  /**
   * メールアカウント移行バッチの実行クラス
   * 
   * @param args
   *            [0]-> リクエストURL [1]-> エンドポイントのサービスのアドレス
   * @exception Exception
   */
  public static void main(String[] args) {
    MaintenanceServiceStub stub = null;
    try {

      // 接続先ＵＲＬを指定しスタブを生成するMaintenanceServiceStub
      stub = new MaintenanceServiceStub(
      // "http://localhost:80/aipo/services/MaintenanceService");
        args[0]);

      RecieveMail req = new RecieveMail();
      req.setUserName(args[1]);
      // req.setUserName("motegi");
      System.out.println("受信ユーザー：" + req.getUserName());

      // レスポンスを取得
      stub._getServiceClient().getOptions().setTimeOutInMilliSeconds(
        60 * 60 * 1000);
      MaintenanceServiceStub.RecieveMailResponse res = stub.recieveMail(req);
      System.out.println("" + res.get_return());

    } catch (Exception e) {
      e.printStackTrace();
    } finally {
      if (stub != null) {
        try {
          // リソース解放
          stub._getServiceClient().cleanup();
          stub.cleanup();
        } catch (AxisFault e) {
          // logger.error(e.toString());
        }
      }
    }
  }
}
