/*
 * Aipo is a groupware program developed by Aimluck,Inc.
 * http://aipostyle.com/
 * 
 * Copyright(C) 2012 avanza Co.,Ltd. All rights reserved.
 * http://www.avnz.co.jp/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package aipo.batch.kicker;

import java.util.Date;
import java.util.Properties;

import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;

public class TestSendMail {

  public static void main(String[] args) {

    if (args.length != 2) {
      System.out.println("コマンドラインパラメータで[宛先アドレス] [SMTPサーバー名]を指定して下さい。");
      return;
    }

    String to = args[0];
    String host = args[1];
    System.out.println(to + "へメールを送信します。");

    String from = "testmail@test.com";

    boolean debug = false;

    Properties props = new Properties();
    props.put("mail.smtp.host", host);
    props.put("mail.host", host);
    props.put("mail.from", from);
    if (debug) {
      props.put("mail.debug", debug);
    }

    Session session = Session.getInstance(props);
    session.setDebug(debug);

    try {
      MimeMessage msg = new MimeMessage(session);
      msg.setFrom(new InternetAddress(from));
      InternetAddress[] address = InternetAddress.parse(to);
      msg.setRecipients(Message.RecipientType.TO, address);
      msg.setSentDate(new Date());
      msg.setText("テストメールです。");
      msg.setSentDate(new Date());
      msg.setSubject("テストメールです。", "ISO-2022-JP");
      Transport.send(msg);

      System.out.println("メール送信に成功しました。");

    } catch (MessagingException mex) {
      System.out.println("メール送信に失敗しました。" + mex.getMessage());
      mex.printStackTrace(System.out);
    }
  }
}
