/*
 * Aipo is a groupware program developed by Aimluck,Inc.
 * Copyright (C) 2004-2011 Aimluck,Inc.
 * http://www.aipo.com
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package aipo.batch.userinfo;

/**
 * <HR>
 * 組織情報格納用Bean
 * <p>
 * 
 * 組織情報格納用Beanクラス。ファイル項目に加えて、階層レベルを追加。
 * <P>
 * <HR>
 * <P>
 * 
 */
public class AipoPost {

  /**
   * コンストラクタ
   */
  public AipoPost(String userGroupCode, String userGroupName,
      String parentUserGroupCode) {
    super();
    this.userGroupCode = userGroupCode;
    this.userGroupName = userGroupName;
    this.parentUserGroupCode = parentUserGroupCode;
  }

  /** ユーザグループコード */
  private String userGroupCode;

  /** ユーザグループ名 */
  private String userGroupName;

  /** 親ユーザグループコード */
  private String parentUserGroupCode;

  /** 階層レベル */
  private int level;

  /**
   * ユーザグループコードを取得します。
   * 
   * @return userGroupCode
   */
  public String getUserGroupCode() {
    return userGroupCode;
  }

  /**
   * ユーザグループコードを設定します。
   * 
   * @param userGroupCode
   *          セットする ユーザグループコード
   */
  public void setUserGroupCode(String userGroupCode) {
    this.userGroupCode = userGroupCode;
  }

  /**
   * ユーザグループ名を取得します。
   * 
   * @return userGroupName
   */
  public String getUserGroupName() {
    return userGroupName;
  }

  /**
   * ユーザグループ名を設定します。
   * 
   * @param userGroupName
   *          セットする ユーザグループ名
   */
  public void setUserGroupName(String userGroupName) {
    this.userGroupName = userGroupName;
  }

  /**
   * 親ユーザグループコードを取得します。
   * 
   * @return parentUserGroupName
   */
  public String getParentUserGroupCode() {
    return parentUserGroupCode;
  }

  /**
   * 親ユーザグループコードを設定します。
   * 
   * @param parentUserGroupName
   *          セットする 親ユーザグループコード
   */
  public void setParentUserGroupName(String parentUserGroupCode) {
    this.parentUserGroupCode = parentUserGroupCode;
  }

  /**
   * 階層レベルを取得します。
   * 
   * @return level
   */
  public int getLevel() {
    return level;
  }

  /**
   * 階層レベルを設定します。
   * 
   * @param level
   *          セットする 階層レベル
   */
  public void setLevel(int level) {
    this.level = level;
  }
}
