package aipo.webservice.util;

/*
 * Aipo is a groupware program developed by Aimluck,Inc.
 * Copyright (C) 2004-2011 Aimluck,Inc.
 * http://www.aipo.com
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

import java.util.Collections;
import java.util.Comparator;
import java.util.List;

import aipo.webservice.soap.axis2.bean.ReceiveMailViewBean;

/**
 * <HR>
 * リマインダー用メール情報ユーティリティクラス
 * <p>
 * 
 * Webサービスのメール情報ユーティリティ
 * <P>
 * <HR>
 * <P>
 * 
 */
public class WsMailUtils {

  /** 受信メール情報の受信時刻昇順による順序付けクラス */
  private static final Comparator<ReceiveMailViewBean> receiveMailViewBeanComparatorByTimeAsc =
    new ReceiveMailViewBeanComparatorByTimeAsc();

  /** 受信メール情報の受信時刻降順による順序付けクラス */
  private static final Comparator<ReceiveMailViewBean> receiveMailViewBeanComparatorByTimeDesc =
    new ReceiveMailViewBeanComparatorByTimeDesc();

  /**
   * 受信メール情報一覧の受信時刻ソート
   * <p>
   * 受信メール情報一覧を受信時刻でソートする。<br>
   * 昇順/降順をパラメータによって判定し、呼び出すクラスを決定する。
   * 
   * @param list
   *          受信メール情報一覧
   * @param isAsc
   *          trueの場合：昇順ソート、falseの場合：降順ソート
   */
  public static void sortByTime(List<ReceiveMailViewBean> list, boolean isAsc) {
    Comparator<ReceiveMailViewBean> comparator = null;
    if (isAsc) {
      comparator = receiveMailViewBeanComparatorByTimeAsc;
    } else {
      comparator = receiveMailViewBeanComparatorByTimeDesc;
    }
    Collections.sort(list, comparator);
  }

}
