/*
 * Copyright (C) 2012 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.ksk.contacts.tel.activity;

import java.util.ArrayList;
import java.util.List;

import com.ksk.contacts.R;
import com.ksk.contacts.tel.util.FlickUtil;
import com.ksk.contacts.tel.util.MemberListAdapter;
import com.ksk.contacts.tel.util.PriorityNumberDB;
import com.ksk.contacts.tel.util.PriorityNumberDB.PriorityNumber;
import com.ksk.contacts.util.CommonData.GroupListData;
import com.ksk.contacts.util.CommonData.MemberInfo;
import com.ksk.contacts.util.ContactMgr;

import android.app.Activity;
import android.content.Intent;
import android.os.Bundle;
import android.text.Editable;
import android.text.TextWatcher;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.AdapterView;
import android.widget.AdapterView.OnItemLongClickListener;
import android.widget.EditText;
import android.widget.LinearLayout;
import android.widget.ListView;
import android.widget.TextView;

public class group extends Activity implements OnItemLongClickListener {

	//Adapter用グループリスト情報
	private List<GroupListData> mGroupList = new ArrayList<GroupListData>();

	private long         mRawContactID = -1;

	private MemberListAdapter mMemberListAdapter;

	private LinearLayout mGroupListLayout;

	private ListView     mMemberListView;

	private TextView     mGroupBarName;

	private TextView     mGroupBarNum;

	private int          mCurrentPos;

	/* (非 Javadoc)
	 * @see android.app.Activity#onCreate(android.os.Bundle)
	 */
	@Override
	protected void onCreate(Bundle savedInstanceState) {

		super.onCreate(savedInstanceState);

		setContentView(R.layout.group);

Log.d("group","ROOT1");
        ContactMgr mContactMgr = new ContactMgr(this);
        mGroupList = mContactMgr.getGroupMemberList();
Log.d("group","ROOT1");

        //検索Viewの取得、及び設定
        EditText SerchEdit = (EditText) findViewById(R.id.edit);
        SerchEdit.addTextChangedListener(xTextListener);

        //グループバーの表示
        //通常の連絡先画面では非表示にし、グループ表示時のみ可視化する
        LinearLayout group_bar = (LinearLayout) findViewById(R.id.group_bar);
        group_bar.setVisibility(View.VISIBLE);
        mGroupBarName = (TextView) findViewById(R.id.group_bar_name);
        mGroupBarNum  = (TextView) findViewById(R.id.group_bar_cnt);

    	//Viewの取得
        LayoutInflater inflater = LayoutInflater.from(this);
        mGroupListLayout = (LinearLayout) findViewById(R.id.grouplist);

        //グループリストの設定
        for(int i=0; i<mGroupList.size(); i++){
            View layout = inflater.inflate(R.layout.groulplist_row, null);

            //グループ名の設定
			TextView g_name = (TextView) layout.findViewById(R.id.name);
			g_name.setText(mGroupList.get(i).group_title);

			//ScrollViewに追加
			mGroupListLayout.addView(layout);
        }

        //グループフォーカスによる背景設定
        mCurrentPos = 0;
        mGroupListLayout.getChildAt(mCurrentPos).setBackgroundResource(R.drawable.ic_group_select);

		//グループバーの更新
		mGroupBarName.setText(mGroupList.get(mCurrentPos).group_title);
		mGroupBarNum.setText(" (" + String.valueOf(mGroupList.get(mCurrentPos).member_list.size()) + ")");

        //メンバーリストの設定
		mMemberListView = (ListView) findViewById(R.id.list);
        mMemberListAdapter = new MemberListAdapter(this, R.layout.memberlist_row2);
        if(mGroupList.size() != 0){
        	mMemberListAdapter.setDataList(mGroupList.get(0).member_list);

        	mMemberListView.setAdapter(mMemberListAdapter);
        }

		mMemberListView.setOnItemLongClickListener(this);

        //フリックの実装
        new FlickUtil(this, mMemberListView, null);
	}

	/* (非 Javadoc)
	 * @see android.app.Activity#onDestroy()
	 */
	@Override
	protected void onDestroy() {
		// TODO 自動生成されたメソッド・スタブ
		super.onDestroy();
	}

	/* (非 Javadoc)
	 * @see android.app.Activity#onPause()
	 */
	@Override
	protected void onPause() {
		// TODO 自動生成されたメソッド・スタブ
		super.onPause();
	}

	/* (非 Javadoc)
	 * @see android.app.Activity#onRestart()
	 */
	@Override
	protected void onRestart() {
		// TODO 自動生成されたメソッド・スタブ
		super.onRestart();

		for(int i=0; i<mGroupList.size(); i++){
			for(int k=0; k<mGroupList.get(i).member_list.size(); k++){
				if((mGroupList.get(i).member_list.get(k).rawcontact_id != null) && (mRawContactID == mGroupList.get(i).member_list.get(k).rawcontact_id)){
					PriorityNumberDB PN_DB = new PriorityNumberDB(this);

		            //音声発信ボタンの設定
		    		PriorityNumber pn_info = PN_DB.getPriorityNumber(mGroupList.get(i).member_list.get(k).rawcontact_id);
		            if((pn_info != null) && (pn_info.phone != null) && (!pn_info.phone.equals(""))){
		            	//電話番号が存在する場合は、音声発信データを設定
		            	mGroupList.get(i).member_list.get(k).tel = pn_info.phone;
		            }else{
		            	mGroupList.get(i).member_list.get(k).tel = "";
		            }
		            //Emailボタンの設定
		            if((pn_info != null) && (pn_info.mail != null) && (!pn_info.mail.equals(""))){
		            	//Emailが存在する場合は、Emailデータを設定
		            	mGroupList.get(i).member_list.get(k).email = pn_info.mail;
		            }else{
		            	mGroupList.get(i).member_list.get(k).email = "";
		            }

//		            mGroupListAdapter.notifyDataSetChanged();
		            i=mGroupList.size();
		            break;
				}
			}
		}

		mRawContactID = -1;
	}

	/* (非 Javadoc)
	 * @see android.app.Activity#onResume()
	 */
	@Override
	protected void onResume() {
		// TODO 自動生成されたメソッド・スタブ
		super.onResume();
	}

	/* (非 Javadoc)
	 * @see android.app.Activity#onStart()
	 */
	@Override
	protected void onStart() {
		// TODO 自動生成されたメソッド・スタブ
		super.onStart();
	}

	/* (非 Javadoc)
	 * @see android.app.Activity#onStop()
	 */
	@Override
	protected void onStop() {
		// TODO 自動生成されたメソッド・スタブ
		super.onStop();
	}

    private TextWatcher xTextListener = new TextWatcher() {
		@Override
		public void afterTextChanged(Editable arg0) {

			//Adapter用メンバーリスト情報(検索用)
			List<MemberInfo> list = new ArrayList<MemberInfo>();

			//Serch用EditViewが空欄以外は以下を実施する。
			if( (arg0 != null) && (!arg0.equals("")) ){

				//入力キーが名前・フリカナ・電話番号・Emailのいずれかに含まれているかチェック。
				//含まれていない場合は、検索用リストから削除する。
				int num = mGroupList.get(mCurrentPos).member_list.size();
				for(int i=0; i<num; i++){
					if(mGroupList.get(mCurrentPos).member_list.get(i).toString().indexOf(arg0.toString()) != -1){
						list.add(mGroupList.get(mCurrentPos).member_list.get(i));
					}
				}

				//Adapterにリストを設定し、表示更新要求を行う
				mMemberListAdapter.setDataList(list);
				mMemberListAdapter.notifyDataSetChanged();

			}else{
				//空欄の場合は、全電話帳リストを表示する。

				//Adapterにリストを設定し、表示更新要求を行う
				mMemberListAdapter.setDataList(mGroupList.get(mCurrentPos).member_list);
				mMemberListAdapter.notifyDataSetChanged();
			}
		}

		@Override
		public void beforeTextChanged(CharSequence s, int start, int count,
				int after) {
			// TODO 自動生成されたメソッド・スタブ
		}

		@Override
		public void onTextChanged(CharSequence s, int start, int before,
				int count) {
			// TODO 自動生成されたメソッド・スタブ
		}
    };

	public void showGroupMember(View v) {

		//グループフォーカスの解除
		mGroupListLayout.getChildAt(mCurrentPos).setBackgroundResource(0);

		for(int i=0; i<mGroupListLayout.getChildCount(); i++){
			if(mGroupListLayout.getChildAt(i).equals(v.getParent())){
				//グループメンバー一覧の更新
		        mMemberListAdapter.setDataList(mGroupList.get(i).member_list);
		        mMemberListAdapter.notifyDataSetChanged();

				//グループバーの更新
				mGroupBarName.setText(mGroupList.get(i).group_title);
				mGroupBarNum.setText(" (" + String.valueOf(mGroupList.get(i).member_list.size()) + ")");

		        //グループフォーカスによる背景設定
				mCurrentPos = i;
		        mGroupListLayout.getChildAt(mCurrentPos).setBackgroundResource(R.drawable.ic_group_select);
			}
		}
    }


	@Override
	public boolean onItemLongClick(AdapterView<?> adapterview, View view, int i, long l) {

		//選択位置のContactIDを取得
		long rawcontact_id = mGroupList.get(mCurrentPos).member_list.get(i).rawcontact_id;

		//取得したContactIDを元に詳細画面Activityに対して起動要求を行う。
		Intent intent = new Intent(this, contactinfo.class);
		intent.putExtra("RawContactID", rawcontact_id);
		startActivity(intent);

		mRawContactID = rawcontact_id;
		return false;
	}
}
