/*
 * Copyright (C) 2012 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.ksk.contacts.tel.activity;

import java.util.List;
import com.ksk.contacts.R;
import com.ksk.contacts.tel.util.FlickUtil;
import com.ksk.contacts.tel.util.ShortCutDialUtil;
import com.ksk.contacts.util.CallLogMgr;
import com.ksk.contacts.util.CommonData;
import com.ksk.contacts.util.menu;
import com.ksk.contacts.util.CallLogMgr.CallLogData;
import android.app.TabActivity;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Bundle;
import android.view.Menu;
import android.view.MenuItem;
import android.view.WindowManager.LayoutParams;
import android.widget.TabHost;
import android.widget.TabHost.OnTabChangeListener;
import android.widget.TextView;

public class telgroup extends TabActivity implements OnTabChangeListener  {

	public static TextView     TopTitle;

	TabHost mTabHost;

	/* (非 Javadoc)
	 * @see android.app.ActivityGroup#onCreate(android.os.Bundle)
	 */
	@Override
	protected void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);

        this.getWindow().setSoftInputMode(LayoutParams.SOFT_INPUT_STATE_ALWAYS_HIDDEN);

		setContentView(R.layout.telgroup);

		TabHost tabHost = getTabHost();

		TabHost.TabSpec spec;

		Intent intent;

		//リソースファイルの取得
		String[] list_tab_name  = getResources().getStringArray(R.array.list_tab_name);
		String[] list_tab_title = getResources().getStringArray(R.array.list_tab_title_name);

		//Tab設定(ダイヤル画面)
//		intent = new Intent(Intent.ACTION_DIAL);
		intent = new Intent().setClass(this, dial.class);
		spec = tabHost.newTabSpec(list_tab_name[0])
                .setIndicator(list_tab_title[0], getResources().getDrawable(R.drawable.ic_tab_dial))
                .setContent(intent);
		tabHost.addTab(spec);

		//Tab設定(お気に入り画面)
//		intent = new Intent(telgroup.this, favorite.class);
		intent = new Intent().setClass(this, favorite.class);
		spec = tabHost.newTabSpec(list_tab_name[1])
                .setIndicator(list_tab_title[1], getResources().getDrawable(R.drawable.ic_tab_favorite))
                .setContent(intent);

		tabHost.addTab(spec);

		//Tab設定(連絡先画面)
		intent = new Intent().setClass(this, contacts.class);
		spec = tabHost.newTabSpec(list_tab_name[2])
                .setIndicator(list_tab_title[2], getResources().getDrawable(R.drawable.ic_tab_contacts))
                .setContent(intent);
		tabHost.addTab(spec);

		//Tab設定(グループ画面)
		intent = new Intent().setClass(this, group.class);
		spec = tabHost.newTabSpec(list_tab_name[3])
                .setIndicator(list_tab_title[3], getResources().getDrawable(R.drawable.ic_tab_group))
                .setContent(intent);
		tabHost.addTab(spec);

		//Tab設定(発着信履歴画面)
		intent = new Intent().setClass(this, call_log.class);
		spec = tabHost.newTabSpec(list_tab_name[4])
                .setIndicator(list_tab_title[4], getResources().getDrawable(R.drawable.ic_tab_call_log))
                .setContent(intent);
		tabHost.addTab(spec);

		//デフォルトタブの設定
		//TODO
		CallLogMgr mCallLogMgr = new CallLogMgr(this);
    	List<CallLogData> list = mCallLogMgr.getNewCallLogData();
    	if(list.size() != 0){
			tabHost.setCurrentTab(4);
			setDefaultTab(4);
    	}else{
			tabHost.setCurrentTab(2);
			setDefaultTab(2);
    	}

		//タブクリック時のコールバック登録
		tabHost.setOnTabChangedListener(this);

		//メイン画面のTABに表示するViewを取得する。
		TopTitle = (TextView)  findViewById(R.id.TopTitle);          //TOPタイトル用View
		TopTitle.setText("連絡先");

		//フリック時の画面遷移イベント取得のためのBroadcastReceiverを登録する。
        registerReceiver(breceiver , new IntentFilter("org.example.broadcast.SHOW_MESSAGE"));
	}

	/* (非 Javadoc)
	 * @see android.app.ActivityGroup#onDestroy()
	 */
	@Override
	protected void onDestroy() {
		// TODO 自動生成されたメソッド・スタブ
		super.onDestroy();

		unregisterReceiver(breceiver);
	}

	/* (非 Javadoc)
	 * @see android.app.ActivityGroup#onPause()
	 */
	@Override
	protected void onPause() {
		// TODO 自動生成されたメソッド・スタブ
		super.onPause();
	}

	/* (非 Javadoc)
	 * @see android.app.ActivityGroup#onResume()
	 */
	@Override
	protected void onResume() {
		// TODO 自動生成されたメソッド・スタブ
		super.onResume();
	}

	/* (非 Javadoc)
	 * @see android.app.ActivityGroup#onStop()
	 */
	@Override
	protected void onStop() {
		// TODO 自動生成されたメソッド・スタブ
		super.onStop();
	}


	@Override
	public void onTabChanged(String arg0) {
		String[] list_tab_name = getResources().getStringArray(R.array.list_tab_name);
		for(int i=0; i<list_tab_name.length; i++){
			String tab_name = list_tab_name[i];
			if(tab_name.equals(arg0)){
				String tab_title = getResources().getStringArray(R.array.list_tab_title_name)[i];
				TopTitle.setText(tab_title);
				break;
			}
		}

	}

	//TODO：Broadcastではない形にしたい
	private BroadcastReceiver breceiver = new BroadcastReceiver() {

	    @Override
	    public void onReceive(Context context, Intent intent) {

			int dis = intent.getIntExtra("dis", FlickUtil.FlickLogic.LEFT);

			String[] list_tab_title = getResources().getStringArray(R.array.list_tab_title_name);

			TabHost tabHost = getTabHost();
			int pos = tabHost.getCurrentTab();

			if(dis == FlickUtil.FlickLogic.LEFT){
				if(--pos < 0){
					pos = 0;
				}
			}else if(dis == FlickUtil.FlickLogic.RIGHT){
				if(++pos >= list_tab_title.length){
					pos = list_tab_title.length - 1;
				}

			}else{
				  return;
			}

			tabHost.setCurrentTab(pos);

			TopTitle.setText(list_tab_title[pos]);
	    }
	};

	@Override
	public boolean onCreateOptionsMenu(Menu menu){

		//TODO
		menu.add(0, CommonData.MENU_SELECT_ADD, 0, "追加")
        .setIcon(android.R.drawable.ic_menu_add);

/*
		menu.add(0, MENU_SELECT_EDIT, 0, "編集")
      .setIcon(android.R.drawable.ic_menu_add);

		menu.add(0, MENU_SELECT_DEL, 0, "削除")
      .setIcon(android.R.drawable.ic_menu_add);
*/
		menu.add(0, CommonData.MENU_SELECT_SHORTCUT, 0, "短縮")
        .setIcon(android.R.drawable.ic_menu_send);

		menu.add(0, CommonData.MENU_SELECT_SET, 0, "設定")
        .setIcon(android.R.drawable.ic_menu_manage );

	    return true;
	}

    // オプションメニューが表示される度に呼び出されます
    @Override
    public boolean onPrepareOptionsMenu(Menu menu) {

        return super.onPrepareOptionsMenu(menu);
    }

    // オプションメニューアイテムが選択された時に呼び出されます
    @Override
    public boolean onOptionsItemSelected(MenuItem item) {
        boolean ret = true;
        switch (item.getItemId()) {

        default:
            ret = super.onOptionsItemSelected(item);
            break;

        case CommonData.MENU_SELECT_ADD:
    		//編集画面Activityに対して起動要求を行う。
    		Intent intent = new Intent(this, contactedit.class);
    		startActivity(intent);

            ret = true;
            break;

        case CommonData.MENU_SELECT_SHORTCUT:
			ShortCutDialUtil gesture = new ShortCutDialUtil(telgroup.this);
			gesture.createPopup();
            ret = true;
            break;

        case CommonData.MENU_SELECT_SET:
        	Intent i = new Intent(telgroup.this, menu.class);
        	startActivity(i);
            ret = true;
            break;
        }
        return ret;
    }
}
