/*
 * Copyright (C) 2012 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.ksk.contacts.tel.util;

import java.util.List;

import com.ksk.contacts.R;
import android.content.Context;
import android.graphics.Bitmap;
import android.view.LayoutInflater;
import android.view.View;
import android.view.View.OnClickListener;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.ImageView;
import android.widget.TextView;

public class FavoriteListAdapter extends BaseAdapter implements OnClickListener {

	//メンバーリスト情報
	public class FavoriteListRow {
		public Bitmap  photo;
		public String  name;
		public long    rawcontact_id;
	}

	private class FavoriteListRowHolder {
		private ImageView       photo;
		private TextView        name;
		private FavoriteListRow data;
	}

	private List<FavoriteListRow> mListData;

	//Context情報
	private Context        mContext;

	//コンストラクタ
    public FavoriteListAdapter(Context context) {
    	mContext  = context;
	}

    /**
     * @param dataList
     */
    public void setDataList(List<FavoriteListRow> dataList) {
    	mListData = dataList;
	}

    public List<FavoriteListRow> getDataList() {
    	return mListData;
	}

	/* (非 Javadoc)
	 * @see android.widget.Adapter#getCount()
	 */
	@Override
    public int getCount() {
    	return mListData.size();
    }

    /* (非 Javadoc)
     * @see android.widget.Adapter#getItem(int)
     */
    @Override
    public Object getItem(int position) {
    	return mListData.get(position);
    }

    /* (非 Javadoc)
     * @see android.widget.Adapter#getItemId(int)
     */
    @Override
    public long getItemId(int position) {
    	return position;
    }

    /* (非 Javadoc)
     * @see android.widget.Adapter#getView(int, android.view.View, android.view.ViewGroup)
     */
    public View getView(int position, View convertView, ViewGroup parent) {
    	FavoriteListRowHolder holder = null;
		View   v = convertView;

		//viewが既に作成済みかをチェック
		if(v == null){
			//未作成の場合は、レイアウトを元にViewを新規作成する
			LayoutInflater inflater = (LayoutInflater)mContext.getSystemService(Context.LAYOUT_INFLATER_SERVICE);
			v = inflater.inflate(R.layout.favorite_row, null, false);

			//Holderを作成し、各パラメータを設定する。
			holder = new FavoriteListRowHolder();
			holder.photo   = (ImageView) v.findViewById(R.id.photo);  //ユーザー画像
			holder.name   = (TextView)  v.findViewById(R.id.name);    //ユーザー名(フルネーム)

			//ViewにHolderを登録する。
			v.setTag(holder);

		}else{
			//View作成済みのため、Viewに登録されているTagからHolder情報を取得する。
			holder = (FavoriteListRowHolder) v.getTag();
		}

		//選択位置を元にリスト情報を取得する。
		FavoriteListRow item = (FavoriteListRow) getItem(position);

		//リスト情報がNULLではない、かつHolderがNULLでない場合は、各情報の設定を行う。
		if((item != null) && (holder != null) ){

			//HolderのDataに、ListData情報を登録する。
			//  →音声発信/Email/カスタムボタン押下時の各種情報取得用
			holder.data = item;
			v.setTag(holder);

			//ユーザー画像の描画
			if(item.photo != null){
				holder.photo.setImageBitmap(item.photo);
			}else{
				holder.photo.setImageResource(R.drawable.ic_launcher_android);
			}

			//ユーザー名の設定
			holder.name.setText(item.name);
		}

		return v;
    }

	/* (非 Javadoc)
	 * @see android.view.View.OnClickListener#onClick(android.view.View)
	 */
	@Override
	public void onClick(View view) {
/*
		SendAction action = new SendAction();

		//ViewのTagよりHolder情報を取得する。
		MemberListRowHolder holder = (MemberListRowHolder) view.getTag();

		//押下されたボタンに応じた処理を実施。
		if(holder.tel.equals(view)){
			Toast.makeText(mContext, "音声発信:" + holder.data.tel, Toast.LENGTH_SHORT).show();

			action.sendCall(mContext, holder.data.tel);

		}else if(holder.email.equals(view)){
			Toast.makeText(mContext, "メール送信:" + holder.data.email, Toast.LENGTH_SHORT).show();

			action.sendMail(mContext, holder.data.email);

		}else if(holder.custom.equals(view)){
			if(holder.data.custom.kind == CommonData.SEND_KIND_TEL){
				Toast.makeText(mContext, "カスタム音声発信:" + holder.data.custom.send, Toast.LENGTH_SHORT).show();

				action.sendCall(mContext, holder.data.tel);

			}else if(holder.data.custom.kind == CommonData.SEND_KIND_MAIL){
				Toast.makeText(mContext, "カスタムメール送信:" + holder.data.custom.send, Toast.LENGTH_SHORT).show();

				action.sendMail(mContext, holder.data.email);
			}

		}else{

		}
*/
	}

	@Override
	public boolean isEnabled(int position) {
		return super.isEnabled(position);
	}
}
